#include <linux/net.h>
#include <net/sock.h>

int getdec(const char **ptr)
{
    const char *p = *ptr;
    int ret=0;
    if ((*p < '0') || (*p > '9')) return(-1);
    while ((*p >= '0') && (*p <= '9')) {
        ret = ret*10 + (*p - '0');
        p++;
    }
    *ptr = p;
    return(ret);
}

__u32 inet_addr(const char *start)
{
    const char *p = start;
    unsigned long ip = 0;
    int val;
    if (((val = getdec(&p)) < 0) || (val > 255)) return(0);
    if (*p != '.') return(0);
    p++;
    ip = val;
    if (((val = getdec(&p)) < 0) || (val > 255)) return(0);
    if (*p != '.') return(0);
    p++;
    ip = (ip << 8) | val;
    if (((val = getdec(&p)) < 0) || (val > 255)) return(0);
    if (*p != '.') return(0);
    p++;
    ip = (ip << 8) | val;
    if (((val = getdec(&p)) < 0) || (val > 255)) return(0);
    return htonl((ip << 8) | val);
}


