#ifndef __DRBL_H__
#define __DRBL_H__

#include <linux/fs.h>

#define DRBL_MAJOR 218      // 256 - ('D'+'R'+'B'+'L' - 4*'A')
#define DRBL_DEVICES 256
#define DRBL_DEVNAME "drbl"
#define DRBL_QUANTUM 4000
#define DRBL_QSET    1000

#define DRBLNODED_PORT 2920 // ('D'+'R'+'B'+'L') * 10

struct Drbl_Dev {
  void **data;
  struct Drbl_Dev *next;
  int quantum; /* the current quantum size */
  int qset; /* the current array size */
  unsigned long size;
  struct semaphore sem; /* mutual exclusion semaphore */
};

extern int server;
extern struct Drbl_Dev *drbl_devices;
extern struct file_operations drbl_fops;

/* prototypes */
extern int proc_init();
extern int proc_exit();

#endif
