#!/bin/sh

imageroot="/var/lib/diskless/default/root"

if [ "$(dpkg -l ssh | grep "^ii")" != "" ]; then ssh_found=1
else ssh_found=0
fi

if [ $ssh_found -eq 0 ]; then 
  cat <<-EOF > /tmp/install-ssh.expect.$$
#!/bin/sh
#\\
exec expect "\$0" \${1+"\$@"}
spawn apt-get -y install ssh
expect "Allow SSH protocol 2 only"
send "y\r"
expect "More"
send "\r"
expect "to be installed SUID root"
send "y\r"
expect "Do you want to run the sshd server"
send "y\r"
expect eof
EOF
  chmod 755 /tmp/install-ssh.expect.$$
  /tmp/install-ssh.expect.$$
  cp /tmp/install-ssh.expect.$$ $imageroot/root
  cp drblsrv.$$/autodebconf_* $imageroot/root
  cat <<-EOF > $imageroot/root/install-sshd.sh
#!/bin/sh
/root/autodebconf_readline
/root/install-ssh.expect.$$
/root/autodebconf_dialog
EOF
  chmod 755 $imageroot/root/install-sshd.sh
  chroot $imageroot /root/install-sshd.sh
  rm -f $imageroot/install-sshd.sh
  rm -f $imageroot/root/install-ssh.expect.$$
  rm -f $imageroot/root/autodebconf_*
  rm -f /tmp/install-ssh.expect.$$
else
  ## check if the latest one exists
  yes | apt-get -y install ssh
fi
