#!/bin/sh

if [ -f /usr/bin/tput ]; then
  NORMAL=`tput sgr0 2> /dev/null`
  BOLD=`tput bold 2> /dev/null`
else
  NORMAL=""
  BOLD=""
fi

if [ ! -e /etc/default/ntp-servers ]; then
  DEFAULT_NTPSERVERS="stdtime.sinica.edu.tw"
  echo -n "${BOLD}Input your NTP servers [$DEFAULT_NTPSERVERS]:${NORMAL} "
  read NTPSERVERS
  if [ "$NTPSERVERS" = "" ]; then
    NTPSERVERS="$DEFAULT_NTPSERVERS"
  fi
  echo "NTPSERVERS=\"$NTPSERVERS\"" > /etc/default/ntp-servers
fi

apt-get -y install ntpdate ntp

cat <<-EOF > /etc/ntp.conf
# /etc/ntp.conf, configuration for ntpd

# ntpd will use syslog() if logfile is not defined
#logfile /var/log/ntpd

driftfile /var/lib/ntp/ntp.drift
statsdir /var/log/ntpstats/

statistics loopstats peerstats clockstats
filegen loopstats file loopstats type day enable
filegen peerstats file peerstats type day enable
filegen clockstats file clockstats type day enable

### lines starting 'server' are auto generated,
### use dpkg-reconfigure to modify those lines.

server $NTPSERVERS
EOF
