#!/bin/sh

#echo -n "Do you want me to setup your NIS [Y|n]? "
#read ANS
#if [ "$ANS" = "N" -o "$ANS" = "n" ]; then exit; fi

if [ -f /usr/bin/tput ]; then
  NORMAL=`tput sgr0 2> /dev/null`
  BOLD=`tput bold 2> /dev/null`
else
  NORMAL=""
  BOLD=""
fi

if [ -e /etc/defaultdomain ]; then echo "drbl" > /etc/defaultdomain; fi
apt-get -y install nis

echo -n "${BOLD}Do you want to setup your NIS as a master NIS server [Y|n]?${NORMAL} "
read MASTER_NIS

DEFAULT_NIS_DOMAIN=`nisdomainname`
if [ "$DEFAULT_NIS_DOMAIN" = "" ]; then DEFAULT_NIS_DOMAIN="drbl"; fi
echo -n "${BOLD}Input Your NIS domain name [$DEFAULT_NIS_DOMAIN]?${NORMAL} "
read NIS_DOMAIN
if [ "$NIS_DOMAIN" = "" ]; then NIS_DOMAIN="$DEFAULT_NIS_DOMAIN"; fi
echo "$NIS_DOMAIN" > /etc/defaultdomain
nisdomainname $NIS_DOMAIN

####
if [ "$MASTER_NIS" = "Y" -o "$MASTER_NIS" = "y" -o "$MASTER_NIS" = "" ]; then

  cat <<-EOF > /etc/default/nis
#
# /etc/defaults/nis	Configuration settings for the NIS daemons.
#

# Are we a NIS server and if so what kind (values: false, slave, master)
NISSERVER=master

# Location of the master NIS password file (for yppasswdd).
# If you change this make sure it matches with /var/yp/Makefile.
YPPWDDIR=/etc

# Do we allow the user to use ypchsh and/or ypchfn ? The YPCHANGEOK
# fields are passed with -e to yppasswdd, see it's manpage.
# Possible values: "chsh", "chfn", "chsh,chfn"
YPCHANGEOK=chsh

EOF

  if [ ! -f /etc/networks ]; then
    for netdev in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
    do
      IP=`/sbin/ifconfig $netdev | grep "inet addr" | cut -d: -f2 | cut -d' ' -f1`
      NM=`/sbin/ifconfig $netdev | grep "inet addr" | cut -d: -f4 | cut -d' ' -f1`
      NETWORK=`netmask $IP/$NM | cut -d/ -f1`
      echo "localnet $NETWORK" >> /etc/networks
    done
  fi

  cat <<-EOF > /etc/nsswitch.conf
# /etc/nsswitch.conf
#
# Example configuration of GNU Name Service Switch functionality.
# If you have the 'glibc-doc' and 'info' packages installed, try:
# 'info libc "Name Service Switch"' for information about this file.

passwd:         compat
group:          compat
shadow:         compat

hosts:          files dns
networks:       files

protocols:      db files
services:       db files
ethers:         db files
rpc:            db files

netgroup:       files nis
EOF

  /etc/init.d/nis restart
  #/usr/lib/yp/ypinit -m
  #drblsrv.$$/autodebconf_readline
  #drblsrv.$$/autoypinit
  #drblsrv.$$/autodebconf_dialog
  cat <<-EOF > /tmp/install-nis.expect.$$
#!/bin/sh
# \\
exec expect "\$0" \${1+"\$@"}
spawn /usr/lib/yp/ypinit -m
expect "next host to add:  "
send ""
expect "Is this correct?"
send "y\r"
expect eof
EOF
  chmod 755 /tmp/install-nis.expect.$$
  /tmp/install-nis.expect.$$
  rm -f /tmp/install-nis.expect.$$ 

else 

  NIS_SERVER=""
  egrep -v '^[[:space:]]*(#|$)' /etc/yp.conf | while read KEY1 VALUE1 KEY2 VALUE2; do
    case "$KEY1" in
      "ypserver") NIS_SERVER="$VALUE1" ;;
      "domain")
	      case "$KEY2" in 
		    "server") NIS_SERVER="$VALUE2" ;;
		    "broadcast") NIS_SERVER="broadcast" ;;
		  esac
	      ;;
    esac
  done

  ## setup nis only if the nis doesn't configure
  while [ "$NIS_SERVER" = "" ]; do
    echo -n "${BOLD}Input your NIS server:${NORMAL} "
    read NIS_SERVER
    echo "ypserver $NIS_SERVER" >> /etc/yp.conf
  done

  /etc/init.d/nis restart
fi

## chroot to $imageroot and install nis
imageroot="/var/lib/diskless/default/root"
cp drblsrv.$$/autodebconf_* $imageroot/root
cat <<-EOF > $imageroot/root/nis.sh
#!/bin/sh
/root/autodebconf_readline
apt-get -y install nis
/root/autodebconf_dialog
EOF
chmod 755 $imageroot/root/nis.sh
chroot $imageroot /root/nis.sh
rm -f $imageroot/root/nis.sh
rm -f $imageroot/root/autodebconf_*
