#!/bin/sh

# image root 
imageroot="/var/lib/diskless/default/root"
imagehost="/var/lib/diskless/default"

# autodebconf_readline, autodebconf_dialog
cp drblsrv.$$/autodebconf_* $imageroot/root
chroot $imageroot /root/autodebconf_noninteractive

## setupx
if [ "$(dpkg -l | grep "xserver-xfree" | cut -d' ' -f1)" = "ii" ]; then
  chroot $imageroot apt-get -y install discover videogen read-edid
  cp drblsrv.$$/imageroot/setupx $imageroot/etc/init.d/setupx
  mkdir -p $imageroot/etc/hwdata
  cp drblsrv.$$/imageroot/vidlist $imageroot/etc/hwdata
  ln -fs ../init.d/setupx $imageroot/etc/rc2.d/S99setupx
fi

# setup $imageroot/etc/diskless-image
mkdir -p $imageroot/etc/diskless-image
cp -r drblsrv.$$/imageroot/diskless-image $imageroot/usr/lib
mv $imageroot/sbin/init $imageroot/sbin/init.orig
cp drblsrv.$$/imageroot/init $imageroot/sbin/init
cp drblsrv.$$/imageroot/X $imageroot/etc/init.d/X

master="drbl"
nfsserver="192.168.1.1"
nfsimagedir="$imageroot"
nfshostsdir="$imagehost"
nfshostdir="/home"
nameserver="192.168.1.1"
domain="drbl.org"
maildomain="drbl.org"
mailroute="smtp"
devfs="yes"

cat > $imageroot/etc/diskless-image/config << EOF
master=$master
nfsserver=$nfsserver
nfsimagedir=$nfsimagedir
nfshostsdir=$nfshostsdir
nfshomedir=$nfshomedir
nameserver=$nameserver
domain=$domain
maildomain=$maildomain
mailroute=$mailroute
devfs=$devfs
EOF

cat > $imageroot/etc/diskless-image/config.m4 <<EOF
divert(-1)dnl
define(<[image_master]>,<[$master]>)
define(<[image_nfsserver]>,<[$nfsserver]>)
define(<[image_nfsimagedir]>,<[$nfsimagedir]>)
define(<[image_nfshostsdir]>,<[$nfshostsdir]>)
define(<[image_nfshomedir]>,<[$nfshomedir]>)
define(<[image_nameserver]>,<[$nameserver]>)
define(<[image_domain]>,<[$domain]>)
define(<[image_maildomain]>,<[$maildomain]>)
define(<[image_mailroute]>,<[$mailroute]>)
define(<[image_devfs]>,<[$devfs]>)
divert(0)dnl
EOF

cat > $imageroot/etc/diskless-image/exports << EOF
$nfsimagedir <ipaddress>(rw no_root_squash)
EOF

cat > $imageroot/etc/fstab << EOF
none	/proc	proc	defaults	1	0
$nfsserver:$nfsimagedir	/	nfs	defaults,nolock	0	1
EOF

cat > $imageroot/etc/resolv.conf << EOF
nameserver $nameserver
domain $domain
search $domain
EOF

cat > $imageroot/etc/hostname << EOF
$master
EOF

# $imageroot/etc/network/interfaces
cat > $imageroot/etc/network/interfaces << EOF
auto lo
iface lo inet loopback
EOF

ln -fs /proc/mounts $imageroot/usr/lib/diskless-image/template/etc/mtab

# setup nis
cat <<-EOF > $imageroot/etc/defaultdomain
drbl
EOF

# rm syslog, ksyslog services
if [ -e $imageroot/etc/rc2.d/S10sysklogd ]; then
  mv $imageroot/etc/rc2.d/S10sysklogd $imageroot/etc/rc2.d/K10sysklogd
fi
if [ -e $imageroot/etc/rc2.d/S11klogd ]; then
  mv $imageroot/etc/rc2.d/S11klogd $imageroot/etc/rc2.d/K11klogd
fi
# remove makedev
if [ -e $imageroot/etc/rc2.d/Smakedev ]; then
  mv $imageroot/etc/rc2.d/S20makedev $imageroot/etc/rc2.d/K20makedev
fi

## remove dhcp3-server, nfs-kernel-server, tftpd-hpa
#chroot $imageroot apt-get -y remove dhcp3-server nfs-kernel-server tftpd-hpa nis
#chroot $imageroot dpkg --purge dhcp3-server nfs-kernel-server tftpd-hpa nis
#
## install nis
#chroot $imageroot apt-get -y install nis

# Blake, 2004/01/13, modutils ...
cat <<-EOF > $imageroot/etc/init.d/modutils
#! /bin/sh
# /etc/init.d/modutils: loads the appropriate modules in 'boot'.

PATH="/sbin:/bin:/usr/sbin:/usr/bin"

[ -f /proc/ksyms ] || exit 0
[ -e /sbin/depmod ] || exit 0

## we don't need to calculate module dependencies when drbl clients boot
## It should be done when the modules were installed 
#if [ -w /lib/modules/ ]; then
#   echo -n "Calculating module dependencies... "
#   depmod -a -q
#   echo "done."
#fi

# Loop over every line in /etc/modules.
echo -n 'Loading modules: '
(cat /etc/modules; echo) | # make sure there is a LF at the end
while read module args
do
    case "\$module" in
        \#*|"") continue ;;
    esac
    echo -n "\$module "
    modprobe \$module \$args
done
echo

#
# Just in case a sysadmin prefers generic symbolic links in
# /lib/modules/boot for boot time modules we will load these modules
#
if [ -n "\`modprobe -l -t boot\`" ]
then
  modprobe -a -t boot \*
fi

exit 0
EOF
chmod 755 $imageroot/etc/init.d/modutils

##
chroot $imageroot /root/autodebconf_dialog
rm -f $imageroot/root/autodebconf_*
