#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description:
#  copy everything from / to /var/lib/diskless/default/root

imageroot="/var/lib/diskless/default/root"

if [ -f /usr/bin/tput ]; then
  NORMAL=`tput sgr0 2> /dev/null`
  BOLD=`tput bold 2> /dev/null`
else
  NORMAL=""
  BOLD=""
fi

# Blake, 2003/11/21, removeentries
## function: removeentries
## $1 - Tag for START
## $2 - Tag for End
## $3 - File to read
removeentries() {
  while read line; do
    case "$line" in $1)
      while read line; do
        if [ "$line" = "$2" ]; then break; fi
      done
    esac
    if [ "$line" = "$2" ]; then continue; fi
    echo "$line"
  done < $3
}

START_TAG="# Added by DRBL."
END_TAG="# Added by DRBL Done."

echo "${BOLD}Start creating DRBL Client Template.. It will take several minutes..${NORMAL}"

# function: copy_to
copy_to() {
  TMP=`mktemp /tmp/drblsrv.XXXXXX`
  copy_src="$1"
  copy_dest="$2"

  echo -n "[$copy_src ==> $copy_dest] "
  /usr/bin/rsync -a -v $copy_src $copy_dest 2> /dev/null > $TMP
  echo $(tail -n 1 $TMP)
  rm -f $TMP
}

# crate $imageroot
if [ "$USE_DEBOOTSTRAP" = "1" ]; then
  # create imageroot using debootstrap
  echo -n "${BOLD}Input your debian mirror site [http://openesource.nchc.org.tw]:${NORMAL} "
  read debian_mirror
  if [ "$debian_mirror" = "" ]; then
    debian_mirror="http://opensource.nchc.org.tw"
  fi
  apt-get -y install debootstrap binutils
  debootstrap --arch i386 woody $imageroot $debian_mirror
else
  # make sure every packages are setuped correctly
  dpkg -configure -a
  # create imageroot from / 
  mkdir -p $imageroot
  mkdir -p $imageroot/bin $imageroot/boot $imageroot/dev $imageroot/etc $imageroot/home $imageroot/lib $imageroot/mnt $imageroot/opt $imageroot/proc $imageroot/root $imageroot/sbin $imageroot/tmp $imageroot/usr $imageroot/var
  chmod -R 777 $imageroot/tmp
  chmod -R o+t $imageroot/tmp

  for dir in bin boot dev etc lib sbin
  do copy_to "/$dir/*" "$imageroot/$dir"; done

  for dir in X11R6 bin doc etc games include info lib local sbin share src
  do
    mkdir -p $imageroot/usr/$dir 
    copy_to "/usr/$dir/*" "$imageroot/usr/$dir" 
  done

  # cp var_dir to $imageroot
  for var_dir in `find /var -type d -ls | awk '{ print $11; }'`
  do
    if [ "$(echo "$var_dir" | grep "^/var/lib/diskless")" != "" ]; then continue; fi
    mkdir -p $imageroot/$var_dir
  done
  for dir in `ls /var/lib`
  do
    if [ "$dir" != "diskless" ]; then
      copy_to "/var/lib/$dir/*" "$imageroot/var/lib/$dir"
    fi
  done
  apt-get clean
  copy_to "/var/cache/apt/*" "$imageroot/var/cache/apt/"

  # change some attribute
  if [ -e $imageroot/usr/bin/sudo ]; then chmod u+s $imageroot/usr/bin/sudo; fi
  if [ -e $imageroot/usr/bin/crontab ]; then chmod u+s $imageroot/usr/bin/crontab; fi
  if [ -e $imageroot/var/run/screen ]; then 
    chmod 755 $imageroot/var/run/screen
    chown root.utmp $imageroot/var/run/screen
  fi
  chmod 666 $imageroot/dev/dsp*
  chmod 666 $imageroot/dev/mixer*
  chmod 666 $imageroot/dev/video*
  chmod 666 $imageroot/dev/vbi*
  
  mv $imageroot/usr/bin/passwd $imageroot/usr/bin/passwd.drbl
  ln -s /usr/bin/yppasswd $imageroot/usr/bin/passwd

  # ssh_config
  removeentries "$START_TAG" "$END_TAG" $imageroot/etc/ssh/ssh_config > /tmp/ssh_config.$$
  echo "$START_TAG" >> /tmp/ssh_config.$$
  echo "Host *" >> /tmp/ssh_config.$$
  echo "  StrictHostKeyChecking no" >> /tmp/ssh_config.$$
  echo "$END_TAG" >> /tmp/ssh_config.$$
  mv /tmp/ssh_config.$$ $imageroot/etc/ssh/ssh_config

  # readdebconf, setdebconf
  drblsrv.$$/readdebconf-v0.9 $imageroot/root/drbl-debconf
  cp drblsrv.$$/setdebconf-v0.9 $imageroot/root
  chroot $imageroot /root/setdebconf-v0.9 /root/drbl-debconf
  rm -f $imageroot/root/setdebconf-v0.9 $imageroot/root/drbl-debconf
fi
