#!/bin/sh

# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description: The script is used to setup samba as a PDC server

apt-get install samba

# create smb.conf
workgroup="drbl"
echo -n "Your NT-Domain-Name [$workgroup]: "
read ANS
if [ "$ANS" != "" ]; then workgroup=$ANS; fi

netbios_name=$(/bin/hostname)
if [ "$netbios_name" = "" ]; then netbios_name="drblsrv"; fi
echo -n "Your netbios name [$netbios_name]: "
read ANS
if [ "$ANS" != "" ]; then netbios_name=$ANS; fi

mv /etc/samba/smb.conf /etc/samba/smb.conf.orig
echo <<-EOF > /etc/samba/smb.conf

[global]
# workgroup = Your NT-Domain-Name
workgroup = $workgroup
# Your PDC identifying comment
server string = Samba/NT PDC
# Your netbios name
netbios name = $netbios_name

# User-level security 
security = user
# Encrypted passwords
encrypt passwords = yes
smb password file = /etc/samba/smbpasswd

unix password sync = Yes
passwd program = /usr/bin/passwd %u
passwd chat = *New*UNIX*password* %n\n
*ReType*new*UNIX*password* %n\n
*passwd:*all*authentication*tokens*updated*successfully

# set these to act as the domain and local browser
# make the server the master of the domain
preferred master = yes
domain master = yes
local master = yes
os level = 64

# the server logons for Windows Client
domain logons = yes
#logon script = %m.bat
#logon script = %U.bat
logon script = logon.cmd

# define your share
[netlogon]
   comment = Network Logon Service
   path = /home/samba/netlogon
   guest ok = yes
   writable = yes
   share modes = no
   create mode = 0644

;[homes]
;comment = Home Directories
;browseable = yes
;writable = yes
;create mode = 0644
EOF

# create smbpasswd
if [ ! -e /etc/samba/smbpasswd ]; then
  touch /etc/samba/smbpasswd
fi
# restart samba services
/etc/init.d/samba restart

# netlogon
mkdir -p /home/samba/netlogon
for dir in `ls /home`
do
  if [ "$dir" != "samba" ]; then
    echo "$dir"
    ln -fs /home/$dir /home/samba/netlogon/$dir
  fi
done
