#!/bin/sh

# imageroot, tftproot
imageroot="/var/lib/diskless/default/root"
imagehost="/var/lib/diskless/default"
tftproot="/tftpboot"

# /etc/default/drbl
if [ -e /etc/default/drbl ]; then
  . /etc/default/drbl
fi

# Blake, 2003/08/12
drbl_mirror="http://drbl.nchc.org.tw/"

# wget, mknbi, netmask
apt-get -y install wget mknbi netmask

## chroot to install nis, devfsd
#cat <<-EOF > $imageroot/root/nis_devfsd.sh
#/sbin/autodebconf_readline
#apt-get -y install nis
##apt-get -y install devfsd > /dev/null 2>&1
##perl -p -i -e "s/MOUNT=.*/MOUNT=yes/" /etc/default/devfsd
##/sbin/depmod -F /boot/System.map-2.4.18 -a
##/sbin/depmod -F /boot/System.map-2.4.20 -a 2.4.20
#if [ -e /etc/rc2.d/S20makedev ]; then
#  mv /etc/rc2.d/S20makedev /etc/rc2.d/K20makedev
#fi
#/sbin/autodebconf_dialog
#EOF
#chmod 755 $imageroot/root/nis_devfsd.sh
#mount -t proc proc $imageroot/proc
#chroot $imageroot /root/nis_devfsd.sh
#umount $imageroot/proc
#rm -rf $imageroot/root/nis_devfsd.sh

# libpcap
apt-get -y install libpcap0 libpcap-dev
apt-get -y install gcc make
cd drblpush.$$/packet
make install
cd ../..

# drbl_deploy.sh
if [ -e /opt/drbl/sbin/drbl_deploy.sh ]; then
  /opt/drbl/sbin/drbl_deploy.sh macadr drblpush.$$
fi

# stop inetd, dhcp
/etc/init.d/inetd stop
/etc/init.d/dhcp3-server stop

#if [ $# -ne 1 ]; then
#  echo "setup-dhcp_nfs.sh output_file"; exit 0;
#fi

# Blake, 2004/02/04, remove old PXE configuration
if [ "$1" == "--force" ]; then
  for ip in `cat /etc/dhcp3/dhcpd.conf | grep "fixed-address" | cut -d\; -f1 | awk '{ print $2; }'`
  do
    pxelocal=`/usr/bin/gethostip $ip | cut -d' ' -f3`
    if [ "$pxelocal" != "" -a -f /tftpboot/pxelinux.cfg/$pxelocal ]; then 
      rm -f /tftpboot/pxelinux.cfg/$pxelocal
    fi
  done
  perl -p -i -e "s/^default.*/default drbl/" /tftpboot/pxelinux.cfg/default
fi

#OUT=$1
OUT="drblpush.$$/drbl_config"
FIREWALL="drblpush.$$/firewall"
SECURENETS="ypserv.securenets"

#nameserver="$(head -n 1 /etc/resolv.conf | awk '{print $2}')"
while read line; do
  if [ "$(echo "$line" | grep -e "^nameserver")" != "" ]; then
    nameserver="$(echo "$line" | awk '{print $2}')"
    break
  fi
done < /etc/resolv.conf
if [ "$nameserver" = "" ]; then nameserver="168.95.1.1"; fi
#nameserver="168.95.1.1"
domain="drbl.org"
#2003/09/04, Blake, read nisdomain configuration from /etc/defaultdomain
if [ -e /etc/defaultdomain ]; then
  nisdomain=`cat /etc/defaultdomain`
else
  nisdomain="drbl"
fi

nbi="vmlinuz-pcnet32.nbi"
interface="eth0"
network="192.168.1.0"
bootserver="192.168.1.1"
nisserver=""

# general 
echo -n "name server=[$nameserver]? "
read ANS
if [ "$ANS" != "" ]; then
  nameserver="$ANS"
fi

echo -n "domain name=[$domain]? "
read ANS
if [ "$ANS" != "" ]; then
  domain="$ANS"
fi

echo -n "nis domain=[$nisdomain]? "
read ANS
if [ "$ANS" != "" ]; then nisdomain="$ANS"; fi

echo "# GENERATED BY setup-drbl.sh" > $OUT
cat <<-EOF >> $OUT
[general]
nameserver=$nameserver
domain=$domain
nisdomain=$nisdomain
EOF

# nbi & pxe
nbi="mkinitrd-net"
pxe="pxelinux.0"
echo "nbi=mkinitrd-net" >> $OUT
echo "pxe=pxelinux.0" >> $OUT

# firewall
cat <<-EOF > $FIREWALL
#!/bin/sh
# generated by drblpush
# Author: Blake, Kuo-Lien Huang
# copyright: GPL

EOF

# yp.securenets
cat <<-EOF > $SECURENETS
# Generated by drblpush
# Author: Blake, Kuo-Lien Huang
# License: GPL

# Always allow access for localhost
255.0.0.0	127.0.0.0
EOF

# subnet
echo -n "How many drbl subnet [1]? "
read nsubnet
if [ "$nsubnet" = "" ]; then
 nsubnet="1";
fi

# Blake, 2004/02/24, cupsys
cupsys_substr=""

total=0
n=0
while [ $n -lt $nsubnet ]
do
  label=`expr $n + 1`

  echo "setup $n subnet..."  
  # interface
  interface="eth$n"
  echo -n "interface=[$interface]? "
  read ANS
  if [ "$ANS" != "" ]; then interface="$ANS"; fi

  # Blake, 2004/02/24, cupsys
  cupsys_substr="$cupsys_substr \@IF($interface)"

  # network, bootserver
  ip=`/sbin/ifconfig $interface | awk '/inet/{print $2;}' | awk -F: '{print $2;}'`
  broadcast=`/sbin/ifconfig $interface | awk '/Bcast/{print $3;}' | awk -F: '{print $2;}'`
  # Blake, 2003/08/12 use netmask to calculate network
  #network=`echo "$ip" | awk -F. '{print $1"."$2"."$3".0"; }'`
  netmask=`/sbin/ifconfig $interface | awk '/Mask/{print $4; }' | awk -F: '{print $2;}'`
  network=`/usr/bin/netmask $ip/$netmask | cut -d/ -f1 | awk '{print $1;}'`
  if [ "$network" = "" ]; then
    netmask="255.255.255.0"
    network=`echo "$ip" | awk -F. '{print $1"."$2"."$3".0"; }'`
  fi
  bootserver=$ip

  # Blake, 2004/07/15, allow user to setup client's router,
  router=$ip
  echo -n "client's router=[$router]? "
  read ANS
  if [ "$ANS" != "" ]; then router="$ANS"; fi

  # nisserver
  #if [ "$nisserver" = "" ]; then nisserver=$ip; fi
  nisserver=$ip
  echo -n "client's nis server=[$nisserver]? "
  read ANS
  if [ "$ANS" != "" ]; then nisserver="$ANS"; fi

  nfsserver=$ip
  echo -n "client's nfs server=[$nfsserver]? "
  read ANS
  if [ "$ANS" != "" ]; then nfsserver="$ANS"; fi

  # Blake, 2004/07/19, if $router != $ip, no masquerade rule for this subnet ..
  if [ "$router" = "$ip" ]; then  
    # add masquerade rules for this subnet
    #echo "iptables -t nat -A POSTROUTING -s $network/24 -j MASQUERADE" >> $FIREWALL
    x=`/usr/bin/netmask $ip/$netmask`
    echo "$eth""_rule_1=\"iptables -t nat -A POSTROUTING -s $x -j MASQUERADE\"" >> $FIREWALL
    echo "$eth""_rule_2=\"iptables -t nat -D POSTROUTING -s $x -j MASQUERADE\"" >> $FIREWALL
  fi

  # add this subnet to ypserv.securnets
  #echo "255.255.255.0	$network" >> $SECURENETS
  echo "$netmask	$network" >> $SECURENETS 

  # create init.$network to $imageroot/sbin/
  if [ ! -e $imageroot/sbin/$network ]; then mkdir $imageroot/sbin/$network; fi
  #IPCMD="ifconfig | grep -A1 eth0 | grep -v eth0 | sed 's/^.*inet addr:\([0-9\.]\+\).*$/\1/'"
  NET=`echo "$nfsserver" | awk -F\. '{ print $1 "." $2 "." $3; }'`
  IPCMD="ifconfig | grep \"$NET\" | sed 's/^.*inet addr:\([0-9\.]\+\).*$/\1/' | head -n 1"
  cat <<-EOF > $imageroot/sbin/$network/init
#!/bin/sh

# Don't do anything special if computer is already booted
if [ \$\$ -ne 1 ]
then
	exec /sbin/init.orig $*
	echo "FATAL ERROR: exec /sbin/init.orig failed" >&2
	exit 1
fi

# Don't do anything special if root is rw (ie master system).
if touch /test-rw
then
	rm /test-rw
	echo "WARNING: master system installed" >&2
	exec /sbin/init.orig $*
	echo "FATAL ERROR: exec /sbin/init.orig failed" >&2
	exit 1
fi

# Try and find configuration file
if [ -f /etc/diskless-image/config ]
then
	# Load config file
	. /etc/diskless-image/config

	# Get IP address, need to mount /proc first
	# Already mount at /sbin/init (klhaung 2002/12/20)
	# mount -n none /proc -t proc
	#IP=`cat /proc/cmdline | sed 's/^.*nfsaddrs=\([0-9\.]\+\).*$/\1/'`
EOF

  echo 'IP=`'$IPCMD'`' >> $imageroot/sbin/$network/init

  cat <<-EOF >> $imageroot/sbin/$network/init

	echo "Client IP address is \$IP"

	# Mount client's /etc directory
	echo -n "Mounting NFS-root directories..."
	mount -n $bootserver:/\$nfshostsdir/\$IP/etc /etc -orw,nolock

	# Update entries in /etc/mtab
	rm -f /etc/mtab~ /etc/nologin
	: > /etc/mtab
	mount -o remount /
	mount -o remount /etc
	mount -o remount /proc

	# report success
	echo "done."
else
	echo "ERROR: Cannot find image config file"
	echo "       Not mounting NFS-root directories"
fi

# Only should get here if something went wrong
exec /sbin/init.orig $*
echo "FATAL ERROR: exec /sbin/init.orig failed" >&2
exit 1
EOF

  chmod a+x $imageroot/sbin/$network/init
 
  # Blake, 2004/02/02, client hostname prefix ..
  # hostname
  hostname=`hostname`
  hostname="$hostname-$interface-"
  echo -n "client's hostname prefix=[$hostname]? "
  read ANS
  if [ "$ANS" != "" ]; then hostname="$ANS"; fi
  #hostname="$hostname-"

  # detect mac address or using range ?
  mac=""
  range=""
  echo "1: Setup client one by one (Automatic MAC Address detected)"
  echo "2: Setup client one by one (Already collect MAC Address in File)"
  echo "3: Setup a range of client"
  echo -n "Choose the method to setup your client [1]:"
  read ANS
  if [ "$ANS" = "" ]; then ANS=1; fi

  ## collect mac address
  case $ANS in
   '1')
    # mac
    if [ -e drblpush.$$/macadr-$interface.txt ]; then
      if [ 0 -ne $(wc -l drblpush.$$/macadr-$interface.txt | awk '{ print $1; }') ]; then
        cat drblpush.$$/macadr-$interface.txt | awk '{ print $1; }' >> drblpush.$$/macadr-tmp.txt
        echo "================================================"
        more drblpush.$$/macadr-tmp.txt
        echo "================================================"
        echo "You have detected the above mac addresses before."
        echo -n "Do you want to include them [Y|n]?"
        read ANS
        if [ "$ANS" = "Y" -o "$ANS" = "y" -o "$ANS" = "" ]; then
         cat drblpush.$$/macadr-$interface.txt | awk '{ print $1; }' >> drblpush.$$/mac_cache
        else
         rm -f drblpush.$$/macadr-$interface.txt
        fi
        rm -f drblpush.$$/macadr-tmp.txt
      fi
    fi
    echo "Detecting MAC address. Enter 'q' to stop." 
    drblpush.$$/detect_mac $interface drblpush.$$/mac_cache >> drblpush.$$/macadr-$interface.txt
    ## input mac address by hand
    echo -n "Do you want to input other MAC address by hand [y|N]? "
    read ans
    if [ "$ans" = "Y" -o "$ans" = "y" ]; then
      echo "Enter 'q' to stop."
      while read mac_by_hand
      do
        if [ "$mac_by_hand" = "" ]; then
          continue
        elif [ "$mac_by_hand" = "q" ]; then
          break
        else
          echo "$mac_by_hand" >> drblpush.$$/macadr-$interface.txt
        fi
      done
    fi
    cat drblpush.$$/macadr-$interface.txt | awk '{ print $1; }' >> drblpush.$$/mac_cache
#    mac="drblpush/macadr-$interface.txt"
#    range=""
#    nhosts=`wc -l drblpush/macadr-$interface.txt | awk '{ print $1; }'`
#    total=`expr $total + $nhosts`
    ## Blake, 2004/07/23
    ### public ip
    #echo -n "Do you use public IP to configure your clients [y|N]?"
    #read ans
    #if [ "$ans" = "Y" -o "$ans" = "y" ]; then
    #   echo "Please input the public IP for each mac address,type 'abort' to quit:"
    #   mv drblpush/macadr-$interface.txt drblpush/macadr-$interface.mac
    #   TTY=`tty`
    #   while read macadr ; do
    #      public_ip=""
    #      while [ "$public_ip" = "" ]; do
    #        echo -n "[$macadr] "
    #        read public_ip < $TTY
    #      done
    #      if [ "$public_ip" = "abort" ]; then 
    #        cp drblpush/macadr-$interface.mac drblpush/macadr-$interface.txt
    #        break
    #      else
    #        echo "$macadr	$public_ip" >> drblpush/macadr-$interface.txt
    #      fi
    #    done < drblpush/macadr-$interface.mac
    #    rm -f drblpush/macadr-$interface.mac
    #fi
    ;;
   '2')
    FN=""
    while [ "$FN" = "" -o ! -f "$FN" ]
    do
      if [ "$FN" != "" ]; then echo "file $FN does not exist!"; fi 
      echo -n "Enter the filename: "
      read FN
    done
    cat $FN > drblpush.$$/macadr-$interface.txt
#    mac="drblpush/macadr-$interface.txt"
#    range=""
#    nhosts=`wc -l drblpush/macadr-$interface.txt | awk '{ print $1; }'`
#    total=`expr $total + $nhosts`
    ;;
#   '3')
#    touch drblpush/macadr-$interface.txt
#    # range
#    range_network=`echo "$network" | awk -F. '{print $1"."$2"."$3; }'`
#    ## Blake, 2003/08/12 available range
#    avaliable_value=`/usr/bin/netmask -r $ip/$netmask | awk '{ print $1; }'`
#    echo "Enter the range of IP addresses that the clients will be assigned"
#    echo "Available value: $avaliable_value"
#    echo -n "Range start: $range_network."
#    read start_range
#    echo -n "Range end: $range_network."
#    read end_range
#    range="$start_range-$end_range"
#    mac=""
#    nbi=""
#    nhosts=`expr $end_range - $start_range + 1`
#    total=`expr $total + $nhosts`
#    ;;
  esac

  ## ip address
  case $ANS in
    '3')
     # range 
     echo -n "How many clients [12]? "
     read nhosts
     if [ "$nhosts" = "" ]; then nhosts=12; fi
     total=`expr $total + $nhosts`

     first_ip=""
     default_ip="$(/usr/bin/netmask -r $ip/$netmask | awk '{ print $1; }' | cut -d- -f1)"
     default_ip_binary="$(/usr/bin/netmask -b $default_ip | cut -d\/ -f1 | sed -e 's/ //g')"
     default_ip_decimal="$(drblpush.$$/btod $default_ip_binary)"
     default_ip_decimal=`expr $default_ip_decimal + 1`
     default_ip="$(/usr/bin/netmask $default_ip_decimal | cut -d\/ -f1 | sed -e 's/ //g')"
     echo -n "Input the first IP address for clients [$default_ip]: "
     read first_ip
     if [ "$first_ip" = "" ]; then first_ip="$default_ip"; fi

     do_range=$nhosts
     mac="" 
     ;;
    *)
     # mac
     mac="drblpush.$$/macadr-$interface.txt"
     range=""
     nhosts=`wc -l drblpush.$$/macadr-$interface.txt | awk '{ print $1; }'`
     total=`expr $total + $nhosts`

     echo -n "Input IP address (m)anually or (a)utomatically [m/A]? "
     read ans
     if [ "$ans" = "" ]; then ans="A"; fi

     ## manually
     if [ "$ans" = "M" -o "$ans" = "m" ]; then
       echo "Input the IP address for each mac address, 'abort' for quit:"
       mv drblpush.$$/macadr-$interface.txt drblpush.$$/macadr-$interface.mac
       TTY=`tty`
       while read macadr x; do
          address=""
          while [ "$address" = "" ]; do
            echo -n "[$macadr] "
            read address < $TTY
          done
          if [ "$address" = "abort" ]; then 
            cp drblpush.$$/macadr-$interface.mac drblpush.$$/macadr-$interface.txt
            echo "Found 'abort'! Change to 'Input IP address automatically'!!"
            ans="A"
            break
          else
            echo "$macadr	$address" >> drblpush.$$/macadr-$interface.txt
          fi
        done < drblpush.$$/macadr-$interface.mac
        rm -f drblpush.$$/macadr-$interface.mac
     fi
     ## automatically
     if [ "$ans" = "a" -o "$ans" = "A" ]; then
        first_ip=""
        default_ip="$(/usr/bin/netmask -r $ip/$netmask | awk '{ print $1; }' | cut -d- -f1)"
        default_ip_binary="$(/usr/bin/netmask -b $default_ip | cut -d\/ -f1 | sed -e 's/ //g')"
        default_ip_decimal="$(drblpush.$$/btod $default_ip_binary)"
        default_ip_decimal=`expr $default_ip_decimal + 1`
        default_ip="$(/usr/bin/netmask $default_ip_decimal | cut -d\/ -f1 | sed -e 's/ //g')"
        echo -n "Input the first IP address for clients [$default_ip]: "
        read first_ip
        if [ "$first_ip" = "" ]; then first_ip="$default_ip"; fi
        first_ip_binary="$(/usr/bin/netmask -b $first_ip | cut -d\/ -f1 | sed -e 's/ //g')"
        first_ip_decimal="$(drblpush.$$/btod $first_ip_binary)"
        mv drblpush.$$/macadr-$interface.txt drblpush.$$/macadr-$interface.mac
        d=$first_ip_decimal
        while read macadr; do
          address="$(/usr/bin/netmask $d | cut -d\/ -f1 | sed -e 's/ //g')"
          while [ "$address" = "$ip" ]; do
            d=`expr $d + 1`
            address="$(/usr/bin/netmask $d | cut -d\/ -f1 | sed -e 's/ //g')"
          done
          echo "$macadr	$address" >> drblpush.$$/macadr-$interface.txt
          d=`expr $d + 1`
        done < drblpush.$$/macadr-$interface.mac
        rm -f drblpush.$$/macadr-$interface.mac
     fi

     echo -n "How many IP address reserved for random clients [0]? "
     read ans
     if [ "$ans" != "" -a "$ans" != "0" ]; then 
       total=`expr $total + $ans`
       if [ "$d" = "" ]; then
         default_ip="$(/usr/bin/netmask -r $ip/$netmask | awk '{ print $1; }' | cut -d- -f1)"
         default_ip_binary="$(/usr/bin/netmask -b $default_ip | cut -d\/ -f1 | sed -e 's/ //g')"
         default_ip_decimal="$(drblpush.$$/btod $default_ip_binary)"
         default_ip_decimal=`expr $default_ip_decimal + 1`
         default_ip="$(/usr/bin/netmask $default_ip_decimal | cut -d\/ -f1 | sed -e 's/ //g')"
         echo -n "Input the first IP address for random clients [$default_ip]: "
         read first_ip
       else
         first_ip="$(/usr/bin/netmask $d | cut -d\/ -f1 | sed -e 's/ //g')"
       fi
       do_range=$ans
     else
       do_range=0
     fi
     ;;
  esac

  if [ $do_range -gt 0 ]; then
     first_ip_binary="$(/usr/bin/netmask -b $first_ip | cut -d\/ -f1 | sed -e 's/ //g')"
     first_ip_decimal="$(drblpush.$$/btod $first_ip_binary)"
     last_ip_decimal=`expr $first_ip_decimal + $do_range - 1`
     last_ip="$(/usr/bin/netmask $last_ip_decimal | cut -d\/ -f1 | sed -e 's/ //g')"
     last_ip_binary="$(/usr/bin/netmask -b $last_ip | cut -d\/ -f1 | sed -e 's/ //g')"
     is_enough=1
     drblpush.$$/btod $first_ip_binary $last_ip_binary | \
     while read d; do
       address="$(/usr/bin/netmask $d | cut -d\/ -f1 | sed -e 's/ //g')"
       if [ "$address" = "$ip" ]; then is_enough=0; continue; fi
       echo "$address" >> drblpush.$$/range-$interface.txt
     done
     if [ $is_enough -eq 0 ]; then
       last_ip_decimal=`expr $last_ip_decimal + 1`
       last_ip="$(/usr/bin/netmask $last_ip_decimal | cut -d\/ -f1 | sed -e 's/ //g')"
       echo "$last_ip" >> drblpush.$$/range-$interface.txt
     fi
     range="drblpush.$$/range-$interface.txt"
  fi

## Blake, 2004/07/21
##  # public ip alias
##  echo -n "Setup public ip for each client [y|N]? "
##  read ANS
##  if [ "$ANS" = "Y" -o "$ANS" = "y" ]; then
##
##    if [ -e $imageroot/etc/diskless-image/public_ip.$network ]; then
##      echo -n "Do you want to keep the settting before [Y|n]? "
##      read ANS
##      if [ "$ANS" = "N" -o "$ANS" = "n" ]; then
##        rm -f $imageroot/etc/diskless-image/public_ip.$network
##      fi
##    fi
##
##    public_ip=""
##    public_netmask="255.255.255.0"
##    public_gateway=""
##   
##    if [ "$mac" != "" ]; then
##      # mac
##      TTY=`tty`
##      while read macadr ; do
##        # check if the settting is exist
##        if [ -e $imageroot/etc/diskless-image/public_ip.$network ]; then
##          t=`grep -i "$macadr" $imageroot/etc/diskless-image/public_ip.$network`
##          if [ "$t" != "" ]; then continue; fi
##        fi
##
##        echo "$macadr"
##        # public ip
##        echo -n "  ip: "
##        read public_ip < $TTY
##        # public netmask
##        echo -n "  netmask [$public_netmask]: "
##        t=$public_netmask
##        read public_netmask < $TTY
##        if [ "$public_netmask" = "" ]; then public_netmask=$t; fi
##        # public gateway
##        echo -n "  gateway [$public_gateway]: "
##        t=$public_gateway
##        read public_gateway < $TTY
##        if [ "$public_gateway" = "" ]; then public_gateway=$t; fi
##        
##        echo -e "$macadr\t$public_ip\t$public_netmask\t$public_gateway" >> $imageroot/etc/diskless-image/public_ip.$network
##      done < drblpush/macadr-$interface.txt
##    else
##      # range
##      i=$start_range
##      while [ $i -le $end_range ]; do
##
##        # check if the settting is exist
##        if [ -e $imageroot/etc/diskless-image/public_ip.$network ]; then
##          t=`grep "$range_network.$i" $imageroot/etc/diskless-image/public_ip.$network`
##          if [ "$t" != "" ]; then continue; fi
##        fi
##
##        echo "$range_network.$i"
##        # public ip
##        echo -n "  ip: "
##        read public_ip
##        # public netmask
##        echo -n "  netmask [$public_netmask]: "
##        t=$public_netmask
##        read public_netmask
##        if [ "$public_netmask" = "" ]; then public_netmask=$t; fi
##        # public gateway
##        echo -n "  gateway [$public_gateway]: "
##        t=$public_gateway
##        read public_gateway
##        if [ "$public_gateway" = "" ]; then public_gateway=$t; fi
##        
##        echo -e "$range_network.$i\t$public_ip\t$public_netmask\t$public_gateway" >> $imageroot/etc/diskless-image/public_ip.$network
##        i=`expr $i + 1`
##      done
##    fi
##  fi

  # OUT
  cat <<-EOF >> $OUT

[drbl$label]
interface=$interface
network=$network
netmask=$netmask
broadcast=$broadcast
nfsserver=$nfsserver
bootserver=$bootserver
nisserver=$nisserver
router=$router
nbi=$nbi
pxe=$pxe
hostname=$hostname
mac=$mac
range=$range
EOF
  #if [ "$mac" != "" ]; then
  #  echo "mac=$mac" >> $OUT
  #else 
  #  echo "range=$range" >> $OUT
  #fi

  # diskless-newhost for drblmgrd
  if [ "$NO_DRBLMGRD" = "false" ]; then
    if [ "$ip" = "" ]; then $ip="$nfsserver"; fi
    echo "create diskless host: tmphost $ip"
    if [ "$ip" != "" -a -e $imagehost/$ip -a "$1" = "--force" ]; then 
      rm -rf $imagehost/$ip;
      rm -f $tftproot/$ip
      other=`echo "$ip" | awk -F\. '{ print $1"."$2"."$3".*"; }'`
      if [ "$other" != "" ]; then 
       rm -rf $imagehost/$other
       rm -f $tftproot/$other
      fi
    fi
    if [ ! -e $imagehost/$ip ]; then
      diskless-newhost $imageroot $ip host=tmphost mailname=tmphost >& /dev/null
      # Blake, 2004/08/16, fstab, just for consistency
      cat <<-FSTAB > $imagehost/$ip/etc/fstab
none    /proc   proc	defaults    1   0
$bootserver:$imagehost/root       /       nfs ro,defaults,nolock 0 1
$bootserver:$imagehost/$ip/var    /var    nfs defaults,nolock 0 1
$bootserver:$imagehost/$ip/root   /root   nfs defaults,nolock 0 2
$ip:/home                                /home   nfs defaults,nolock 0 2
$bootserver:$imagehost/root/var/lib/dpkg  /var/lib/dpkg   nfs
ro,defaults,nolock  0 1
$nfsserver:/opt                                 /opt    nfs defaults,nolock 0 1
$nfsserver:/var/mail    /var/mail   nfs defaults,nolock 0 1
tmpfs   /tmp    tmpfs   defaults    0   0
#/dev/nbd0	/tmp	ext2	defaults	0	0
FSTAB
      # Blake, 2004/03/09, for mozilla 
      cp -r $imageroot/var/lib/mozilla/* $imagehost/$ip/var/lib/mozilla
      # Blake, 2004/04/27, for kde menu
      rm -rf $imagehost/$ip/var/lib/kde/menu
      cp -r $imageroot/var/lib/kde/menu $imagehost/$ip/var/lib/kde/
      # Blake, 2004/03/09, client's root
      mkdir $imagehost/$ip/root
      ##cp $imageroot/root/.profile $imagehost/$ip/root
      ##cp $imageroot/root/.bashrc $imagehost/$ip/root
      cat <<-EOF > $imagehost/$ip/root/.profile
# ~/.profile: executed by Bourne-compatible login shells.

if [ -f ~/.bashrc ]; then
  . ~/.bashrc
fi

PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/bin/X11
export PATH

mesg n
EOF
      # 2003/08/25
      if [ -d /root/.kde ]; then
        cp -r /root/.kde $imagehost/$ip/root
      fi
    fi
    cat <<-NETWORKS > $imagehost/$ip/etc/networks
localnet $network
NETWORKS
    cat <<-YPCONF > $imagehost/$ip/etc/yp.conf
domain $nisdomain server $nisserver
YPCONF
	cat <<-DEFAULTDOMAIN > $imagehost/$ip/etc/defaultdomain
$nisdomain
DEFAULTDOMAIN

    if [ -e $imagehost/$ip/etc/passwd ]; then
      NIS_PWD=`cat $imagehost/$ip/etc/passwd | grep "+::::::"`
      if [ "\$NIS_PWD" = "" -o "\$NIS_PWD" != "+::::::" ]; then
        echo "+::::::" >> $imagehost/$ip/etc/passwd
      fi
    fi

    if [ -e $imagehost/$ip/etc/group ]; then
      NIS_GRP=`cat $imagehost/$ip/etc/group | grep "+:::"`
      if [ "\$NIS_GRP" = "" -o "\$NIS_GRP" != "+:::" ]; then
        echo "+:::" >> $imagehost/$ip/etc/group
      fi
    fi

    if [ -e $imagehost/$ip/etc/shadow ]; then
      NIS_SHADOW=`cat $imagehost/$ip/etc/shadow | grep "+::::::::"`
      if [ "\$NIS_SHADOW" = "" -o "\$NIS_SHADOW" != "+::::::::" ]; then
	    echo "+::::::::" >> $imagehost/$ip/etc/shadow
      fi
    fi

    echo "$nameserver" | awk -F, '{ for(i=1;i<=NF;i++) print "nameserver ",$i; }' > $imagehost/$ip/etc/resolv.conf
  fi
  # end

  n=`expr $n + 1`
done

# firewall
cat <<-EOF >> $FIREWALL
masquerade_only_rules()
{
EOF

for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then
     echo "  \$""$eth""_rule_1" >> $FIREWALL
  fi
done

cat <<-EOF >> $FIREWALL

  iptables -P FORWARD ACCEPT
  iptables -P INPUT ACCEPT
}
EOF

cat <<-EOF >> $FIREWALL
deny_connection_rules()
{
EOF

for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then
     echo "  \$""$eth""_rule_2" >> $FIREWALL
  fi
done

cat <<-EOF >> $FIREWALL
}
EOF

cat <<-EOF >> $FIREWALL

case \$1 in
  "start")
    # Define firewall rule
    masquerade_only_rules
 
    # Turn on IP forwarding
    echo 1 > /proc/sys/net/ipv4/ip_forward
    ;;
  "stop")
    # Turn off IP forwarding
    echo 0 > /proc/sys/net/ipv4/ip_forward
    
    # Define firewall rule
    deny_connection_rules
    ;;
  "restart")
    \$0 stop
    \$0 start
    ;;
  *)
    echo "Usage: /etc/init.d/firewall {start|stop|restart|init|config}" 
    ;;
esac
EOF


echo "Setup DRBL..."
## drbl.pl will generate a file name 'drbl_deploy.sh'
## if using automatic mac address detected, 
## drblpush/macadr* will contain mac address that already detected
drblpush.$$/drbl.pl $OUT NO_OUTPUT
zip -j macadr.zip drblpush.$$/macadr* $OUT
lineno=`wc -l drbl_deploy.sh | awk '{ print $1; }'`
lineno=`expr $lineno + 1`
bsdsum1=`sum macadr.zip | awk '{ print $1; }'`
bsdsum2=`sum macadr.zip | awk '{ print $2; }'`
/usr/bin/perl -p -i -e "s/=1#<LINENO>/=$lineno/" drbl_deploy.sh
/usr/bin/perl -p -i -e "s/=1#<CHECKSUM1>/=$bsdsum1/" drbl_deploy.sh
/usr/bin/perl -p -i -e "s/=1#<CHECKSUM2>/=$bsdsum2/" drbl_deploy.sh
cat macadr.zip >> drbl_deploy.sh
chmod 755 drbl_deploy.sh
mv drbl_deploy.sh /opt/drbl/sbin
rm -f macadr.zip

# Blake, 2003/11/21, removeentries
## function: removeentries
## $1 - Tag for START
## $2 - Tag for End
## $3 - File to read
removeentries() {
  while read line; do
    case "$line" in $1)
      while read line; do
        if [ "$line" = "$2" ]; then break; fi
      done
    esac
    if [ "$line" = "$2" ]; then continue; fi
    echo "$line"
  done < $3
}

START_TAG="# Added by DRBL."
END_TAG="# Added by DRBL Done."

## copy dhcpd.conf
if [ ! -e /etc/dhcp3/dhcpd.conf ]; then
  mv /etc/dhcp3/dhcpd.conf /etc/dhcp3/dhcpd.conf.drbl
fi
cp dhcpd.conf /etc/dhcp3
cp dhcp /etc/default/dhcp3-server
rm -f dhcpd.conf
rm -f dhcp

## copy hosts
# Blake, 2003/11/21
#if [ ! -e /etc/hosts.drbl ]; then
#  mv /etc/hosts /etc/hosts.drbl
#fi
#cp hosts /etc/
#if [ -f /etc/FQDN ]; then
#  ## Blake, 2003/09/02
#  ##for ip in `cat /etc/dhcp3/dhcpd.conf | grep "next-server" | awk '{ print $2; }' | cut -d";" -f1`
#  ##do
#  ##  perl -p -i -e "s/$ip.*//g" /etc/hosts
#  ##done
#  outif=`/sbin/route -n | grep -e "^0.0.0.0" | awk '{ print $8; }'`
#  outip=`/sbin/ifconfig $outif | grep "inet addr" | cut -d":" -f2 | cut -d " " -f1`
#  fqdn=`cat /etc/FQDN`
#  hostname=`cat /etc/hostname`
#  if [ "$fqdn" != "$hostname" ]; then
#    echo "$outip $fqdn $hostname" >> /etc/hosts
#  else 
#    echo "$outip $hostname" >> /etc/hosts
#  fi
#fi
removeentries "$START_TAG" "$END_TAG" /etc/hosts > hosts.$$
echo "$START_TAG" >> hosts.$$
cat hosts >> hosts.$$
echo "$END_TAG" >> hosts.$$
cp hosts.$$ /etc/hosts
rm -f hosts.$$

## update-hosts.pl will generate a file named 'skel_hosts'
##drblpush/update-hosts.pl hosts
##cp skel_hosts $imageroot/etc/hosts
##cp skel_hosts /etc/hosts
##rm -f skel_hosts
if [ "$NO_DRBLMGRD" = "false" ]; then
  for dir in `ls $imagehost` 
  do
    if [ "$dir" != "." -a "$dir" != ".." ]; then
	  cp hosts $imagehost/$dir/etc
	fi
  done
fi
rm -f hosts

## nfs-user-server
# Blake, 2003/11/21,
#if [ ! -e /etc/exports.drbl ]; then
#  mv /etc/exports /etc/exports.drbl
#fi
#cp exports /etc
#rm -f exports
removeentries "$START_TAG" "$END_TAG" /etc/exports > exports.$$
echo "$START_TAG" >> exports.$$
cat exports >> exports.$$
echo "$END_TAG" >> exports.$$
cp exports.$$ /etc/exports
rm -f exports.$$
rm -f exports

removeentries "$START_TAG" "$END_TAG" /etc/netgroup > netgroup.$$
echo "$START_TAG" >> netgroup.$$
cat netgroup >> netgroup.$$
echo "$END_TAG" >> netgroup.$$
cp netgroup.$$ /etc/netgroup
rm -f netgroup.$$
rm -f netgroup

# Blake, 2004/02/11, nfs-kernel-server
#echo "RPCNFSDCOUNT=$total" > /etc/default/nfs-user-server
#if [ ! -e /etc/init.d/nfs-user-server.drbl ]; then
#  mv /etc/init.d/nfs-user-server /etc/init.d/nfs-user-server.drbl
#fi
#cp drblpush/nfs-user-server /etc/init.d/
if [ $total -gt 8 ]; then
  #/usr/bin/perl -p -i -e "s/RPCNFSDCOUNT=.*/RPCNFSDCOUNT=$total/" /etc/init.d/nfs-kernel-server
  /usr/bin/perl -p -i -e "s/RPCNFSDCOUNT=.*/RPCNFSDCOUNT=$total/" /etc/default/nfs-kernel-server
fi

## Blake, 2004/07/19, use iptables script in /etc/init.d/
## copy firewall
chmod a+x $FIREWALL
if [ -f /etc/init.d/iptables ]; then
  ./$FIREWALL restart
  /etc/init.d/iptables save active
else
  cp $FIREWALL /etc/init.d/firewall
  ln -fs /etc/init.d/firewall /etc/rc2.d/S99firewall 
  ln -fs /etc/init.d/firewall /etc/rc5.d/S99firewall
fi

## 2004/03/04
## do the following configuration if the nis is the master server
## copy ypserv.securenets
. /etc/default/nis
if [ "$NISSERVER" = "master" ]; then

  # ypserv.securenets
  removeentries "$START_TAG" "$END_TAG" /etc/ypserv.securenets > ypserv.securenets.$$
  echo "$START_TAG" >> ypserv.securenets.$$
  cat ypserv.securenets >> ypserv.securenets.$$
  for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
  do
    ip=$(/sbin/ifconfig $eth | grep "inet addr" | awk -F: '{print $2;}' | awk '{print $1;}')
    if [ "$ip" != "" ]; then
      echo "255.255.255.255	$ip" >> ypserv.securenets.$$ 
    fi
  done
  echo "$END_TAG" >> ypserv.securenets.$$
  cp ypserv.securenets.$$ /etc/ypserv.securenets
  rm -f ypserv.securenets.$$
  rm -f ypserv.securenets

  # yp.conf
  removeentries "$START_TAG" "$END_TAG" /etc/yp.conf > yp.conf.$$
  echo "$START_TAG" >> yp.conf.$$
  for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
  do
    ip=$(/sbin/ifconfig $eth | grep "inet addr" | awk -F: '{print $2;}' | awk '{print $1;}')
    if [ "$ip" != "" ]; then
      echo "domain $nisdomain server $ip" > yp.conf.$$
      break
    fi
  done
  echo "$END_TAG" >> yp.conf.$$
  cp yp.conf.$$ /etc/yp.conf
  rm -f yp.conf.$$

  # nis
  if [ ! -d /var/yp/$nisdomain ]; then
    echo "$nisdomain" > /etc/defaultdomain
	/bin/nisdomainname $nisdomain
    drblpush.$$/autoypinit
	/etc/init.d/nis restart
  fi
fi

## the script will generate a file named 'skel_ypserv.securenets'
##drblpush/update-ypserv.pl $SECURENETS
##cp skel_ypserv.securenets /etc/ypserv.securenets
#rm -f ypserv.securenets

# start inetd, dhcpd
/etc/init.d/inetd start
/etc/init.d/dhcp3-server start

# Blake, 2004/02/24, cupsys
if [ "$cupsys_substr" != "" -a "$(dpkg -l cupsys | grep "cupsys" | cut -d' ' -f1)" = "ii" ]; then
  cp /etc/cups/cupsd.conf /etc/cups/cupsd.conf.orig
  /usr/bin/perl -p -i -e "s/127.0.0.1/$cupsys_substr/g" /etc/cups/cupsd.conf
  /etc/init.d/cupsys restart
fi

# Blake, 2004/03/04, openmosix.map
if [ "$(dpkg -l openmosix | grep "openmosix" | cut -d' ' -f1)" = "ii" ]; then
  cp openmosix.map /etc/
  openmosixId=`tail -n 1 /etc/openmosix.map | awk '{ print $1; }'`
  openmosixId=`expr $openmosixId + 1`
  openmosixIP=$(/sbin/ifconfig eth0 | grep "inet addr" | awk -F: '{print $2;}' | awk '{print $1;}')
  if [ "$openmosixIP" != "" ]; then
    echo "$openmosixId	$openmosixIP	1" >> /etc/openmosix.map
  fi

  for host in `ls $imagehost`; do
    if [ "$host" = "." -o "$host" = ".." ]; then continue; fi
    cp drblpush.$$/openmosix_map.sh $imagehost/$host/etc/rc2.d/S19openmosix_map.sh
    cp openmosix.map $imagehost/$host/etc/
  done
  if [ -f /etc/init.d/openmosix ]; then /etc/init.d/openmosix restart; fi
  if [ -f /etc/init.d/openmosixcollector ]; then /etc/init.d/openmosixcollector restart; fi
fi
rm -f openmosix.map

# Blake, 2004/02/11, nfs-kernel-server
# drblmgrd && nfs-user-server
if [ "$NO_DRBLMGRD" = "false" ]; then
  drblpush.$$/drblmgrd init_d
  mkdir -p /opt/drbl/sbin
  cp drblpush.$$/drblmgrd /opt/drbl/sbin
  chmod 755 /opt/drbl/sbin/drblmgrd
  /etc/init.d/drblmgrd stop
  /etc/init.d/drblmgrd start
  CPWD=$(pwd)
  cd /etc/rc2.d/; ln -fs ../init.d/drblmgrd S99drblmgrd; cd $CPWD
  cd /etc/rc5.d/; ln -fs ../init.d/drblmgrd S99drblmgrd; cd $CPWD

  # restart nfs-user-server 
  #/etc/init.d/nfs-user-server restart
  /etc/init.d/nfs-kernel-server restart 2> /dev/null
  # start firewall (nat)
  if [ -f /etc/init.d/iptables ]; then
    /etc/init.d/iptables start
  else
    /etc/init.d/firewall start
  fi
fi

## /opt/drbl/sbin/drbl_deploy.sh
#echo "Create clients..This will take several minutes.."
#/opt/drbl/sbin/drbl_deploy.sh

##
##
echo "------------NCHC OPENSOURCE TASKFORCE-----------------";
echo "Thanks for choosing DRBL Debian Solution              ";
echo "If you have any question, please visit the web site:  ";
echo " http://drbl.nchc.org.tw/debian                       ";
echo "or email to "
echo " c00hkl00@nchc.org.tw, c00jhs00@nchc.org.tw";
echo "-------------------Thank You--------------------------";
