#!/bin/sh
# License: GPL
# Author: Blake, Kuo-Lien Huang 
# Description:
#   setup routing table according /etc/dhcp3/dhcpd.conf
#

case "$1" in
  "add") cmd="add";;
  "del") cmd="del";;
  *) cmd="add";
esac

routing_device="$(/sbin/route -n | grep "^0.0.0.0" | awk '{ print $8; }')"
while read line; do
 
    if [ "$(echo "$line" | grep "next-server")" != "" ]; then
      next_server="$(echo "$line" | awk '{ print $2; }' | cut -d\; -f1)"
      for netdev in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`; do
        if [ "$(/sbin/ifconfig $netdev | grep "inet addr" | cut -d: -f2 | cut -d' ' -f1)" = "$next_server" ]; then
	  routing_device="$netdev"; break
	fi
      done
    elif [ "$(echo "$line" | grep "fixed-address")" != "" ]; then
      fixed_address="$(echo "$line" | awk '{ print $2; }' | cut -d\; -f1)"
      echo "/sbin/route $cmd -host $fixed_address dev $routing_device"
      /sbin/route $cmd -host $fixed_address dev $routing_device
    elif [ "$(echo "$line" | grep "range")" != "" ]; then
      range_s_ip="$(echo "$line" | awk '{ print $2; }' | cut -d\; -f1)"
      range_e_ip="$(echo "$line" | awk '{ print $3; }' | cut -d\; -f1)"
      range_s_ip_b="$(/usr/bin/netmask -b $range_s_ip | cut -d\/ -f1 | sed -e 's/ //g')"
      range_e_ip_b="$(/usr/bin/netmask -b $range_e_ip | cut -d\/ -f1 | sed -e 's/ //g')"
      drblpush.$$/btod $range_s_ip_b $range_e_ip_b |\
      while read d; do
        address="$(/usr/bin/netmask $d | cut -d\/ -f1 | sed -e 's/ //g')"
        echo "/sbin/route $cmd -host $address dev $routing_device"
        /sbin/route $cmd -host $address dev $routing_device
      done
    fi

done < /etc/dhcp3/dhcpd.conf
