#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description:
#   * setup the drbl network automatically
#   * 2003/08/12
#       ask user if he would like to detect MAC address on all NICs

imageroot="/var/lib/diskless/default/root"
imagehost="/var/lib/diskless/default"
tftproot="/tftpboot"

if [ -e /etc/default/drbl ]; then
  . /etc/default/drbl
fi

apt-get install tcpdump

if [ -e /opt/drbl/sbin/drbl_deploy.sh ]; then
  rm -rf drblpush.$$/mac_cache
  rm -rf drblpush.$$/drbl_conf
  found=0
  /opt/drbl/sbin/drbl_deploy.sh macadr drblpush.$$
  for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`; do
    if [ -f drblpush.$$/macadr-$eth.txt ] ; then
      if [ "$(wc -l drblpush.$$/macadr-$eth.txt | cut -d' ' -f1)" != "0" ]; then
        found=1
        cat drblpush.$$/macadr-$eth.txt | awk -v eth=$eth '{ print "["eth"] "$1; }' >> drblpush.$$/mac_cache
      fi
    fi
  done
  if [ $found -eq 1 ]; then
    echo "==============================================="
    more drblpush.$$/mac_cache
    echo "==============================================="
    echo "You have detected the above mac address before."
    echo -n "Do you want to include them [Y|n]? "
    read ANS
    if [ "$ANS" = "N" -o "$ANS" = "n" ]; then 
      rm -f drblpush.$$/macadr-*.txt 
      rm -f drblpush.$$/mac_cache
    fi
  fi
fi

# wget, mknbi, netmask
apt-get -y install wget mknbi netmask

# chroot to install nis, devfsd
#cat <<-EOF > $imageroot/root/nis.sh
#/sbin/autodebconf_readline
#apt-get -y install nis
#if [ -e /etc/rc2.d/S20makedev ]; then
#  mv /etc/rc2.d/S20makedev /etc/rc2.d/K20makedev
#fi
#/sbin/autodebconf_dialog
#EOF
#chmod 755 $imageroot/root/nis.sh
#mount -t proc proc $imageroot/proc
#chroot $imageroot /root/nis.sh
#umount $imageroot/proc
#rm -rf $imageroot/root/nis.sh

# stop inetd, dhcp
/etc/init.d/inetd stop
/etc/init.d/dhcp3-server stop

## function: status
status() {
  rm -f drblpush.$$/setup-drbl-auto.all
  for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
  do
    if [ "$eth" != "$outeth" ]; then
      cat drblpush.$$/setup-drbl-auto.$eth >> drblpush.$$/setup-drbl-auto.all
    fi
  done
  num=$(perl -ane 'print "\U$F[0]\n"' drblpush.$$/setup-drbl-auto.all | sort | uniq | wc | awk '{print $1}')
  echo "======================================="
  perl -ane 'print "\U$F[0]\n"' drblpush.$$/setup-drbl-auto.all | sort | uniq
  echo "Total: $num"
  echo "======================================="
}

## function: stop
stop() {
  TMP=`mktemp /tmp/pid.XXXXXX`
  /bin/ps -e | grep 'tcpdump' | sed -e 's/^ *//' -e 's/ .*//' > $TMP
  while read pid
  do
    #echo "kill -9 $pid"
    kill -9 $pid
  done < $TMP
  rm -f $TMP
}

## main
outeth=$(/sbin/route -n | grep -e "^0.0.0.0" | awk '{ print $8; }')
echo -n "Detect MAC address on all NICs (include outgoing NIC) [y|N]? "
read ANS
if [ "$ANS" = "Y" -o "$ANS" = "y" ]; then outeth=""; fi

for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then
    #/usr/sbin/tcpdump -qte -i $eth > drblpush.$$/setup-drbl-auto.$eth 2> /dev/null &
    /usr/sbin/tcpdump -tel -i $eth broadcast and port bootpc > drblpush.$$/setup-drbl-auto.$eth 2> /dev/null &
  fi
done

##
echo "Start detecting MAC address...."
echo "1. View the status of MAC address detection"
echo "2. Stop MAC address detection and Start DRBL configuration"
while read CMD
do
  if [ "$CMD" = "2" ]; then
    stop
    break
  elif [ "$CMD" = "1" -o "$CMD" = "" ]; then
    status
    echo "1. View the status of MAC address detection"
    echo "2. Stop MAC address detection and Start DRBL configuration"
  fi
done

## analyze the mac address 
for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then
    perl -ane 'print "\U$F[0]\n"' drblpush.$$/setup-drbl-auto.$eth | sort | uniq > drblpush.$$/macadr-auto-$eth
  fi
done

ethmatch=""
for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" -a -f drblpush.$$/macadr-auto-$eth ]; then

     for ethx in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`    
     do
       if [ "$ethx" = "$eth" ]; then
         ethmatch="$eth=$eth $ethmatch"
       elif [ "$ethx" != "$outeth" -a -f drblpush.$$/macadr-auto-$ethx ]; then
         #echo "diff drblpush/macadr-auto-$eth drblpush/macadr-auto-$ethx"
         #read ANS
         if [ "$(diff drblpush.$$/macadr-auto-$eth drblpush.$$/macadr-auto-$ethx)" = "" ]; then
           rm -f drblpush.$$/macadr-auto-$ethx
           ethmatch="$eth=$ethx $ethmatch"  
         fi
       fi
     done
     
  fi
done

for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" -a ! -f drblpush.$$/macadr-$eth.txt ]; then
    touch drblpush.$$/macadr-$eth.txt
  fi
done

for ethmac in `ls drblpush.$$/macadr-auto-*`
do
  eth=${ethmac/drblpush.$$\/macadr-auto-/}
  run=1
  macadr=""
  while [ $run -eq 1 ]
  do
    for match in `echo $ethmatch`
    do
      # make sure macadr is not ""
      if [ "$macadr" = "" ]; then 
        if ! read macadr ; then
          run=0
          break
        fi 
      fi

      # assign macadr
      if [ "$(echo "$match" | grep -e "^$eth=")" != "" ]; then
        ethx=${match/$eth=/} 
        echo "$macadr" >> drblpush.$$/macadr-$ethx.txt
        if ! read macadr ; then
          run=0
          break
        fi
      fi 
    done
  done < $ethmac
done

rm -f drblpush.$$/macadr-auto-*

## sketch diagram
echo "The sketch diagram of DRBL configuration"
echo "      +---------------+"
echo "      |  DRBL Server  |"
if [ "$outeth" != "" ]; then
  echo "      |               +-- OUT ($outeth)"
fi
for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then
    numclients=`wc -l drblpush.$$/macadr-$eth.txt| awk '{ print $1 }'` 
    echo "      |               |"
    echo "      |               +-- DRBL Client ($eth): $numclients"
  fi
done
echo "      |               |"
echo "      +---------------+"
echo

print_choice() {
  for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
  do
    if [ "$eth" != "$outeth" ]; then
      echo "$eth: view the MAC address of DRBL clients through $eth"
    fi
  done 
  echo "Y(y): OK! Let's do it"
  echo "N(n): No.. I would like to stop"
  echo -n "Enter your choice [Y]: "
}

print_choice
while read ANS
do
  if [ "$ANS" = "N" -o "$ANS" = "n" ]; then
    # start inetd, dhcpd
    /etc/init.d/inetd start
    /etc/init.d/dhcp3-server start
    exit
  elif [ "$ANS" = "Y" -o "$ANS" = "y" -o "$ANS" = "" ]; then
    break
  else 
    if [ -f drblpush.$$/macadr-$ANS.txt ]; then
      echo "========== $ANS =========="
      cat drblpush.$$/macadr-$ANS.txt
      echo "=========================="
    else 
      echo "No such choice.."
    fi
    print_choice
  fi
done

## generate the config file for drbl.pl, firewall and ypserv.securenets
echo "Setup DRBL..."
OUT="drblpush.$$/drbl_config"
FIREWALL="drblpush.$$/firewall"
SECURENETS="ypserv.securenets"

# remove old PXE configuration
for ip in `cat /etc/dhcp3/dhcpd.conf | grep "fixed-address" | cut -d\; -f1 | awk '{ print $2; }'`
do
  pxelocal=`/usr/bin/gethostip $ip | cut -d' ' -f3`
  if [ "$pxelocal" != "" -a -f /tftpboot/pxelinux.cfg/$pxelocal ]; then 
    rm -f /tftpboot/pxelinux.cfg/$pxelocal
  fi
done
perl -p -i -e "s/^default.*/default drbl/" /tftpboot/pxelinux.cfg/default

#nameserver="$(head -n 1 /etc/resolv.conf | awk '{print $2}')"
while read line; do
  if [ "$(echo "$line" | grep -e "^nameserver")" != "" ]; then
    nameserver="$(echo "$line" | awk '{print $2}')"
    break
  fi
done < /etc/resolv.conf

if [ "$nameserver" = "" ]; then nameserver="168.95.1.1"; fi
domain="drbl.org"
nisdomain="$(nisdomainname)"

# drbl_config
cat <<-EOF > $OUT
# GENERATED BY setup-drbl-auto.sh
[general]
nameserver=$nameserver
domain=$domain
nisdomain=$nisdomain
EOF

## use these two special cases
nbi="mkinitrd-net"
pxe="pxelinux.0"
cat <<-EOF >> $OUT
nbi=$nbi
pxe=$pxe
EOF

# firewall
cat <<-EOF > $FIREWALL
#!/bin/sh
# generated by drblpush
# Author: Blake, Kuo-Lien Huang
# copyright: GPL

EOF

# yp.securenets
cat <<-EOF > $SECURENETS
# Generated by drblpush
# Author: Blake, Kuo-Lien Huang
# License: GPL

# Always allow access for localhost
255.0.0.0	127.0.0.0
EOF

total=0
n=0
for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then

    t=`wc -l drblpush.$$/macadr-$eth.txt | awk '{ print $1 }'`
    total=`expr $total + $t`

    label=`expr $n + 1`
    hostname=`hostname`
    hostname="$hostname-$eth-"

    ip="$(/sbin/ifconfig $eth | grep "inet addr" | cut -d":" -f2 | cut -d" " -f1)"
    if [ "$ip" = "" ]; then continue; fi
    broadcast="$(/sbin/ifconfig $eth | awk '/Bcast/{print $3;}' | awk -F: '{print $2;}')"

    #network="$(echo $ip | awk -F. '{print $1"."$2"."$3".0"}')"
    netmask=$(/sbin/ifconfig $eth | awk '/Mask/{print $4; }' | awk -F: '{print $2;}')
    network=$(/usr/bin/netmask $ip/$netmask | cut -d/ -f1 | awk '{print $1;}')
    if [ "$network" = "" ]; then
      netmask="255.255.255.0"
      network=`echo "$ip" | awk -F. '{print $1"."$2"."$3".0"; }'`
    fi

    nfsserver=$ip
    nisserver=$ip
    bootserver=$ip
    # drbl_config
    cat <<-EOF >> $OUT
[drbl$label]
interface=$eth
network=$network
netmask=$netmask
broadcast=$broadcast
nfsserver=$nfsserver
nisserver=$nisserver
bootserver=$bootserver
nbi=$nbi
pxe=$pxe
hostname=$hostname
mac=drblpush.$$/macadr-$eth.txt

EOF
    # firewall
    #echo "iptables -t nat -A POSTROUTING -s $network/24 -j MASQUERADE" >> $FIREWALL
    echo "$eth""_rule_1=\"iptables -t nat -A POSTROUTING -s $network/$netmask -j MASQUERADE\"" >> $FIREWALL
    echo "$eth""_rule_2=\"iptables -t nat -D POSTROUTING -s $network/$netmask -j MASQUERADE\"" >> $FIREWALL

    # add this subnet to ypserv.securnets
    #echo "255.255.255.0	$network" >> $SECURENETS
    echo "$netmask	$network" >> $SECURENETS
 
    # create init.$network to $imageroot/sbin/
    if [ ! -e $imageroot/sbin/$network ]; then mkdir $imageroot/sbin/$network; fi
    #IPCMD="ifconfig | grep -A1 eth0 | grep -v eth0 | sed 's/^.*inet addr:\([0-9\.]\+\).*$/\1/'"
    NET=`echo "$nfsserver" | awk -F\. '{ print $1 "." $2 "." $3; }'`
    IPCMD="ifconfig | grep \"$NET\" | sed 's/^.*inet addr:\([0-9\.]\+\).*$/\1/' | head -n 1"
    cat <<-EOF > $imageroot/sbin/$network/init
#!/bin/sh

# Don't do anything special if computer is already booted
if [ \$\$ -ne 1 ]
then
	exec /sbin/init.orig $*
	echo "FATAL ERROR: exec /sbin/init.orig failed" >&2
	exit 1
fi

# Don't do anything special if root is rw (ie master system).
if touch /test-rw
then
	rm /test-rw
	echo "WARNING: master system installed" >&2
	exec /sbin/init.orig $*
	echo "FATAL ERROR: exec /sbin/init.orig failed" >&2
	exit 1
fi

# Try and find configuration file
if [ -f /etc/diskless-image/config ]
then
	# Load config file
	. /etc/diskless-image/config

	# Get IP address, need to mount /proc first
	# Already mount at /sbin/init (klhaung 2002/12/20)
	# mount -n none /proc -t proc
	#IP=`cat /proc/cmdline | sed 's/^.*nfsaddrs=\([0-9\.]\+\).*$/\1/'`
EOF
    echo 'IP=`'$IPCMD'`' >> $imageroot/sbin/$network/init
    cat <<-EOF >> $imageroot/sbin/$network/init

	echo "Client IP address is \$IP"

	# Mount client's /etc directory
	echo -n "Mounting NFS-root directories..."
	mount -n $nfsserver:/\$nfshostsdir/\$IP/etc /etc -orw,nolock

	# Update entries in /etc/mtab
	rm -f /etc/mtab~ /etc/nologin
	: > /etc/mtab
	mount -o remount /
	mount -o remount /etc
	mount -o remount /proc

	# report success
	echo "done."
else
	echo "ERROR: Cannot find image config file"
	echo "       Not mounting NFS-root directories"
fi

# Only should get here if something went wrong
exec /sbin/init.orig $*
echo "FATAL ERROR: exec /sbin/init.orig failed" >&2
exit 1
EOF
    chmod a+x $imageroot/sbin/$network/init

    # diskless-newhost for drblmgrd
    if [ "$NO_DRBLMGRD" = "false" ]; then
      if [ "$ip" = "" ]; then $ip="$nfsserver"; fi
      echo "create diskless host: tmphost $ip"
      if [ "$ip" != "" -a -e $imagehost/$ip ]; then 
        rm -rf $imagehost/$ip;
        rm -f $tftproot/$ip
        other=`echo "$ip" | awk -F\. '{ print $1"."$2"."$3".*"; }'`
        if [ "$other" != "" ]; then 
          rm -rf $imagehost/$other
          rm -f $tftproot/$other
        fi
      fi
      if [ ! -e $imagehost/$ip ]; then
        diskless-newhost $imageroot $ip host=tmphost mailname=tmphost >& /dev/null
        # Blake, 2004/08/16, fstab, just for consistency
        cat <<-FSTAB > $imagehost/$ip/etc/fstab
none    /proc   proc	defaults    1   0
$ip:$imagehost/root       /       nfs ro,defaults,nolock 0 1
$ip:$imagehost/$ip/var    /var    nfs defaults,nolock 0 1
$ip:$imagehost/$ip/root   /root   nfs defaults,nolock 0 2
$ip:/home                                /home   nfs defaults,nolock 0 2
$ip:$imagehost/root/var/lib/dpkg  /var/lib/dpkg   nfs
ro,defaults,nolock  0 1
$ip:/opt                                 /opt    nfs defaults,nolock 0 1
$ip:/var/mail    /var/mail   nfs defaults,nolock 0 1
tmpfs   /tmp    tmpfs   defaults    0   0
#/dev/nbd0	/tmp	ext2	defaults	0	0
FSTAB
        # Blake, 2004/03/09, for mozilla 
        cp -r $imageroot/var/lib/mozilla/* $imagehost/$ip/var/lib/mozilla
        # Blake, 2004/04/27, for kde menu
        rm -rf $imagehost/$ip/var/lib/kde/menu
        cp -r $imageroot/var/lib/kde/menu $imagehost/$ip/var/lib/kde/ 
        # Blake, 2004/03/09, client's root
        mkdir $imagehost/$ip/root
        ##cp $imageroot/root/.profile $imagehost/$ip/root
        ##cp $imageroot/root/.bashrc $imagehost/$ip/root
        cat <<-EOF > $imagehost/$ip/root/.profile
# ~/.profile: executed by Bourne-compatible login shells.

if [ -f ~/.bashrc ]; then
  . ~/.bashrc
fi

PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/bin/X11
export PATH

mesg n
EOF
        # 2003/08/25
        if [ -d /root/.kde ]; then
          cp -r /root/.kde $imagehost/$ip/root
        fi
      fi
      cat <<-NETWORKS > $imagehost/$ip/etc/networks
localnet $network
NETWORKS
      cat <<-YPCONF > $imagehost/$ip/etc/yp.conf
domain $nisdomain server $ip
YPCONF
      cat <<-DEFAULTDOMAIN > $imagehost/$ip/etc/defaultdomain
$nisdomain
DEFAULTDOMAIN

      if [ -e $imagehost/$ip/etc/passwd ]; then
        NIS_PWD=`cat $imagehost/$ip/etc/passwd | grep "+::::::"`
        if [ "\$NIS_PWD" = "" -o "\$NIS_PWD" != "+::::::" ]; then
          echo "+::::::" >> $imagehost/$ip/etc/passwd
        fi
      fi

      if [ -e $imagehost/$ip/etc/group ]; then
        NIS_GRP=`cat $imagehost/$ip/etc/group | grep "+:::"`
        if [ "\$NIS_GRP" = "" -o "\$NIS_GRP" != "+:::" ]; then
          echo "+:::" >> $imagehost/$ip/etc/group
        fi
      fi

      if [ -e $imagehost/$ip/etc/shadow ]; then
        NIS_SHADOW=`cat $imagehost/$ip/etc/shadow | grep "+::::::::"`
        if [ "\$NIS_SHADOW" = "" -o "\$NIS_SHADOW" != "+::::::::" ]; then
	      echo "+::::::::" >> $imagehost/$ip/etc/shadow
        fi
      fi

      echo "$nameserver" | awk -F, '{ for(i=1;i<=NF;i++) print "nameserver ",$i; }' > $imagehost/$ip/etc/resolv.conf
    fi
    # end 

    n=`expr $n + 1`
  fi
done

# firewall
cat <<-EOF >> $FIREWALL
masquerade_only_rules()
{
EOF

for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then
     echo "  \$""$eth""_rule_1" >> $FIREWALL
  fi
done

cat <<-EOF >> $FIREWALL

  iptables -P FORWARD ACCEPT
  iptables -P INPUT ACCEPT
}
EOF

cat <<-EOF >> $FIREWALL
deny_connection_rules()
{
EOF

for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then
     echo "  \$""$eth""_rule_2" >> $FIREWALL
  fi
done

cat <<-EOF >> $FIREWALL
}
EOF

cat <<-EOF >> $FIREWALL

case \$1 in
  "start")
    # Define firewall rule
    masquerade_only_rules
 
    # Turn on IP forwarding
    echo 1 > /proc/sys/net/ipv4/ip_forward
    ;;
  "stop")
    # Turn off IP forwarding
    echo 0 > /proc/sys/net/ipv4/ip_forward
    
    # Define firewall rule
    deny_connection_rules
    ;;
  "restart")
    \$0 stop
    \$0 start
    ;;
  *)
    echo "Usage: /etc/init.d/firewall {start|stop|restart|init|config}" 
    ;;
esac
EOF

drblpush.$$/drbl.pl $OUT NO_OUTPUT
zip -j macadr.zip drblpush.$$/macadr* $OUT
lineno=`wc -l drbl_deploy.sh | awk '{ print $1; }'`
lineno=`expr $lineno + 1`
bsdsum1=`sum macadr.zip | awk '{ print $1; }'`
bsdsum2=`sum macadr.zip | awk '{ print $2; }'`
/usr/bin/perl -p -i -e "s/=1#<LINENO>/=$lineno/" drbl_deploy.sh
/usr/bin/perl -p -i -e "s/=1#<CHECKSUM1>/=$bsdsum1/" drbl_deploy.sh
/usr/bin/perl -p -i -e "s/=1#<CHECKSUM2>/=$bsdsum2/" drbl_deploy.sh
cat macadr.zip >> drbl_deploy.sh
chmod 755 drbl_deploy.sh
mv drbl_deploy.sh /opt/drbl/sbin
rm -f macadr.zip

# Blake, 2003/11/21, removeentries
## function: removeentries
## $1 - Tag for START
## $2 - Tag for End
## $3 - File to read
removeentries() {
  while read line; do
    case "$line" in $1)
      while read line; do
        if [ "$line" = "$2" ]; then break; fi
      done
    esac
    if [ "$line" = "$2" ]; then continue; fi
    echo "$line"
  done < $3
}

START_TAG="# Added by DRBL."
END_TAG="# Added by DRBL Done."

## copy dhcpd.conf
if [ ! -e /etc/dhcpd.conf.drbl ]; then
  mv /etc/dhcp3/dhcpd.conf /etc/dhcp3/dhcpd.conf.drbl
fi
cp dhcpd.conf /etc/dhcp3
cp dhcp /etc/default/dhcp3-server
rm -f dhcpd.conf
rm -f dhcp

## copy hosts
# Blake, 2003/11/21, add new entries in /etc/hosts
# instead of replace the file
#if [ ! -e /etc/hosts.drbl ]; then
#  mv /etc/hosts /etc/hosts.drbl
#fi
#cp hosts /etc/
#if [ -f /etc/FQDN ]; then
#  ## Blake, 2003/09/02
#  ##for ip in `cat /etc/dhcp3/dhcpd.conf | grep "next-server" | awk '{ print $2; }' | cut -d";" -f1`
#  ##do
#  ##  perl -p -i -e "s/$ip.*//g" /etc/hosts
#  ##done
#  outif=`/sbin/route -n | grep -e "^0.0.0.0" | awk '{ print $8; }'`
#  outip=`/sbin/ifconfig $outif | grep "inet addr" | cut -d":" -f2 | cut -d " " -f1`
#  fqdn=`cat /etc/FQDN`
#  hostname=`cat /etc/hostname`
#  if [ "$fqdn" != "$hostname" ]; then
#    echo "$outip $fqdn $hostname" >> /etc/hosts
#  else 
#    echo "$outip $hostname" >> /etc/hosts
#  fi
#fi
removeentries "$START_TAG" "$END_TAG" /etc/hosts > hosts.$$
echo "$START_TAG" >> hosts.$$
cat hosts >> hosts.$$
echo "$END_TAG" >> hosts.$$
cp hosts.$$ /etc/hosts
rm -f hosts.$$

## update-hosts.pl will generate a file named 'skel_hosts'
##drblpush/update-hosts.pl hosts
##cp skel_hosts $imageroot/etc/hosts
##cp skel_hosts /etc/hosts
##rm -f skel_hosts
if [ "$NO_DRBLMGRD" = "false" ]; then
  for dir in `ls $imagehost` 
  do
    if [ "$dir" != "." -a "$dir" != ".." ]; then
	  cp hosts $imagehost/$dir/etc
	fi
  done
fi
rm -f hosts

## nfs-user-server
# Blake, 2003/11/21, Add new entries in /etc/exports 
# instead of replace the file
#if [ ! -e /etc/exports.drbl ]; then
#  mv /etc/exports /etc/exports.drbl
#fi
#cp exports /etc
removeentries "$START_TAG" "$END_TAG" /etc/exports > exports.$$
echo "$START_TAG" >> exports.$$
cat exports >> exports.$$
echo "$END_TAG" >> exports.$$
cp exports.$$ /etc/exports
rm -f exports.$$
rm -f exports

removeentries "$START_TAG" "$END_TAG" /etc/netgroup > netgroup.$$
echo "$START_TAG" >> netgroup.$$
cat netgroup >> netgroup.$$
echo "$END_TAG" >> netgroup.$$
cp netgroup.$$ /etc/netgroup
rm -f netgroup.$$
rm -f netgroup

# Blake, 2004/02/11, kernel-nfs-server
#echo "RPCNFSDCOUNT=$total" > /etc/default/nfs-user-server
#if [ ! -e /etc/init.d/nfs-user-server.drbl ]; then
#  mv /etc/init.d/nfs-user-server /etc/init.d/nfs-user-server.drbl
#fi
#cp drblpush/nfs-user-server /etc/init.d/
if [ $total -gt 8 ]; then
  #/usr/bin/perl -p -i -e "s/RPCNFSDCOUNT=.*/RPCNFSDCOUNT=$total/" /etc/init.d/nfs-kernel-server
  /usr/bin/perl -p -i -e "s/RPCNFSDCOUNT=.*/RPCNFSDCOUNT=$total/" /etc/default/nfs-kernel-server
fi

## Blake, 2004/07/19. use script "iptables" in /etc/init.d
## copy firewall
chmod a+x $FIREWALL
if [ -f /etc/init.d/iptables ]; then
  ./$FIREWALL restart
  /etc/init.d/iptables save active
else
  cp $FIREWALL /etc/init.d/firewall
  ln -fs /etc/init.d/firewall /etc/rc2.d/S99firewall 
  ln -fs /etc/init.d/firewall /etc/rc5.d/S99firewall
fi

## 2004/03/04
## do the following configuration if the nis is the master server
## copy ypserv.securenets
. /etc/default/nis
if [ "$NISSERVER" = "master" ]; then

  # ypserv.securenets
  removeentries "$START_TAG" "$END_TAG" /etc/ypserv.securenets > ypserv.securenets.$$
  echo "$START_TAG" >> ypserv.securenets.$$
  cat ypserv.securenets >> ypserv.securenets.$$
  for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
  do
    ip=$(/sbin/ifconfig $eth | grep "inet addr" | awk -F: '{print $2;}' | awk '{print $1;}')
    if [ "$ip" != "" ]; then
      echo "255.255.255.255	$ip" >> ypserv.securenets.$$ 
    fi
  done
  echo "$END_TAG" >> ypserv.securenets.$$
  cp ypserv.securenets.$$ /etc/ypserv.securenets
  rm -f ypserv.securenets.$$
  rm -f ypserv.securenets

  # yp.conf
  removeentries "$START_TAG" "$END_TAG" /etc/yp.conf > yp.conf.$$
  echo "$START_TAG" >> yp.conf.$$
  for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
  do
    ip=$(/sbin/ifconfig $eth | grep "inet addr" | awk -F: '{print $2;}' | awk '{print $1;}')
    if [ "$ip" != "" ]; then
      echo "domain $nisdomain server $ip" > yp.conf.$$
      break
    fi
  done
  echo "$END_TAG" >> yp.conf.$$
  cp yp.conf.$$ /etc/yp.conf
  rm -f yp.conf.$$

  # nis
  if [ ! -d /var/yp/$nisdomain ]; then
    echo "$nisdomain" > /etc/defaultdomain
	/bin/nisdomainname $nisdomain
    drblpush.$$/autoypinit
	/etc/init.d/nis restart
  fi
fi

## the script will generate a file named 'skel_ypserv.securenets'
##drblpush/update-ypserv.pl $SECURENETS
##cp skel_ypserv.securenets /etc/ypserv.securenets
#rm -f ypserv.securenets

# start inetd, dhcpd
/etc/init.d/inetd start
/etc/init.d/dhcp3-server start

# Blake, 2004/02/24, cupsys
cupsys_substr=""
for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then
    cupsys_substr="$cupsys_substr \@IF($eth)"
  fi
done
if [ "$cupsys_substr" != "" -a "$(dpkg -l cupsys | grep "cupsys" | cut -d' ' -f1)" = "ii" ]; then
  cp /etc/cups/cupsd.conf /etc/cups/cupsd.conf.orig
  /usr/bin/perl -p -i -e "s/127.0.0.1/$cupsys_substr/g" /etc/cups/cupsd.conf
  /etc/init.d/cupsys restart
fi

# Blake, 2004/03/04, openmosix.map
if [ "$(dpkg -l openmosix | grep "openmosix" | cut -d' ' -f1)" = "ii" ]; then
  cp openmosix.map /etc/
  openmosixId=`tail -n 1 /etc/openmosix.map | awk '{ print $1; }'`
  openmosixId=`expr $openmosixId + 1`
  openmosixIP=$(/sbin/ifconfig eth0 | grep "inet addr" | awk -F: '{print $2;}' | awk '{print $1;}')
  if [ "$openmosixIP" != "" ]; then
    echo "$openmosixId	$openmosixIP	1" >> /etc/openmosix.map
  fi

  for host in `ls $imagehost`; do
    if [ "$host" = "." -o "$host" = ".." ]; then continue; fi
    cp drblpush.$$/openmosix_map.sh $imagehost/$host/etc/rc2.d/S19openmosix_map.sh
    cp openmosix.map $imagehost/$host/etc/
  done
  if [ -f /etc/init.d/openmosix ]; then /etc/init.d/openmosix restart; fi
  if [ -f /etc/init.d/openmosixcollector ]; then /etc/init.d/openmosixcollector restart; fi
fi
rm -f openmosix.map
# Blake, 2004/02/11, kernel-nfs-server
# drblmgrd && nfs-user-server
if [ "$NO_DRBLMGRD" = "false" ]; then
  drblpush.$$/drblmgrd init_d
  mkdir -p /opt/drbl/sbin
  cp drblpush.$$/drblmgrd /opt/drbl/sbin
  chmod 755 /opt/drbl/sbin/drblmgrd
  /etc/init.d/drblmgrd stop
  /etc/init.d/drblmgrd start
  CPWD=$(pwd)
  cd /etc/rc2.d/; ln -fs ../init.d/drblmgrd S99drblmgrd; cd $CPWD
  cd /etc/rc5.d/; ln -fs ../init.d/drblmgrd S99drblmgrd; cd $CPWD

  # restart nfs-user-server 
  #/etc/init.d/nfs-user-server restart
  /etc/init.d/nfs-kernel-server restart 2> /dev/null
  # start firewall (nat)
  #/etc/init.d/firewall start
  if [ -f /etc/init.d/iptables ]; then
    /etc/init.d/iptables start
  else
    /etc/init.d/firewall start
  fi
fi
##
##
echo "------------NCHC OPENSOURCE TASKFORCE-----------------";
echo "Thanks for choosing DRBL Debian Solution              ";
if [ "$NO_DRBLMGRD" = "true" ]; then
  echo "next step: /opt/drbl/sbin/drbl_deploy.sh";
fi
echo "If you have any question, please visit the web site:  ";
echo " http://drbl.nchc.org.tw/debian                       ";
echo "or email to "
echo " c00hkl00@nchc.org.tw, c00jhs00@nchc.org.tw";
echo "-------------------Thank You--------------------------";
