#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description:
#   detect MAC address, add it to drblconf automatically 

imageroot="/var/lib/diskless/default/root"
imagehost="/var/lib/diskless/default"
tftproot="/tftpboot"

# wget, mknbi, netmask, tcpdump
apt-get -y install wget mknbi netmask tcpdump

if [ -e /etc/default/drbl ]; then
  . /etc/default/drbl
fi

if [ ! -d drblpush ]; then
  mkdir -p drblpush
fi

# stop inetd, dhcp
/etc/init.d/inetd stop
/etc/init.d/dhcp3-server stop

## function: status
status() {
  rm -f drblpush/setup-drbl-add.all
  touch drblpush/setup-drbl-add.all
  for eth in $NETDEVICES; do
    if [ "$eth" != "$outeth" ]; then
      #cat drblpush/setup-drbl-add.$eth >> drblpush/setup-drbl-add.all
      while read detect_mac; do
        detect_mac=$(echo "$detect_mac" | perl -ane 'print "\U$F[0]\n"')
        if [ "$(grep "$detect_mac" drblpush/macadr-$eth.txt)" != "" ]; then continue; fi
        if [ "$(grep "$detect_mac" drblpush/setup-drbl-add.all)" != "" ]; then continue; fi
        echo "$detect_mac" >> drblpush/setup-drbl-add.all
      done < drblpush/setup-drbl-add.$eth
    fi
  done
  #num=$(perl -ane 'print "\U$F[0]\n"' drblpush/setup-drbl-add.all | sort | uniq | wc | awk '{print $1}')
  num=$(wc -l drblpush/setup-drbl-add.all | awk '{print $1}')
  echo "======================================="
  perl -ane 'print "\U$F[0]\n"' drblpush/setup-drbl-add.all | sort | uniq
  echo "Total: $num"
  echo "======================================="
}

## function: stop
stop() {
  TMP=`mktemp /tmp/pid.XXXXXX`
  /bin/ps -e | grep 'tcpdump' | sed -e 's/^ *//' -e 's/ .*//' > $TMP
  while read pid
  do
    #echo "kill -9 $pid"
    kill -9 $pid
  done < $TMP
  rm -f $TMP
}

## main

# NETDEVICES
NETDEVICES="$1"
NETDEVICES="${NETDEVICES/,/ }"
if [ -z "$NETDEVICES" ]; then
  NETDEVICES="$(cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}')"
  outeth=$(/sbin/route -n | grep -e "^0.0.0.0" | awk '{ print $8; }')
  echo -n "Detect MAC address on all NICs (include outgoing NIC) [y|N]? "
  read ANS
  if [ "$ANS" = "Y" -o "$ANS" = "y" ]; then outeth=""; fi
fi

# drblpush/macadr-$eth.txt
if [ -f /opt/drbl/sbin/drbl_deploy.sh ]; then
  /opt/drbl/sbin/drbl_deploy.sh macadr
else
  # create empty one
  for eth in $NETDEVICES;  do
   if [ "$eth" != "$outeth" -a ! -f drblpush/macadr-$eth.txt ]; then
     touch drblpush/macadr-$eth.txt
   fi
  done
fi

for eth in $NETDEVICES; do
  if [ "$eth" != "$outeth" ]; then
    #/usr/sbin/tcpdump -qte -i $eth > drblpush/setup-drbl-add.$eth 2> /dev/null &
    /usr/sbin/tcpdump -tel -i $eth broadcast and port bootpc > drblpush/setup-drbl-add.$eth 2> /dev/null &
  fi
done

##
echo "Start detecting MAC address...."
echo "1: View the status of the MAC address collection"
echo "2: Stop MAC address detection and Start DRBL configuration"
echo "3: Abort"
while read CMD
do
  if [ "$CMD" = "3" ]; then
    exit 0
  elif [ "$CMD" = "2" ]; then
    stop
    break
  elif [ "$CMD" = "3" -o "$CMD" = "" ]; then
    status
    echo "1: View the status of the MAC address collection"
    echo "2: Stop MAC address detection and Start DRBL configuration"
    echo "3: Abort"
  fi
done

## analyze the mac address 
for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ ! -f drblpush/setup-drbl-add.$eth ]; then continue; fi
  if [ "$eth" != "$outeth" ]; then
    #perl -ane 'print "\U$F[0]\n"' drblpush/setup-drbl-add.$eth | sort | uniq > drblpush/macadr-add-$eth
    touch drblpush/macadr-add-$eth
    while read detect_mac; do
      detect_mac=$(echo "$detect_mac" | perl -ane 'print "\U$F[0]\n"')
      if [ "$(grep "$detect_mac" drblpush/macadr-$eth.txt)" != "" ]; then continue; fi
      if [ "$(grep "$detect_mac" drblpush/macadr-add-$eth)" != "" ]; then continue; fi
      echo "$detect_mac" >> drblpush/macadr-add-$eth
    done < drblpush/setup-drbl-add.$eth
  fi
done

ethmatch=""
for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" -a -f drblpush/macadr-add-$eth ]; then

     for ethx in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`    
     do
       if [ "$ethx" = "$eth" ]; then
         ethmatch="$eth=$eth $ethmatch"
       elif [ "$ethx" != "$outeth" -a -f drblpush/macadr-add-$ethx ]; then
         #echo "diff drblpush/macadr-add-$eth drblpush/macadr-add-$ethx"
         #read ANS
         if [ "$(diff drblpush/macadr-add-$eth drblpush/macadr-add-$ethx)" = "" ]; then
           rm -f drblpush/macadr-add-$ethx
           ethmatch="$eth=$ethx $ethmatch"  
         fi
       fi
     done
     
  fi
done

for ethmac in `ls drblpush/macadr-add-*`
do
  eth=${ethmac/drblpush\/macadr-add-/}
  run=1
  macadr=""
  while [ $run -eq 1 ]
  do
    for match in `echo $ethmatch`
    do
      # make sure macadr is not ""
      if [ "$macadr" = "" ]; then 
        if ! read macadr ; then
          run=0
          break
        fi 
      fi

      # assign macadr
      if [ "$(echo "$match" | grep -e "^$eth=")" != "" ]; then
        ethx=${match/$eth=/} 
        echo "$macadr" >> drblpush/macadr-$ethx.txt
        if ! read macadr ; then
          run=0
          break
        fi
      fi 
    done
  done < $ethmac
done

rm -f drblpush/macadr-add-*

## generate the config file for drbl.pl, firewall and ypserv.securenets
echo "Setup DRBL..."
OUT="drblpush/drbl_config"
FIREWALL="drblpush/firewall"
SECURENETS="ypserv.securenets"

nameserver="$(head -n 1 /etc/resolv.conf | awk '{print $2}')"
if [ "$nameserver" = "" ]; then nameserver="168.95.1.1"; fi
domain="drbl.org"
#nisdomain="drbl"
nisdomain="$(nisdomainname)"
nbi="mkinitrd-net"
pxe="pxelinux.0"

# drbl_config
cat <<-EOF > $OUT
# GENERATED BY setup-drbl-add.sh
[general]
nameserver=$nameserver
domain=$domain
nisdomain=$nisdomain
nbi=$nbi
pxe=$pxe
EOF

# firewall
cat <<-EOF > $FIREWALL
#!/bin/sh
# generated by drblpush
# Author: Blake, Kuo-Lien Huang
# copyright: GPL

masquerade_only_rules()
{
EOF

# yp.securenets
cat <<-EOF > $SECURENETS
# Generated by drblpush
# Author: Blake, Kuo-Lien Huang
# License: GPL

# Always allow access for localhost
255.0.0.0	127.0.0.0
EOF

total=0
n=0
for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then

    if [ ! -f drblpush/macadr-$eth.txt ]; then continue; fi
    t=`wc -l drblpush/macadr-$eth.txt | awk '{ print $1; }'`
    total=`expr $total + $t`

    label=`expr $n + 1`
    hostname=`hostname`
    hostname="$hostname-$eth-"

    ip="$(/sbin/ifconfig $eth | grep "inet addr" | cut -d":" -f2 | cut -d" " -f1)"
    broadcast="$(/sbin/ifconfig $eth | awk '/Bcast/{print $3;}' | awk -F: '{print $2;}')"

    #network="$(echo $ip | awk -F. '{print $1"."$2"."$3".0"}')"
    netmask=$(/sbin/ifconfig $eth | awk '/Mask/{print $4; }' | awk -F: '{print $2;}')
    network=$(/usr/bin/netmask $ip/$netmask | cut -d/ -f1 | awk '{print $1;}')
    if [ "$network" = "" ]; then
      netmask="255.255.255.0"
      network=`echo "$ip" | awk -F. '{print $1"."$2"."$3".0"; }'`
    fi

    nfsserver=$ip
    nisserver=$ip
    bootserver=$ip
    # drbl_config
    cat <<-EOF >> $OUT
[drbl$label]
interface=$eth
network=$network
netmask=$netmask
broadcast=$broadcast
nfsserver=$nfsserver
nisserver=$nisserver
bootserver=$bootserver
nbi=$nbi
pxe=$pxe
hostname=$hostname
mac=drblpush/macadr-$eth.txt

EOF
    # firewall
    #echo "iptables -t nat -A POSTROUTING -s $network/24 -j MASQUERADE" >> $FIREWALL
    echo "iptables -t nat -A POSTROUTING -s $network/$netmask -j MASQUERADE" >> $FIREWALL

    # add this subnet to ypserv.securnets
    #echo "255.255.255.0	$network" >> $SECURENETS
    echo "$netmask	$network" >> $SECURENETS
 
    # create init.$network to $imageroot/sbin/
    if [ ! -e $imageroot/sbin/$network ]; then mkdir $imageroot/sbin/$network; fi
    #IPCMD="ifconfig | grep -A1 eth0 | grep -v eth0 | sed 's/^.*inet addr:\([0-9\.]\+\).*$/\1/'"
    NET=`echo "$nfsserver" | awk -F\. '{ print $1 "." $2 "." $3; }'`
    IPCMD="ifconfig | grep \"$NET\" | sed 's/^.*inet addr:\([0-9\.]\+\).*$/\1/' | head -n 1"
    cat <<-EOF > $imageroot/sbin/$network/init
#!/bin/sh

# Don't do anything special if computer is already booted
if [ \$\$ -ne 1 ]
then
	exec /sbin/init.orig $*
	echo "FATAL ERROR: exec /sbin/init.orig failed" >&2
	exit 1
fi

# Don't do anything special if root is rw (ie master system).
if touch /test-rw
then
	rm /test-rw
	echo "WARNING: master system installed" >&2
	exec /sbin/init.orig $*
	echo "FATAL ERROR: exec /sbin/init.orig failed" >&2
	exit 1
fi

# Try and find configuration file
if [ -f /etc/diskless-image/config ]
then
	# Load config file
	. /etc/diskless-image/config

	# Get IP address, need to mount /proc first
	# Already mount at /sbin/init (klhaung 2002/12/20)
	# mount -n none /proc -t proc
	#IP=`cat /proc/cmdline | sed 's/^.*nfsaddrs=\([0-9\.]\+\).*$/\1/'`
EOF
    echo 'IP=`'$IPCMD'`' >> $imageroot/sbin/$network/init
    cat <<-EOF >> $imageroot/sbin/$network/init

	echo "Client IP address is \$IP"

	# Mount client's /etc directory
	echo -n "Mounting NFS-root directories..."
	mount -n $nfsserver:/\$nfshostsdir/\$IP/etc /etc -orw,nolock

	# Update entries in /etc/mtab
	rm -f /etc/mtab~ /etc/nologin
	: > /etc/mtab
	mount -o remount /
	mount -o remount /etc
	mount -o remount /proc

	# report success
	echo "done."
else
	echo "ERROR: Cannot find image config file"
	echo "       Not mounting NFS-root directories"
fi

# Only should get here if something went wrong
exec /sbin/init.orig $*
echo "FATAL ERROR: exec /sbin/init.orig failed" >&2
exit 1
EOF
    chmod a+x $imageroot/sbin/$network/init

    # diskless-newhost for drblmgrd
    if [ "$NO_DRBLMGRD" = "false" ]; then
      if [ "$ip" = "" ]; then $ip="$nfsserver"; fi
      echo "create diskless host: tmphost $ip"
      if [ ! -e $imagehost/$ip ]; then
        diskless-newhost $imageroot $ip host=tmphost mailname=tmphost >& /dev/null
        # Blake, 2004/03/09, for mozilla 
        cp -r $imageroot/var/lib/mozilla/* $imagehost/$ip/var/lib/mozilla
        # Blake, 2004/04/27, for kde menu
        rm -rf $imagehost/$ip/var/lib/kde/menu
        cp -r $imageroot/var/lib/kde/menu $imagehost/$ip/var/lib/kde/
        # Blake, 2004/03/09, client's root
        mkdir $imagehost/$ip/root
        cp $imageroot/root/.profile $imagehost/$ip/root
        cp $imageroot/root/.bashrc $imagehost/$ip/root
        # 2003/08/25
        if [ -d /root/.kde ]; then
          cp -r /root/.kde $imagehost/$ip/root
        fi
      fi
      cat <<-NETWORKS > $imagehost/$ip/etc/networks
localnet $network
NETWORKS
      cat <<-YPCONF > $imagehost/$ip/etc/yp.conf
domain $nisdomain server $ip
YPCONF
      cat <<-DEFAULTDOMAIN > $imagehost/$ip/etc/defaultdomain
$nisdomain
DEFAULTDOMAIN

      if [ -e $imagehost/$ip/etc/passwd ]; then
        NIS_PWD=`cat $imagehost/$ip/etc/passwd | grep "+::::::"`
        if [ "\$NIS_PWD" = "" -o "\$NIS_PWD" != "+::::::" ]; then
          echo "+::::::" >> $imagehost/$ip/etc/passwd
        fi
      fi

      if [ -e $imagehost/$ip/etc/group ]; then
        NIS_GRP=`cat $imagehost/$ip/etc/group | grep "+:::"`
        if [ "\$NIS_GRP" = "" -o "\$NIS_GRP" != "+:::" ]; then
          echo "+:::" >> $imagehost/$ip/etc/group
        fi
      fi

      if [ -e $imagehost/$ip/etc/shadow ]; then
        NIS_SHADOW=`cat $imagehost/$ip/etc/shadow | grep "+::::::::"`
        if [ "\$NIS_SHADOW" = "" -o "\$NIS_SHADOW" != "+::::::::" ]; then
	      echo "+::::::::" >> $imagehost/$ip/etc/shadow
        fi
      fi

      echo "$nameserver" | awk -F, '{ for(i=1;i<=NF;i++) print "nameserver ",$i; }' > $imagehost/$ip/etc/resolv.conf
    fi
    # end 

    n=`expr $n + 1`
  fi
done

# firewall
cat <<-EOF >> $FIREWALL

iptables -P FORWARD ACCEPT
iptables -P INPUT ACCEPT
}

function deny_connection_rules
{
iptables -t filter -F
iptables -t nat -F
}

case \$1 in
  "start")
    # Define firewall rule
    masquerade_only_rules
 
    # Turn on IP forwarding
    echo 1 > /proc/sys/net/ipv4/ip_forward
    ;;
  "stop")
    # Turn off IP forwarding
    echo 0 > /proc/sys/net/ipv4/ip_forward
    
    # Define firewall rule
    deny_connection_rules
    ;;
  "restart")
    \$0 stop
    \$0 start
    ;;
  *)
    echo "Usage: /etc/init.d/firewall {start|stop|restart|init|config}" 
    ;;
esac
EOF

drblpush/drbl.pl $OUT NO_OUTPUT
zip macadr.zip drblpush/macadr* $OUT
lineno=`wc -l drbl_deploy.sh | awk '{ print $1; }'`
lineno=`expr $lineno + 1`
bsdsum1=`sum macadr.zip | awk '{ print $1; }'`
bsdsum2=`sum macadr.zip | awk '{ print $2; }'`
/usr/bin/perl -p -i -e "s/=1#<LINENO>/=$lineno/" drbl_deploy.sh
/usr/bin/perl -p -i -e "s/=1#<CHECKSUM1>/=$bsdsum1/" drbl_deploy.sh
/usr/bin/perl -p -i -e "s/=1#<CHECKSUM2>/=$bsdsum2/" drbl_deploy.sh
cat macadr.zip >> drbl_deploy.sh
chmod 755 drbl_deploy.sh
mv drbl_deploy.sh /opt/drbl/sbin
rm -f macadr.zip

# Blake, 2003/11/21, removeentries
## function: removeentries
## $1 - Tag for START
## $2 - Tag for End
## $3 - File to read
removeentries() {
  while read line; do
    case "$line" in $1)
      while read line; do
        if [ "$line" = "$2" ]; then break; fi
      done
    esac
    if [ "$line" = "$2" ]; then continue; fi
    echo "$line"
  done < $3
}

START_TAG="# Added by DRBL."
END_TAG="# Added by DRBL Done."

## copy dhcpd.conf
if [ ! -e /etc/dhcp3/dhcpd.conf.drbl ]; then
  mv /etc/dhcp3/dhcpd.conf /etc/dhcp3/dhcpd.conf.drbl
fi
cp dhcpd.conf /etc/dhcp3
cp dhcp /etc/default/dhcp3-server
rm -f dhcpd.conf
rm -f dhcp

## copy hosts
# Blake, 2003/11/21
#if [ ! -e /etc/hosts.drbl ]; then
#  mv /etc/hosts /etc/hosts.drbl
#fi
#cp hosts /etc/
#if [ -f /etc/FQDN ]; then
#  ## Blake, 2003/09/02
#  ##for ip in `cat /etc/dhcp3/dhcpd.conf | grep "next-server" | awk '{ print $2; }' | cut -d";" -f1`
#  ##do
#  ##  perl -p -i -e "s/$ip.*//g" /etc/hosts
#  ##done
#  outif=`/sbin/route -n | grep -e "^0.0.0.0" | awk '{ print $8; }'`
#  outip=`/sbin/ifconfig $outif | grep "inet addr" | cut -d":" -f2 | cut -d " " -f1`
#  fqdn=`cat /etc/FQDN`
#  hostname=`cat /etc/hostname`
#  if [ "$fqdn" != "$hostname" ]; then
#    echo "$outip $fqdn $hostname" >> /etc/hosts
#  else 
#    echo "$outip $hostname" >> /etc/hosts
#  fi
#fi
removeentries "$START_TAG" "$END_TAG" /etc/hosts > hosts.$$
echo "$START_TAG" >> hosts.$$
cat hosts >> hosts.$$
echo "$END_TAG" >> hosts.$$
cp hosts.$$ /etc/hosts
rm -f hosts.$$

## update-hosts.pl will generate a file named 'skel_hosts'
##drblpush/update-hosts.pl hosts
##cp skel_hosts $imageroot/etc/hosts
##cp skel_hosts /etc/hosts
##rm -f skel_hosts
if [ "$NO_DRBLMGRD" = "false" ]; then
  for dir in `ls $imagehost` 
  do
    if [ "$dir" != "." -a "$dir" != ".." ]; then
	  cp hosts $imagehost/$dir/etc
	fi
  done
fi
rm -f hosts

## nfs-user-server
# Blake, 2003/11/21
#if [ ! -e /etc/exports.drbl ]; then
#  mv /etc/exports /etc/exports.drbl
#fi
#cp exports /etc
#rm -f exports
removeentries "$START_TAG" "$END_TAG" /etc/exports > exports.$$
echo "$START_TAG" >> exports.$$
cat exports >> exports.$$
echo "$END_TAG" >> exports.$$
cp exports.$$ /etc/exports
rm -f exports.$$
rm -f exports

removeentries "$START_TAG" "$END_TAG" /etc/netgroup > netgroup.$$
echo "$START_TAG" >> netgroup.$$
cat netgroup >> netgroup.$$
echo "$END_TAG" >> netgroup.$$
cp netgroup.$$ /etc/netgroup
rm -f netgroup.$$
rm -f netgroup

# Blake, 2004/03/04, openmosix.map
cp openmosix.map /etc/
openmosixId=`tail -n 1 /etc/openmosix.map | awk '{ print $1; }'`
openmosixId=`expr $openmosixId + 1`
openmosixIP=$(/sbin/ifconfig eth0 | grep "inet addr" | awk -F: '{print $2;}' | awk '{print $1;}')
if [ "$openmosixIP" != "" ]; then
  echo "$openmosixId	$openmosixIP	1" >> /etc/openmosix.map
fi

for host in `ls $imagehost`; do
  if [ "$host" = "." -o "$host" = ".." ]; then continue; fi
  cp drblpush/openmosix_map.sh $imagehost/$host/etc/rc2.d/S19openmosix_map.sh
  cp openmosix.map $imagehost/$host/etc/
done

/etc/init.d/openmosix restart
/etc/init.d/openmosixcollector restart
rm -f openmosix.map

# Blake, 2004/02/11, nfs-kernel-server
#echo "RPCNFSDCOUNT=$total" > /etc/default/nfs-user-server
#if [ ! -e /etc/init.d/nfs-user-server.drbl ]; then
#  mv /etc/init.d/nfs-user-server /etc/init.d/nfs-user-server.drbl
#fi
#cp drblpush/nfs-user-server /etc/init.d/
if [ $total -gt 8 ]; then
  #/usr/bin/perl -p -i -e "s/RPCNFSDCOUNT=.*/RPCNFSDCOUNT=$total/" /etc/init.d/nfs-kernel-server
  /usr/bin/perl -p -i -e "s/RPCNFSDCOUNT=.*/RPCNFSDCOUNT=$total/" /etc/default/nfs-kernel-server
fi

## Blake, 2004/07/19, use script "iptables" in /etc/init.d
### copy firewall
chmod a+x $FIREWALL
#cp $FIREWALL /etc/init.d/firewall
#ln -fs /etc/init.d/firewall /etc/rc2.d/S99firewall 
#ln -fs /etc/init.d/firewall /etc/rc5.d/S99firewall
./$FIREWALL start
/sbin/iptables-save > /var/lib/iptables/active
./$FIREWALL stop

rm -f ypserv.securenets

# start inetd, dhcpd
/etc/init.d/inetd start
/etc/init.d/dhcp3-server start
/etc/init.d/nfs-kernel-server restart 2> /dev/null
/etc/init.d/drblmgrd stop
/etc/init.d/drblmgrd start
/etc/init.d/iptables start

##
##
echo "------------NCHC OPENSOURCE TASKFORCE-----------------";
echo "Thanks for choosing DRBL Debian Solution              ";
if [ "$NO_DRBLMGRD" = "true" ]; then
  echo "next step: /opt/drbl/sbin/drbl_deploy.sh";
fi
echo "If you have any question, please visit the web site:  ";
echo " http://drbl.nchc.org.tw/debian                       ";
echo "or email to "
echo " c00hkl00@nchc.org.tw, c00jhs00@nchc.org.tw";
echo "-------------------Thank You--------------------------";
