#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description:
#  generate initrd image and pxe configuration for each IP in dhcpd.conf
#

kernel_version=$1
if [ "$kernel_version" = "" ]; then kernel_version=$(uname -r); fi
if [ ! -f /tftpboot/initrd-pxe_pciscan.$kernel_version.img -o \
     ! -f /etc/dhcp3/dhcpd.conf ]; then
  echo "DRBL configuration is incorrect! abort!!"
  exit 0
fi

##
cp /tftpboot/initrd-pxe_pciscan.$kernel_version.img initrd-pxe_pciscan.$kernel_version.img.gz
gunzip initrd-pxe_pciscan.$kernel_version.img.gz
mkdir -p pxe_pciscan
mount -o loop initrd-pxe_pciscan.$kernel_version.img pxe_pciscan

## function mkinitrd
mkinitrd() {

  ip=$1
  netmask=$2
  broadcast=$3
  router=$4
  initrd="pxe_pciscan"

  echo "mkinitrd for $ip/$netmask"

  hostip=`/usr/bin/gethostip $ip | awk '{ print $3; }'`
  cat <<-EOF > /tftpboot/pxelinux.cfg/$hostip
default drbl
timeout 0
label drbl
  kernel vmlinuz-pxe_pciscan.$kernel_version
  append initrd=initrd-pxe_pciscan.$kernel_version-$ip.img ramdisk_size=9600
EOF
  initrdimg=`mktemp /tmp/initrd.img.XXXXXX`
  initrdmnt=`mktemp -d /tmp/initrd.mnt.XXXXXX`
  dd if=/dev/zero bs=1k of=$initrdimg count=$((`du -sk $initrd | cut -f1` * 7 / 6)) 2> /dev/null
  /sbin/mke2fs -q -F $initrdimg 2> /dev/null
  mount -o loop $initrdimg $initrdmnt
  cp -a $initrd/* $initrdmnt/
  cat <<-EOF > $initrdmnt/linuxrc
#!/bin/sh

PATH=/sbin:/bin

echo Busybox /linuxrc starting

echo Mounting /proc filesystem
mount -t proc none /proc

echo=echo
if grep '\bquiet\b' /proc/cmdline > /dev/null; then
  echo=true
  quiet=1
fi

\$echo Creating root device
mknod /dev/root b 1 0 2>/dev/null
chmod 700 /dev/root
echo 0x100 > /proc/sys/kernel/real-root-dev

\$echo Inserting modules
if [ -z "\$quiet" ]; then
  /bin/insert-modules
else
  /bin/insert-modules >/dev/null
fi

\$echo Bringing up loopback interface
ifconfig lo 127.0.0.1 up
route add -net 127.0.0.0 netmask 255.0.0.0 lo

netdevices="\$(cat /proc/net/dev | grep eth | cut -d":" -f1 | sed 's/ *//')"
for device in \$netdevices
do
  \$echo "Try to setup $device ($ip/$netmask)"
  ifconfig \$device $ip netmask $netmask broadcast $broadcast up > /dev/null 2>&1
  #/bin/ping -c 5 $router
  found=10
  while [ \$found -gt 0 ]
  do
    if /bin/ping -c 1 $router > /dev/null 2>&1; then
      break
    else
      found=\`/bin/expr \$found - 1\`
    fi
  done

  if [ \$found -gt 0 ]; then
  #if /bin/ping -c 5 $router > /dev/null 2>&1; then
    \$echo "route add default gw $router dev \$device"
    route add default gw $router dev \$device
    rootpath="$router:/tftpboot/$ip"
    if [ -e /bin/drblhost ]; then
      \$echo "/bin/drblhost $router:6460 $ip"
      /bin/drblhost $router:6460 $ip
    fi
    \$echo Mounting root filesystem $rootpath at /sysroot
    \$echo "mount -t nfs nolock,rsize=8192,wsize=8192 \$rootpath /sysroot"
    mount -t nfs -o nolock,rsize=8192,wsize=8192 \$rootpath /sysroot
    break
  fi
  \$echo "Failed to setup $device ($ip/$netmask)"
  ifconfig \$device down
done

## do network configuration by hand
if [ ! -d /sysroot/initrd ]; then
  \$echo -n "Do you want to setup your network by hand [Y|n]? "
  read ans
  if [ "\$ans" = "" -o "\$ans" = "Y" -o "\$ans" = "y" ]; then
    interfaces="\$(echo \$netdevices)"
    \$echo -n "Choose the network device [\$interfaces]: "
    read interface
    \$echo -n "IP: "
    read ip
    \$echo -n "NETMASK: "
    read netmask
    if [ "\$netmask" != "" ]; then netmask="netmask \$netmask"; fi
    \$echo -n "BROADCAST: "
    read broadcast
    if [ "\$broadcast" != "" ]; then broadcast="broadcast \$broadcast"; fi
    \$echo -n "GATEWAY: "
    read router
    if [ "\$interface" != "" -a "\$ip" != "" ]; then
      ifconfig \$interface \$ip \$netmask \$broadcast
    fi
    if [ "\$gateway" != "" ]; then
      route add default gw \$router dev \$interface
    fi
    rootpath="\$router:/tftpboot/\$ip"
    if [ -e /bin/drblhost ]; then
      /bin/drblhost \$router:6460 $ip
    fi
    \$echo Mounting root filesystem $rootpath at /sysroot
    mount -t nfs -o nolock,rsize=8192,wsize=8192 $rootpath /sysroot
  fi
fi

if [ -d /sysroot/initrd ]; then
  \$echo Unmounting /proc prior to pivot_root
  umount /proc

  \$echo Pivoting root to /sysroot
  pivot_root /sysroot /sysroot/initrd
  cd /

  \$echo Releasing locks on old devfs
  exec 0</dev/null
  exec 1>/dev/console
  exec 2>/dev/console

else
  # Failed to mount root: report error and hang
  echo FATAL ERROR: Failed to mount root filesystem
  #echo Press Alt-SysRq-B or hit the reset switch to reboot
  #while : ; do sleep 6000 ; done
fi
EOF
  umount -d $initrdmnt
  gzip -9 -n -c $initrdimg > /tftpboot/initrd-pxe_pciscan.$kernel_version-$ip.img
  rm -f $initrdimg
  rmdir $initrdmnt
}

##
ip=""
broadcast=""
while read dhcp_conf
do
  if [ "$(echo "$dhcp_conf" | grep "^option routers")" != "" ]; then
    router=$(echo "$dhcp_conf" | cut -d\; -f1 | awk '{ print $3; }')
  elif [ "$(echo "$dhcp_conf" | grep "^option subnet-mask")" != "" ]; then
    netmask=$(echo "$dhcp_conf" | cut -d\; -f1 | awk '{ print $3; }')
  elif [ "$(echo "$dhcp_conf" | grep "^option broadcast-address")" != "" ]; then
    broadcast=$(echo "$dhcp_conf" | cut -d\; -f1 | awk '{ print $3; }')
  elif [ "$(echo "$dhcp_conf" | grep "^fixed-address")" != "" ]; then
    ip=$(echo "$dhcp_conf" | cut -d\; -f1 | awk '{ print $2; }')
    mkinitrd $ip $netmask $broadcast $router
  fi
done < /etc/dhcp3/dhcpd.conf

##
umount -d pxe_pciscan
rmdir pxe_pciscan
rm -f initrd-pxe_pciscan.$kernel_version.img
