#include <pcap.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>

#define ETHER_HDRLEN 14
#define HEXDUMP_BYTES_PER_LINE 16

char mac[40][20];
int mac_idx=0;
int n_mac_found=0;

void logit(char* logmsg,...)
{
/* use va_start va_end va_arg to operate va_list
 * see more information: man va_start
 */
  va_list args;
  FILE *fp = fopen("packet.log","a+t");
  if(fp!=NULL) 
  {
    va_start(args, logmsg);
    vfprintf(fp,logmsg,args);
    fprintf(fp,"\n"); 
    va_end(args);
    fclose(fp); 
  }
}

/* readline */
int readline(int fd, char* ptr, int maxlen)
{
  int n, rc;
  char c;

  for(n = 1; n < maxlen; n++)
  {
    if( (rc = read(fd,&c,1)) == 1 )
    {
      *ptr++ = c;
      if( c=='\n' ) break;
    }
    else if( rc==0 )
    {
      if( n==1 ) return EOF; // EOF, no data read
      else break; // EOF, some data was read
    }
    else 
    {
      return EOF;
    } 
  }

  *ptr = 0;
  return n;
}

char *copy_argv(register char **argv)
{
	register char **p;
	register u_int len = 0;
	char *buf;
	char *src, *dst;

	p = argv;
	if (*p == 0)
		return 0;

	while (*p)
		len += strlen(*p++) + 1;

	buf = (char *)malloc(len);
	if (buf == NULL) {
		logit("copy_argv: malloc");
        exit(0);
    }
	p = argv;
	dst = buf;
	while ((src = *p++) != NULL) {
		while ((*dst++ = *src++) != '\0')
			;
		dst[-1] = ' ';
	}
	dst[-1] = '\0';

	return buf;
}

void hex_print_with_offset(const u_char *cp, u_int length, u_int oset)
{
	u_int i, s;
	int nshorts;
	
	nshorts = (u_int) length / sizeof(u_short);
	i = 0;

	while (--nshorts >= 0) { 
		if ((i++ % 8) == 0) {
			(void)fprintf(stdout,"\n0x%04x\t", oset);
			oset += HEXDUMP_BYTES_PER_LINE;


		}
	    s = *cp++;
		(void)fprintf(stdout," %02x%02x", s, *cp++);
    }
    if (length & 1) {
	  if ((i % 8) == 0) (void)fprintf(stdout,"\n0x%04x\t", oset);
	  (void)fprintf(stdout," %02x", *cp);
	}
}

/* pcap_handler */
void ether_if_print(u_char *user, const struct pcap_pkthdr *h, const u_char *p)
{
  u_int caplen = h->caplen;
  u_int length = h->len;
  u_char *packetp, *snapend;
  
  if(caplen < ETHER_HDRLEN) ;
  else {
        /* Ether Frame Format */
	/* DestionMAC(6) SourceMAC(6) Length(2) */ 
	int found=0, i=0;
	char macaddr[20];
        sprintf(macaddr,
		"%02x:%02x:%02x:%02x:%02x:%02x",
	        *(p+6),*(p+7),*(p+8),*(p+9),*(p+10),*(p+11));	
 
	for(i=0;i<mac_idx;i++) {
	  //printf("mac[%d]=[%s], macaddr=[%s]\n",i,mac[i],macaddr);	
      	  if( strcmp(mac[i],macaddr)==0 ) { found=1; break; }
	}

	if(found==0) {
	  fprintf(stdout,"%s\n",macaddr);
      fprintf(stderr,"%3d %s\n",n_mac_found,macaddr);
	  strcpy(mac[mac_idx],macaddr);
	  mac[mac_idx][17]='\0';
	  mac_idx++;
      n_mac_found++;
	}	
        /*
	packetp = p;
	snapend = p + caplen;
	length -= ETHER_HDRLEN;
	caplen -= ETHER_HDRLEN;
	p += ETHER_HDRLEN;

	hex_print_with_offset(p, caplen, 0);	
        */
  }
}

void* thread_function(void* arg)
{
  char buf[BUFSIZ];
  int n;
  while(1) {
    n = readline(0,buf,BUFSIZ);
    buf[1]='\0';
    if(strcmp(buf,"q")==0) exit(0);
  }
  return NULL;
}

void create_thread()
{
  pthread_t thread;
  pthread_create(&thread, NULL, &thread_function, NULL);
}

int main(int argc, char* argv[])
{
  //char device[255], *cmdbuf;
  char device[255],cmdbuf[255];
  char ebuf[PCAP_ERRBUF_SIZE], buf[BUFSIZ];
  u_char *pcap_userdata = 0;
  int snaplen = 65535, pflag=1, cnt=-1;
  int n, i, fd;
  bpf_u_int32 localnet, netmask;
  pcap_t *pd;
  pcap_handler printer = ether_if_print;
  struct bpf_program fcode;

  // read device
  if(argc<2) strcpy(device,"eth0");
  else strcpy(device,argv[1]);
 
  // read cache 
  if(argc>2) {
    fd = open(argv[2],O_RDONLY);
    if(fd<0) ;
    else {
      while( (n=readline(fd,buf,BUFSIZ)) > 0 ) {
        strcpy(mac[mac_idx],buf);
        mac[mac_idx][17]='\0';
        mac_idx++;
      }  
    }
    close(fd);
  } else ;
  
  // start thread
  create_thread();

  // start detect 
  pd = pcap_open_live(device, snaplen, !pflag, 0, ebuf);
  if(pd==NULL) { 
    logit("%s",ebuf);
    exit(0);
  }
  i = pcap_snapshot(pd);
  if(snaplen<i) {
    logit("snaplen raised from %d to %d",snaplen,i);
	snaplen = i;
  }
  //if(argc>2) {
    if(pcap_lookupnet(device,&localnet,&netmask,ebuf)<0) {
      localnet = 0;
      netmask = 0;
      logit("%s",ebuf);
    }
    strcpy(cmdbuf,"port 68");
    //cmdbuf = copy_argv(&argv[2]);
    //printf("cmdbuf=%s\n",cmdbuf);
    if(pcap_compile(pd, &fcode, cmdbuf, 1, netmask)<0) {
      logit("%s",pcap_geterr(pd));
      exit(0);
    }
    if(pcap_setfilter(pd, &fcode)<0) {
      logit("%s",pcap_geterr(pd));
      exit(0);
    }
  //}
  if(pcap_loop(pd, cnt, printer, pcap_userdata) < 0) {
	logit("pcap_loop: %s",pcap_geterr(pd));
	exit(0);
  }
  pcap_close(pd);
  exit(0);
}
