#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description:

woody_kver=$1
sarge_kver=$2
if [ "$woody_kver" = "" ]; then woody_kver="2.4.18-bf2.4"; fi

drblroot="/var/lib/diskless/default/root"
tmpdir=/tmp
initrd=`mktemp -d ${tmpdir}/initrd.XXXXXX`
initrdmnt=`mktemp -d ${tmpdir}/initrd.mnt.XXXXXX`
initrd_skel=`mktemp -d ${tmpdir}/initrd_skel.XXXXXX`

# woody netinst
#kernel_version="2.4.18-bf2.4"
kernel_version=$woody_kver
initrdimg="initrd-woody_netinst-$kernel_version.img"
echo "create $initrdimg ..."

cp root.bin $tmpdir/root.bin.$$.gz
gunzip $tmpdir/root.bin.$$.gz
mount -o loop $tmpdir/root.bin.$$ $initrd_skel

cp -a $initrd_skel/* $initrd/
# Blake, 2004/01/09, untar xlp.tgz
tar -C $initrd/etc -xzf xlp.tgz

# Blake, 2004/01/09, create disks-i386 for modules, pcmcia ...
mkdir -p $initrd/disks-i386/bf2.4
## rescue.bin
# Blake, 2004/01/12, create rescue.bin based on the kernel version we use
#cp rescue.bin $initrd/disks-i386/
rescue=`mktemp -d ${tmpdir}/rescue.XXXXXX`
rescue_skel=`mktemp -d ${tmpdir}/rescue_skel.XXXXXX`
mount -o loop rescue.bin $rescue_skel
cp -a $rescue_skel/* $rescue/
cp $drblroot/boot/vmlinuz-$kernel_version $rescue/linux.bin
/usr/bin/perl -p -i -e "s/VERSION=.*/VERSION=$kernel_version/" $rescue/install.sh
mkcramfs $rescue $initrd/disks-i386/rescue.bin 2> /dev/null
umount -d $rescue_skel
rm -rf $rescue_skel
rm -rf $rescue
## drivers.tgz
chroot $drblroot tar czf /root/modules.tgz /lib/modules/$kernel_version 2>/dev/null
cd drivers
mv $drblroot/root/modules.tgz .
tar --exclude CVS -czf $initrd/disks-i386/bf2.4/drivers.tgz ./
rm -f modules.tgz
cd ..
## iso
mkisofs -o $initrd/disks-i386.iso -graft-points /=$initrd/disks-i386 2>/dev/null
rm -rf $initrd/disks-i386/*
## configure
cat <<-EOF >> $initrd/etc/fstab
/disks-i386.iso	/disks-i386	iso9660	defaults,ro,loop	0	0
EOF
cat <<-EOF >> $initrd/sbin/udbootstrap.sh
#!/bin/sh
mount -a
/sbin/udbootstrap
EOF
chmod 755 $initrd/sbin/udbootstrap.sh
/usr/bin/perl -p -i -e 's/udbootstrap/udbootstrap.sh/' $initrd/etc/inittab

dd if=/dev/zero bs=1k of=$initrdimg count=$((`du -sk $initrd | cut -f1` * 7 / 6)) 2> /dev/null
/sbin/mke2fs -q -F $initrdimg 2> /dev/null
mount -o loop $initrdimg $initrdmnt
# Blake, 2004/01/16, use tar instead of cp
#cp -a $initrd/* $initrdmnt/
$(cd $initrd; tar czf /tmp/$initrdimg.tar.gz *)
tar -C $initrdmnt -xzf /tmp/$initrdimg.tar.gz
rm -f /tmp/$initrdimg.tar.gz

umount -d $initrdmnt
gzip -9 $initrdimg
mv $initrdimg.gz $initrdimg

umount -d $initrd_skel
rm -f $tmpdir/root.bin.$$
rm -rf $initrd/*

# sarge netinst
#kernel_version=""
#initrdimg="initrd-sarge_netinst-$kernel_version.img"
#echo "create $initrdimg ..."
#
#cp netboot-initrd.gz $tmpdir/netboot-initrd.$$.gz
#gunzip $tmpdir/netboot-initrd.$$.gz
#mount -o loop $tmpdir/netboot-initrd.$$ $initrd_skel
#
#cp -a $initrd_skel/* $initrd/
#rm -rf $initrd/lib/modules/*
#cp -a $drblroot/lib/modules/$kernel_version $initrd/lib/modules/
#dd if=/dev/zero bs=1k of=$initrdimg count=$((`du -sk $initrd | cut -f1` * 3 / 2)) 2> /dev/null
#/sbin/mke2fs -q -F $initrdimg 2> /dev/null
#mount -o loop $initrdimg $initrdmnt
#cp -a $initrd/* $initrdmnt/
#
#umount -d $initrdmnt
#gzip -9 $initrdimg
#mv $initrdimg.gz $initrdimg

#umount -d $initrd_skel
#rm -f $tmpdir/netboot-initrd.$$
#rm -rf $initrd/*

# housekeeping
rmdir $initrd_skel
rmdir $initrdmnt
rmdir $initrd
