#!/bin/sh

imageroot="/var/lib/diskless/default/root"
kernel_version=`uname -r`

cd drblpush.$$/netinst/
#./make_initrd.sh 2.4.25
#./make_nbi.sh 2.4.25

# woody_netinst initrd 
#kernel_version=`ls initrd-woody_netinst-*.img`
#kernel_version=${kernel_version/initrd-woody_netinst-/}
#kernel_version=${kernel_version%\.*}

./make_initrd.sh $kernel_version
./make_nbi.sh $kernel_version

if [ "$kernel_version" != "" ]; then
  cp initrd-woody_netinst-$kernel_version.img /tftpboot
  cp $imageroot/boot/vmlinuz-$kernel_version /tftpboot
  cat <<-EOF >> /tftpboot/pxelinux.cfg/default

label woody_netinst
  kernel vmlinuz-$kernel_version
  append initrd=initrd-woody_netinst-$kernel_version.img ramdisk_size=65535 root=/dev/ram flavor=bf2.4
EOF
  cp boot-woody_netinst.nbi /tftpboot
fi

# sarge_netinst initrd

# others
others="rh8.0 rh9 FC1 FC2 mdk9.2 mdk10.0"
for d in $others; do
  #label="$d""_netinst"
  label=$d
  kernel="nbi_img/vmlinuz."$label"_netinstall"
  initrd="nbi_img/initrd_"$label"_netinstall.img"
  append="initrd=$initrd ramdisk_size=9600 root=/dev/ram"
  if [ -f /tftpboot/$kernel -a -f /tftpboot/$initrd ]; then
    cat << EOF >> /tftpboot/pxelinux.cfg/default

label $label
  kernel $kernel
  append $append
EOF
  fi
done

cd ../..
