#!/bin/sh

USAGE="Usage: $0 -k|--kernel <kernel_ver>"
# Parse command-line options
while [ $# -gt 0 ]; do
  case "$1" in
    -k|--kernel)
	  shift
	  kernel_ver=$1
	  shift
	  ;;
	--drbl)
	  output_dir="tftpboot"
	  shift
	  ;;
    *)
	  echo $USAGE >& 2
	  break 
	  ;;
  esac
done

# generate pxe_pciscan/etc/niclist and pci_scan
# mkinitrd-net will do it !!

# read the pxe_pciscan.conf for more modules
# should read /lib/modules/`uname -r`/modules.dep for path information
# right now assume the new modules are placed in 
# /lib/modules/`uname -r`/kernel/drivers/net
include_modules="./include-modules"
if [ -e pxe_pciscan.conf ]; then
  cat pxe_pciscan.conf | sed -e '/^#/d' | sed -e '/^$/d' >> niclist
  for module in `cat pxe_pciscan.conf | sed '/^#/d' | awk '{ print $2; }'`
  do
    #module=$module".o"
	#module_o=$(find /lib/modules/$kernel_ver/kernel/drivers/net -name $module.o -print)
	#if [ ! -z "$module_o" ]; then
	#  cp $module_o pxe_pciscan/lib/modules/$kernel_ver/
	#fi
    $include_modules -k $kernel_ver -d pxe_pciscan/lib/modules/$kernel_ver $module > pxe_pciscan/bin/insert-modules-$module
    chmod 755 pxe_pciscan/bin/insert-modules-$module
  done
fi

#8139cp will cause some problem, remove the line
#cp niclist pxe_pciscan/etc/
sed -e "/8139cp$/d" niclist > pxe_pciscan/etc/niclist
gcc -static -o pxe_pciscan/bin/pci_scan pci_scan.c

# generate pxe_pciscan/bin/insert-modules
cat <<-EOF > pxe_pciscan/bin/insert-modules
#!/bin/sh

#nic=\`/bin/pci_scan /etc/niclist\`
for nic_module in \`/bin/pci_scan /etc/niclist\`
do
  case \$nic_module in
EOF

for file in `ls pxe_pciscan/bin/insert-modules-*`
do
  #module=`echo $file | sed -e 's/pxe_pciscan\/bin\/insert-modules-//g'` 
  module=${file##pxe_pciscan/bin/insert-modules-}
  
  cat <<-EOF >> pxe_pciscan/bin/insert-modules
    '$module')
      /bin/insert-modules-$module
      ;;
EOF
  
done

cat <<-EOF >> pxe_pciscan/bin/insert-modules
    *)
      echo "Cannot detect the NIC or the NIC not provided: nic=\$nic_module"
      ;;
  esac
done
EOF
chmod 755 pxe_pciscan/bin/insert-modules

# Fix usb keyboard & mouse co-exist problem
cp /lib/modules/$kernel_ver/kernel/drivers/usb/usbcore.o pxe_pciscan/lib/modules/$kernel_ver/
if [ -e /lib/modules/$kernel_ver/kernel/drivers/usb/host ]; then
  cp /lib/modules/$kernel_ver/kernel/drivers/usb/host/usb-uhci.o pxe_pciscan/lib/modules/$kernel_ver/
  cp /lib/modules/$kernel_ver/kernel/drivers/usb/host/usb-ohci.o pxe_pciscan/lib/modules/$kernel_ver/
  # usb 2.0
  if [ -f /lib/modules/$kernel_ver/kernel/drivers/usb/host/ehci-hcd.o ]; then
    cp /lib/modules/$kernel_ver/kernel/drivers/usb/host/ehci-hcd.o pxe_pciscan/lib/modules/$kernel_ver
  fi
else
  cp /lib/modules/$kernel_ver/kernel/drivers/usb/usb-uhci.o pxe_pciscan/lib/modules/$kernel_ver/
  cp /lib/modules/$kernel_ver/kernel/drivers/usb/usb-ohci.o pxe_pciscan/lib/modules/$kernel_ver/
  # usb 2.0
  if [ -f /lib/modules/$kernel_ver/kernel/drivers/usb/ehci-hcd.o ]; then
    cp /lib/modules/$kernel_ver/kernel/drivers/usb/ehci-hcd.o pxe_pciscan/lib/modules/$kernel_ver
  fi
fi
cp /lib/modules/$kernel_ver/kernel/drivers/input/input.o pxe_pciscan/lib/modules/$kernel_ver/
cp /lib/modules/$kernel_ver/kernel/drivers/usb/usbkbd.o pxe_pciscan/lib/modules/$kernel_ver/
cp /lib/modules/$kernel_ver/kernel/drivers/usb/usbmouse.o pxe_pciscan/lib/modules/$kernel_ver/
cp /lib/modules/$kernel_ver/kernel/drivers/usb/hid.o pxe_pciscan/lib/modules/$kernel_ver/
cp /lib/modules/$kernel_ver/kernel/drivers/input/keybdev.o pxe_pciscan/lib/modules/$kernel_ver/
cp /lib/modules/$kernel_ver/kernel/drivers/input/mousedev.o pxe_pciscan/lib/modules/$kernel_ver/


# Create temporary working files
initrd="pxe_pciscan"
initrdimg=`mktemp /tmp/initrd.img.XXXXXX`
initrdmnt=`mktemp -d /tmp/initrd.mnt.XXXXXX`

# Create empty ext2fs image file
dd if=/dev/zero bs=1k of=$initrdimg count=$((`du -sk $initrd | cut -f1` * 7 /
6)) 2> /dev/null
/sbin/mke2fs -q -F $initrdimg 2> /dev/null

# Mount image file, copy files on, create /dev entries, display free space,
# umount
mount -o loop $initrdimg $initrdmnt
cp -a $initrd/* $initrdmnt/
mknod $initrdmnt/dev/console c 5 1
mknod $initrdmnt/dev/null c 1 3
mknod $initrdmnt/dev/ram b 1 1
mknod $initrdmnt/dev/systty c 4 0
mknod $initrdmnt/dev/random c 1 8
mknod $initrdmnt/dev/urandom c 1 9
for i in 1 2 3 4; do mknod $initrdmnt/dev/tty$i c 4 $i; done
if [ "$quiet" == "n" ]; then
  df -h $initrdmnt
fi
umount -d $initrdmnt

#Create output file
initrd_suffix="pxe_pciscan"
gzip -9 -n -c $initrdimg > $output_dir/initrd-$initrd_suffix-$kernel_ver.img
mknbi-linux --param="ramdisk_size=9600" /boot/vmlinuz-$kernel_ver $output_dir/initrd-$initrd_suffix-$kernel_ver.img > $output_dir/boot.nbi

# Removet temporary files
rm -f $initrdimg
rmdir $initrdmnt
