#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>

/* report the error and exit */
void bail(const char *on_what)
{
  fputs(on_what, stderr);
  fputs("\n",stderr);
  exit(1);
}

/* full_write */
int full_write(int desc, const char *ptr, size_t len)
{
  int total_written = 0;
  while(len > 0)
  {
    int written = write(desc, ptr, len);
    if(written<0) return written;
    else ;
    total_written += written;
    ptr += written;
    len -= written;
  }
  return total_written;
}

/* readline */
int readline(int fd, char* ptr, int maxlen)
{
  int n, rc;
  char c;

  for(n = 1; n < maxlen; n++)
  {
    if( (rc = read(fd,&c,1)) == 1 )
    {
      *ptr++ = c;
      if( c=='\n' ) break;
    }
    else if( rc==0 )
    {
      if( n==1 ) return EOF; // EOF, no data read
      else break; // EOF, some data was read
    }
    else 
    {
      return EOF;
    } 
  }

  *ptr = 0;
  return n;
}

/* mkaddr
 * argument: 
 *   void* addr: return address (type: "struct sockaddr_in *")
 *   int* addrlen: indicate the length of "void* addr"
 *   char* str_addr: input string address (format: "ip/hostname:port")
 *   char* protocol: input string protocol
 * return:
 *   0  success
 *   -1 bad host part
 *   -2 bad port part
 */
int mkaddr(void* addr, int* addrlen, char* str_addr, char* protocol)
{
  char *inp_addr = strdup(str_addr);
  char *host_part = strtok(inp_addr, ":");
  char *port_part = strtok(NULL, "\n");
  struct sockaddr_in *ap = (struct sockaddr_in *) addr;
  struct hostent *hp = NULL;
  struct servent *sp = NULL;
  char *cp;
  long lv;

  /* set input defaults */
  if(!host_part) host_part = "*"; 
  if(!port_part) port_part = "*";
  if(!protocol)  protocol  = "tcp";

  /* initialize the address structure */
  memset(ap,0,*addrlen);
  ap->sin_family = AF_INET;
  ap->sin_port = 0;
  ap->sin_addr.s_addr = INADDR_ANY;

  /* fill in the host address */
  if(strcmp(host_part,"*") == 0) ;
  else if( isdigit(*host_part) ) 
  {
    if(!inet_aton(host_part,&ap->sin_addr)) return -1;
  }
  else 
  {
    /* assume a hostname */
    hp = gethostbyname(host_part);
    if(!hp) return -1;
    if(hp->h_addrtype!=AF_INET) return -1;
    ap->sin_addr = * (struct in_addr *)hp->h_addr_list[0];
  }

  /* process an optional port # */
  if(!strcmp(port_part,"*"))  ;
  else if(isdigit(*port_part)) 
  {
    /* process numeric port # */
    lv = strtol(port_part,&cp,10);
	if( cp!= NULL && *cp ) return -2;
	if( lv < 0L || lv >= 32768 ) return -2;
	ap->sin_port = htons((short)lv);
  }
  else 
  {
    /* lookup the service */
    sp = getservbyname(port_part,protocol);
    if(!sp) return -2;
    ap->sin_port = (short)sp->s_port;
  }

  /* return address length */
  *addrlen = sizeof(*ap);

  free(inp_addr);
  return 0;
}

int main(int argc, char **argv)
{
  char *srvr_addr = NULL;
  char *local_addr = NULL;
  struct sockaddr_in adr_srvr;
  int len_inet, s, z, n;
  char buf[BUFSIZ];

  if(argc<3) { 
    printf("Usage: socket <remote ip>:<port> <local ip>\n"); 
	exit(0); 
  }
  else { 
    srvr_addr = argv[1];
	local_addr = argv[2];
  }
  
  s = socket(AF_INET, SOCK_STREAM, 0);
  if(s==-1) bail("line 103: socket error");
  len_inet = sizeof(adr_srvr);
 
  z = mkaddr(&adr_srvr, &len_inet, srvr_addr, "tcp");
  if(z==-1) bail("line 107: mkaddr error");

  z = connect(s, (struct sockaddr*)&adr_srvr, len_inet);
  if(z==-1) bail("line 110: connect error");

  sprintf(buf,"%s\n",local_addr);
  full_write(s,buf,strlen(buf));
  readline(s,buf,BUFSIZ);
  printf("%s",buf);

  close(z); 
}
