#!/bin/sh

kernel_version=$1
#if [ "$kernel_version" = "" ]; then kernel_version="2.4.20"; fi
if [ "$kernel_version" = "" ]; then kernel_version="2.4.25"; fi

# imageroot
imageroot="/var/lib/diskless/default/root"

# wget, mknbi
apt-get -y install mknbi

# vmware

# mkinitrd-net
if [ ! -e $imageroot/root/mkinitrd-net ]; then
  cp -r drblpush.$$/mkinitrd-net $imageroot/root
fi
cat <<-EOF > $imageroot/root/mkinitrd-net.sh
if [ -e /etc/mtab ]; then rm -f /etc/mtab; fi
ln -fs /proc/mounts /etc/mtab
apt-get -y install mknbi
apt-get -y install make gcc libc6-dev
apt-get -y install bzip2 binutils
cd root/mkinitrd-net
mkdir -p tftpboot
ln -fs /usr/src/kernel-headers-$kernel_version /usr/src/linux
#make
/sbin/depmod -F /boot/System.map-$kernel_version -a $kernel_version
make KVER=$kernel_version drbl-all-nbi
cd ../..
mkdir -p /initrd
cd dev
tar cmzf /etc/diskless-image/dev.tgz *
cd ..
EOF
chmod 755 $imageroot/root/mkinitrd-net.sh
mount -t proc proc $imageroot/proc
chroot $imageroot /root/mkinitrd-net.sh
umount $imageroot/proc

##
mkdir -p /tftpboot/$kernel_version
mv $imageroot/root/mkinitrd-net/tftpboot/* /tftpboot/$kernel_version
## move the file dhcpd.conf.etherboot-pcimap.include to /etc/dhcp3 for security
mkdir -p /etc/dhcp3/$kernel_version
mv /tftpboot/$kernel_version/dhcpd.conf.etherboot-pcimap.include /etc/dhcp3/$kernel_version
chmod 600 /etc/dhcp3/$kernel_version/dhcpd.conf.etherboot-pcimap.include
# pxelinux
cp $imageroot/boot/vmlinuz-$kernel_version /tftpboot/
cat <<-EOF >> /tftpboot/pxelinux.cfg/default
label drbl-$kernel_version
  kernel vmlinuz-$kernel_version
  append initrd=initrd-pxe_pciscan-$kernel_version.img ramdisk_size=9600

EOF
touch /tftpboot/mkinitrd-net
##

## copy the file dhcpd.conf.etherboot.include to /etc/dhcp3 for security
#cp drblpush/mkinitrd-net/dhcpd.conf.etherboot.include /tftpboot/
cp drblpush.$$/mkinitrd-net/dhcpd.conf.etherboot.include /etc/dhcp3/$kernel_version
chmod 600 /etc/dhcp3/dhcpd.conf.etherboot.include
rm -rf $imageroot/root/mkinitrd-net
rm -f $imageroot/root/mkinitrd-net.sh
