#!/bin/sh

apt-get -y install wget

kernel_version="mkinitrd+net.3.0"
kernel_image="kernel-image-2.4.18_diskless."$kernel_version"_i386.deb"
kernel_headers="kernel-headers-2.4.18_diskless."$kernel_version"_i386.deb"
bcm4401_image="bcm4400_1.0.1-1_i386.deb"

if [ -e "/var/cache/apt/archives/$kernel_image" -a \
     -e "/var/cache/apt/archives/$kernel_headers" -a \
	 -e "/var/cache/apt/archives/$bcm4401_image" ]; then
  mv "/var/cache/apt/archives/$kernel_image" .
  mv "/var/cache/apt/archives/$kernel_headers" .
  mv "/var/cache/apt/archives/$bcm4401_image" .
else 
  # get image from drbl mirror site
  if [ "$drbl_mirror" = "" ]; then
    echo -n "drbl mirror site [http://drbl.nchc.gov.tw/]? "
    read ANS
    if [ "$ANS" = "" ]; then
      drbl_mirror="http://drbl.nchc.gov.tw/"
    else
      drbl_mirror="$ANS"
    fi
  fi
  http_site="$drbl_mirror/kernel/debian/"
  wget $http_site/$kernel_image
  wget $http_site/$kernel_headers
  wget $http_site/$bcm4401_image
fi

# drbl client kernel image/headers
if [ -e $imageroot/lib/modules/2.4.18 ]; then
  rm -rf $imageroot/lib/modules/2.4.18
fi
dpkg --root $imageroot -i $kernel_image
dpkg --root $imageroot -i $kernel_headers
dpkg --root $imageroot -i $bcm4401_image
rm -f $kernel_image
rm -f $kernel_headers
rm -f $bcm4401_image

# the command should be executed in postinst of bcm4401
chroot $imageroot /sbin/depmod -F /boot/System.map-2.4.18 -a

# for vmware
echo "pcnet32 0x0000d041 0x00002000 0xffffffff 0xffffffff 0x00000000 0x00000000 0x00000000" >> $imageroot/lib/modules/2.4.18/modules.pcimap
# for modutils
mkdir -p $imageroot/etc/kernel
mv $imageroot/lib/modules/2.4.18/modules.* $imageroot/etc/kernel/
for file in `ls $imageroot/etc/kernel/ | grep "modules"`
do
  echo "ln -fs /etc/kernel/$file /lib/modules/2.4.18/$file" >> $imageroot/etc/kernel/modutils.sh
done
chmod 755 $imageroot/etc/kernel/modutils.sh
mount -t proc proc $imageroot/proc
chroot $imageroot /etc/kernel/modutils.sh
umount $imageroot/proc
rm -rf $imageroot/etc/kernel/modules.sh


