#!/bin/sh
# Steven Shiau <steven@nchc.org.tw>
# 2003/11/19 Modified by Blake, Kuo-Lien Huang for Debian's DRBL
#
fdos_img_src="boot1440.img"
img_output="boot1440_drbl.img"
nbi_output="boot1440_drbl.nbi"

# check file
[ ! `which unix2dos` ] && echo "no unix2dos..." && exit 1

# clean the old file
[ -f $img_output ] && rm -f $img_output
[ -f kernel.sys ] && rm -f kernel.sys

# process the fdos image
img_mt=`mktemp -d fdos_img.XXXXXX`
cp $fdos_img_src $img_output
mount -o loop -t vfat $img_output $img_mt

# cp kernel.sys to be sued for mknbi-fdos
cp -f $img_mt/kernel.sys .
mkdir -p $img_mt/drbl

# not directory output the file to floppy, it's getting full...
# unix2dos needs soem working space
cat <<-EOF >fdconfig.sys
!FILES=20
!BUFFERS=20
!LASTDRIVE=Z

;
; Freedos configuration file for system drivers
; Contents provided by Bernd Blaauw
; http://members.home.nl/bblaauw , bblnews@hotmail.com
; and by Jeremy Davis 
; http://www.fdos.org/ , jeremyd@computer.org
; Please edit to suit your needs.
MENU
MENU
MENU
MENU DRBL tool
MENU
MENU 1 - Boot with (IDE/ATAPI) CD-ROM driver (default)
MENU 2 - Boot with (IDE/ATAPI) CD-ROM driver and support XMS (386+)
MENU 3 - Clean Boot (No CD-ROM driver loaded)
MENU 4 - LSI/NCR/SYMBIOS-chip based SCSI CDROM install
MENU 5 - Game ?
MENU 6 - Use the files you inserted in directory DRBL
MENU    (press 0 to run Memtest86 - physical memory test program)
MENU    FreeDOS is a trademark of Jim Hall 1994-2003
MENU    ************************************************************************
MENU    This tool is written by NCHC Opensource Taskforce.
MENU    Steven Shiau <steven@nchc.org.tw> and K. L. Huang <c00hkl00@nchc.org.tw>
MENU    Working with DRBL environment.
MENU    http://opensource.nchc.org.tw, http://drbl.nchc.org.tw
MENU    ************************************************************************
MENU
MENUDEFAULT=6,10

0?SHELL=A:\FREEDOS\MEMTESTE.EXE

123456?SHELL=A:\COMMAND.COM /E:1024 /P=A:\FREEDOS\FDAUTO.BAT

2?DEVICE=A:\DRIVER\FDXMS.SYS
2?DOS=HIGH,NOUMB

; 3 : clean boot
3?ECHO Clean boot performed..

4?ECHO going SCSI.

5?ECHO lil' game . . .

6?ECHO DRBL . . .
EOF

#
cat <<-EOF >fdauto.bat
@echo off
set dircmd=/p /ogn
echo Welcome to FreeDOS (http://www.freedos.org)!

REM if clean booting, skip loading CDEx, etc.
if [%config%]==[3] GOTO END
if [%config%]==[5] GOTO ee
REM if drbl booting, skip loading CDEx, etc.
if [%config%]==[6] GOTO drbl

if exist a:\freedos\cpudet.com a:\freedos\cpudet.com
set cputype=80%errorlevel%86
if not "%CPUTYPE%"=="80386" goto CPU16bit
for %%x in ( 1 2 6 7 8 9 ) do if "%config%"=="%%x" goto benq_drv
if exist a:\driver\aspi8xx.sys a:\driver\devload a:\driver\aspi8xx.sys
if exist a:\driver\symdisk.sys a:\driver\devload a:\driver\symdisk.sys
if not exist a:\driver\aspi8xx.sys goto askdrvr
goto atapidrv

:askdrvr
echo Please provide complete filename of driver(s), or hit ENTER to continue . . .
echo (note: if booting from cdrom physical floppydrive will be B: instead of A:)
echo.
echo Example: A:\DRIVER\ASPI8DOS.SYS
set /p scsidrvr=Location : 
if "%scsidrvr%"=="" goto benq_drv
for %%x in ( %scsidrvr% ) do if exist %%x a:\driver\devload %%x
goto benq_drv

:benq_drv
if exist a:\driver\vide-cdd.sys a:\driver\devload a:\driver\vide-cdd.sys /D:FDCD0001
for %%x in ( 1 2 3 4 5 6 7 8 9 0 ) do if exist FDCD000%%x goto cdex
goto eltorito
:eltorito
if exist a:\driver\eltorito.sys a:\driver\devload a:\driver\eltorito.sys /D:FDCD0001
rem May fail in case you boot from physical floppy or if cd is in floppy-emulation mode
rem instead of non-emulation mode (for H. Peter Anvin's isolinux.bin)
for %%x in ( 1 2 3 4 5 6 7 8 9 0 ) do if exist FDCD000%%x goto cdex
goto atapidrv
:atapidrv
a:\driver\devload a:\driver\atapicdd.sys /D:FDCD0001
for %%x in ( 1 2 3 4 5 6 7 8 9 0 ) do if exist FDCD000%%x goto cdex
goto cdex

:cdex
REM dynamic building of driver-names to load:
REM and generate error if CD-ROM driver not loaded!
set DRVNAMES=
for %%x in ( 1 2 3 4 5 6 7 8 9 0 ) do if exist FDCD000%%x set DRVNAMES=%DRVNAMES% /D:FDCD000%%x
if "%DRVNAMES%"=="" goto error_nocdd
if not exist a:\driver\findcd.com set cddrvltr=X
echo Loading CD-ROM extensions ...
if not "%cddrvltr%"=="" a:\driver\shsucdx.exe %DRVNAMES%,%cddrvltr%
if "%cddrvltr%"=="" a:\driver\shsucdx.exe %DRVNAMES%
set DRVNAMES=

REM If you are having problems and own another DOS, you may try its cdex, e.g.
REM mscdex.exe /d:FDCD0001

REM ECHO Attempting to load DPMI services resident
set swapfile=-
rem set swapfile=c:\temp\cwsdpmi.swp
if exist a:\freedos\cwsdpmi.exe a:\freedos\cwsdpmi.exe -p -s%swapfile%

:begin
rem FreeDOS's autorun is always executed if found. If not, default to the autorun.bat that may be
rem present in the isolinux directory.
call a:\freedos\FINDCD.BAT
if [%cdrom%]==[NONE] call a:\freedos\FINDCD.BAT ISOLINUX\AUTORUN.BAT
if [%cdrom%]==[]     call a:\freedos\FINDCD.BAT ISOLINUX\AUTORUN.BAT

if [%cdrom%]==[NONE] goto error
if [%cdrom%]==[] goto error

REM Enable support for End User programs (not included with FreeDOS), like DriveSnapshot restore software

set filelist=%cdrom%\snapshot.exe %cdrom%\dosapps\snapshot.exe %cdrom%\isolinux\snapshot.exe a:\snapshot.exe a:\utils\snapshot.exe
for %%x in ( %filelist% ) do if exist %%x set snapexec=%%x
for %%x in ( %cdrom%\*.sna ) do if exist %%x set snapdata=%%x
for %%x in ( %snapexec% %snapdata% ) do if "%%x"=="" goto callCD
set snapline=%snapexec% RESTORE HD1 auto %snapdata% -Y -V
set filelist=
set snapexec=
set snapdata=
goto callCD

REM Perform installation 
REM (note only thing happened was locating cdrom-disk and drive
REM  and establishing which End User programs if any are available.)
REM findfile variable created by findcd.bat

:callCD
if not exist %cdrom%\%findfile% goto error
CDD %cdrom%
if not [%config%]==[9] CALL %cdrom%\%findfile%
goto end

:ee
if not exist GAMES\MSWEEP.COM GOTO begin
echo Easter Egg :-) Entertainment courtesy Dave Dunfield
echo Free for noncommercial use, used with permission in this distribution.
if exist GAMES\MSWEEP.COM GAMES\MSWEEP.COM
GOTO END

:drbl
echo The files you insert are in directory "drbl"
echo Changing to directory drbl...
cd drbl
GOTO END

:error_nocdd
echo Error! Either a CD-ROM driver was not loaded, failed to load, or
echo was loaded with a device name other than FDCD0001.
echo Please make appropriate corrections and try again.  Thanks.
GOTO END

:error
echo No drive found with FreeDOS on it.  Installation Aborted!
echo If the FreeDOS CD is not yet in the drive, please insert
echo it now then change to the CD drive and run \FREEDOS\AUTORUN\AUTORUN.BAT
GOTO END

:CPU16bit
echo CD-ROM driver requires at least an Intel 386 (or compatible) processor.
echo Instead, a %cputype% processor has been detected.
echo We recommend installing FreeDOS using diskettes.
goto end

:END
EOF

# overwrite the orininal ones...
unix2dos fdconfig.sys
if [ "$?" -gt 0 ]; then
 echo "Failed to convert fdconfig.sys to dos format" 
 exit 1
fi
unix2dos fdauto.bat
if [ "$?" -gt 0 ]; then
 echo "Failed to convert fdauto.bat to dos format" 
 exit 1
fi

cp -f fdconfig.sys $img_mt/fdconfig.sys
cp -f fdauto.bat $img_mt/freedos/fdauto.bat
rm -f fdconfig.sys
rm -f fdauto.bat

#
umount $img_mt

if [ -f $img_output ]; then
 mknbi-fdos --output=$nbi_output kernel.sys $img_output 
fi

# clean the tmp dir
[ -d $img_mt ] && rm -rf $img_mt
[ -f kernel.sys ] && rm -f kernel.sys
echo "done!"
exit 0
