#!/usr/bin/perl -X

############################################################################
##                                                                         #
##   This program is free software; you can redistribute it and/or modify  #
##   it under the terms of the GNU General Public License as published by  #
##   the Free Software Foundation; either version 2 of the License, or     #
##   (at your option) any later version.                                   #
##                                                                         #
############################################################################

# in: config_file
# out: hash of hash reference 
sub read_config {

  my %HoH = ();
  my $KoH="general";
  my $key="",$value="";

  open(CONFIG,$_[0]);
  while(<CONFIG>) {
    if($_=~/#.*/) {
      # ignore comment
    }
    elsif($_=~/\[.*\]/) {
      # has key 
      chop;
      $KoH=substr($_,1,length($_)-2); 
    }
    else { 
      # hash value
      chop;
      if( 0 == length($_) ) { next; }
      ($key,$value)=split(/=/);
      #print "KoH=$KoH, key=$key, value=$value\n";
      $HoH{ $KoH }{ $key }= $value;
    }
  }
  close(CONFIG);

  return( \%HoH );  
}

sub main {

  my $rHoH = read_config($_[0]);

  my $nameserver=$rHoH->{"general"}{"nameserver"};
  my $domain=$rHoH->{"general"}{"domain"};
  my $nisdomain=$rHoH->{"general"}{"nisdomain"};
  my $first_diskless_host="";

  # generate dhcpd.conf, hosts drbl_deploy.sh
  open(DHCPD_OUT,">dhcpd.conf");
  open(DHCPDITF_OUT,">dhcp");
  open(HOSTS_OUT,">hosts");
  open(DISKLESS_OUT,">drbl_deploy.sh");
  open(EXPORTS_OUT,">exports");
  open(NETGROUP_OUT,">netgroup");
  open(OPENMOSIXMAP_OUT,">openmosix.map");

  # some general option in dhcpd.conf, hosts, drbl_deploy.sh dhcp
  print DHCPD_OUT <<EOF;
default-lease-time			21600;
max-lease-time				21600;
#use-host-decl-names		on;
#option subnet-mask			255.255.255.0;
option domain-name-servers  $nameserver;
option domain-name			"$domain";	

EOF

  if( $rHoH->{"general"}{"nbi"} =~ /^mkinitrd-net$/ ) {
    print DHCPD_OUT <<EOF;
include "/etc/dhcp3/dhcpd.conf.etherboot.include";
include "/etc/dhcp3/dhcpd.conf.client-switch.include";
EOF
  }
  if( $rHoH->{"general"}{"pxe"} =~ /^pxelinux.0$/ ) {
    print DHCPD_OUT <<EOF;
include "/etc/dhcp3/dhcpd.conf.pxelinux.include";
EOF
  }	

  print DHCPDITF_OUT "INTERFACES=\"";

#  print HOSTS_OUT <<EOF;
#127.0.0.1 localhost localhost.localdomain
#EOF

  print EXPORTS_OUT <<EOF;
/var/lib/diskless/default/root \@nodes(ro,sync,async,no_root_squash)
/home     \@nodes(rw,sync,async,no_root_squash)
/opt      \@nodes(ro,sync,async,no_root_squash)
/var/mail \@nodes(rw,sync,async,no_root_squash)

EOF

  print NETGROUP_OUT "nodes";

  print OPENMOSIXMAP_OUT <<EOF;
# Static openMosix configuration
# ==============================
#
# Each line in this file should contain 3 fields, statically mapping
# IP addresses to openMosix node-numbers:
#
# 1) The first openMosix node-number in this range.
# 2) The IP address of the above node (or node-name from /etc/hosts).
# 3) The number of nodes in this range.
#
# Note: If you don't create a valid IP <-> node-number mapping, the
#	autodiscovery daemon will be started, automatically assigning
#	node-numbers to all visible openMosix machines.
#
# Example: 10 machines with IP addresses 192.168.1.50 - 192.168.1.59
#	   which will have openMosix node-numbers 1-10:
#
# 1	   192.168.1.50	    10
#
# MOSIX-#  IP  number-of-nodes
# ============================
EOF

  print DISKLESS_OUT <<EOF;
#!/bin/sh

############################################################################
##                                                                         #
##   This program is free software; you can redistribute it and/or modify  #
##   it under the terms of the GNU General Public License as published by  #
##   the Free Software Foundation; either version 2 of the License, or     #
##   (at your option) any later version.                                   #
##                                                                         #
############################################################################

if [ "\$1" != "" -a "\$1" = "macadr" ]; then
  BINARY_LINENO=1#<LINENO>
  BINARY_BSD_CHECKSUM1=1#<CHECKSUM1>
  BINARY_BSD_CHECKSUM2=1#<CHECKSUM2>
  BINARY_OUTNAME=macadr-\$\$.zip

  apt-get -y install zip unzip
  outname=\$BINARY_OUTNAME
  trap 'rm -f \$outname; rm -rf macadr; exit 1' HUP INT QUIT TERM
  echo "Unpacking..."
  tail +\$BINARY_LINENO \$0 > \$outname
  if [ -x /usr/bin/sum ]; then
    echo "Checksumming..."

    sum=`/usr/bin/sum \$outname`
    index=1
    for s in \$sum
    do
      case \$index in
      1)  sum1=\$s;
          index=2;
          ;;
      2)  sum2=\$s;
          index=3;
          ;;
      esac
    done
    if expr \$sum1 != \$BINARY_BSD_CHECKSUM1 ||
       expr \$sum2 != \$BINARY_BSD_CHECKSUM2 ; then
      echo "drbl_deplay.sh appears to be corrupted."
      exit 1
    fi
  else
    echo "Can't find /usr/bin/sum to do checksum. Continuing anyway."
  fi

  echo "Extracting..."
  if [ -e \$outname -a -x /usr/bin/unzip ]; then
    if [ "\$2" != "" ]; then
      /usr/bin/unzip \$outname -d \$2
    else
      /usr/bin/unzip \$outname -d drblpush
    fi
	rm -f \$outname
  fi

  exit 0
fi

EOF

  foreach my $k1 ( keys %$rHoH ) {
    #print "key: $k1\n";
    #foreach my $k2 ( keys %{ $rHoH->{ $k1 } } ) {
    #  print "$k2=$rHoH->{$k1}{$k2}\n";
    #}
    if( $k1=~/general/ ) { next; } # skip general block
    my $interface=$rHoH->{$k1}{"interface"};
    my $network=$rHoH->{$k1}{"network"};
    my $netmask=$rHoH->{$k1}{"netmask"};
    my $broadcast=$rHoH->{$k1}{"broadcast"};
    my $nfsserver=$rHoH->{$k1}{"nfsserver"};
    my $bootserver=$rHoH->{$k1}{"bootserver"};
    my $nisserver=$rHoH->{$k1}{"nisserver"};
    my $ntpserver=$rHoH->{$k1}{"ntpserver"};
    my $router=$rHoH->{$k1}{"router"};
    my $nbi=$rHoH->{$k1}{"nbi"};
    my $pxe=$rHoH->{$k1}{"pxe"};
    my $mac=$rHoH->{$k1}{"mac"};
    my $range=$rHoH->{$k1}{"range"};
    my $hostname=$rHoH->{$k1}{"hostname"};
    if( length($nfsserver)==0 ) { $nfsserver=$bootserver; }
    if( length($nisserver)==0 ) { $nisserver=$bootserver; }
    if( length($ntpserver)==0 ) { $ntpserver=$bootserver; }
    if( length($router)==0 ) { $router=$bootserver; }
    if( length($nbi)==0 ) { $nbi=$rHoH->{"general"}{"nbi"}; }

    # ntpserver (TW only)

    # warring
    unless ($interface && $network && $netmask && $broadcast && $nfsserver && $router && $nbi && ($mac||$range) && $hostname ) 
    {
      print "WARRING: the configuration in block [$k1] is incorrect\n";
      print "following is your configuration:\n";
      print "[$k1]\n";
      print "interface=$interface\n";
      print "network=$network\n";
      print "netmask=$netmask\n";
      print "broadcast=$broadcast\n";
      print "nfsserver=$nfsserver\n";
      print "bootserver=$bootserver\n";
      print "nisserver=$nisserver\n";
      print "ntpserver=$ntpserver\n";
      print "router=$router\n";
      print "nbi=$nbi\n";
      print "mac=$mac\n";
      print "range=$range\n";
      print "hostname=$hostname\n";
      next ;
    }

    # go 
    @bootserverIp=split(/\./,$bootserver);
    @networkIp=split(/\./,$network);

    print DHCPD_OUT <<EOF;

subnet $network netmask $netmask {
    option broadcast-address $broadcast;
    option subnet-mask $netmask;
    option routers $router;
    next-server $bootserver;

EOF
   
    print DHCPDITF_OUT "$interface ";

    # generate hosts
    $server_hostname=readpipe("hostname");
## Blake, 2003/09/02 
print HOSTS_OUT <<EOF;
$bootserver boot_$k1.$domain boot_$k1
EOF
##    print HOSTS_OUT <<EOF;
##$nfsserver nfsserver_$k1.$domain nfsserver_$k1 $server_hostname
##EOF

#    # range
#    if( length($mac)==0 && length($range)!=0 ) {
#      open(RANGE_OUT,">/tmp/range");
#      my($rs,$re)=split(/-/,$range,2);
#      for($i=$rs;$i<=$re;$i++) {
#        print RANGE_OUT "$networkIp[0].$networkIp[1].$networkIp[2].$i\n";
#      }
#      close(RANGE_OUT);
#    }

    # open mac or range
    $x=`/usr/bin/netmask -r $network/$netmask | awk '{ print \$1; }' | cut -d- -f1`;
    @IP=split(/\./,$x);
    $A=$IP[0]; $B=$IP[1]; $C=$IP[2]; $D=$IP[3];

    $run=0;
    if( length($mac)!=0 && length($range)!=0 ) { $run=3; }
    elsif( length($mac)!=0 && length($range)==0 ) { $run=2; }
    elsif( length($mac)==0 && length($range)!=0 ) { $run=1; }
    else { $run=0; }

    ##if( length($mac)!=0 ) { open(MAC_IN,$mac); }
    ##elsif( length($range)!= 0 ) { 
    ##  #open(MAC_IN,"/tmp/range");
    ##  open(MAC_IN,$range);
    ##}
    ##else {}

    $i=1;
    $openmosixId=1;
    $range_start=""; $range_end="";

    while($run>0) {

      if( $run == 2 || $run == 3 ) { open(MAC_IN,$mac); }
      elsif( $run == 1 ) { open(MAC_IN,$range); }
      else {}

      while(<MAC_IN>) {
        chop;
        if($_ =~ /^$/) { next; }
        ($m,$ip)=split(/\t+/);
 
        # hostname
        $label="";
        if($i<10) { $label=$hostname."00".$i; }
        elsif($i<100) { $label=$hostname."0".$i; }
        elsif($i<255) { $label=$hostname.$i; }
        else { last; } # minus 2 ip: $network.0 $network.255
 
        # ip
        if( $run == 3 || $run == 2 ) 
        { # mac
          ## Blake, 2003/08/12 use netmask instead
          ##if($bootserverIp[0]==$networkIp[0] &&
          ##   $bootserverIp[1]==$networkIp[1] &&
          ##   $bootserverIp[2]==$networkIp[2] &&
          ##   $bootserverIp[3]==$i) { 
          ##   $i++; 
          ##}
          #$ip="$networkIp[0].$networkIp[1].$networkIp[2].$i";
          if( length($ip)==0 ) {
            $D++;
            if($D>=255) { $C++; $D=1; }
            if($C>=255) { $B++; $C=1; }
            if($B>=255) { $A++; $B=1; }

            if($bootserverIp[0]==$A &&
               $bootserverIp[1]==$B &&
               $bootserverIp[2]==$C &&
               $bootserverIp[3]==$D) { 
              $D++;
              if($D>=255) { $C++; $D=1; }
              if($C>=255) { $B++; $C=1; }
              if($B>=255) { $A++; $B=1; }
            }
            $ip="$A.$B.$C.$D";
          }
          #
          # generate dhcpd.conf
		  #
		
		  # if $nbi = "mkinitrd-net"
		  if( $nbi =~ /^mkinitrd-net$/ ) {

            # if $pxe is not defined 
		    if( $pxe =~ /^$|^pxelinux.0$/ ) {
	          print DHCPD_OUT <<EOF;
    host $label {
        hardware ethernet  $m;
        fixed-address $ip;
    }
EOF
            }
		    # if pxe is defined
            else {
		      print DHCPD_OUT <<EOF;
    host $label {
        hardware ethernet  $m;
        fixed-address $ip;
        if substring (option vendor-class-identifier, 0, 9) = "PXEClient" {
           filename "$pxe";
        }
    }
EOF
		    } # end pxe 
		  } 
		  # if $nbi != "mkinitrd-net"
		  else {
            # if $pxe is not defined 
		    if( $pxe =~ /^$|^pxelinux.0$/ ) {
              print DHCPD_OUT <<EOF;
    host $label {
        hardware ethernet  $m;
        fixed-address $ip;
        filename "$nbi";
    }
EOF
            }
		    # if $pxe is not defined
		    else {
              print DHCPD_OUT <<EOF;
    host $label {
        hardware ethernet  $m;
        fixed-address $ip;
        if substring (option vendor-class-identifier, 0, 9) = "PXEClient" {
           filename "$pxe";
        }
        else if substring (option vendor-class-identifier, 0, 9) = "Etherboot" {
           filename "$nbi";
        }
   }
EOF
		    } # end pxe
          } # end mkinitrd-net
        }
        elsif( $run == 1 )
        { # range
          $ip=$_;
          if ( $range_start =~ /^$/ ) { $range_start=$ip; }
          else { $range_end=$ip; }
        }
        else {}

        # generate hosts
        print HOSTS_OUT <<EOF;
$ip $label.$domain $label
EOF

        # generate exports
        print EXPORTS_OUT <<EOF;
/var/lib/diskless/default/$ip/etc  $ip(rw,sync,async,no_root_squash)
/var/lib/diskless/default/$ip/var  $ip(rw,sync,async,no_root_squash)
/var/lib/diskless/default/$ip/root $ip(rw,sync,async,no_root_squash)

EOF
        # generate netgroup
        print NETGROUP_OUT " ($label,,)";

        # generate openmosix.map
	    print OPENMOSIXMAP_OUT <<EOF;
$openmosixId	$ip	1
EOF
        $openmosixId=$openmosixId+1;

        # generate drbl_deploy.sh
        if( length($first_diskless_host) == 0 ) {
          print DISKLESS_OUT <<EOF;
echo "create diskless host: $label $ip"
if [ -e /var/lib/diskless/default/$ip ]; then 
  rm -rf /var/lib/diskless/default/$ip
fi
diskless-newhost /var/lib/diskless/default/root $ip host=$label mailname=$label >& /dev/null
# Blake, 2004/03/09, for mozilla 
cp -r /var/lib/diskless/default/root/var/lib/mozilla/* /var/lib/diskless/default/$ip/var/lib/mozilla
mkdir /var/lib/diskless/default/$ip/root
cp /var/lib/diskless/default/root/.profile /var/lib/diskless/default/$ip/root
cp /var/lib/diskless/default/root/.bashrc /var/lib/diskless/default/$ip/root
EOF
          $first_diskless_host=$ip;
        } else {
          print DISKLESS_OUT <<EOF;
echo "create diskless host: $label $ip"
if [ -e /var/lib/diskless/default/$ip ]; then 
  rm -rf /var/lib/diskless/default/$ip
fi
cp -a /var/lib/diskless/default/$first_diskless_host /var/lib/diskless/default/$ip
rm -f /tftpboot/$ip
ln -s /var/lib/diskless/default/root /tftpboot/$ip
EOF
        }
        $nameserver_=$nameserver;
        $nameserver_=~s/,/ /g;
        print DISKLESS_OUT <<EOF;
cat <<-FSTAB > /var/lib/diskless/default/$ip/etc/fstab
none	/proc	proc	defaults	1	0
$bootserver:/var/lib/diskless/default/root		/		nfs	ro,defaults,nolock	0 1
$bootserver:/var/lib/diskless/default/$ip/var	/var	nfs	defaults,nolock 0 1
$bootserver:/var/lib/diskless/default/$ip/root	/root	nfs	defaults,nolock 0 2
$bootserver:/var/lib/diskless/default/root/var/lib/dpkg	/var/lib/dpkg	nfs	ro,defaults,nolock	0 1
$bootserver:/opt		/opt	nfs defaults,nolock 0 1
$nfsserver:/home	/home	nfs defaults,nolock 0 2
$nfsserver:/var/mail	/var/mail	nfs	defaults,nolock 0 1
tmpfs	/tmp	tmpfs	defaults	0	0
#/dev/nbd0	/tmp	ext2	defaults	0	0
FSTAB

cat <<-HOSTNAME > /var/lib/diskless/default/$ip/etc/hostname
$label
HOSTNAME

cat <<-NETWORKS > /var/lib/diskless/default/$ip/etc/networks
localnet $network
NETWORKS

cat <<-YPCONF > /var/lib/diskless/default/$ip/etc/yp.conf
domain $nisdomain server $nisserver
YPCONF

cat <<-NTPDATE > /var/lib/diskless/default/$ip/etc/default/ntp-servers
NTPSERVERS="$ntpserver"
NTPDATE

if [ -e /var/lib/diskless/default/$ip/etc/passwd ]; then
  NIS_PWD=`cat /var/lib/diskless/default/$ip/etc/passwd | grep "+::::::"`
  if [ "\$NIS_PWD" = "" -o "\$NIS_PWD" != "+::::::" ]; then
    echo "+::::::" >> /var/lib/diskless/default/$ip/etc/passwd
  fi
fi

if [ -e /var/lib/diskless/default/$ip/etc/group ]; then
  NIS_GRP=`cat /var/lib/diskless/default/$ip/etc/group | grep "+:::"`
  if [ "\$NIS_GRP" = "" -o "\$NIS_GRP" != "+:::" ]; then
    echo "+:::" >> /var/lib/diskless/default/$ip/etc/group
  fi
fi

if [ -e /var/lib/diskless/default/$ip/etc/shadow ]; then
  NIS_SHADOW=`cat /var/lib/diskless/default/$ip/etc/shadow | grep "+::::::::"`
  if [ "\$NIS_SHADOW" = "" -o "\$NIS_SHADOW" != "+::::::::" ]; then
    echo "+::::::::" >> /var/lib/diskless/default/$ip/etc/shadow
  fi
fi

rm -f /var/lib/diskless/default/$ip/etc/resolv.conf
for nameserver in $nameserver_
do 
  echo "nameserver \$nameserver" >> /var/lib/diskless/default/$ip/etc/resolv.conf
done
EOF
        # next one
        $i++;
      } # end of while(<MAC_IN>)

      if ( $run == 1 ) {
        if( $nbi =~ /^mkinitrd-net$/ ) {
          # if $pxe = ""
          if( $pxe =~ /^$|^pxelinux.0$/ ) {
            print DHCPD_OUT <<EOF;
    range $range_start $range_end;

EOF
          }
          # if $pxe != ""
          else {
            print DHCPD_OUT <<EOF;
    range $range_start $range_end;
    if substring (option vendor-class-identifier, 0, 9) = "PXEClient" {
        filename "$pxe";
    }

EOF
          }
        } else {
          if( $pxe =~ /^$|^pxelinux.0$/ ) {

            print DHCPD_OUT <<EOF;
    range $range_start $range_end;
    filename "$nbi";

EOF
          }
          # if $pxe != ""
          else {
            print DHCPD_OUT <<EOF;
    range $range_start $range_end;
    if substring (option vendor-class-identifier, 0, 9) = "PXEClient" {
       filename "$pxe";
    }
    else if substring (option vendor-class-identifier, 0, 9) = "Etherboot" {
       filename "$nbi";
    }

EOF
          }
        }
      }

      $run = $run - 2;
      close(MAC_IN);

    } # end of while($run!=0)

    print DHCPD_OUT <<EOF;
}

EOF

##    # generate dhcpd.conf 
##    if( length($mac)!=0 ) 
##    { # mac - just close it 
##      print DHCPD_OUT <<EOF;
##}
##
##EOF
##    } 
##    elsif( length($range)!=0 )
##    { # range - generate range & filename
##      my($rs,$re)=split(/-/,$range,2);
##	  if( $nbi =~ /^mkinitrd-net$/ ) {
##        # if $pxe = ""
##	    if( $pxe =~ /^$/ ) {
##          print DHCPD_OUT <<EOF;
##    range $networkIp[0].$networkIp[1].$networkIp[2].$rs $networkIp[0].$networkIp[1].$networkIp[2].$re;
##}
##
##EOF
##        }
##		# if $pxe != ""
##		else {
##	     print DHCPD_OUT <<EOF;
##    range $networkIp[0].$networkIp[1].$networkIp[2].$rs $networkIp[0].$networkIp[1].$networkIp[2].$re;
##    if substring (option vendor-class-identifier, 0, 9) = "PXEClient" {
##        filename "$pxe";
##    }
##}
##
##EOF
##		}
##      }
##	  else {
##	    if( $pxe =~ /^$/ ) {
##
##          print DHCPD_OUT <<EOF;
##    range $networkIp[0].$networkIp[1].$networkIp[2].$rs $networkIp[0].$networkIp[1].$networkIp[2].$re;
##    filename "$nbi";
##}
##
##EOF
##        }
##		# if $pxe != ""
##		else {
##          print DHCPD_OUT <<EOF;
##    range $networkIp[0].$networkIp[1].$networkIp[2].$rs $networkIp[0].$networkIp[1].$networkIp[2].$re;
##    if substring (option vendor-class-identifier, 0, 9) = "PXEClient" {
##       filename "$pxe";
##    }
##    else if substring (option vendor-class-identifier, 0, 9) = "Etherboot" {
##       filename "$nbi";
##    }
##
##}
##
##EOF
##        }
##	  }
##    }
##    else {}
##    close(MAC_IN);

  } # end of foreach

  # generate drbl_deploy.sh
  print DISKLESS_OUT <<EOF;
if [ "\$NO_DRBLMGRD" = "false" ]; then
  NETDEVICES="\$(cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}')"
  for DEVICE in \$NETDEVICES
  do
    ip=\$(/sbin/ifconfig \$DEVICE | grep "inet addr" | cut -d":" -f2 | cut -d" " -f1)
    rm -rf /var/lib/diskless/default/\$ip
    rm -f /tftpboot/\$ip
    diskless-newhost /var/lib/diskless/default/root \$ip host=tmphost mailname=tmphost
  done
fi
EOF

  print DISKLESS_OUT <<EOF;
echo "restart dhcpd"
/etc/init.d/dhcp3-server restart
#Blake, 2004/02/14, nfs-kernel-server
#echo "reload nfs-user-server"
#/etc/init.d/nfs-user-server reload
echo "reload nfs-kernel-server"
/etc/init.d/nfs-kernel-server reload 2> /dev/null
echo "restart inetd"
/etc/init.d/inetd restart

echo "-----------NCHC OPENSOURCE TASKFORCE---------------"
echo "Thank you for choosing DRBL Debian Solution."
echo "If you have question, please feel free to email to"
echo "ostf\@opensource.nchc.org.tw or c00hkl00\@nchc.org.tw"
echo "----------------Thank You--------------------------"
exit 0
EOF

  print DHCPDITF_OUT "\"";
  print NETGROUP_OUT "\n";

  close(DHCPD_OUT);
  close(DHCPITF_OUT);
  close(HOSTS_OUT);
  close(DISKLESS_OUT);
  close(EXPORTS_OUT);
  close(NETGROUP_OUT);
  close(OPENMOSIXMAP_OUT);
}


#########################################
if(@ARGV<1) {
  print "Usage: drbl.pl config_file\n";
  exit;
}

main($ARGV[0]);
system("chmod 755 drbl_deploy.sh");

if(@ARGV<2) {
  print "--------NCHC OPENSOURCE TASKFORCE--------------------\n";
  print "Thanks for choosing DRBL Debian Solution             \n";
  print "next step: ./drbl_deploy.sh\n";
  print "---------------Thank You-----------------------------\n";
}
#########################################
