#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description:
#  

TMP=`mktemp -d /tmp/collect-mac.XXXXXX`

# stop inetd, dhcp
/etc/init.d/inetd stop
/etc/init.d/dhcp3-server stop

## function: status
status() {
  rm -f $TMP/setup-drbl-auto.all
  for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
  do
    if [ "$eth" != "$outeth" ]; then
      cat $TMP/setup-drbl-auto.$eth >> $TMP/setup-drbl-auto.all
    fi
  done
  num=$(perl -ane 'print "\U$F[0]\n"' $TMP/setup-drbl-auto.all | sort | uniq | wc | awk '{print $1}')
  echo "======================================="
  perl -ane 'print "\U$F[0]\n"' $TMP/setup-drbl-auto.all | sort | uniq
  echo "Total: $num"
  echo "======================================="
}

## function: stop
stop() {
  PIDTMP=`mktemp /tmp/pid.XXXXXX`
  /bin/ps -e | grep 'tcpdump' | sed -e 's/^ *//' -e 's/ .*//' > $TMP
  while read pid
  do
    #echo "kill -9 $pid"
    kill -9 $pid
  done < $PIDTMP
  rm -f $PIDTMP
}

## main
outeth=$(/sbin/route -n | grep -e "^0.0.0.0" | awk '{ print $8; }')
echo -n "Detect MAC address on all NICs (include outgoing NIC) [y|N]? "
read ANS
if [ "$ANS" = "Y" -o "$ANS" = "y" ]; then outeth=""; fi

for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then
    #/usr/sbin/tcpdump -qte -i $eth > $TMP/setup-drbl-auto.$eth 2> /dev/null &
    /usr/sbin/tcpdump -tel -i $eth broadcast and port bootpc > $TMP/setup-drbl-auto.$eth 2> /dev/null &
  fi
done

##
echo "Start detecting MAC address...."
echo "1. View the status of MAC address detection"
echo "2. Stop MAC address detection and Start DRBL configuration"
while read CMD
do
  if [ "$CMD" = "2" ]; then
    stop
    break
  elif [ "$CMD" = "1" -o "$CMD" = "" ]; then
    status
    echo "1. View the status of MAC address detection"
    echo "2. Stop MAC address detection and Start DRBL configuration"
  fi
done

## analyze the mac address 
for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then
    perl -ane 'print "\U$F[0]\n"' $TMP/setup-drbl-auto.$eth | sort | uniq > $TMP/macadr-auto-$eth
  fi
done

ethmatch=""
for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" -a -f $TMP/macadr-auto-$eth ]; then

     for ethx in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`    
     do
       if [ "$ethx" = "$eth" ]; then
         ethmatch="$eth=$eth $ethmatch"
       elif [ "$ethx" != "$outeth" -a -f $TMP/macadr-auto-$ethx ]; then
         #echo "diff $TMP/macadr-auto-$eth $TMP/macadr-auto-$ethx"
         #read ANS
         if [ "$(diff $TMP/macadr-auto-$eth $TMP/macadr-auto-$ethx)" = "" ]; then
           rm -f $TMP/macadr-auto-$ethx
           ethmatch="$eth=$ethx $ethmatch"  
         fi
       fi
     done
     
  fi
done

for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" -a ! -f $TMP/macadr-$eth.txt ]; then
    touch $TMP/macadr-$eth.txt
  fi
done

for ethmac in `ls $TMP/macadr-auto-*`
do
  eth=${ethmac/$TMP\/macadr-auto-/}
  run=1
  macadr=""
  while [ $run -eq 1 ]
  do
    for match in `echo $ethmatch`
    do
      # make sure macadr is not ""
      if [ "$macadr" = "" ]; then 
        if ! read macadr ; then
          run=0
          break
        fi 
      fi

      # assign macadr
      if [ "$(echo "$match" | grep -e "^$eth=")" != "" ]; then
        ethx=${match/$eth=/} 
        echo "$macadr" >> $TMP/macadr-$ethx.txt
        if ! read macadr ; then
          run=0
          break
        fi
      fi 
    done
  done < $ethmac
done

rm -f $TMP/macadr-auto-*

## sketch diagram
echo "The sketch diagram of DRBL configuration"
echo "      +---------------+"
echo "      |  DRBL Server  |"
if [ "$outeth" != "" ]; then
  echo "      |               +-- OUT ($outeth)"
fi
for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
do
  if [ "$eth" != "$outeth" ]; then
    numclients=`wc -l $TMP/macadr-$eth.txt| awk '{ print $1 }'` 
    echo "      |               |"
    echo "      |               +-- DRBL Client ($eth): $numclients"
  fi
done
echo "      |               |"
echo "      +---------------+"
echo

print_choice() {
  for eth in `cat /proc/net/dev | awk -F: '/eth.:|tr.:/{print $1}'`
  do
    if [ "$eth" != "$outeth" ]; then
      echo "$eth: view the MAC address of DRBL clients through $eth"
    fi
  done 
  echo "S(s): Save"
  echo "Q(q): Quit"
  echo -n "Enter your choice [S]: "
}

print_choice
while read ANS
do
  if [ "$ANS" = "Q" -o "$ANS" = "q" ]; then
    rm -rf $TMP
    # start inetd, dhcpd
    /etc/init.d/inetd start
    /etc/init.d/dhcp3-server start
    exit
  elif [ "$ANS" = "S" -o "$ANS" = "s" -o "$ANS" = "" ]; then
    break
  else 
    if [ -f $TMP/macadr-$ANS.txt ]; then
      echo "========== $ANS =========="
      cat $TMP/macadr-$ANS.txt
      echo "=========================="
    else 
      echo "No such choice.."
    fi
    print_choice
  fi
done

## save the files
finished=0
while [ $finished -ne 1 ]; do
  echo -n "The directory to save these files [$HOME]:"
  read SAVEDIR
  if [ "$SAVEDIR" = "" ]; then SAVEDIR="$HOME"; fi
  mkdir -p $SAVEDIR
  if [ -d $SAVEDIR ]; then
    cp $TMP/macadr-*.txt $SAVEDIR
    rm -rf $TMP
    finished=1
  else
    echo "Cannot create the directory '$SAVEDIR'.."
  fi
done
