#!/bin/sh
# Written by K. L. Huang, Blake <c00hkl00@nchc.org.tw>. 
# Modified by Steven Shiau <steven@nchc.org.tw> to use in DRBL for RedHat

# Blake, 2003/11/19, modified from Steven's version to fit DRBL for Debian

#Setting
PXELINUX_DIR="/tftpboot/pxelinux.cfg"
DHCPDCONF_DIR="/etc/dhcp3"
drblroot="/var/lib/diskless/default/"
ocsroot="/home/partimag"

# function : stop_ocs
stop_ocs_if_necessary() {
  if [ -e $ocsroot/ocsmgrd ]; then
    /opt/drbl/sbin/drbl-ocs stop
  fi
}
# function : stop thin_client_if_necessary
stop_thinclient_if_necessary() {
  ## check if it is thin-client mode now ..
  export FORCE_YES=1; /opt/drbl/sbin/drbl-thinclient stop
}
# function: stop drbl-hdinstall
stop_hdinstall_if_necessary() {
  /opt/drbl/sbin/drbl-hdinstall stop
}

# function : set_localboot, set_remoteboot
# these funcations are used in the modified version of etherboot shipped with DRBL for Debian 
# to control local boot/remote boot.
set_localboot() {

  # configure file in $PXELINUX_DIR
  for host in `ls $drblroot`
  do
     if [ "$host" != "." -a "$host" != ".." -a "$host" != "root" ]; then
       PXECFG=$(/usr/bin/gethostip $host | cut -d" " -f3)
       cat <<-EOF > $PXELINUX_DIR/$PXECFG
default local

label local
  localboot 0
EOF
     fi
  done

  # dhcpd.conf.client-switch.include
  cat <<-EOF > $DHCPDCONF_DIR/dhcpd.conf.client-switch.include
if substring ( option vendor-class-identifier, 0, 9 ) = "Etherboot" {
}
EOF
  /etc/init.d/dhcp3-server restart
}

## Note: 
## this function not only control the localboot for the modified version etherboot 
## but also stop clonezilla
set_remoteboot() {

  BOOTMODE=$1
  FILENAME=""

  # MODE -> FILENAME
  case "$BOOTMODE" in
    "drbl")
      FILENAME=""
      ;;
    "fdos")
      FILENAME="filename \"boot-fdos.nbi\";"
      ;;
    "memtest")
      FILENAME="filename \"boot-memtest86.nbi\";"
      ;;
    "woody_netinst")
      FILENAME="filename \"boot-woody_netinst.nbi\";"
      ;;
  esac

  # configuration file in PXELINUX_DIR
  for host in `ls $drblroot`
  do
     if [ "$host" != "." -a "$host" != ".." -a "$host" != "root" ]; then
       PXECFG=$(/usr/bin/gethostip $host | cut -d" " -f3)
       rm -f $PXELINUX_DIR/$PXECFG
     fi
  done

  # dhcpd.conf.client-switch.include
  if [ "$FILENAME" != "" ]; then
    cat <<-EOF > $DHCPDCONF_DIR/dhcpd.conf.client-switch.include
if substring ( option vendor-class-identifier, 0, 9 ) = "Etherboot" {
  $FILENAME
}
EOF
    /etc/init.d/dhcp3-server restart
  fi
}

#main script
MODE="$1"

# Check if root or not
if [ ! "$UID" = "0" ]; then
  echo
  echo "[$LOGNAME] You need to run this script \"$0\" as root."
  echo
  exit 1
fi

# Get the mode from use
if [ -z "$MODE" ]; then 
     DIA="/usr/bin/dialog"
     TMP=$(mktemp /tmp/menu.XXXXXX)
     $DIA \
     --backtitle "NCHC - National Center for High-Performance Computing" \
     --title "NCHC OpenSource TaskForce Solution" \
     --radiolist "Switch the mode for client:" 24 80 17 \
     "remote-linux-graphic" "Remote Boot Linux, enter graphic mode" off \
     "remote-linux-graphic-autologin" "Remote Boot Linux, enter auto-login graphic mode" off \
	 "remote-linux-thin" "Remote Boot Linux, enter thin client mode" off \
     "remote-linux-text" "Remote Boot Linux, enter text mode" off \
     "remote-linux-www" "Remote Boot Linux, enter WWW applicant mode" off \
     "remote-memtest" "Remote Boot to run memtest86" off \
     "remote-fdos" "Remote Boot to run FreeDOS" off \
     "clonezilla-save-disk" "CloneZilla Save Disk mode" off \
     "clonezilla-restore-disk" "CloneZilla Restore Disk mode" off \
     "clonezilla-save-hda1" "CloneZilla Save 1st Partition mode" off \
     "clonezilla-restore-hda1" "CloneZilla Restore 1st Partition mode" off \
     "local" "Local boot" off \
     "woody-netinstall" "Debian Linux (woody) install via network" off \
     "drbl-hdinstall" "DRBL Client installation" off \
     "reboot" "Reboot all clients" off \
     "shutdown" "Shutdown all clients" off \
     "wake-on-lan" "Wakeup all clients (WOL)" off 2> $TMP
     MODE=$(cat $TMP)
     rm -f $TMP
fi

# stop_ocs and stop_thinclient
if [ "$MODE" != "" ]; then
  stop_ocs_if_necessary
  stop_thinclient_if_necessary
  stop_hdinstall_if_necessary
fi

# set the mode for PXE client
# Todo: set the mode for etherboot client
case "$MODE" in
  "remote-linux-graphic")
     echo "Settinig client as remote-linux graphic mode..."
	 set_remoteboot drbl
	 /usr/bin/perl -p -i -e "s/^default.*/default drbl/" $PXELINUX_DIR/default

     for host in `ls $drblroot`
     do
       echo "Setting the graphic mode for node IP = $host"
       if [ "$host" != "." -a "$host" != ".." ]; then
         ln -fs ../init.d/xfs $drblroot/$host/etc/rc2.d/S20xfs
         ln -fs ../init.d/setupx  $drblroot/$host/etc/rc2.d/S98setupx
         ln -fs ../init.d/xdm  $drblroot/$host/etc/rc2.d/S99xdm
         ln -fs ../init.d/kdm  $drblroot/$host/etc/rc2.d/S99kdm 
       fi
     done
     echo "done!"
     ;;
  "remote-linux-graphic-autologin")
     echo "Setting clients as remote-linux auto-login graphic mode..."
     set_remoteboot drbl
     /usr/bin/perl -p -i -e "s/^default.*/default drbl/" $PXELINUX_DIR/default
     export FORCE_YES=1; /opt/drbl/sbin/drbl-autologin start
     echo "done!"
     ;;
  "remote-linux-thin")
     echo "Setting clients as remote-linux thin client mode..."
     set_remoteboot drbl
     /usr/bin/perl -p -i -e "s/^default.*/default drbl/" $PXELINUX_DIR/default
     for host in `ls $drblroot`
     do
       echo "Setting the graphic mode for node IP = $host"
       if [ "$host" != "." -a "$host" != ".." ]; then
         ln -fs ../init.d/xfs $drblroot/$host/etc/rc2.d/S20xfs
         ln -fs ../init.d/setupx  $drblroot/$host/etc/rc2.d/S98setupx
         ln -fs ../init.d/xdm  $drblroot/$host/etc/rc2.d/S99xdm
         ln -fs ../init.d/kdm  $drblroot/$host/etc/rc2.d/S99kdm 
       fi
     done
     export FORCE_YES=1; /opt/drbl/sbin/drbl-thinclient start
     echo "done!"
     ;;
  "remote-linux-www")
     echo "Setting clients as remote-linux www applicant mode..."
     set_remoteboot drbl
     /usr/bin/perl -p -i -e "s/^default.*/default drbl/" $PXELINUX_DIR/default
     for host in `ls $drblroot`
     do
       echo "Setting the graphic mode for node IP = $host"
       if [ "$host" != "." -a "$host" != ".." ]; then
         ln -fs ../init.d/xfs $drblroot/$host/etc/rc2.d/S20xfs
         ln -fs ../init.d/setupx  $drblroot/$host/etc/rc2.d/S98setupx
         ln -fs ../init.d/xdm  $drblroot/$host/etc/rc2.d/S99xdm
         ln -fs ../init.d/kdm  $drblroot/$host/etc/rc2.d/S99kdm 
       fi
     done
     DIA="/usr/bin/dialog"
     TMP=$(mktemp /tmp/url.XXXXXX)
     $DIA \
       --backtitle "NCHC - National Center for High-Performance Computing" \
       --title "NCHC OpenSource TaskForce Solution" \
       --inputbox "Please enter the default URL" 12 60 "http://drbl.nchc.org.tw" 2> $TMP
     url=$(cat $TMP)
     rm -f $TMP
     export FORCE_YES=1; /opt/drbl/sbin/drbl-thinclient start www $url
     echo "done!"    
     ;;
  "remote-linux-text") 
     echo "Settinig client as remote-linux text mode..."
     set_remoteboot drbl
	 /usr/bin/perl -p -i -e "s/^default.*/default drbl/" $PXELINUX_DIR/default

     for host in `ls $drblroot`
     do
       echo "Setting the text mode for node IP = $host"
       if [ "$host" != "." -a "$host" != ".." ]; then
         rm -f $drblroot/$host/etc/rc2.d/S20xfs
         rm -f $drblroot/$host/etc/rc2.d/S98setupx
         rm -f $drblroot/$host/etc/rc2.d/S99xdm
         rm -f $drblroot/$host/etc/rc2.d/S99kdm 
       fi
     done
	 echo "done!"
     ;;
  "remote-memtest")
     echo -n "Setting client as remote-memtest mode..."
     set_remoteboot memtest 
	 /usr/bin/perl -p -i -e "s/^default.*/default memtest/" $PXELINUX_DIR/default
	 echo "done!"
	 ;;
  "remote-fdos")
     echo -n "Setting client as remote-fdos mode..."
     set_remoteboot fdos
	 /usr/bin/perl -p -i -e "s/^default.*/default fdos/" $PXELINUX_DIR/default
	 echo "done!"
	 ;;
  "clonezilla-save-disk")
     echo -n "Setting client as clonezilla-save-disk mode..."
	 set_remoteboot drbl
	 /usr/bin/perl -p -i -e "s/^default.*/default drbl/" $PXELINUX_DIR/default
     /opt/drbl/sbin/drbl-ocs startdisk save
     echo "done!"
     ;;
  "clonezilla-restore-disk")
     echo -n "Setting client as clonezilla-restore-disk mode..."
	 set_remoteboot drbl
	 /usr/bin/perl -p -i -e "s/^default.*/default drbl/" $PXELINUX_DIR/default
     # Blake, 2004/01/29, unicast, multicast or unicast + multicast
     DIA="/usr/bin/dialog"
     TMP=$(mktemp /tmp/menu.XXXXXX)
     $DIA \
     --backtitle "NCHC - National Center for High-Performance Computing" \
     --title "NCHC OpenSource TaskForce Solution" \
     --radiolist "Choose the mode for restore" 12 80 4 \
     "unicast" "unicast restore" off \
     "multicast" "multicast restore" off \
     "multicast+unicast" "multicast+unicast restore" on \
     "isoimage" "create iso image to restore by CDROM" off 2> $TMP
     RESTORE_MODE=$(cat $TMP) 
     rm -f $TMP
     if [ "$RESTORE_MODE" = "multicast" ]; then
       /opt/drbl/sbin/drbl-ocs --ocsmgrd_option "--nocheck" startdisk multicast_restore
     elif [ "$RESTORE_MODE" = "unicast" ]; then
       /opt/drbl/sbin/drbl-ocs startdisk restore
     elif [ "$RESTORE_MODE" = "isoimage" ]; then
       /opt/drbl/sbin/drbl-ocs startdisk isoimage_restore
     else
       /opt/drbl/sbin/drbl-ocs startdisk multicast_restore
     fi
     echo "done!"
     ;;
  "clonezilla-save-hda1")
     echo -n "Setting client as clonezilla-save-hda1 mode..."
     set_remoteboot drbl
     /usr/bin/perl -p -i -e "s/^default.*/default drbl/" $PXELINUX_DIR/default
     /opt/drbl/sbin/drbl-ocs start save
     echo "done!"
     ;;
  "clonezilla-restore-hda1")
     echo -n "Setting client as clonezilla-restore-hda1 mode..."
     set_remoteboot drbl
     /usr/bin/perl -p -i -e "s/^default.*/default drbl/" $PXELINUX_DIR/default

     DIA="/usr/bin/dialog"
     TMP=$(mktemp /tmp/menu.XXXXXX)
     $DIA \
     --backtitle "NCHC - National Center for High-Performance Computing" \
     --title "NCHC OpenSource TaskForce Solution" \
     --radiolist "Choose the mode for restore" 12 80 4 \
     "unicast" "unicast restore" off \
     "multicast" "multicast restore" off \
     "multicast+unicasst" "multicas+unicast restore" on \
     "isoimage" "create iso image to restore by CDROM" off 2> $TMP
     RESTORE_MODE=$(cat $TMP) 
     rm -f $TMP
     if [ "$RESTORE_MODE" = "multicast" ]; then
       /opt/drbl/sbin/drbl-ocs --ocsmgrd_option "--nocheck" start multicast_restore
     elif [ "$RESTORE_MODE" = "unicast" ]; then
       /opt/drbl/sbin/drbl-ocs start restore
     elif [ "$RESTORE_MODE" = "isoimage" ]; then
       /opt/drbl/sbin/drbl-ocs start isoimage_restore
     else
       /opt/drbl/sbin/drbl-ocs start multicast_restore
     fi
     echo "done!"
     ;;
  "local")
     echo -n "Setting client as local mode..."
     set_localboot
	 /usr/bin/perl -p -i -e "s/^default.*/default local/" $PXELINUX_DIR/default
	 echo "done!"
	 ;;
  "woody-netinstall")
     echo -n "Setting client as woody-netinstall mode..."
     set_remoteboot woody_netinst
     /usr/bin/perl -p -i -e "s/^default.*/default woody_netinst/" $PXELINUX_DIR/default
     echo "done!"
     ;;
  "drbl-hdinstall")
     echo -n "Setting client as drbl-hdinstall mode..."
     set_remoteboot drbl
     /usr/bin/perl -p -i -e "s/^default.*/default drbl/" $PXELINUX_DIR/default
     /opt/drbl/sbin/drbl-hdinstall start
     echo "done!"
     ;;
  "reboot")
     echo -n "Reboot all clienst now..."
     /opt/drbl/bin/drbl-doit -u root -b /sbin/reboot
     /opt/drbl/bin/drbl-doit -u administrator -b /usr/bin/shutdown -f -r now
     echo "done!"
     ;;
  "shutdown")
     echo -n "Shutdown all clients now..."
     /opt/drbl/bin/drbl-doit -u root -b /sbin/poweroff
     /opt/drbl/bin/drbl-doit -u administrator -b /usr/bin/shutdown -f -s now
     echo "done!"
     ;;
  "wake-on-lan")
     echo -n "Turn on all clients by Wake-on-LAN now..."
     /opt/drbl/bin/drbl-doit --wol
     echo "done!" 
     ;;
  *)
     echo "Usage: $0 [remote-linux|remote-linux-graphics|remote-linux-text|remote-memtest|remote-fdos|woody-netinstall|drbl-hdinstall|local|reboot|shutdown|wake-on-lan]"
     echo "remote-linux-graphic: Client machine will boot from DRBL server, and enter graphic mode"
     echo "remote-linux-text: Client machine will boot from DRBL server, and enter text mode"
     echo "remote-memtest: Remote Boot to run memtest86"
     echo "remote-fdos: Remote Boot to run FreeDOS"
     echo "clonezilla-save-disk: CloneZilla Save Disk mode"
     echo "clonezilla-restore-disk: CloneZilla Restore Disk mode"
     echo "clonezilla-save-hda1: CloneZilla Save 1st Partition (hda1) mode"
     echo "clonezilla-restore-hda1: CloneZilla Restore 1st Partition (hda1) mode"
     echo "local:  Client machine will boot from local"
     echo "woody-netinstall: Debian Linux (woody) install via network"
     echo "drbl-hdinstall: DRBL Client installation"
     echo "reboot: Reboot all clients"
     echo "shutdown: Shutdown all clients"
     echo "wake-on-lan: Wake all clients (WOL)"
     echo "If no argument is specified, a dialog will appear to let you choose the mode!"
	 ;;
esac
