/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2124 $
|                     $Date: 2009-02-26 23:50:30 +0100 (jeu, 26 fév 2009) $
\*============================================================================*/

/*******************************************************************************
*            Streaming Persistence default routing implementation              *
*******************************************************************************/

#include "dc/dc_Error.h"

#include "dcXTOOL_Sun.h"
#include "dcCOMN_Tools.h"

extern sun_impl_t sun_dcpl_impl;

void * sun_write_init(void * implementation, const char * sun_id, unsigned long * len)
{
	sun_impl_t * p_impl;

	p_impl = implementation ? (sun_impl_t *)implementation : &sun_dcpl_impl;
	return p_impl->write_init(p_impl, sun_id, len);
}

void * sun_read_init(void * implementation, const char * sun_id)
{
	sun_impl_t * p_impl;

	DC_CHECK_PARAM_RETURN(sun_id, NULL);

	p_impl = implementation ? (sun_impl_t *)implementation : &sun_dcpl_impl;
	return p_impl->read_init(p_impl, sun_id);
}

int sun_stream_read(void * in_stream, char * buf, unsigned long * size)
{
	DC_CHECK_PARAM(in_stream && buf && size);

	return ((sun_ctx_t *)in_stream)->impl->read(in_stream, buf, size);
}

int sun_stream_write(void * out_stream, const char * buf, unsigned long * size)
{
	DC_CHECK_PARAM(out_stream && buf && size);

	return ((sun_ctx_t *)out_stream)->impl->write(out_stream, buf, size);
}

int sun_get_error(void * stream)
{
	DC_CHECK_PARAM(stream);

	return ((sun_ctx_t *)stream)->impl->error(stream);
}

int sun_close(void * stream)
{
	DC_CHECK_PARAM(stream);
	return ((sun_ctx_t *)stream)->impl->close(stream);
}

