/*============================================================================*\
|                                                                              |
|         SOA4D Devices Profile for Web Services C Toolkit (DPWSCore)          |
|                                                                              |
|               ->> Copyright 2007 Schneider Electric SA <<-                   |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 827 $
|                     $Date: 2008-03-13 16:34:05 +0100 (jeu, 13 mar 2008) $
\*============================================================================*/
/*******************************************************************************
*            Streaming Persistence default routing implementation              *
*******************************************************************************/
#ifndef _SUN_H_
#define _SUN_H_

#include "dc/dc_Sun.h"

typedef struct sun_impl {
	void * (*write_init)(void * implementation, const char * sun_id, unsigned long * len);
	void * (*read_init)(void *, const char *);
	int (*read)(void *, char *, unsigned long *);
	int (*write)(void *, const char *, unsigned long *);
	int (*error)(void *);
	int (*close)(void *);
} sun_impl_t;

// Note all implementation context structs should start with the same impl field.
typedef struct sun_ctx {
	sun_impl_t * impl;
} sun_ctx_t;
	
#endif /*_SUN_H_*/
