/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2007-2009 Odonata www.odonata.fr <<-                |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/
/******************************************************************************\
 *                  Very limited schema Guided XML Parsing                    *
\******************************************************************************/
#ifndef SGXP_H_
#define SGXP_H_

#include "dc/dc_Types.h"
#include "dc/dc_Epx.h"

/*----------------------------------------------------------------------------*\
 *                              Type definitions                              *
\*----------------------------------------------------------------------------*/
#define SGXP_ERR_TAG_MISMATCH			101
#define SGXP_ERR_EVENT_MISMATCH			102
#define SGXP_ERR_MG_MISMATCH			103
#define SGXP_ERR_MISSING_PARTICLE		104
#define SGXP_ERR_TOO_MANY_OCCURENCES	105
#define SGXP_ERR_UNEXPECTED_PARTICLE	106
#define SGXP_ERR_MISSING_EXPECTED_ELT	107
#define SGXP_ERR_MISSING_REQUIRED_ATT	108
#define SGXP_ERR_INVALID_VALUE			109
#define SGXP_ERR_INVALID_ENUM			110
#define SGXP_ERR_UNSUPPORTED_VALUE		111		// recognized but not supported

#define WILDCARD_NS_URI		NULL
#define WILDCARD_LNAME		NULL

#define XS_OCC_UNBOUNDED	-1

#ifndef DC_RT_FMAC1	/* runtime functions declaration prefix */
# define DC_RT_FMAC1
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
	XS_MG_SEQUENCE = 0, /* No parsing running */
	XS_MG_CHOICE = 1
} xs_model_group;

/** When entering the current event will be the start element, it should be the end element when exiting */
typedef int (*value_cbk)(void * psr_ctx, char * ns_uri, char * lname, void * user_data);

struct elt_step {
	char * ns_uri;
	char * lname;
	unsigned int min_occurs;
	unsigned int max_occurs;
	xs_model_group mg;	// in fact very limited: mg means elts are in a mono occurence mg with siblings with the same mg
	int mg_nb;
	value_cbk cbk;
	void * user_data;
	DC_BOOL simple_content;	// if DC_TRUE, characters and end_element are consumed by the caller
};

typedef enum {
	XS_ATT_OPTIONAL = 0,
	XS_ATT_REQUIRED = 1
} xs_att_occurrence;

struct att_step {
	char * ns_uri;
	char * lname;
	xs_att_occurrence use;
	value_cbk cbk;
	void * user_data;
};

#define SGXP_NB_ATT_STEPS(t) (sizeof(t)/sizeof(struct att_step))
#define SGXP_NB_ELT_STEPS(t) (sizeof(t)/sizeof(struct elt_step))

typedef int (*sgxp_token_parser_cbk)(void * psr_ctx, char * token, void * user_data);

/*----------------------------------------------------------------------------*\
 *                                   Parsing                                  *
\*----------------------------------------------------------------------------*/

// NOTE: Prefix definition events are supposed to be turned off.

DC_RT_FMAC1 int sgxp_check_start_tag(void * psr_ctx, char * ns_uri, char * lname, DC_BOOL required);
DC_RT_FMAC1 int sgxp_parse_simple_content(void * psr_ctx, struct att_step * atts, int nb_att_steps, value_cbk value_cbk, void * user_data);
DC_RT_FMAC1 int sgxp_parse_complex_content(void * psr_ctx, struct att_step * atts, int nb_att_steps, struct elt_step * complex_type, int nb_steps);
DC_RT_FMAC1 int sgxp_parse_simple_element(void * psr_ctx, char * ns_uri, char * lname, DC_BOOL required, struct att_step * atts, int nb_att_steps, value_cbk value_cbk, void * user_data);
DC_RT_FMAC1 int sgxp_parse_complex_element(void * psr_ctx, char * ns_uri, char * lname, DC_BOOL required, struct att_step * atts, int nb_att_steps, struct elt_step * complex_type, int nb_steps);

DC_RT_FMAC1 int sgxp_parse_list(void * psr_ctx, char * list, sgxp_token_parser_cbk token_parser, void * user_data);

#ifdef __cplusplus
}
#endif

#endif /*DYNDEPL_MGR_H_*/
