/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2154 $
|                     $Date: 2009-03-05 17:38:15 +0100 (jeu, 05 mar 2009) $
\*============================================================================*/

/** \page xml XML utilities
 * The XML features are:
 * <ul>
 * <li>XML processing API currently based on the gSOAP runtime (dc_Epx.h must be included),</li>
 * <li>XML file processing (see dc_FileX.h and dc_Sun.h),</li>
 * <li>Generic invocation (dc_GenericInvocation.h must be included),</li>
 * </ul>
 */

/***************************************************************************//**
* \file
* Generic stub & skeleton.
* Allows web service invocations without code generation thanks especially to
* the EPX XML processing API.
*******************************************************************************/

#ifndef GENERIC_H_
#define GENERIC_H_

#include "dc/dc_Dpws.h"
#include "dc/dc_Epx.h"

#ifndef DC_RT_FMAC1	/* runtime functions declaration prefix */
# define DC_RT_FMAC1
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct dpws;	// forward declaration
struct wsa_endpoint_ref;	// forward declaration

/*----------------------------------------------------------------------------*\
 *                        Callback types definitions                          *
\*----------------------------------------------------------------------------*/
/** Generic serialization callback used to send messages.
 * @param serializer_context An EPX serialization context.
 * @param user_data Data that will be passed back to the callback in order for
 * the developper to retrieve its context.
 * @return DPWS_OK or an error code.
 */
typedef int (*serialize_cbk) (void * serializer_context, void * user_data);

/** Generic parsing callback used to receive messages.
 * @param parser_context An EPX parsing context.
 * @param user_data Data that will be passed back to the callback in order for
 * the developper to retrieve its context.
 * @return DPWS_OK or an error code.
 */
typedef int (*parser_cbk) (void * parser_context, void * user_data);

/** Generic service callback used to process a request.
 * @param dpws A pointer on a dpws runtime data structure.
 * @param parser_context An EPX parsing context for processing the incoming message.
 * @param[out] response_cbk The service callback should return a pointer on the
 * function responsible for sending the response. Can be ignored if the response
 * is empty or does not exist (one-way). The response callback may be called twice
 * in order to calculate the message size (for the HTTP header) and is expected to
 * produce the same output each time.
 * @param[out] p_user_data Put here the data that will be passed back to the
 * response callback in order for the developper to retrieve its context.
 * @return DPWS_OK or an error code.
 */
typedef int (*serve_cbk)(struct dpws * dpws, void * parser_context, serialize_cbk *response_cbk, void **p_user_data);

/***************************************************************************//**
* \name Generic skeleton
* Server message processing.
* @{
*******************************************************************************/

/** Generic server message processing function.
 * Calls to this API should be performed in a dispatch function (signature
 * int dispatch(struct dpws *)) based on the WS-Addressing action contained in
 * the dpws runtime structure.
 * @param dpws A pointer on a dpws runtime data structure.
 * @param resp_action The action used for the response. If NULL, the operation
 * is supposed to be one-way (no response message).
 * @param fault_action The action used for a potential SOAP fault. If NULL, the
 * default action for fault messages defined by WS-Addressing is assumed.
 * @param resp_root_pfxs struct prefix_def array of user prefix definitions to
 * be set at the root of the response message and thus usable both in the
 * headers and in the body. Nullable (set nb_pfxs to 0).
 * @param nb_pfxs Number of elements in the user prefix array.
 * @param serve_func The callback that will process the service.
 * @return DPWS_OK or an error code.
 */
DC_RT_FMAC1 int dpws_process_request(struct dpws *dpws, char * resp_action, char * fault_action, struct prefix_def * resp_root_pfxs, int nb_pfxs, serve_cbk serve_func);

// @}

/***************************************************************************//**
* \name Generic stub
* Client message processing.
* @{
*******************************************************************************/

/** Sends a generic one-way SOAP message.
 * @param dpws A pointer on a dpws runtime data structure.
 * @param to The destination endpoint reference.
 * @param action The WS-Addressing action of the request.
 * @param root_pfxs struct prefix_def array of user prefix definitions to be
 * set at the root of the request message and thus usable both in the headers
 * and in the body. Nullable (set nb_pfxs to 0).
 * @param nb_pfxs Number of elements in the user prefix array.
 * @param request_cbk The callback that will be in charge to send the message.
 * It may be called twice in order to calculate the message size (for the HTTP
 * header) and is expected to produce the same output each time.
 * @param user_data Data that will be passed back to the callback in order for
 * the developper to retrieve its context.
 * @return DPWS_OK or an error code.
 */
DC_RT_FMAC1 int dpws_send(struct dpws *dpws, struct wsa_endpoint_ref *to, char * action, struct prefix_def * root_pfxs, int nb_pfxs, serialize_cbk request_cbk, void * user_data);

/** Performs a generic request-response SOAP interaction.
 * @param dpws A pointer on a dpws runtime data structure.
 * @param to The destination endpoint reference.
 * @param action The WS-Addressing action of the request.
 * @param root_pfxs struct prefix_def array of user prefix definitions to be
 * set at the root of the request message and thus usable both in the headers
 * and in the body. Nullable (set nb_pfxs to 0).
 * @param nb_pfxs Number of elements in the user prefix array.
 * @param request_cbk The callback that will be in charge to send the request.
 * It may be called twice in order to calculate the message size (for the HTTP
 * header) and is expected to produce the same output each time.
 * @param response_cbk The callback that will be in charge to receive the response.
 * The callback is responsible to return SOAP_FAULT if the action matches a
 * user fault error or in case of root tag mismatch.
 * @param user_data Data that will be passed back to the callbacks in order for
 * the developper to retrieve its context.
 * @return DPWS_OK or an error code.
 */
DC_RT_FMAC1 int dpws_call(struct dpws *dpws, struct wsa_endpoint_ref *to, char * action, struct prefix_def * root_pfxs, int nb_pfxs, serialize_cbk request_cbk, parser_cbk response_cbk, void * user_data);

// @}

#ifdef __cplusplus
}
#endif

#endif /*GENERIC_H_*/
