/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2007-2009 Odonata www.odonata.fr <<-                |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2220 $
|                     $Date: 2009-03-25 10:28:16 +0100 (mer, 25 mar 2009) $
\*============================================================================*/

/***************************************************************************//**
* \file
* APIs for XML file processing.
* It contains functions to:
* <ul>
* <li>Prepares a SOAP runtime structure for XML file processing.</li>
* <li>Process an XML file with EPX.</li>
* </ul>
*******************************************************************************/

#ifndef FILEX_H_
#define FILEX_H_

#ifndef DC_RT_FMAC1	/* runtime functions declaration prefix */
# define DC_RT_FMAC1
#endif
#include "dc/dc_Types.h"	// includes gSOAP definitions

#ifdef __cplusplus
extern "C" {
#endif

/** Initialize and prepares the gSOAP runtime structure for writing XML into a
 * specified file using, for example, the EPX API.
 * @param soap The gSOAP runtime structure to initialize.
 * @param sun_out_stream Storage unit implementation-dependent opened output
 * stream. If NULL, output is performed on sdout.
 * @return SOAP_OK or any gSOAP error code.
 */
DC_RT_FMAC1 int xml_out_fopen(struct soap * soap, void * sun_out_stream);

/** Close the XML file opened for writing and restores a standard-initialized
 * gSOAP runtime structure.
 * @param soap The gSOAP runtime structure that references the opened file.
 * @return SOAP_OK or any gSOAP error code.
 */
DC_RT_FMAC1 int xml_out_fclose(struct soap *soap);

/** Initialize and prepares the gSOAP runtime structure for reading XML from a
 * specified file using, for example, the EPX API.
 * @param soap The gSOAP runtime structure to initialize.
 * @param sun_in_stream Storage unit implementation-dependent opened input stream.
 * @return SOAP_OK or any gSOAP error code.
 */
DC_RT_FMAC1 int xml_in_fopen(struct soap * soap, void * sun_in_stream);

/** Close the SUN XML stream opened for reading and restores a standard-initialized
 * gSOAP runtime structure.
 * @param soap The gSOAP runtime structure that references the opened file.
 * @return SOAP_OK or any gSOAP error code.
 */
DC_RT_FMAC1 int xml_in_fclose(struct soap *soap);

/**
 * Serialize the content of the parser context into the specified file or the
 * console.
 * @param pctx the parser context.
 * @param filename the destination file name. If NULL, output will be redirected
 * to the console.
 * @return SOAP_OK or any gSOAP error code.
 */
DC_RT_FMAC1 int xml_file_serialize(void * pctx, char * filename);

/**
 * Parse the content of the specified file and send it to
 * the specified serializer context.
 * @param sctx the serializer context.
 * @param filename the source file name.
 * @return SOAP_OK or any gSOAP error code.
 */
DC_RT_FMAC1 int xml_file_parse(void * sctx, char * filename);


#ifdef __cplusplus
}
#endif

#endif /*FILEX_H_*/
