/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/******************************************************************************\
 *                         Binding reference manager                          *
\******************************************************************************/
#ifndef REF_MGR_H_
#define REF_MGR_H_

#include "dc/dc_Dpws.h"
#include "dc/dc_XMLTypes.h"
#include "dcCOMN_DynArray.h"
#include "dcDPWS_Memory.h"

// typedef enum {WS_STATIC_BINDING, WS_DISCOVERY_BINDING} ws_binding_ref_t;
typedef enum {WSD_HINT_MM_ACTION_PICK_ONE, WSD_HINT_MM_ACTION_FAIL} on_multiple_matches_action_t;
typedef enum {WSD_HINT_BT_DEPLOYMENT, WSD_HINT_BT_RUNTIME} binding_time_t;
typedef enum {WSD_HINT_RL_ACTION_FAIL, WSD_HINT_RL_ACTION_RETRY, WSD_HINT_RL_ACTION_IGNORE} on_reference_lost_action_t;

struct discovery_hint {
	DA_TYPED(pqn) types;
	DA_TYPED(str) scopes;
};

DA_TYPED_DECL(dht, struct discovery_hint);

struct discovery_hints {
	on_multiple_matches_action_t on_multiple_matches;
	binding_time_t binding_time;
	on_reference_lost_action_t on_reference_lost;
	char * service_id;
	DA_TYPED(dht) hints;
};

struct reference {
	char * name;
	struct prefixed_qname type;
	epx_boolean_t must_supply;
};

struct ws_binding_ref {
	char * name;
	struct reference * sclass_ref;
// Union removed because of the room used (structs have too different sizes)
	struct wsa_endpoint_ref * epr;	// not Read-Only
	short proxy;	// not Read-Only
	struct discovery_hints * wsd_hints;
};

struct ws_bref_node {
	struct ws_bref_node * next;
	struct ws_binding_ref data;
};

/*----------------------------------------------------------------------------*\
 *                               Internal API                                 *
\*----------------------------------------------------------------------------*/
int dyndepl_discover_bref(struct dpws * dpws, struct ws_binding_ref * bref);

#endif /*REF_MGR_H_*/
