/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/******************************************************************************\
 *                         Configuration XML constants                        *
\******************************************************************************/
#ifndef XMLCONF_DEFS_H_
#define XMLCONF_DEFS_H_

#define WSA_URI "http://schemas.xmlsoap.org/ws/2004/08/addressing"
#define WDP_URI "http://schemas.xmlsoap.org/ws/2006/02/devprof"

/*----------------------------------------------------------------------------*\
 *         Dynamic deployment descriptor representation definitions           *
\*----------------------------------------------------------------------------*/

#define DYNDEPL_NS_URI	"http://www.soa4d.org/dpwscore/2007/08/dyndepl"
#define DYNDEPL_NS_PREFIX "dd"

#define DYNDEPL_ELT_DEVICE	"Device"

#define DYNDEPL_ELT_ADDRESS	"Address"
#define DYNDEPL_ELT_TYPES	"Types"
#define DYNDEPL_ELT_SCOPES	"Scopes"

#define WDP_ELT_THIS_MODEL	"ThisModel"
#define WDP_ELT_MANUFACTURER	"Manufacturer"
#define WDP_ELT_MANUFACTURER_URL	"ManufacturerUrl"
#define WDP_ELT_MODEL_NAME	"ModelName"
#define WDP_ELT_MODEL_NUMBER	"ModelNumber"
#define WDP_ELT_MODEL_URL	"ModelUrl"
#define WDP_ELT_PRESENTATION_URL	"PresentationUrl"
#define XML_ATT_LANG	"lang"

#define WDP_ELT_THIS_DEVICE	"ThisDevice"
#define WDP_ELT_FRIENDLY_NAME	"FriendlyName"
#define WDP_ELT_FIRMWARE_VERSION	"FirmwareVersion"
#define WDP_ELT_SERIAL_NUMBER	"SerialNumber"

#define DYNDEPL_ELT_SERVICE	"Service"
#define DYNDEPL_ATT_SERVICE_ID	"serviceId"
#define DYNDEPL_ELT_SERVICE_CLASS	"ServiceClass"
#define DYNDEPL_ATT_SERVICE_CLASS_ID "classId"
#define DYNDEPL_ELT_SERVICE_PORT	"ServicePort"
#define DYNDEPL_ELT_INTERFACE	"Interface"
#define DYNDEPL_ELT_REFERENCE	"Reference"
#define DYNDEPL_ELT_PROPERTY_VALUE	"PropertyValue"
#define DYNDEPL_ATT_NAME	"name"
#define DYNDEPL_ELT_DISCOVERY_HINTS	"DiscoveryHints"
#define DYNDEPL_ELT_HINT	"Hint"
#define DYNDEPL_ATT_ON_MULTIPLE_MATCHES	"onMultipleMatches"
#define DYNDEPL_ENUM_WSD_HINT_MM_ACTION_PICK_ONE "pickOne"
#define DYNDEPL_ENUM_WSD_HINT_MM_ACTION_FAIL "fail"
#define DYNDEPL_ATT_BINDING_TIME	"bindingTime"
#define DYNDEPL_ENUM_WSD_HINT_BT_DEPLOYMENT "deployment"
#define DYNDEPL_ENUM_WSD_HINT_BT_RUNTIME "runtime"
#define DYNDEPL_ATT_ON_REFERENCE_LOST	"onReferenceLost"
#define DYNDEPL_ENUM_WSD_HINT_RL_ACTION_FAIL "fail"
#define DYNDEPL_ENUM_WSD_HINT_RL_ACTION_RETRY "retry"
#define DYNDEPL_ENUM_WSD_HINT_RL_ACTION_IGNORE "ignore"
#define DYNDEPL_ELT_PROPERTY	"Property"
#define DYNDEPL_ATT_TYPE	"type"
#define DYNDEPL_ATT_MUST_SUPPLY	"mustSupply"
#define DYNDEPL_ATT_MULTIPLE	"multiple"
#define DYNDEPL_ELT_WSDL_INFO	"WSDLInfo"
#define DYNDEPL_ATT_TARGET_NS	"targetNamespace"
#define DYNDEPL_ATT_LOCATION	"location"


/*----------------------------------------------------------------------------*\
 *                    WS-Addressing representation definitions                *
\*----------------------------------------------------------------------------*/
#define WSA_ELT_ENDPOINT_REFERENCE	"EndpointReference"
#define WSA_ELT_ADDRESS	"Address"

/*----------------------------------------------------------------------------*\
 *                  DC configuration representation definitions               *
\*----------------------------------------------------------------------------*/

#define DC_CONFIG_NS_PREFIX "dcc"
#define DC_CONFIG_NS_URI "http://www.soa4d.org/dpwscore/2008/10/config"

#define DC_CONFIG_ELT_CONFIG "Config"
#define DC_CONFIG_ELT_BOOT_SEQ "BootSequence"
#define DC_CONFIG_ELT_PREFERRED_LANG "PreferredLanguage"
#define DC_CONFIG_ELT_HTTP_LISTENER "HTTPListener"
#define DC_CONFIG_ELT_REGISTRY "Registry"
#define DC_CONFIG_ELT_CACHE "Cache"
#define DC_CONFIG_ELT_SUBSC_MANAGER "SubscriptionManager"

#define DC_CONFIG_ATT_PORT "port"
#define DC_CONFIG_ATT_SIZE "size"
#define DC_CONFIG_ATT_MAX_DURATION "maxDuration"

#define DC_CONFIG_ATT_METADATA_VERSION	"metadataVersion"
#define DC_CONFIG_ATT_METADATA_CHECKSUM	"metadataChecksum"

#endif /*XMLCONF_DEFS_H_*/
