/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|                      ->>  Copyright 2008 Odonata <<-                         |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1772 $
|                     $Date: 2008-10-09 11:57:03 +0200 (jeu., 09 oct. 2008) $
\*============================================================================*/

#ifndef DCGSOAP_RUNTIME_H_
#define DCGSOAP_RUNTIME_H_
/* gSOAP configuration */

/* The following definitions removes non-portable (mainly HTTP) of gSOAP runtime */
#define WITH_NOIO
#define WITH_NOHTTP
#define WITH_IPV6
#define HAVE_CONFIG_H
#include "stdsoap2.h"

/*----------------------------------------------------------------------------*\
 *                    GSOAP ALLOCATOR FOR DC DYNAMIC ARRAYS                    *
\*----------------------------------------------------------------------------*/
#include "dcCOMN_DynArray.h"

/** Builds a dynamic array allocator using a given gSOAP runtime structure.
 * @param soap The gSOAP runtime structure that will perform allocation.
 * @param[out] The allocator structure to setup.
 * @return A pointer on the provider allocator structure.
 */
SOAP_FMAC1 da_allocator_t * soap_get_da_allocator(struct soap * soap, da_allocator_t * allocator);

/*----------------------------------------------------------------------------*\
 *                               XML Definitions                              *
\*----------------------------------------------------------------------------*/

#define XML_NS_PREFIX "xml"	/**< Reserved prefix for the XML namespace. */
#define XML_NS_URI "http://www.w3.org/XML/1998/namespace"	/**< XML namespace URI. */
#define XMLNS_NS_PREFIX "xmlns"	/**< Reserved prefix for "XML namespace" namespace. */
#define XMLNS_NS_URI "http://www.w3.org/2000/xmlns/"	/**< "XML namespace" namespace URI. */

/*----------------------------------------------------------------------------*\
 *                     CUSTOM GSOAP MARSHALLING FUNCTIONS                     *
\*----------------------------------------------------------------------------*/

/** Macro function that serializes an XML simple element.
 * @param soap The serialization context.
 * @param tag The element QName.
 * @param value The element value.
 * @return A gSOAP error code.
 */
int soap_simple_element_out(struct soap *soap, const char *tag, const char *value);

/** Macro function that serializes an XML empty element tag.
 * @param soap The serialization context.
 * @param tag The element QName.
 * @return A gSOAP error code.
 */
int soap_empty_element_out(struct soap *soap, const char *tag);

/** Macro function that parses an XML simple element.
 * @param soap The parsing context.
 * @param tag The element QName.
 * @param[out] value Receives the element value.
 * @return A gSOAP error code.
 */
int soap_simple_element_in(struct soap *soap, const char *tag, char** value);

/*----------------------------------------------------------------------------*\
 *                              RUNTIME ADJUNCTS                              *
\*----------------------------------------------------------------------------*/

/** Retrieves the namespace URI for a given prefix during XML parsing.
 * @param soap The parsing context.
 * @param prefix A character buffer containing the prefix.
 * @param p_len The number of character of the prefix. If 0, prefix is supposed
 * to be a string ended with '0'.
 * @return The value of the namespace URI (read-only, memory is managed by the
 * gSOAP runtime context) or NULL if the prefix is not defined.
 */
SOAP_FMAC1 char * soap_get_namespace_uri(struct soap * soap, const char * prefix, size_t p_len);

/** Retrieves the namespace URI for a given QName during XML parsing.
 * @param soap The parsing context.
 * @param qname A string containing the QName.
 * @return The value of the namespace URI (read-only, memory is managed by the
 * gSOAP runtime context) or NULL if the prefix is not defined.
 */
SOAP_FMAC1 char * soap_get_ns_uri(struct soap * soap, const char * qname);

/** Retrieves the local name for a given QName during XML parsing.
 * @param soap The parsing context.
 * @param qname A string containing the QName.
 * @return The value of the local name pointing on the provided \a qname.
 */
SOAP_FMAC1 char * soap_get_lname(struct soap * soap, const char * qname);

/** Retrieves or defines if missing  an XML prefix in the namespace stack during
 * serialization.
 * @param soap The serialization context.
 * @param ns_uri The namespace URI.
 * @param pfx The associated prefix to define or check. If NULL, will be
 * retrieved or generated if missing.
 * @return The prefix provided or retrieved, or a potential predefined one (
 * "xml", "xmlns").
 */
SOAP_FMAC1 const char * soap_check_prefix_definition(struct soap * soap, const char *ns_uri, const char * pfx);

/** Updates the namespace URI for a given prefix before XML serialization.
 * @param soap The parsing context.
 * @param prefix A string containing the prefix.
 * @param uri The URI to be used.
 */
SOAP_FMAC1 void soap_update_namespace_uri(struct soap * soap, const char * prefix, char * uri);

/*----------------------------------------------------------------------------*\
 *                                 UTILITIES                                  *
\*----------------------------------------------------------------------------*/

/** Retrieves the current namespace definitions while parsing.
 * @param soap The parsing context.
 * @param[out] The size of the returned array.
 * @return An array of prefix/URI namespace definitions.
 */
struct prefix_def * soap_build_ns_context(struct soap *soap, int * nb_def);

/*----------------------------------------------------------------------------*\
 *                           STATIC GSOAP FUNCTIONS ACCESS                    *
\*----------------------------------------------------------------------------*/

/** Export of the private soap_count_attachments function used.
 * Counts the size of the attachments and updates the current message count.
 * @param soap The gSOAP runtime structure processing the message.
 * @return The updated message count.
 */
size_t dc_soap_count_attachments(struct soap *soap);

#endif /*DCGSOAP_RUNTIME_H_*/
