/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1772 $
|                     $Date: 2008-10-09 11:57:03 +0200 (jeu., 09 oct. 2008) $
\*============================================================================*/

#ifndef DCDPWS_UDP_H_
#define DCDPWS_UDP_H_

#include "dcDPWS_Transport.h"
#include "dcDCPL_Net.h"

typedef struct udp_transport_data {
	struct transport_data base;
} udp_transport_data_t;

struct dpws;
struct reactor;
struct reactor_item;
struct media_type;

int dc_udp_serve_request(struct dpws * dpws, struct reactor_item * item, int (*cbk)(struct dpws *), void* callback_data);
int dc_udp_add_multicast_listener(struct reactor * reactor, int family, dcpl_ip_addr_t * bind_addr, unsigned short port, const char* multicast_addr);

int dc_udp_connect(struct dpws * dpws, const char * endpoint, const char * action, struct media_type * mtype, size_t len);

int dc_udp_open_output_channel(struct dpws * dpws, udp_transport_data_t * tdata, int family);
int dc_udp_open_response_channel(struct dpws * dpws, udp_transport_data_t * tdata, udp_transport_data_t * request_data);
int dc_udp_open_multicast_output_channel(struct dpws * dpws, udp_transport_data_t * tdata, const char * mcast_addr, uint16_t port, dcpl_ip_addr_t * out_netif_addr);

int dc_udp_setup_output_channel(struct dpws * dpws, udp_transport_data_t * tdata, DCPL_SOCKET socket);
int dc_udp_setup_multicast_output_channel(struct dpws * dpws, udp_transport_data_t * tdata, DCPL_SOCKET socket, const char * mcast_addr, uint16_t port, dcpl_ip_addr_t * out_netif_addr);

#endif
