/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|                      ->>  Copyright 2008 Odonata <<-                         |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1772 $
|                     $Date: 2008-10-09 11:57:03 +0200 (jeu., 09 oct. 2008) $
\*============================================================================*/

#include "dcDPWS_Transport.h"
#include "dcDPWS_Memory.h"
#include "dcDCPL_Socket.h"
#include "dc/dc_Types.h"
#include "dc/dc_Error.h"
#include "dcCOMN_Tools.h"
#include "dc/dc_DpwsRequest.h"

transport_data_t * dc_transport_data_init(transport_data_t * tdata, size_t size, transport_class_t * tclass)
{
	transport_data_t * result = tdata;
	
	if (!result) {
		result = DC_MALLOC(DC_MEM_TRANSIENT, size);
		if (!result)
			return NULL;
		result->status = DC_TRANSPORT_ALLOCED;
	} else {
		result->status = DC_TRANSPORT_UNKNOWN;
	}
	result->socket = DCPL_INVALID_SOCKET;
	result->tclass = tclass;
	result->itf = 0;
	result->peer_port = 0;
	result->peer_addr[0] = '\0';
	dcpl_init_error(&result->error);
	return result;
}

void dc_transport_data_clear(transport_data_t * tdata)
{
	if (tdata) {
		int alloced = (tdata->status & DC_TRANSPORT_ALLOCED);
		if (tdata->tclass->fcleardata)
			tdata->tclass->fcleardata(tdata);
		tdata->status = DC_TRANSPORT_UNKNOWN;
		tdata->socket = DCPL_INVALID_SOCKET;
		tdata->tclass = NULL;
		tdata->itf = 0;
		tdata->peer_port = 0;
		tdata->peer_addr[0] = '\0';
		dcpl_init_error(&tdata->error);
		if (alloced)
			DC_FREE(DC_MEM_TRANSIENT, tdata);
	}
}

int dc_transport_setup_channel(struct dpws * dpws, transport_data_t * tdata, DCPL_SOCKET socket, uint32_t direction)
{
	int ret = DPWS_OK;
	struct soap * soap = dpws_dpws2soap(dpws);
	if (!tdata)
		return DPWS_ERR_INVALID_PARAMETER;
	tdata->socket = socket;
	tdata->status |= direction;
	dpws->user_mode = soap->omode;
	dpws->transport_data = tdata;
	if (tdata->tclass->fsetupchannel)
		tdata->tclass->fsetupchannel(dpws, tdata);
	return ret;
}

int dc_transport_teardown_channel(struct dpws * dpws, transport_data_t * tdata)
{
	int ret = DPWS_OK;
	struct soap * soap = dpws_dpws2soap(dpws);
	if (!tdata)
		tdata = (transport_data_t *)dpws->transport_data;
	if (tdata) {
		if (tdata->tclass->fteardownchannel)
			tdata->tclass->fteardownchannel(dpws, tdata);
		tdata->status &= ~(DC_TRANSPORT_INPUT | DC_TRANSPORT_OUTPUT);
		soap->omode = dpws->user_mode;
		dpws->transport_data = NULL;
	}
	return ret;
}

int dc_transport_close_channel(struct dpws * dpws)
{
	transport_data_t * tdata = dpws->transport_data;
	dc_transport_teardown_channel(dpws, tdata);
	if (tdata->tclass->fclosechannel)
		tdata->tclass->fclosechannel(tdata);
	if (tdata && tdata->socket != DCPL_INVALID_SOCKET) {
		DPWSLOG1(DC_TRANSPORT, "Closing socket %d", socket);
		dcpl_closesocket(tdata->socket, NULL);
		tdata->socket = DCPL_INVALID_SOCKET;
	}
	dc_transport_data_clear(tdata);
	return DPWS_OK;
}
