/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/*******************************************************************************
*                            WS-METADATA STUB & SKELETON                       *
*******************************************************************************/
/* soapC.c
   Generated by gSOAP 2.6.2 from metadata.gsoap
   Copyright (C) 2001-2004 Genivia, Inc. All Rights Reserved.
   This software is released under the gSOAP public license and GPL.
   See README.txt for further details.
*/
#include "dcDPWS_Metadata.h"
#include "dcDPWS_Memory.h"
#include "dcCOMN_Tools.h"
#include "dcCOMN_DynArray.h"
#include "dcDCPL_Os.h"
#include "dcDPWS_Registry.h"
#include "dcGSOAP_Runtime.h"
#include "dcDPWS_Utils.h"


struct Namespace dpws10_transfer_snd_namespaces[] =
{
	{SOAP_ENV_PREFIX, SOAP_ENV_URI, SOAP_ENV_WILDCARD, NULL},
	{WSA_PREFIX, WSA_200408_URI, WSA_WILDCARD, NULL},
	{WDP_PREFIX, DPWS10_WDP_URI, WDP_WILDCARD, NULL},
	{WSM_PREFIX, WSM_URI, WSM_WILDCARD, NULL},
	{WST_PREFIX, WST_URI, WST_WILDCARD, NULL},
	{PNPX_PREFIX, PNPX_URI, PNPX_WILDCARD, NULL},
	{DF_PREFIX, DF_URI, DF_WILDCARD, NULL},
	{NULL, NULL, NULL, NULL}
};

struct Namespace dpws11_transfer_snd_namespaces[] =
{
	{SOAP_ENV_PREFIX, SOAP_ENV_URI, SOAP_ENV_WILDCARD, NULL},
	{WSA_PREFIX, WSA_200508_URI, WSA_WILDCARD, NULL},
	{WDP_PREFIX, DPWS11_WDP_URI, WDP_WILDCARD, NULL},
	{WSM_PREFIX, WSM_URI, WSM_WILDCARD, NULL},
	{WST_PREFIX, WST_URI, WST_WILDCARD, NULL},
	{PNPX_PREFIX, PNPX_URI, PNPX_WILDCARD, NULL},
	{DF_PREFIX, DF_URI, DF_WILDCARD, NULL},
	{NULL, NULL, NULL, NULL}
};

/*------------------------- Static Functions prototypes ----------------------*/

static struct wdp__HostServiceType * build_hosting_section(struct dpws *dpws,
														   struct service_endpoint* endpoint,
														   DA_TYPED(pqn)* types,
														   char* service_id);
static struct wdp__LocalizedStringType ** fill_localized_string(struct dpws * dpws, DA_TYPED(lstr) * src, int * p_size);
static int cache_update(struct dpws* dpws, struct device_proxy * device, DA_TYPED(psi)* services, struct _wdp__Relationship * relationship);

/*******************************************************************************
*                                 MARSHALLING                                  *
*******************************************************************************/

#define WITH_NOGLOBAL
#ifdef SOAP_FMAC3
# undef SOAP_FMAC3
#endif
#define SOAP_FMAC3 static
#include "transferC.c"
#undef WITH_NOGLOBAL

/*******************************************************************************
*                                    STUB                                      *
*******************************************************************************/
// NOTE: in order to keep a standard generation (setting is performed by the caller)
#define transfer_namespaces (dpws->protocols->default_namespaces)
#define transfer_snd_namespaces (dpws->protocols->transfer_snd_namespaces)
#include "transferClient.c"
#undef transfer_namespaces
#undef transfer_snd_namespaces
/*******************************************************************************
*                                  SKELETON                                    *
*******************************************************************************/
#define WITH_NOSERVEREQUEST
#define transfer_namespaces (dpws->protocols->default_namespaces)
#define transfer_snd_namespaces (dpws_soap2dpws(soap)->protocols->transfer_snd_namespaces)
#include "transferServer.c"
#undef transfer_snd_namespaces
#undef transfer_namespaces
#undef WITH_NOSERVEREQUEST

int transfer_serve_request(struct dpws *dpws)
{
	struct soap *soap = &dpws->soap;
	const char* action = dpws->action ? dpws->action : "";
	struct dpws_protocols * protocols[N_DPWS_VERSIONS];
	int i, size;

	size = get_protocols_versions(dpws, protocols, N_DPWS_VERSIONS);
	for (i = 0; i < size; i++) {
		dpws->protocols = protocols[i];
		dpws_set_namespaces(dpws, dpws->protocols->default_namespaces);
		soap_peek_element(soap);
		if (!strcmp(action, dpws->protocols->wst_get_action))
			return soap_serve___wst__Get(soap);
	}
	return soap->error = SOAP_NO_METHOD;
}

/******************************************************************************\
 *                                                                            *
 * Service Operations (Server-side)                                           *
 *                                                                            *
\******************************************************************************/

static struct wdp__HostServiceType * build_hosting_section(struct dpws *dpws,
														   struct service_endpoint* endpoint,
														   DA_TYPED(pqn)* types,
														   char* service_id)
{
	struct wdp__HostServiceType * section;
	int i = 0;
	section = (struct wdp__HostServiceType *)DC_MSG_MALLOC(DC_MEM_REGISTRY, dpws, sizeof(struct wdp__HostServiceType));
	if (section) {
		soap_default_wdp__HostServiceType(dpws_dpws2soap(dpws), section);

		section->__sizeEndpointReference = endpoint->service_ports.nb;
		if (!(section->wsa__EndpointReference =
			(struct wsa_endpoint_ref **)DC_MSG_MALLOC(DC_MEM_REGISTRY, dpws, sizeof(struct wsa_endpoint_ref *) * endpoint->service_ports.nb)))
			return NULL;
		for (; i < endpoint->service_ports.nb; i++)
		{
			if (!(section->wsa__EndpointReference[i] = (struct wsa_endpoint_ref *)DC_MSG_MALLOC(DC_MEM_REGISTRY, dpws, sizeof(struct wsa_endpoint_ref))))
			{
				dpws->err = DPWS_ERR_EOM;
				return NULL;
			}
			dpws_default_wsa_endpoint_ref(section->wsa__EndpointReference[i]);
			if (!(section->wsa__EndpointReference[i]->address = get_transport_address(dpws, dpws->soap.host, *DA_GET(&endpoint->service_ports, i))))
			{
				dpws->err = DPWS_ERR_EOM;
				return NULL;
			}
		}
		section->Types = (dyn_array_t *)types;
		section->ServiceId = service_id;
		section->pnpx__HardwareId = endpoint->hardware_id;
		section->pnpx__CompatibleId = endpoint->compatible_id;
	}
	return section;
}


static struct wdp__LocalizedStringType ** fill_localized_string(struct dpws * dpws, DA_TYPED(lstr) * src, int * p_size)
{
	int i;
	struct wdp__LocalizedStringType ** ret;
	*p_size = src->nb;
	ret = (struct wdp__LocalizedStringType **)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct wdp__LocalizedStringType *) * src->nb);
	if (ret) {
		for (i = 0; i < src->nb; i++) {
			if (!(ret[i] = (struct wdp__LocalizedStringType *)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct wdp__LocalizedStringType))))
				return NULL;
			soap_default_wdp__LocalizedStringType(dpws_dpws2soap(dpws), ret[i]);
			ret[i]->__item = DA_GET(src, i)->s;
			ret[i]->xml__lang = DA_GET(src, i)->lang;
		}
	}
	return ret;
}

int __wst__Get(struct dpws *dpws, struct __wst__AnyXmlType *body)
{
	struct _wsm__Metadata *response;
	struct _wsm__MetadataSection * section = NULL;
	struct service_endpoint * endpoint = get_endpoint(dpws->href_endpoint);
	_wdp__ThisModel * model = NULL;
	_wdp__ThisDevice * device = NULL;
	struct _wdp__Relationship * relationship;
	struct wsdl_info * wsdlInfo;
	int i, s_idx = 0, ret = DPWS_OK;
	struct Namespace * mdns;
	struct service_class *servClass = (struct service_class *)getObject(&registryPool, endpoint->hrefServiceClass);
	DA_TYPED(pqn) *types;


	DC_ERROR_ASSERT_ALLOC(response = (struct _wsm__Metadata *)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct _wsm__Metadata)));
	DC_ERROR_ASSERT_ALLOC(types = (DA_TYPED(pqn)*)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(dyn_array_t)));

	body->__type = SOAP_TYPE__wsm__Metadata;
	body->__any = response;
	response->__sizeMetadataSection = count_tns_wsdl(endpoint);	// init nb of metadata sections

	/* Sections for device endpoints */
	if (!endpoint->service_id)
	{
		struct service_endpoint * w_endpoint;
		int nendpoints = 0, i; // recount to ignore device

		response->__sizeMetadataSection += 2;
		if (endpoint->device->hosted_services.nb > 1)	// device built-in service is always present
			response->__sizeMetadataSection++;
		DC_ERROR_ASSERT_ALLOC(response->wsm__MetadataSection
				= DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct _wsm__MetadataSection *) * response->__sizeMetadataSection)); // allocate the maximunm anyway

		/* DPWS: This model */
		DC_ERROR_ASSERT_ALLOC(section = response->wsm__MetadataSection[s_idx++]
				= (struct _wsm__MetadataSection*)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct _wsm__MetadataSection)));
		soap_default__wsm__MetadataSection(dpws_dpws2soap(dpws), section);
		section->Dialect = dpws->protocols->wdp_model_uri;
		section->__type = SOAP_TYPE__wdp__ThisModel;
		DC_ERROR_ASSERT_ALLOC(section->_any = model
				= (_wdp__ThisModel*)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(_wdp__ThisModel)));
		soap_default__wdp__ThisModel(dpws_dpws2soap(dpws), model);

		DC_ERROR_ASSERT_ALLOC(model->Manufacturer
				= fill_localized_string(dpws, &endpoint->device->manufacturers, &model->__sizeManufacturer));
		model->ManufacturerUrl = endpoint->device->manufacturer_url;

		DC_ERROR_ASSERT_ALLOC(model->ModelName
				= fill_localized_string(dpws, &endpoint->device->model_names, &model->__sizeModelName));

		model->ModelNumber = endpoint->device->model_number;
		model->ModelUrl = endpoint->device->model_url;
		model->PresentationUrl = endpoint->device->presentation_url;

		model->pnpx__DeviceCategory = endpoint->device->device_category;
		model->df__DeviceCategory = endpoint->device->device_category;
		model->df__ModelId = endpoint->device->model_id;

		/* DPWS: This device */

		DC_ERROR_ASSERT_ALLOC(section = response->wsm__MetadataSection[s_idx++]
				= (struct _wsm__MetadataSection*)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct _wsm__MetadataSection)));
		soap_default__wsm__MetadataSection(dpws_dpws2soap(dpws), section);
		section->Dialect = dpws->protocols->wdp_device_uri;
		section->__type = SOAP_TYPE__wdp__ThisDevice;
		DC_ERROR_ASSERT_ALLOC(section->_any = device
				= (_wdp__ThisDevice*)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(_wdp__ThisDevice)));
		soap_default__wdp__ThisDevice(dpws_dpws2soap(dpws), device);

		DC_ERROR_ASSERT_ALLOC(device->FriendlyName
				= fill_localized_string(dpws, &endpoint->device->friendly_names, &device->__sizeFriendlyName));

		device->FirmwareVersion = endpoint->device->firmware_version;
		device->SerialNumber = endpoint->device->serial_number;

		/* DPWS: Hosting */
		if (endpoint->device->hosted_services.nb > 1)	// Create a section if hosted services exist
		{

			DC_ERROR_ASSERT_ALLOC(mdns = get_device_metadata_ns_table(dpws, endpoint->device));
			dpws_set_namespaces(dpws, mdns);

			DC_ERROR_ASSERT_ALLOC(section = response->wsm__MetadataSection[s_idx++]
					= (struct _wsm__MetadataSection*)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct _wsm__MetadataSection)));
			soap_default__wsm__MetadataSection(dpws_dpws2soap(dpws), section);
			section->Dialect = dpws->protocols->wdp_hosting_uri;
			section->__type = SOAP_TYPE__wdp__Relationship;
			DC_ERROR_ASSERT_ALLOC(section->_any = relationship
					= (struct _wdp__Relationship*)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct _wdp__Relationship)));
			soap_default__wdp__Relationship(dpws_dpws2soap(dpws), relationship);
			relationship->Type = dpws->protocols->wdp_relationship_uri;

			DC_ERROR_ASSERT_ALLOC(relationship->Hosted
					= (struct wdp__HostServiceType **)DC_MSG_MALLOC(DC_MEM_API, dpws, endpoint->device->hosted_services.nb * sizeof(struct wdp__HostServiceType *)));
			for (i = 0; i <  endpoint->device->hosted_services.nb; i++) {
				w_endpoint = (struct service_endpoint *)getObject(&registryPool, *DA_GET(&endpoint->device->hosted_services, i));
				if (w_endpoint->service_id)	{// ignore device
					DC_ERROR_ASSERT_ALLOC(relationship->Hosted[nendpoints++]
					     = build_hosting_section(dpws, w_endpoint, get_service_types(w_endpoint), w_endpoint->service_id));
				}
			}
			relationship->__sizeHosted = nendpoints;
		}
	}
	else	// Sections for service endpoints
	{
		response->__sizeMetadataSection += 1;
		DC_ERROR_ASSERT_ALLOC(response->wsm__MetadataSection
				= DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct _wsm__MetadataSection *) * response->__sizeMetadataSection)); // allocate the maximunm anyway

		/* DPWS: Hosting */

		DC_ERROR_ASSERT_ALLOC(mdns = get_device_metadata_ns_table(dpws, endpoint->device));
		dpws_set_namespaces(dpws, mdns);

		DC_ERROR_ASSERT_ALLOC(section = response->wsm__MetadataSection[s_idx++]
				= (struct _wsm__MetadataSection*)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct _wsm__MetadataSection)));
		soap_default__wsm__MetadataSection(dpws_dpws2soap(dpws), section);
		section->Dialect = dpws->protocols->wdp_hosting_uri;
		section->__type = SOAP_TYPE__wdp__Relationship;
		DC_ERROR_ASSERT_ALLOC(section->_any = relationship
				= (struct _wdp__Relationship*)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct _wdp__Relationship)));
		soap_default__wdp__Relationship(dpws_dpws2soap(dpws), relationship);
		relationship->Type = dpws->protocols->wdp_relationship_uri;

		DC_ERROR_ASSERT_ALLOC(relationship->Host
				= build_hosting_section(dpws, endpoint, get_device_types(dpws, endpoint->device, types, DC_TRUE), NULL));
		relationship->__sizeHosted = 1;
		DC_ERROR_ASSERT_ALLOC(relationship->Hosted
				= (struct wdp__HostServiceType **)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct wdp__HostServiceType *)));
		DC_ERROR_ASSERT_ALLOC(relationship->Hosted[0]
		        = build_hosting_section(dpws, endpoint, get_service_types(endpoint), endpoint->service_id));
	}

	/* WS-MetadataExchange: WSDL */
	// NOTE: only location currently supported
	for (i = 0; i < servClass->wsdl_files.nb; i++)
	{
		wsdlInfo = DA_GET(&servClass->wsdl_files, i);
		DC_ERROR_ASSERT_ALLOC(section = response->wsm__MetadataSection[s_idx++]
				= (struct _wsm__MetadataSection*)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct _wsm__MetadataSection)));
		soap_default__wsm__MetadataSection(dpws_dpws2soap(dpws), section);
		section->Dialect = WSDL_URI;
		section->Identifier = wsdlInfo->target_ns;
		section->wsm__Location = wsdlInfo->location;
	}

	// NOTE: not supported
	//	- schemas are supposed to be referenced by WSDL
	// 	- WS-Policy: the only currently supported is SoapHttpRequestReplyAddress
	//	  which must be known to ask for metadata...
DC_FUNC_ERROR
	return ret;
}

static int cache_update(struct dpws* dpws, struct device_proxy * device, DA_TYPED(psi)* services, struct _wdp__Relationship * relationship)
{
	int i, ret = DPWS_OK;

	dcpl_mutex_lock(cache_lock);
	if (services)
		services->inc = relationship->__sizeHosted;
	for (i = 0; i < relationship->__sizeHosted; i++)
	{
		struct wdp__HostServiceType *hosted;
		hosted = relationship->Hosted[i];
		if (device) {
			DC_ERROR_ASSERT_ALLOC(add_service_proxy(device, hosted->wsa__EndpointReference,
					hosted->__sizeEndpointReference, (DA_TYPED(qn)*)hosted->Types, hosted->ServiceId));
			device->hosted_retrieved = DC_TRUE;
		}
		if (services) {
			struct service_info* s_info = (struct service_info *)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct service_info)), **psi;
			DC_ERROR_ASSERT_ALLOC(psi = DA_ADD(services));
			*psi = s_info;
			// no need to perform a deep copy of the EPR since already allocated on the gSOAP heap, but need to add the final null...
			DC_ERROR_ASSERT_ALLOC(s_info->endpoints = (struct wsa_endpoint_ref**)
					DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct wsa_endpoint_ref *) * (hosted->__sizeEndpointReference + 1)));
			memcpy(s_info->endpoints, hosted->wsa__EndpointReference, sizeof(struct wsa_endpoint_ref *) * hosted->__sizeEndpointReference);
			memset(s_info->endpoints + hosted->__sizeEndpointReference, 0, sizeof(struct wsa_endpoint_ref *));
			s_info->service_id = hosted->ServiceId;
		}
	}
DC_FUNC_ERROR
	dcpl_mutex_unlock(cache_lock);
	return ret;
}

int get_endpoint_metadata(struct dpws* dpws, short href, struct device_proxy * device,
						struct model_info *model, struct device_info *dev_info,
						DA_TYPED(pepr)* host_endpoints,	DA_TYPED(psi)* services,
						DA_TYPED(pwi)* wsdlList)
{
	struct __wst__AnyXmlType response;
	struct _wsm__Metadata * out;
	int i, ret = DPWS_OK;

	if (dpws_call___wst__Get(dpws, get_default_EPR(dpws, href), NULL, &response))
		return dpws_dpws2soap(dpws)->error;
	out = (struct _wsm__Metadata *)response.__any;

	for (i = 0; i < out->__sizeMetadataSection; i++) {
		struct _wsm__MetadataSection *section = out->wsm__MetadataSection[i];
		if (!strcmp(dpws->protocols->wdp_model_uri, section->Dialect) && model) {
			_wdp__ThisModel * this_model;
			if (!section->_any)
				return DPWS_ERR_UNSUPPORTED_METADATA_SECTION;
			this_model = (_wdp__ThisModel *)section->_any;
			// manufacturer (if more than one take the one without @lang or in english (first of the 2)
			model->manufacturer = find_localized_entry((struct localized_string **)this_model->Manufacturer, this_model->__sizeManufacturer, registry_cfg.preferred_lang);
			// model name (if more than one take the one without @lang or in english (first of the 2)
			model->model_name = find_localized_entry((struct localized_string **)this_model->ModelName, this_model->__sizeModelName, registry_cfg.preferred_lang);
			// other fields
			model->manufacturer_url = this_model->ManufacturerUrl;
			model->model_number = this_model->ModelNumber;
			model->model_url = this_model->ModelUrl;
			model->presentation_url = this_model->PresentationUrl;
		}
		if (!strcmp(dpws->protocols->wdp_device_uri, section->Dialect) && dev_info) {
			_wdp__ThisDevice * this_device;
			if (!section->_any)
				return DPWS_ERR_UNSUPPORTED_METADATA_SECTION;
			this_device = (_wdp__ThisDevice *)section->_any;
			dev_info->friendly_name = find_localized_entry((struct localized_string **)this_device->FriendlyName, this_device->__sizeFriendlyName, registry_cfg.preferred_lang);
			dev_info->firmware_version = this_device->FirmwareVersion;
			dev_info->serial_number = this_device->SerialNumber;
		}
		if (!strcmp(dpws->protocols->wdp_hosting_uri, section->Dialect)) {
			struct _wdp__Relationship * relationship;
			if (!section->_any)
				return DPWS_ERR_UNSUPPORTED_METADATA_SECTION;
			relationship = (struct _wdp__Relationship *)section->_any;
			if (strcmp(relationship->Type, dpws->protocols->wdp_relationship_uri)) continue;
			if (host_endpoints && relationship->Host) {
				// no need to perform a deep copy of the EPR since already allocated on the gSOAP heap, but need to add the final null...
				host_endpoints->nb = host_endpoints->size = relationship->Host->__sizeEndpointReference;
				DC_ERROR_ASSERT_ALLOC(host_endpoints->tab
						= DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct wsa_endpoint_ref *) * (host_endpoints->nb + 1)));
				memcpy(host_endpoints->tab, relationship->Host->wsa__EndpointReference, sizeof(struct wsa_endpoint_ref *) * host_endpoints->nb);
				memset((struct wsa_endpoint_ref **)host_endpoints->tab + host_endpoints->nb, 0, sizeof(struct wsa_endpoint_ref *));
			}
			// Cache update
			DC_ERROR_ASSERT_CALL(cache_update(dpws, device, services, relationship));
		}
		if (!strcmp(WSDL_URI, section->Dialect) && wsdlList) {
			struct wsdl_info * w_wsdl, ** pwi;
			if (!section->wsm__Location)
				//return DPWS_ERR_UNSUPPORTED_METADATA_SECTION;
				continue;
			DC_ERROR_ASSERT_ALLOC(w_wsdl = (struct wsdl_info *)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct wsdl_info)));
			w_wsdl->target_ns = section->Identifier;
			w_wsdl->location = section->wsm__Location;
			DC_ERROR_ASSERT_ALLOC(pwi = DA_ADD(wsdlList));
			*pwi = w_wsdl;
		}
	}
DC_FUNC_ERROR
	return ret;
}

