/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1772 $
|                     $Date: 2008-10-09 11:57:03 +0200 (jeu., 09 oct. 2008) $
\*============================================================================*/

#ifndef DCDPWS_HTTP_H_
#define DCDPWS_HTTP_H_

#include "dcDPWS_Transport.h"

#define DC_HTTP_GET					0x01
#define DC_HTTP_POST				0x02

#define DC_HTTP_BIT_OFFSET			16
#define DC_HTTP_MASK				(0xFF << DC_HTTP_BIT_OFFSET)
#define DC_HTTP_HEADERS_RECEIVED	(0x01 << DC_HTTP_BIT_OFFSET)
#define DC_HTTP_HEADERS_SENT		(0x02 << DC_HTTP_BIT_OFFSET)
#define DC_HTTP_NOKEEPALIVE			(0x04 << DC_HTTP_BIT_OFFSET)
#define DC_HTTP_KEEPALIVE			(0x08 << DC_HTTP_BIT_OFFSET)
#define DC_HTTP_CHUNKED_INPUT		(0x10 << DC_HTTP_BIT_OFFSET)
#define DC_HTTP_CHUNKED_OUTPUT		(0x20 << DC_HTTP_BIT_OFFSET)

typedef struct http_transport_data {
	struct transport_data base;
	int code;		/** < Contains HTTP method on request, HTTP staus on reply */
	int length;
	char * buf;
	int bufsize;
	int buflen;
	int index;
	int ahead;
	int socket_flags;
	int recv_timeout;
	int send_timeout;
} http_transport_data_t;

struct dpws;
struct reactor;
struct reactor_item;
struct media_type;

int dc_http_add_listener(struct reactor * reactor, int bind_flags, int family, const char* addr, unsigned short port, uint32_t itf_selector, int backlog);
int dc_http_accept_request(struct dpws * dpws, struct reactor_item * item, void* callback_data);

int dc_http_connect(struct dpws * dpws, const char * endpoint, const char * action, struct media_type * mtype, size_t len);

int dc_http_open_output_channel(struct dpws * dpws, http_transport_data_t * tdata, const char* host, unsigned short port);
int dc_http_get_local_address(struct dpws * dpws, DCPL_SOCKET s, char * local_addr_buf, int buf_size);

int dc_http_setup_output_channel(struct dpws * dpws, http_transport_data_t * tdata, DCPL_SOCKET socket);

#endif
