/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/*******************************************************************************
*       WS-Eventing Protocol Implementation (for event source port type)       *
*******************************************************************************/
#ifndef EVENT_H
# define EVENT_H

#include "dc/dc_Dpws.h"
#include "dcDPWS_Registry.h"

#ifdef SOAP_FMAC3
# undef SOAP_FMAC3
#endif
#define SOAP_FMAC3 static
# include "eventsourceStub.h"

extern struct Namespace dpws10_eventing_snd_namespaces[];	/**< WS-Eventing sGOAP "send" namespace table for DPWS 1.0 */
extern struct Namespace dpws11_eventing_snd_namespaces[];	/**< WS-Eventing sGOAP "send" namespace table for DPWS 1.1 */

/** Public exposition of "event source" message serialization for SOAP fault
 * details enhancement with incoming message parts.
 * @param dpws The message context.
 * @param A pointer on the C structure to be serialized.
 * @param tag The tag name.
 * @param type The XML type Id used by the gSOAP marshalling generated code.
 * @return A DPWS error code.
 */
int event_putelement(struct dpws *dpws, const void *ptr, const char *tag, int type);

/** Sends "eventing end" notifications for a stopping device.
 * @param dpws The DPWS runtime structure that will be used to send messages.
 * @param device A pointer to the registry device
 * @return A DPWS error code.
 */
int send_eventing_end(struct dpws* dpws, struct device * device);

/** Dispatch function for subscription events (aka "event end").
 * @param dpws The message context.
 * @return A DPWS error code.
 */
int eventing_handle_event(struct dpws *dpws);

#endif
