/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2215 $
|                     $Date: 2009-03-19 15:44:46 +0100 (jeu, 19 mar 2009) $
\*============================================================================*/

/*******************************************************************************
*                            WS-EVENTING STUB & SKELETON                       *
*******************************************************************************/

#include "dcDPWS_Utils.h"
#include "dcDPWS_Event.h"
#include "dcCOMN_Tools.h"
#include "dcDPWS_Registry.h"
#include "dcDPWS_Discovery.h"
#include "dcDPWS_SubscManager.h"
#include "dc/dc_Plugin.h"
#include "dcCOMN_Tools.h"
#include "dcDPWS_Reactor.h"
#include "dcDPWS_Http.h"

// wse: built-in compiler prefix (ns table not generated)
struct Namespace dpws10_eventing_snd_namespaces[] =
{
	{SOAP_ENV_PREFIX, SOAP_ENV_URI, SOAP_ENV_WILDCARD, NULL},
	{WSA_PREFIX, WSA_200408_URI, WSA_WILDCARD, NULL},
	{WSE_PREFIX, WSE_URI, WSE_WILDCARD, NULL},
#ifdef WITH_WSMAN
	{WSMAN_PREFIX, WSMAN_URI, WSMAN_WILDCARD, NULL},
#endif
	{NULL, NULL, NULL, NULL}
};

struct Namespace dpws11_eventing_snd_namespaces[] =
{
	{SOAP_ENV_PREFIX, SOAP_ENV_URI, SOAP_ENV_WILDCARD, NULL},
	{WSA_PREFIX, WSA_200508_URI, WSA_WILDCARD, NULL},
	{WSE_PREFIX, WSE_URI, WSE_WILDCARD, NULL},
#ifdef WITH_WSMAN
	{WSMAN_PREFIX, WSMAN_URI, WSMAN_WILDCARD, NULL},
#endif
	{NULL, NULL, NULL, NULL}
};

/*******************************************************************************
*                                 MARSHALLING                                  *
*******************************************************************************/
#define WITH_NOGLOBAL
#ifdef SOAP_FMAC3
#undef SOAP_FMAC3
#endif
#define SOAP_FMAC3 static
#include "eventsourceC.c"
#undef WITH_NOGLOBAL

int event_putelement(struct dpws *dpws, const void *ptr, const char *tag, int type)
{
	return soap_putelement(dpws_dpws2soap(dpws), ptr, tag, -1, type);
}

/*******************************************************************************
*                                    STUB                                      *
*******************************************************************************/
#define eventsource_namespaces (dpws->protocols->default_namespaces)
#define eventsource_snd_namespaces (dpws->protocols->eventing_snd_namespaces)
#include "eventsourceClient.c"
#undef eventsource_snd_namespaces
#undef eventsource_namespaces

/*******************************************************************************
*                                  SKELETON                                    *
*******************************************************************************/
#define WITH_NOSERVEREQUEST
#define eventsource_snd_namespaces (dpws_soap2dpws(soap)->protocols->eventing_snd_namespaces)
#define eventsource_namespaces (dpws->protocols->default_namespaces)
#include "eventsourceServer.c"
#undef eventsource_namespaces
#undef eventsource_snd_namespaces
#undef WITH_NOSERVEREQUEST

int eventing_handle_event(struct dpws *dpws)
{
	struct soap *soap = &dpws->soap;
	const char* action = dpws->action ? dpws->action : "";
	struct dpws_protocols * protocols[N_DPWS_VERSIONS];
	int i, size;
	size = get_protocols_versions(dpws, protocols, N_DPWS_VERSIONS);
	for (i = 0; i < size; i++) {
		dpws->protocols = protocols[i];
		dpws_set_namespaces(dpws, dpws->protocols->default_namespaces);
		soap_peek_element(soap);
		if (!strcmp(action, dpws->protocols->wse_subscriptionend_action) || (!strlen(action) && !soap_match_tag(soap, soap->tag, "wse:SubscriptionEnd")))
			return soap_serve___wse__SubscriptionEnd(soap);
	}
	return soap->error = SOAP_NO_METHOD;
}

/******************************************************************************\
 *                                                                            *
 * Service Operations (Server-side)                                           *
 *                                                                            *
\******************************************************************************/

int __wse__SubscribeOp(struct dpws * dpws, struct _wse__Subscribe * msg, struct _wse__SubscribeResponse *response)
{
	uint32_t duration;
	DA_TYPED(str) * filter = NULL;
	struct service_endpoint * service;
	int ret = DPWS_OK;

	// checks
	if (!msg) {
		dpws->err_detail_type = SOAP_TYPE_string;
		dpws->err_detail_data = msg;
		dpws->err_detail_data_elt = NULL;
		return WSE_ERR_INVALID_SUBSCRIPTION;
	}

	if (!msg->wse__Delivery) {
		dpws->err_detail_type = SOAP_TYPE__wse__Subscribe;
		dpws->err_detail_data = msg;
		dpws->err_detail_data_elt = "wse:SubscribeOp";
		return WSE_ERR_INVALID_SUBSCRIPTION;
	}

	if (!msg->wse__Delivery->Mode)
		msg->wse__Delivery->Mode = WSE_MODE_PUSH;
	else if (strcmp(msg->wse__Delivery->Mode, WSE_MODE_PUSH)) {
		dpws->err_detail_type = SOAP_TYPE__wse__Subscribe;
		dpws->err_detail_data = msg;
		dpws->err_detail_data_elt = "wse:SubscribeOp";
		return WSE_ERR_DELIVERY_MODE_REQUESTED_UNAVAILABLE;
	}

	service = get_endpoint(dpws->href_endpoint);	// protected by the invokation runtime counter
	if (!msg->wse__Delivery->wse__NotifyTo) {
		dpws->err_detail_type = SOAP_TYPE__wse__Subscribe;
		dpws->err_detail_data = msg;
		dpws->err_detail_data_elt = "wse:SubscribeOp";
		return WSE_ERR_INVALID_MESSAGE;
	}
	if (msg->wse__Expires) {
		duration = xmlduration2duration(msg->wse__Expires);
		if (duration == 0) {
			dpws->err_detail_type = SOAP_TYPE__wse__Subscribe;
			dpws->err_detail_data = msg;
			dpws->err_detail_data_elt = "wse:SubscribeOp";
			return WSE_ERR_UNSUPPORTED_EXPIRATION_TYPE;
		}
		if (duration < 0) {
			dpws->err_detail_type = SOAP_TYPE__wse__Subscribe;
			dpws->err_detail_data = msg;
			dpws->err_detail_data_elt = "wse:SubscribeOp";
			return WSE_ERR_INVALID_EXPIRATION_TIME;
		}
		if (duration > sm_config.max_subsc_duration)
			duration = sm_config.max_subsc_duration;
	} else
		duration = sm_config.max_subsc_duration;

	if (msg->wse__Filter) {
		if (msg->wse__Filter->Dialect && !strcmp(msg->wse__Filter->Dialect, dpws->protocols->wdp_wse_filtering_dialect))
			filter = (DA_TYPED(str) *)msg->wse__Filter->__item;
		else
			return WSE_ERR_FILTERING_REQUESTED_UNAVAILABLE;
	}
	// else no filter
	if (!(response->wse__SubscriptionManager = (struct wsa_endpoint_ref*)DC_MSG_MALLOC(DC_MEM_SUBSCRIPTION, dpws, sizeof(struct wsa_endpoint_ref)))){
		ret = DPWS_ERR_EOM;
		goto error;
	}
//	dpws_default_wsa_endpoint_ref(response->wse__SubscriptionManager);
#ifdef WITH_WSMAN
	dpws->wsman_headers.heartbeats = msg->wse__Delivery->wsman__Heartbeats;
	ret = dpws->eventing_sm->create_subsc(dpws, duration, filter ? filter->tab : NULL, filter ? filter->nb : 0, msg->wse__Delivery->wse__NotifyTo, msg->wse__EndTo, (char**)&response->wse__SubscriptionManager->subscription_id);	// NOTE: memory risk if the registration is removed by a concurrent thread. Should not occur since registration is event sink private (except odd design)
#else
	ret = wse_create_subsc_manager(dpws, duration, filter ? filter->tab : NULL, filter ? filter->nb : 0, msg->wse__Delivery->wse__NotifyTo, msg->wse__EndTo, &response->wse__SubscriptionManager->subscription_id);	// NOTE: memory risk if the registration is removed by a concurrent thread. Should not occur since registration is event sink private (except odd design)
#endif
	if (ret) {
		dpws->err_detail_type = SOAP_TYPE__wse__Subscribe;
		dpws->err_detail_data = NULL;
		dpws->err_detail_data_elt = NULL;
	}
	else {
		service->subsc_manager = DC_TRUE;
		if (!(response->wse__Expires = (char*)DC_MSG_MALLOC(DC_MEM_SUBSCRIPTION, dpws, DURATION_MAX_SIZE))) {
			ret = DPWS_ERR_EOM;
			goto error;
		}
		duration2xmlduration(response->wse__Expires, duration); // DPWS authorizes to reply with a duration
		if (!(response->wse__SubscriptionManager->address = DC_MSG_STRDUP(DC_MEM_SUBSCRIPTION, dpws, dpws->to))) {	// Because the eventsource is also the subscription manager.
			ret = DPWS_ERR_EOM;
			goto error;
		}
	}

error:
	return ret;
}


int __wse__SubscriptionEnd(struct dpws* dpws, struct _wse__SubscriptionEnd *msg)
{
	struct event_end_info * event_end = NULL;
	struct service_class * servClass = (struct service_class *)getObject(&registryPool, get_endpoint(dpws->href_endpoint)->hrefServiceClass);

	event_end = (struct event_end_info*)DC_MSG_MALLOC(DC_MEM_SUBSCRIPTION, dpws, sizeof(struct event_end_info));
	event_end->subscription_manager = msg->wse__SubscriptionManager;
	event_end->status = msg->wse__Status;

	// Status (if more than one take the one without @lang or in english (first of the 2)
	event_end->reason = find_localized_entry((struct localized_string **)msg->wse__Reason, msg->__sizeReason, registry_cfg.preferred_lang);

	servClass->event_end_hook(event_end);
	return SOAP_OK;
}


/*----------------------------------------------------------------------------*\
 *                                    API                                     *
\*----------------------------------------------------------------------------*/

struct wsa_endpoint_ref * dpws_event_subscribe_ex(
		struct dpws* dpws,
		struct wsa_endpoint_ref* event_source,
		short href_notify_to,
		short href_end_to,
		char ** filter,
		char ** expiration
		)
{
	struct wsa_endpoint_ref * sm;
	http_transport_data_t tdata;
	char local_address[MAX_IP_ADDRESS_STRING_LEN];
	struct wsa_endpoint_ref *notify_to = NULL, *end_to = NULL;

	DC_CHECK_PARAM_RETURN(dpws, NULL);
	DC_CHECK_PARAM_NO_RC(dpws->err, event_source && href_notify_to >= 0 && expiration, NULL);

    /* Connect to retrieve the local IP used for connecting the event source */
	soap_set_endpoint(dpws_dpws2soap(dpws), event_source->address);
	if ((dpws->err = dc_http_open_output_channel(dpws, &tdata, dpws->soap.host, dpws->soap.port)))
		return NULL;
	if ((dpws->err = dc_http_get_local_address(dpws, tdata.base.socket, local_address, MAX_IP_ADDRESS_STRING_LEN)))
		goto error;

	if (!(notify_to = (struct wsa_endpoint_ref *)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct wsa_endpoint_ref))))
	{
		dpws->err = DPWS_ERR_EOM;
		goto error;
	}
	if (!(notify_to = build_local_endpoint_ref(dpws, notify_to, local_address, href_notify_to)))
	{
		goto error;
	}
	if (href_end_to >= 0)
	{
		if (!(end_to = (struct wsa_endpoint_ref *)DC_MSG_MALLOC(DC_MEM_API, dpws, sizeof(struct wsa_endpoint_ref))))
		{
			dpws->err = DPWS_ERR_EOM;
			goto error;
		}
		if (!(end_to = build_local_endpoint_ref(dpws, end_to, local_address, href_end_to)))
		{
			goto error;
		}
	}
	sm = dpws_event_subscribe(dpws, event_source, notify_to, end_to, filter, expiration);
	if ((dpws->err = dc_transport_close_channel(dpws)))
		return NULL;

	return sm;

error:
	dc_transport_close_channel(dpws);
	return NULL;
}

struct wsa_endpoint_ref* dpws_event_subscribe(
		struct dpws* dpws,
		struct wsa_endpoint_ref* event_source,
		struct wsa_endpoint_ref* notify_to,
		struct wsa_endpoint_ref* end_to,
		char ** filter,
		char ** expiration
		)
{
	struct _wse__Subscribe subscription;
	struct wse__DeliveryType delivery;
	struct wse__FilterType s_filter;
	struct _wse__SubscribeResponse response;
	DA_TYPED(str) actions = DA_INITIALIZER(char *, DC_MEM_API, 2);	// wrapper
	struct wsa_endpoint_ref* ret = NULL;
	int nbActions = 0;

	DC_CHECK_PARAM_RETURN(dpws, NULL);
	DC_CHECK_PARAM_NO_RC(dpws->err, event_source && notify_to && expiration, NULL);

    soap_default__wse__Subscribe(dpws_dpws2soap(dpws), &subscription);
	subscription.wse__EndTo = end_to;
	subscription.wse__Delivery = &delivery;
	delivery.Mode = WSE_MODE_PUSH;
	delivery.wse__NotifyTo = notify_to;
#ifdef WITH_WSMAN
	delivery.wsman__Heartbeats = dpws->wsman_headers.heartbeats;
#endif
	subscription.wse__Expires = *expiration;
	if (!filter || !*filter)
		subscription.wse__Filter = NULL;
	else {
		subscription.wse__Filter = &s_filter;
		s_filter.__item = (dyn_array_t *)&actions;
		s_filter.Dialect = event_source->dpws_version->wdp_wse_filtering_dialect;
		actions.tab = filter;	// NOTE: custom uri list marshalling use the null boundary and not the nb field
		while (*filter++) nbActions++;
		actions.nb = nbActions;
	}
	if (dpws_call___wse__SubscribeOp(dpws, event_source, NULL, &subscription, &response))
		goto exit;
	*expiration = response.wse__Expires;
	ret = response.wse__SubscriptionManager;

exit:
    dpws_init_headers_and_version(dpws);
	return ret;
}

int send_eventing_end(struct dpws* dpws, struct device * device)
{
	int ret = DPWS_OK;
	struct wsa_endpoint_ref manager_endpoint;
	struct _wse__SubscriptionEnd body;
	struct end_info eventEndInfo;
	struct wse__LanguageSpecificStringType reason = {NULL, WSE_SUBSCRIPTION_END_REASON},
											*pReason = &reason;

	/* set message data */
	eventEndInfo.dpws = dpws;
	eventEndInfo.pBody = &body;
	soap_default__wse__SubscriptionEnd(dpws_dpws2soap(dpws), &body);
	dpws_default_wsa_endpoint_ref(&manager_endpoint);
	body.wse__SubscriptionManager = &manager_endpoint;
	body.wse__Status = (char *)soap_wse__SubscriptionEndCodeType2s(dpws_dpws2soap(dpws),
		wse__SubscriptionEndCodeType__http___x002f_x002fschemas_x002exmlsoap_x002eorg_x002fws_x002f2004_x002f08_x002feventing_x002fSourceShuttingDown);	// NOTE: Failures are not implemented since altered working is not supported
	body.__sizeReason = 1;
	body.wse__Reason = &pReason;

	DA_BROWSE(&device->hosted_services, send_eventing_end_msg, &eventEndInfo);

 	return ret;
}

/*----------------------------------------------------------------------------*\
 *                   RUNTIME (used by the generated code)                     *
\*----------------------------------------------------------------------------*/

int dpws_serve_subscribe(struct dpws* dpws)
{
	return soap_serve___wse__SubscribeOp(dpws_dpws2soap(dpws));
}
