/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2250 $
|                     $Date: 2009-04-07 17:21:13 +0200 (mar, 07 avr 2009) $
\*============================================================================*/

/*******************************************************************************
*                              INTERNAL DPWS HEADER                            *
*******************************************************************************/
#ifndef _DPWS_H_
#define _DPWS_H_

#include "dc/dc_Types.h"
#include "dc/dc_Constants.h"
#include "dcDPWS_Reactor.h"
#include "dcCOMN_Handle.h"

/* Message status codes */
// bit 0 exchange step: resquest = 0, response = 1
// bit 1 communication way: send = 0, receive = 1
// bit 2 transport: tcp = 0, udp = 1
// bit 3 mode: unicast = 0, multicast = 1
// bit 4-9 message type. None = 'user'
// bit 4: hello
// bit 5: bye
// bit 6: probe
// bit 7: probe match
// bit 8: resolve
// bit 9: resolve match
// bit 10: discovery proxy hello
// bit 11: directed probe

#define DPWS_MSG_TYPES			(0x0FF0)
#define DPWS_MSG_TYPES_MASK		(0xF00F)

#define DPWS_MSG_HELLO			(0x0010)
#define DPWS_MSG_BYE			(0x0020)
#define DPWS_MSG_PROBE			(0x0040)
#define DPWS_MSG_PROBE_MATCH	(0x0080)
#define DPWS_MSG_RESOLVE		(0x0100)
#define DPWS_MSG_RESOLVE_MATCH	(0x0200)
#define DPWS_MSG_DP_HELLO		(0x0400)
#define DPWS_MSG_DIRECTED_PROBE	(0x0800)

#define DPWS_GET_MSG_TYPE(s) (s & DPWS_MSG_TYPES)
#define DPWS_IS_DISCOVERY(s) (DPWS_GET_MSG_TYPE(s))

#define DPWS_MULTICAST_MSG(s) (s & 0x0170)
#define DPWS_POLICY_MSG(s) (s & 0x0290)
#define DPWS_APP_SEQ_MSG(s) (s & 0x06B0)
#define DPWS_APP_DELAY_MSG(s) (s & 0x0090)
#define DPWS_RESET_MSG_TYPE(s) (s &= DPWS_MSG_TYPES_MASK)

#define DPWS_SET_REQUEST(s) (s &= 0xFFFE)
#define DPWS_SET_RESPONSE(s) (s |= 0x0001)
#define DPWS_IS_RESPONSE(s) (s & 0x0001)

#define DPWS_SET_SEND(s) (s &= 0xFFFD)
#define DPWS_SET_RCV(s) (s |= 0x0002)
#define DPWS_IS_RCV(s) (s & 0x0002)

#define DPWS_SET_TCP(s) (s &= 0xFFFB)
#define DPWS_SET_UDP(s) (s |= 0x0004)
#define DPWS_IS_UDP(s) (s & 0x0004)

#define DPWS_SET_UNICAST(s) (s &= 0xFFF7)
#define DPWS_SET_MULTICAST(s) (s |= 0x0008)
#define DPWS_IS_MULTICAST(s) (s & 0x0008)

#define DPWS_SET_USER(s) (s &= DPWS_MSG_TYPES_MASK)
#define DPWS_IS_USER(s) (DPWS_GET_MSG_TYPE(s) == 0x0000)

#define DPWS_SET_HELLO(s) (s = DPWS_MSG_HELLO | (s & DPWS_MSG_TYPES_MASK))
#define DPWS_IS_HELLO(s) (DPWS_GET_MSG_TYPE(s) == DPWS_MSG_HELLO)

#define DPWS_SET_BYE(s) (s = DPWS_MSG_BYE | (s & DPWS_MSG_TYPES_MASK))
#define DPWS_IS_BYE(s) ((DPWS_GET_MSG_TYPE(s) == DPWS_MSG_BYE)

#define DPWS_SET_PROBE(s) (s = DPWS_MSG_PROBE | (s & DPWS_MSG_TYPES_MASK))
#define DPWS_IS_PROBE(s) (DPWS_GET_MSG_TYPE(s) == DPWS_MSG_PROBE)

#define DPWS_SET_PROBE_MATCH(s) (s = DPWS_MSG_PROBE_MATCH | (s & DPWS_MSG_TYPES_MASK))
#define DPWS_IS_PROBE_MATCH(s) (DPWS_GET_MSG_TYPE(s) == DPWS_MSG_PROBE_MATCH)

#define DPWS_SET_RESOLVE(s) (s = DPWS_MSG_RESOLVE | (s & DPWS_MSG_TYPES_MASK))
#define DPWS_IS_RESOLVE(s) (DPWS_GET_MSG_TYPE(s) == DPWS_MSG_RESOLVE)

#define DPWS_SET_RESOLVE_MATCH(s) (s = DPWS_MSG_RESOLVE_MATCH | (s & DPWS_MSG_TYPES_MASK))
#define DPWS_IS_RESOLVE_MATCH(s) (DPWS_GET_MSG_TYPE(s) == DPWS_MSG_RESOLVE_MATCH)

#define DPWS_SET_DP_HELLO(s) (s = DPWS_MSG_DP_HELLO | (s & DPWS_MSG_TYPES_MASK))
#define DPWS_IS_DP_HELLO(s) (DPWS_GET_MSG_TYPE(s) == DPWS_MSG_DP_HELLO)

#define DPWS_SET_DIRECTED_PROBE(s) (s = DPWS_MSG_DIRECTED_PROBE | (s & DPWS_MSG_TYPES_MASK))
#define DPWS_IS_DIRECTED_PROBE(s) (DPWS_GET_MSG_TYPE(s) == DPWS_MSG_DIRECTED_PROBE)

#define DPWS_INIT_STATUS(s) (s = 0x0)	//request,send,tcp,unicast,user

#define DPWS_SET_UDP_MULTICAST(s) (s |= 0x000C)
#define DPWS_IS_UDP_RCV_MULTICAST(s) ((s & 0x000E) == 0x000E)

#define DPWS_IS_DISCOVERY_RESP_MSG(s) (s & 0x0680)	//probe match, resolve match or discovery proxy hello


#define DPWS_ERR_UDP_TIMEOUT					1300	// internal


#define QNAME_PREFIX_GEN_PREFIX "ns"
#define QNAME_PREFIX_GEN_LEN 	(sizeof(QNAME_PREFIX_GEN_PREFIX) + sizeof(MAX_SERVICES_PER_DEVICE))

#define dpws_endpoint_ref_is_null(endpoint) (!((endpoint).address))

/*----------------------------------------------------------------------------*\
 *                                INTERNAL API                                *
\*----------------------------------------------------------------------------*/

extern struct dpws_protocols * default_protocols;	/**< The default DPWS protocol literals. */
extern struct dpws_protocols * dpws_protocols[];	/**< The DPWS protocol literals for all supported versions. */
extern dcpl_mutex_t * reactor_lock;	/**< The stack global reactor lock. */
extern handlePool_t reactor_handle_pool;

/** Sends one way or asynchronous empty response.
 * Currently used by the HTTP transport.
 * @param dpws A pointer on a dpws runtime data structure.
 * @return DPWS_OK, if no error occurred. A DPWS or gSOAP error code otherwise.
 */
int dpws_send_empty_response(struct dpws * dpws);

/**
 * Sets the WS-Addressing version corresponding to the URI
 * @param dpws A pointer on a dpws runtime data structure.
 * @param uri The WS-Addressing URI
 * @return 0 if the WS-Addressing version is supported, -1 otherwise
 */
int set_wsa_version(struct dpws * dpws, const char* wsa_uri);

/**
 * Compares the parameter to the discovery URN for several WS-Discovery
 * versions and sets the current version of DPWS if the URI matches
 * @param dpws A pointer on a dpws runtime data structure.
 * @param disco_urn The URI to be checked
 * @return 1 if the URI is a discovery URN, 0 otherwise
 */
int is_discovery_urn(struct dpws * dpws, const char* disco_urn);

/**
 * Returns the list of possible DPWS protocols, based on available information
 * (including information on WS-Addressing and DPWS versions already present
 * in the DPWS structure).
 * @param dpws A pointer on a dpws runtime data structure.
 * @param protocols An array in which the possible protocols versions will be stored
 * @param maxsize The size of the array
 * @return The number of protocols versions returned in the array
 */
int get_protocols_versions(struct dpws * dpws, struct dpws_protocols ** protocols, int maxsize);

/** Initializes a WS-Addressing EPR as anonymous according to the current
 * version of the protocol.
 * @param dpws The message context containing protocol information.
 * @param[in,out] a A pointer on the EPR structure ro initialize.
 */
void dpws_set_anonymous_wsa_endpoint_ref(struct dpws * dpws, struct wsa_endpoint_ref *a);

#endif /*_DPWS_H_*/
