/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 818 $
|                     $Date: 2008-03-13 12:51:13 +0100 (jeu., 13 mars 2008) $
\*============================================================================*/
/******************************************************************************\
 *                          Module Memory Facilities                          *
\******************************************************************************/
#ifndef DPWS_MEMORY_H_
#define DPWS_MEMORY_H_

#include "dcGSOAP_Runtime.h"	// includes stdsoap2.h
#include "dc/dc_Types.h"

/*----------------------------------------------------------------------------*\
 *                       Allocation redirection macros                        *
\*----------------------------------------------------------------------------*/
#ifndef DC_MSG_MALLOC
# define DC_MSG_MALLOC(mod, dpws, size) soap_malloc(dpws_dpws2soap(dpws), size)	/**< Macro to use for transient message-related allocations */
#endif

#ifndef DC_MSG_STRDUP
# define DC_MSG_STRDUP(mod, dpws, s) soap_strdup(dpws_dpws2soap(dpws), s)	/**< Macro to use for transient message-related allocations */
#endif

/*----------------------------------------------------------------------------*\
 *                                 Dynamic array                              *
\*----------------------------------------------------------------------------*/

/** A typed-array of localized strings structures */
DA_TYPED_DECL(lstr, localized_string_t);
/** A typed-array of QName structures */
DA_TYPED_DECL(qn, qname_t);
/** A typed-array of prefixed QName structures */
DA_TYPED_DECL(pqn, prefixed_qname_t);
/** A typed-array of WS-Addressing EPR structure pointers */
DA_TYPED_DECL(pepr, struct wsa_endpoint_ref *);
/** A typed-array of service metadata structure pointers */
DA_TYPED_DECL(psi, struct service_info *);
/** A typed-array of WSDL info structure pointers */
DA_TYPED_DECL(pwi, struct wsdl_info *);


#endif /*DPWS_MEMORY_H_*/
