/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|                      ->>  Copyright 2008 Odonata <<-                         |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1772 $
|                     $Date: 2008-10-09 11:57:03 +0200 (jeu., 09 oct. 2008) $
\*============================================================================*/

/***************************************************************************//**
* \file
* DPWSCore Portability layer error managements.
*******************************************************************************/

#ifndef DCDCPL_ERROR_H_
#define DCDCPL_ERROR_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * A structure that is passed to most DCPL API to get a maximum of information
 * about a platform error.
 */
typedef struct dcpl_error {
	int error;		/**< The DCPL error code */
	int syserr;		/**< The system error code */
	char* detail;	/**< Optional detail information */
} dcpl_error_t;

/* Generic error codes */
#define DCPL_OK								0

#define DCPL_EOM_ERROR						-10
#define DCPL_NOT_SUPPORTED_ERROR			-11
#define DCPL_ILLEGAL_OPERATION				-12

/* Socket error codes */
#define DCPL_MAX_SOCKET_ERROR				-100

#define DCPL_SOCKET_CREATE_ERROR			-100
#define DCPL_SOCKET_BIND_ERROR				-101
#define DCPL_SOCKET_LISTEN_ERROR			-102
#define DCPL_SOCKET_ACCEPT_ERROR			-103
#define DCPL_SOCKET_CONNECT_ERROR			-104
#define DCPL_SOCKET_GETSOCKNAME_ERROR		-105
#define DCPL_SOCKET_CLOSE_ERROR				-106
#define DCPL_SOCKET_SHUTDOWN_ERROR			-107

#define DCPL_SOCKET_SO_ERROR				-110
#define DCPL_SOCKET_REUSEADDR_ERROR			-111

#define DCPL_SOCKET_JOIN_GROUP_ERROR		-120
#define DCPL_SOCKET_LEAVE_GROUP_ERROR		-121
#define DCPL_SOCKET_MULTICAST_IF_ERROR		-122
#define DCPL_SOCKET_MULTICAST_HOPS_ERROR	-123
#define DCPL_SOCKET_PACKET_INFO				-124

#define DCPL_SOCKET_RECV_ERROR				-130
#define DCPL_SOCKET_SEND_ERROR				-131
#define DCPL_SOCKET_SELECT_ERROR			-132
#define DCPL_SOCKET_TIMEOUT_ERROR			-133
#define DCPL_SOCKET_RESOLVE_ERROR			-134

/* Reactor error codes */
#define DCPL_REACTOR_INTR					-200	/**< Reactor interrupted */


/** Initialize a DPCL error structure to "No error".
 * @param error_info The error structure to initialize.
 * @return A DCPL error code.
 */
int dcpl_init_error(struct dcpl_error * error_info);

/** Set a DPCL error structure.
 * The \a syserr member should be set automatically.
 * @param error_info The error structure to initialize.
 * @param error The DPCL error.
 * @param detail An optional message string.
 * @return A DCPL error code.
 */
int dcpl_set_error(struct dcpl_error * error_info, int error, char* detail);

/** Get a message for a DCPL error.
 * @param error_info The DCPL error structure.
 * @param error_string_buf A buffer where the error string can be written
 * @param buflen The size of the buffer
 * @return An error message.
 */
const char* dcpl_error_string(struct dcpl_error * error_info, char * error_string_buf, int buflen);

#ifdef __cplusplus
}
#endif


#endif
