/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/******************************************************************************\
 *                          Generic list utilities                            *
\******************************************************************************/
#include "dcCOMN_ListUtils.h"

#define NULL 0

/*----------------------------------------------------------------------------*\
 *                         Simple chained list utilies                        *
\*----------------------------------------------------------------------------*/
void scl_add(p_scl_list_t list, p_scl_node_t node)
{
	node->next = list->next;
	list->next = node;
}

p_scl_node_t scl_get(p_scl_list_t list, int pos)
{
	int i = 0;
	p_scl_node_t n;

	for (n = list->next; n; n = n->next) {
		if (i == pos)
			break;
		i++;
	}
	return n;
}

p_scl_node_t scl_find(p_scl_list_t list, scl_match_cbk_t comparator, void * cbk_data)
{
	p_scl_node_t n;

	for (n = list->next; n; n = n->next) {
		if (comparator(n, cbk_data))
			break;
	}
	return n;
}


p_scl_node_t scl_remove(p_scl_list_t list)
{
	p_scl_node_t n;
	n = list->next;
	list->next = n->next;
	n->next = NULL;
	return n;
}

/*----------------------------------------------------------------------------*\
 *                         Double chained list utilies                        *
\*----------------------------------------------------------------------------*/
void dcl_add_first(p_dcl_list_t list, p_dcl_node_t node)
{
	node->next = list->first;
	if (list->first)
		list->first->previous = node;
	else
		list->last = node;
	node->previous = NULL;
	list->first = node;
}

void dcl_add_last(p_dcl_list_t list, p_dcl_node_t node)
{
	node->next = NULL;
	if (list->last)
		list->last->next = node;
	else
		list->first = node;
	node->previous = list->last;
	list->last = node;
}

void dcl_remove(p_dcl_list_t list, p_dcl_node_t node)
{
	if (node->previous)
		node->previous->next = node->next;
	else
		list->first = node->next;
	if (node->next)
		node->next->previous = node->previous;
	else
		list->last = node->previous;
	node->next = node->previous = NULL;
}

void dcl_insert(p_dcl_list_t list, p_dcl_node_t node, dcl_cmp_cbk_t comparator)
{
	p_dcl_node_t wNode;

	if (!list->first || comparator(node, list->first) >= 0)
		dcl_add_first(list, node);
	else {
		for (wNode = list->first; wNode->next; wNode = wNode->next)
		{
			if (comparator(node, wNode->next) >= 0)
			{
				node->previous = wNode;
				node->next = wNode->next;
				wNode->next->previous = node;
				wNode->next = node;
				break;
			}
		}
		if (!wNode->next)
			dcl_add_last(list, node);
	}
}
