DC_IBS_DIR?=../../../../gnu
include $(DC_IBS_DIR)/common.mk

FULL_SHARED_EXT?=$(SHARED_EXT)
CPPFLAGS+= $(SHARED_CPPFLAGS)

all: static shared

.PHONY: all static shared clean cleanall distclean
		
static: $(MAKE_TOOL_DEPS) lib$(DC_SC)$(STATIC_EXT)

lib$(DC_SC)$(STATIC_EXT): $(OBJS)
		$(AR) cr lib$(DC_SC)$(STATIC_EXT) $(OBJS)

shared: prerequisites $(SHARED_PREFIX)$(DC_TC)$(FULL_SHARED_EXT)

prerequisites: $(MAKE_STATIC_DEPS) $(MAKE_SHARED_DEPS)
		
$(SHARED_PREFIX)$(DC_TC)$(FULL_SHARED_EXT): $(OBJS) $(STATIC_DEPS) $(SHARED_DEPS)
		$(LINKER) -shared $(CUSTOM_SHARED_LIB_OPTIONS) $(CMFLAGS) -o $(SHARED_PREFIX)$(DC_TC)$(FULL_SHARED_EXT) $(OBJS) $(LDFLAGS) $(LIBS)
		$(CUSTOM_BUILD_SHARED_CMD)

$(MAKE_SHARED_DEPS): %.mak:
		$(MAKE) -C $(DC_TARGET_DIR)/$*/$(DC_ARCH) shared

clean:
		-rm *.o lib*$(STATIC_EXT) $(SHARED_PREFIX)*$(SHARED_EXT)* $(CUSTOM_OUTPUT_FILES)

distclean: cleanall $(CLEAN_DEPS)
		
$(CLEAN_DEPS): %.clean:
		$(MAKE) -C $(DC_TARGET_DIR)/$*/$(DC_ARCH) distclean
