/* eventsourceC.c
   Generated by gSOAP 2.7.6c from ../../../../../src/dpws/src/eventsource.gsoap
   Copyright (C) 2000-2005, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "eventsourceH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) eventsourceC.c ver 2.7.6c 2009-04-17 13:17:56 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
	soap->part = SOAP_END_HEADER;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE__wse__EventSource:
		return soap_in__wse__EventSource(soap, NULL, NULL, "wse:EventSource");
	case SOAP_TYPE_wse__SubscriptionEndCodeType:
		return soap_in_wse__SubscriptionEndCodeType(soap, NULL, NULL, "wse:SubscriptionEndCodeType");
	case SOAP_TYPE_xsd__boolean:
		return soap_in_xsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_SOAP_ENV__Reason:
		return soap_in_SOAP_ENV__Reason(soap, NULL, NULL, "SOAP-ENV:Reason");
	case SOAP_TYPE_wse__LanguageSpecificStringType:
		return soap_in_wse__LanguageSpecificStringType(soap, NULL, NULL, "wse:LanguageSpecificStringType");
	case SOAP_TYPE__wse__SubscriptionEnd:
		return soap_in__wse__SubscriptionEnd(soap, NULL, NULL, "wse:SubscriptionEnd");
	case SOAP_TYPE__wse__SubscribeResponse:
		return soap_in__wse__SubscribeResponse(soap, NULL, NULL, "wse:SubscribeResponse");
	case SOAP_TYPE__wse__Subscribe:
		return soap_in__wse__Subscribe(soap, NULL, NULL, "wse:Subscribe");
	case SOAP_TYPE_wse__FilterType:
		return soap_in_wse__FilterType(soap, NULL, NULL, "wse:FilterType");
	case SOAP_TYPE_wse__DeliveryType:
		return soap_in_wse__DeliveryType(soap, NULL, NULL, "wse:DeliveryType");
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		return soap_in_PointerToSOAP_ENV__Reason(soap, NULL, NULL, "SOAP-ENV:Reason");
	case SOAP_TYPE_PointerTo_wse__SubscriptionEnd:
		return soap_in_PointerTo_wse__SubscriptionEnd(soap, NULL, NULL, "wse:SubscriptionEnd");
	case SOAP_TYPE_PointerTo_wse__SubscribeResponse:
		return soap_in_PointerTo_wse__SubscribeResponse(soap, NULL, NULL, "wse:SubscribeResponse");
	case SOAP_TYPE_PointerTo_wse__Subscribe:
		return soap_in_PointerTo_wse__Subscribe(soap, NULL, NULL, "wse:Subscribe");
	case SOAP_TYPE__wse__SupportedDeliveryMode:
	{	char **s;
		s = soap_in__wse__SupportedDeliveryMode(soap, NULL, NULL, "wse:SupportedDeliveryMode");
		return s ? *s : NULL;
	}
	case SOAP_TYPE__wse__SupportedDialect:
	{	char **s;
		s = soap_in__wse__SupportedDialect(soap, NULL, NULL, "wse:SupportedDialect");
		return s ? *s : NULL;
	}
	case SOAP_TYPE__wse__Identifier:
	{	char **s;
		s = soap_in__wse__Identifier(soap, NULL, NULL, "wse:Identifier");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerToPointerTowse__LanguageSpecificStringType:
		return soap_in_PointerToPointerTowse__LanguageSpecificStringType(soap, NULL, NULL, "wse:LanguageSpecificStringType");
	case SOAP_TYPE_PointerTowse__LanguageSpecificStringType:
		return soap_in_PointerTowse__LanguageSpecificStringType(soap, NULL, NULL, "wse:LanguageSpecificStringType");
	case SOAP_TYPE_PointerTowse__FilterType:
		return soap_in_PointerTowse__FilterType(soap, NULL, NULL, "wse:FilterType");
	case SOAP_TYPE_PointerTowse__DeliveryType:
		return soap_in_PointerTowse__DeliveryType(soap, NULL, NULL, "wse:DeliveryType");
	case SOAP_TYPE_wse__NonNegativeDurationType:
	{	char **s;
		s = soap_in_wse__NonNegativeDurationType(soap, NULL, NULL, "wse:NonNegativeDurationType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_wse__OpenSubscriptionEndCodeType:
	{	char **s;
		s = soap_in_wse__OpenSubscriptionEndCodeType(soap, NULL, NULL, "wse:OpenSubscriptionEndCodeType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_wse__ExpirationType:
	{	char **s;
		s = soap_in_wse__ExpirationType(soap, NULL, NULL, "wse:ExpirationType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE__xml__lang:
	{	char **s;
		s = soap_in__xml__lang(soap, NULL, NULL, "xml:lang");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__duration:
	{	char **s;
		s = soap_in_xsd__duration(soap, NULL, NULL, "xsd:duration");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_uri_list:
		return soap_in_uri_list(soap, NULL, NULL, "uri-list");
	case SOAP_TYPE_qname_list:
		return soap_in_qname_list(soap, NULL, NULL, "qname-list");
	case SOAP_TYPE_endpoint_ref:
		return soap_in_endpoint_ref(soap, NULL, NULL, "endpoint-ref");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wse:EventSource"))
		{	*type = SOAP_TYPE__wse__EventSource;
			return soap_in__wse__EventSource(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wse:SubscriptionEndCodeType"))
		{	*type = SOAP_TYPE_wse__SubscriptionEndCodeType;
			return soap_in_wse__SubscriptionEndCodeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_xsd__boolean;
			return soap_in_xsd__boolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SOAP-ENV:Reason"))
		{	*type = SOAP_TYPE_SOAP_ENV__Reason;
			return soap_in_SOAP_ENV__Reason(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wse:LanguageSpecificStringType"))
		{	*type = SOAP_TYPE_wse__LanguageSpecificStringType;
			return soap_in_wse__LanguageSpecificStringType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wse:SubscriptionEnd"))
		{	*type = SOAP_TYPE__wse__SubscriptionEnd;
			return soap_in__wse__SubscriptionEnd(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wse:SubscribeResponse"))
		{	*type = SOAP_TYPE__wse__SubscribeResponse;
			return soap_in__wse__SubscribeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wse:Subscribe"))
		{	*type = SOAP_TYPE__wse__Subscribe;
			return soap_in__wse__Subscribe(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wse:FilterType"))
		{	*type = SOAP_TYPE_wse__FilterType;
			return soap_in_wse__FilterType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wse:DeliveryType"))
		{	*type = SOAP_TYPE_wse__DeliveryType;
			return soap_in_wse__DeliveryType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wse:SupportedDeliveryMode"))
		{	char **s;
			*type = SOAP_TYPE__wse__SupportedDeliveryMode;
			s = soap_in__wse__SupportedDeliveryMode(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wse:SupportedDialect"))
		{	char **s;
			*type = SOAP_TYPE__wse__SupportedDialect;
			s = soap_in__wse__SupportedDialect(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wse:Identifier"))
		{	char **s;
			*type = SOAP_TYPE__wse__Identifier;
			s = soap_in__wse__Identifier(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wse:NonNegativeDurationType"))
		{	char **s;
			*type = SOAP_TYPE_wse__NonNegativeDurationType;
			s = soap_in_wse__NonNegativeDurationType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wse:OpenSubscriptionEndCodeType"))
		{	char **s;
			*type = SOAP_TYPE_wse__OpenSubscriptionEndCodeType;
			s = soap_in_wse__OpenSubscriptionEndCodeType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wse:ExpirationType"))
		{	char **s;
			*type = SOAP_TYPE_wse__ExpirationType;
			s = soap_in_wse__ExpirationType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xml:lang"))
		{	char **s;
			*type = SOAP_TYPE__xml__lang;
			s = soap_in__xml__lang(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:duration"))
		{	char **s;
			*type = SOAP_TYPE_xsd__duration;
			s = soap_in_xsd__duration(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE__wse__EventSource:
		return soap_out__wse__EventSource(soap, "wse:EventSource", id, (const enum xsd__boolean *)ptr, NULL);
	case SOAP_TYPE_wse__SubscriptionEndCodeType:
		return soap_out_wse__SubscriptionEndCodeType(soap, tag, id, (const enum wse__SubscriptionEndCodeType *)ptr, "wse:SubscriptionEndCodeType");
	case SOAP_TYPE_xsd__boolean:
		return soap_out_xsd__boolean(soap, tag, id, (const enum xsd__boolean *)ptr, "xsd:boolean");
	case SOAP_TYPE_SOAP_ENV__Reason:
		return soap_out_SOAP_ENV__Reason(soap, tag, id, (const struct SOAP_ENV__Reason *)ptr, "SOAP-ENV:Reason");
	case SOAP_TYPE_wse__LanguageSpecificStringType:
		return soap_out_wse__LanguageSpecificStringType(soap, tag, id, (const struct wse__LanguageSpecificStringType *)ptr, "wse:LanguageSpecificStringType");
	case SOAP_TYPE__wse__SubscriptionEnd:
		return soap_out__wse__SubscriptionEnd(soap, "wse:SubscriptionEnd", id, (const struct _wse__SubscriptionEnd *)ptr, NULL);
	case SOAP_TYPE__wse__SubscribeResponse:
		return soap_out__wse__SubscribeResponse(soap, "wse:SubscribeResponse", id, (const struct _wse__SubscribeResponse *)ptr, NULL);
	case SOAP_TYPE__wse__Subscribe:
		return soap_out__wse__Subscribe(soap, "wse:Subscribe", id, (const struct _wse__Subscribe *)ptr, NULL);
	case SOAP_TYPE_wse__FilterType:
		return soap_out_wse__FilterType(soap, tag, id, (const struct wse__FilterType *)ptr, "wse:FilterType");
	case SOAP_TYPE_wse__DeliveryType:
		return soap_out_wse__DeliveryType(soap, tag, id, (const struct wse__DeliveryType *)ptr, "wse:DeliveryType");
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		return soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, (struct SOAP_ENV__Reason *const*)ptr, "SOAP-ENV:Reason");
	case SOAP_TYPE_PointerTo_wse__SubscriptionEnd:
		return soap_out_PointerTo_wse__SubscriptionEnd(soap, tag, id, (struct _wse__SubscriptionEnd *const*)ptr, "wse:SubscriptionEnd");
	case SOAP_TYPE_PointerTo_wse__SubscribeResponse:
		return soap_out_PointerTo_wse__SubscribeResponse(soap, tag, id, (struct _wse__SubscribeResponse *const*)ptr, "wse:SubscribeResponse");
	case SOAP_TYPE_PointerTo_wse__Subscribe:
		return soap_out_PointerTo_wse__Subscribe(soap, tag, id, (struct _wse__Subscribe *const*)ptr, "wse:Subscribe");
	case SOAP_TYPE__wse__SupportedDeliveryMode:
		return soap_out_string(soap, "wse:SupportedDeliveryMode", id, (char**)&ptr, NULL);
	case SOAP_TYPE__wse__SupportedDialect:
		return soap_out_string(soap, "wse:SupportedDialect", id, (char**)&ptr, NULL);
	case SOAP_TYPE__wse__Identifier:
		return soap_out_string(soap, "wse:Identifier", id, (char**)&ptr, NULL);
	case SOAP_TYPE_PointerToPointerTowse__LanguageSpecificStringType:
		return soap_out_PointerToPointerTowse__LanguageSpecificStringType(soap, tag, id, (struct wse__LanguageSpecificStringType **const*)ptr, "wse:LanguageSpecificStringType");
	case SOAP_TYPE_PointerTowse__LanguageSpecificStringType:
		return soap_out_PointerTowse__LanguageSpecificStringType(soap, tag, id, (struct wse__LanguageSpecificStringType *const*)ptr, "wse:LanguageSpecificStringType");
	case SOAP_TYPE_PointerTowse__FilterType:
		return soap_out_PointerTowse__FilterType(soap, tag, id, (struct wse__FilterType *const*)ptr, "wse:FilterType");
	case SOAP_TYPE_PointerTowse__DeliveryType:
		return soap_out_PointerTowse__DeliveryType(soap, tag, id, (struct wse__DeliveryType *const*)ptr, "wse:DeliveryType");
	case SOAP_TYPE_wse__NonNegativeDurationType:
		return soap_out_string(soap, tag, id, (char**)&ptr, "wse:NonNegativeDurationType");
	case SOAP_TYPE_wse__OpenSubscriptionEndCodeType:
		return soap_out_string(soap, tag, id, (char**)&ptr, "wse:OpenSubscriptionEndCodeType");
	case SOAP_TYPE_wse__ExpirationType:
		return soap_out_string(soap, tag, id, (char**)&ptr, "wse:ExpirationType");
	case SOAP_TYPE__xml__lang:
		return soap_out_string(soap, "xml:lang", id, (char**)&ptr, NULL);
	case SOAP_TYPE_xsd__duration:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:duration");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:anyURI");
	case SOAP_TYPE_uri_list:
		return soap_out_uri_list(soap, tag, id, (struct dynamic_array *const*)ptr, "uri-list");
	case SOAP_TYPE_qname_list:
		return soap_out_qname_list(soap, tag, id, (struct dynamic_array *const*)ptr, "qname-list");
	case SOAP_TYPE_endpoint_ref:
		return soap_out_endpoint_ref(soap, tag, id, (struct wsa_endpoint_ref *const*)ptr, "endpoint-ref");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_SOAP_ENV__Reason:
		soap_serialize_SOAP_ENV__Reason(soap, (const struct SOAP_ENV__Reason *)ptr);
		break;
	case SOAP_TYPE___wse__SubscriptionEnd:
		soap_serialize___wse__SubscriptionEnd(soap, (const struct __wse__SubscriptionEnd *)ptr);
		break;
	case SOAP_TYPE___wse__SubscribeOp:
		soap_serialize___wse__SubscribeOp(soap, (const struct __wse__SubscribeOp *)ptr);
		break;
	case SOAP_TYPE_wse__LanguageSpecificStringType:
		soap_serialize_wse__LanguageSpecificStringType(soap, (const struct wse__LanguageSpecificStringType *)ptr);
		break;
	case SOAP_TYPE__wse__SubscriptionEnd:
		soap_serialize__wse__SubscriptionEnd(soap, (const struct _wse__SubscriptionEnd *)ptr);
		break;
	case SOAP_TYPE__wse__SubscribeResponse:
		soap_serialize__wse__SubscribeResponse(soap, (const struct _wse__SubscribeResponse *)ptr);
		break;
	case SOAP_TYPE__wse__Subscribe:
		soap_serialize__wse__Subscribe(soap, (const struct _wse__Subscribe *)ptr);
		break;
	case SOAP_TYPE_wse__FilterType:
		soap_serialize_wse__FilterType(soap, (const struct wse__FilterType *)ptr);
		break;
	case SOAP_TYPE_wse__DeliveryType:
		soap_serialize_wse__DeliveryType(soap, (const struct wse__DeliveryType *)ptr);
		break;
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		soap_serialize_PointerToSOAP_ENV__Reason(soap, (struct SOAP_ENV__Reason *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wse__SubscriptionEnd:
		soap_serialize_PointerTo_wse__SubscriptionEnd(soap, (struct _wse__SubscriptionEnd *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wse__SubscribeResponse:
		soap_serialize_PointerTo_wse__SubscribeResponse(soap, (struct _wse__SubscribeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wse__Subscribe:
		soap_serialize_PointerTo_wse__Subscribe(soap, (struct _wse__Subscribe *const*)ptr);
		break;
	case SOAP_TYPE__wse__SupportedDeliveryMode:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__wse__SupportedDialect:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__wse__Identifier:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_PointerToPointerTowse__LanguageSpecificStringType:
		soap_serialize_PointerToPointerTowse__LanguageSpecificStringType(soap, (struct wse__LanguageSpecificStringType **const*)ptr);
		break;
	case SOAP_TYPE_PointerTowse__LanguageSpecificStringType:
		soap_serialize_PointerTowse__LanguageSpecificStringType(soap, (struct wse__LanguageSpecificStringType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowse__FilterType:
		soap_serialize_PointerTowse__FilterType(soap, (struct wse__FilterType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowse__DeliveryType:
		soap_serialize_PointerTowse__DeliveryType(soap, (struct wse__DeliveryType *const*)ptr);
		break;
	case SOAP_TYPE_wse__NonNegativeDurationType:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_wse__OpenSubscriptionEndCodeType:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_wse__ExpirationType:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__xml__lang:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__duration:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_uri_list:
		soap_serialize_uri_list(soap, (struct dynamic_array *const*)ptr);
		break;
	case SOAP_TYPE_qname_list:
		soap_serialize_qname_list(soap, (struct dynamic_array *const*)ptr);
		break;
	case SOAP_TYPE_endpoint_ref:
		soap_serialize_endpoint_ref(soap, (struct wsa_endpoint_ref *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wse__EventSource(struct soap *soap, enum xsd__boolean *a)
{	soap_default_xsd__boolean(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wse__EventSource(struct soap *soap, const enum xsd__boolean *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wse__EventSource);
	if (soap_out__wse__EventSource(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3S const char* SOAP_FMAC4S soap__wse__EventSource2s(struct soap *soap, enum xsd__boolean n)
{	return soap_xsd__boolean2s(soap, n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wse__EventSource(struct soap *soap, const char *tag, int id, const enum xsd__boolean *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wse__EventSource), type);
	soap_send(soap, soap__wse__EventSource2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum xsd__boolean * SOAP_FMAC4 soap_get__wse__EventSource(struct soap *soap, enum xsd__boolean *p, const char *tag, const char *type)
{
	if ((p = soap_in__wse__EventSource(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2_wse__EventSource(struct soap *soap, const char *s, enum xsd__boolean *a)
{
	return soap_s2xsd__boolean(soap, s, a);
}

SOAP_FMAC3 enum xsd__boolean * SOAP_FMAC4 soap_in__wse__EventSource(struct soap *soap, const char *tag, enum xsd__boolean *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, "xsd:boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum xsd__boolean *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wse__EventSource, sizeof(enum xsd__boolean), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2_wse__EventSource(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum xsd__boolean *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wse__EventSource, 0, sizeof(enum xsd__boolean), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wse__SubscriptionEndCodeType(struct soap *soap, enum wse__SubscriptionEndCodeType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wse__SubscriptionEndCodeType
	*a = SOAP_DEFAULT_wse__SubscriptionEndCodeType;
#else
	*a = (enum wse__SubscriptionEndCodeType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wse__SubscriptionEndCodeType(struct soap *soap, const enum wse__SubscriptionEndCodeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wse__SubscriptionEndCodeType);
	if (soap_out_wse__SubscriptionEndCodeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_wse__SubscriptionEndCodeType[] =
{	{ (long)wse__SubscriptionEndCodeType__http___x002f_x002fschemas_x002exmlsoap_x002eorg_x002fws_x002f2004_x002f08_x002feventing_x002fDeliveryFailure, "http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryFailure" },
	{ (long)wse__SubscriptionEndCodeType__http___x002f_x002fschemas_x002exmlsoap_x002eorg_x002fws_x002f2004_x002f08_x002feventing_x002fSourceShuttingDown, "http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceShuttingDown" },
	{ (long)wse__SubscriptionEndCodeType__http___x002f_x002fschemas_x002exmlsoap_x002eorg_x002fws_x002f2004_x002f08_x002feventing_x002fSourceCancelling, "http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceCancelling" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wse__SubscriptionEndCodeType2s(struct soap *soap, enum wse__SubscriptionEndCodeType n)
{	const char *s = soap_str_code(soap_codes_wse__SubscriptionEndCodeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wse__SubscriptionEndCodeType(struct soap *soap, const char *tag, int id, const enum wse__SubscriptionEndCodeType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wse__SubscriptionEndCodeType), type);
	soap_send(soap, soap_wse__SubscriptionEndCodeType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum wse__SubscriptionEndCodeType * SOAP_FMAC4 soap_get_wse__SubscriptionEndCodeType(struct soap *soap, enum wse__SubscriptionEndCodeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wse__SubscriptionEndCodeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wse__SubscriptionEndCodeType(struct soap *soap, const char *s, enum wse__SubscriptionEndCodeType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return SOAP_OK;
	soap_s2QName(soap, s, &t);
	map = soap_code(soap_codes_wse__SubscriptionEndCodeType, t);
	if (map)
		*a = (enum wse__SubscriptionEndCodeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum wse__SubscriptionEndCodeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wse__SubscriptionEndCodeType * SOAP_FMAC4 soap_in_wse__SubscriptionEndCodeType(struct soap *soap, const char *tag, enum wse__SubscriptionEndCodeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum wse__SubscriptionEndCodeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wse__SubscriptionEndCodeType, sizeof(enum wse__SubscriptionEndCodeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wse__SubscriptionEndCodeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wse__SubscriptionEndCodeType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wse__SubscriptionEndCodeType, 0, sizeof(enum wse__SubscriptionEndCodeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__boolean(struct soap *soap, enum xsd__boolean *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_xsd__boolean
	*a = SOAP_DEFAULT_xsd__boolean;
#else
	*a = (enum xsd__boolean)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__boolean(struct soap *soap, const enum xsd__boolean *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__boolean);
	if (soap_out_xsd__boolean(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_xsd__boolean[] =
{	{ (long)xsd__boolean__false_, "false" },
	{ (long)xsd__boolean__true_, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_xsd__boolean2s(struct soap *soap, enum xsd__boolean n)
{	const char *s = soap_str_code(soap_codes_xsd__boolean, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__boolean(struct soap *soap, const char *tag, int id, const enum xsd__boolean *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xsd__boolean), type);
	soap_send(soap, soap_xsd__boolean2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum xsd__boolean * SOAP_FMAC4 soap_get_xsd__boolean(struct soap *soap, enum xsd__boolean *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__boolean(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2xsd__boolean(struct soap *soap, const char *s, enum xsd__boolean *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_xsd__boolean, s);
	if (map)
		*a = (enum xsd__boolean)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum xsd__boolean)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum xsd__boolean * SOAP_FMAC4 soap_in_xsd__boolean(struct soap *soap, const char *tag, enum xsd__boolean *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum xsd__boolean *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__boolean, sizeof(enum xsd__boolean), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2xsd__boolean(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum xsd__boolean *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_xsd__boolean, 0, sizeof(enum xsd__boolean), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	dpws_headers_out(dpws_soap2dpws(soap));
	if (a) {
	/* transient dummy skipped */
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (!dpws_header_in(dpws_soap2dpws(soap)))
				continue;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wse__SubscriptionEnd(struct soap *soap, const struct __wse__SubscriptionEnd *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_wse__SubscriptionEnd(soap, &a->wse__SubscriptionEnd);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wse__SubscriptionEnd(struct soap *soap, struct __wse__SubscriptionEnd *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wse__SubscriptionEnd = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wse__SubscriptionEnd(struct soap *soap, const struct __wse__SubscriptionEnd *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wse__SubscriptionEnd(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wse__SubscriptionEnd(struct soap *soap, const char *tag, int id, const struct __wse__SubscriptionEnd *a, const char *type)
{
	soap_out_PointerTo_wse__SubscriptionEnd(soap, "wse:SubscriptionEnd", -1, &a->wse__SubscriptionEnd, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __wse__SubscriptionEnd * SOAP_FMAC4 soap_get___wse__SubscriptionEnd(struct soap *soap, struct __wse__SubscriptionEnd *p, const char *tag, const char *type)
{
	if ((p = soap_in___wse__SubscriptionEnd(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __wse__SubscriptionEnd * SOAP_FMAC4 soap_in___wse__SubscriptionEnd(struct soap *soap, const char *tag, struct __wse__SubscriptionEnd *a, const char *type)
{
	short soap_flag_wse__SubscriptionEnd = 1;
	a = (struct __wse__SubscriptionEnd *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___wse__SubscriptionEnd, sizeof(struct __wse__SubscriptionEnd), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wse__SubscriptionEnd(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wse__SubscriptionEnd && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wse__SubscriptionEnd(soap, "wse:SubscriptionEnd", &a->wse__SubscriptionEnd, ""))
				{	soap_flag_wse__SubscriptionEnd--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wse__SubscribeOp(struct soap *soap, const struct __wse__SubscribeOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_wse__Subscribe(soap, &a->wse__Subscribe);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wse__SubscribeOp(struct soap *soap, struct __wse__SubscribeOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wse__Subscribe = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wse__SubscribeOp(struct soap *soap, const struct __wse__SubscribeOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wse__SubscribeOp(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wse__SubscribeOp(struct soap *soap, const char *tag, int id, const struct __wse__SubscribeOp *a, const char *type)
{
	soap_out_PointerTo_wse__Subscribe(soap, "wse:Subscribe", -1, &a->wse__Subscribe, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __wse__SubscribeOp * SOAP_FMAC4 soap_get___wse__SubscribeOp(struct soap *soap, struct __wse__SubscribeOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___wse__SubscribeOp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __wse__SubscribeOp * SOAP_FMAC4 soap_in___wse__SubscribeOp(struct soap *soap, const char *tag, struct __wse__SubscribeOp *a, const char *type)
{
	short soap_flag_wse__Subscribe = 1;
	a = (struct __wse__SubscribeOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___wse__SubscribeOp, sizeof(struct __wse__SubscribeOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wse__SubscribeOp(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wse__Subscribe && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wse__Subscribe(soap, "wse:Subscribe", &a->wse__Subscribe, ""))
				{	soap_flag_wse__Subscribe--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wse__LanguageSpecificStringType(struct soap *soap, const struct wse__LanguageSpecificStringType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wse__LanguageSpecificStringType(struct soap *soap, struct wse__LanguageSpecificStringType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default__xml__lang(soap, &a->xml__lang);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wse__LanguageSpecificStringType(struct soap *soap, const struct wse__LanguageSpecificStringType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wse__LanguageSpecificStringType);
	if (soap_out_wse__LanguageSpecificStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wse__LanguageSpecificStringType(struct soap *soap, const char *tag, int id, const struct wse__LanguageSpecificStringType *a, const char *type)
{
	if (a->xml__lang)
		soap_set_attr(soap, "xml:lang", a->xml__lang);
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wse__LanguageSpecificStringType * SOAP_FMAC4 soap_get_wse__LanguageSpecificStringType(struct soap *soap, struct wse__LanguageSpecificStringType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wse__LanguageSpecificStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wse__LanguageSpecificStringType * SOAP_FMAC4 soap_in_wse__LanguageSpecificStringType(struct soap *soap, const char *tag, struct wse__LanguageSpecificStringType *a, const char *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!(a = (struct wse__LanguageSpecificStringType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wse__LanguageSpecificStringType, sizeof(struct wse__LanguageSpecificStringType), 0, NULL, NULL, NULL)))
		return NULL;
	*soap->id = '\0';
	soap_default_wse__LanguageSpecificStringType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "xml:lang", 0), &a->xml__lang))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, "wse:LanguageSpecificStringType"))
		return NULL;
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wse__SubscriptionEnd(struct soap *soap, const struct _wse__SubscriptionEnd *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_endpoint_ref(soap, &a->wse__SubscriptionManager);
	soap_serialize_wse__OpenSubscriptionEndCodeType(soap, &a->wse__Status);
	if (a->wse__Reason)
	{	int i;
		for (i = 0; i < a->__sizeReason; i++)
		{
			soap_serialize_PointerTowse__LanguageSpecificStringType(soap, a->wse__Reason + i);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wse__SubscriptionEnd(struct soap *soap, struct _wse__SubscriptionEnd *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wse__SubscriptionManager = NULL;
	soap_default_wse__OpenSubscriptionEndCodeType(soap, &a->wse__Status);
	a->__sizeReason = 0;
	a->wse__Reason = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wse__SubscriptionEnd(struct soap *soap, const struct _wse__SubscriptionEnd *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wse__SubscriptionEnd);
	if (soap_out__wse__SubscriptionEnd(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wse__SubscriptionEnd(struct soap *soap, const char *tag, int id, const struct _wse__SubscriptionEnd *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wse__SubscriptionEnd), type);
	soap_out_endpoint_ref(soap, "wse:SubscriptionManager", -1, &a->wse__SubscriptionManager, "");
	soap_out_wse__OpenSubscriptionEndCodeType(soap, "wse:Status", -1, &a->wse__Status, "");
	if (a->wse__Reason)
	{	int i;
		for (i = 0; i < a->__sizeReason; i++)
			soap_out_PointerTowse__LanguageSpecificStringType(soap, "wse:Reason", -1, a->wse__Reason + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _wse__SubscriptionEnd * SOAP_FMAC4 soap_get__wse__SubscriptionEnd(struct soap *soap, struct _wse__SubscriptionEnd *p, const char *tag, const char *type)
{
	if ((p = soap_in__wse__SubscriptionEnd(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wse__SubscriptionEnd * SOAP_FMAC4 soap_in__wse__SubscriptionEnd(struct soap *soap, const char *tag, struct _wse__SubscriptionEnd *a, const char *type)
{
	short soap_flag_wse__SubscriptionManager = 1, soap_flag_wse__Status = 1, soap_flag_wse__Reason = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct _wse__SubscriptionEnd *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wse__SubscriptionEnd, sizeof(struct _wse__SubscriptionEnd), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wse__SubscriptionEnd(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wse__SubscriptionManager && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_endpoint_ref(soap, "wse:SubscriptionManager", &a->wse__SubscriptionManager, "endpoint-ref"))
				{	soap_flag_wse__SubscriptionManager--;
					continue;
				}
			if (soap_flag_wse__Status && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_wse__OpenSubscriptionEndCodeType(soap, "wse:Status", &a->wse__Status, "wse:OpenSubscriptionEndCodeType"))
				{	soap_flag_wse__Status--;
					continue;
				}
			if (soap_flag_wse__Reason && soap->error == SOAP_TAG_MISMATCH)
			{	struct wse__LanguageSpecificStringType **p;
				soap_new_block(soap);
				for (a->__sizeReason = 0; !soap_element_begin_in(soap, "wse:Reason", 1); a->__sizeReason++)
				{	p = (struct wse__LanguageSpecificStringType **)soap_push_block(soap, sizeof(struct wse__LanguageSpecificStringType *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerTowse__LanguageSpecificStringType(soap, "wse:Reason", p, "wse:LanguageSpecificStringType"))
						break;
					soap_flag_wse__Reason = 0;
				}
				a->wse__Reason = (struct wse__LanguageSpecificStringType **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_wse__Reason && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wse__SubscriptionManager > 0 || soap_flag_wse__Status > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wse__SubscriptionEnd *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wse__SubscriptionEnd, 0, sizeof(struct _wse__SubscriptionEnd), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wse__SubscribeResponse(struct soap *soap, const struct _wse__SubscribeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_endpoint_ref(soap, &a->wse__SubscriptionManager);
	soap_serialize_wse__ExpirationType(soap, &a->wse__Expires);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wse__SubscribeResponse(struct soap *soap, struct _wse__SubscribeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wse__SubscriptionManager = NULL;
	soap_default_wse__ExpirationType(soap, &a->wse__Expires);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wse__SubscribeResponse(struct soap *soap, const struct _wse__SubscribeResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wse__SubscribeResponse);
	if (soap_out__wse__SubscribeResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wse__SubscribeResponse(struct soap *soap, const char *tag, int id, const struct _wse__SubscribeResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wse__SubscribeResponse), type);
	if (a->wse__SubscriptionManager)
		soap_element_result(soap, "wse:SubscriptionManager");
	soap_out_endpoint_ref(soap, "wse:SubscriptionManager", -1, &a->wse__SubscriptionManager, "");
	soap_out_wse__ExpirationType(soap, "wse:Expires", -1, &a->wse__Expires, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _wse__SubscribeResponse * SOAP_FMAC4 soap_get__wse__SubscribeResponse(struct soap *soap, struct _wse__SubscribeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__wse__SubscribeResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wse__SubscribeResponse * SOAP_FMAC4 soap_in__wse__SubscribeResponse(struct soap *soap, const char *tag, struct _wse__SubscribeResponse *a, const char *type)
{
	short soap_flag_wse__SubscriptionManager = 1, soap_flag_wse__Expires = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct _wse__SubscribeResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wse__SubscribeResponse, sizeof(struct _wse__SubscribeResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wse__SubscribeResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wse__SubscriptionManager && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_endpoint_ref(soap, "wse:SubscriptionManager", &a->wse__SubscriptionManager, "endpoint-ref"))
				{	soap_flag_wse__SubscriptionManager--;
					continue;
				}
			if (soap_flag_wse__Expires && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_wse__ExpirationType(soap, "wse:Expires", &a->wse__Expires, "wse:ExpirationType"))
				{	soap_flag_wse__Expires--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wse__SubscriptionManager > 0 || soap_flag_wse__Expires > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wse__SubscribeResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wse__SubscribeResponse, 0, sizeof(struct _wse__SubscribeResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wse__Subscribe(struct soap *soap, const struct _wse__Subscribe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_endpoint_ref(soap, &a->wse__EndTo);
	soap_serialize_PointerTowse__DeliveryType(soap, &a->wse__Delivery);
	soap_serialize_wse__ExpirationType(soap, &a->wse__Expires);
	soap_serialize_PointerTowse__FilterType(soap, &a->wse__Filter);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wse__Subscribe(struct soap *soap, struct _wse__Subscribe *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wse__EndTo = NULL;
	a->wse__Delivery = NULL;
	soap_default_wse__ExpirationType(soap, &a->wse__Expires);
	a->wse__Filter = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wse__Subscribe(struct soap *soap, const struct _wse__Subscribe *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wse__Subscribe);
	if (soap_out__wse__Subscribe(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wse__Subscribe(struct soap *soap, const char *tag, int id, const struct _wse__Subscribe *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wse__Subscribe), type);
	soap_out_endpoint_ref(soap, "wse:EndTo", -1, &a->wse__EndTo, "");
	soap_out_PointerTowse__DeliveryType(soap, "wse:Delivery", -1, &a->wse__Delivery, "");
	soap_out_wse__ExpirationType(soap, "wse:Expires", -1, &a->wse__Expires, "");
	soap_out_PointerTowse__FilterType(soap, "wse:Filter", -1, &a->wse__Filter, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _wse__Subscribe * SOAP_FMAC4 soap_get__wse__Subscribe(struct soap *soap, struct _wse__Subscribe *p, const char *tag, const char *type)
{
	if ((p = soap_in__wse__Subscribe(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wse__Subscribe * SOAP_FMAC4 soap_in__wse__Subscribe(struct soap *soap, const char *tag, struct _wse__Subscribe *a, const char *type)
{
	short soap_flag_wse__EndTo = 1, soap_flag_wse__Delivery = 1, soap_flag_wse__Expires = 1, soap_flag_wse__Filter = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct _wse__Subscribe *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wse__Subscribe, sizeof(struct _wse__Subscribe), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wse__Subscribe(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wse__EndTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_endpoint_ref(soap, "wse:EndTo", &a->wse__EndTo, "endpoint-ref"))
				{	soap_flag_wse__EndTo--;
					continue;
				}
			if (soap_flag_wse__Delivery && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowse__DeliveryType(soap, "wse:Delivery", &a->wse__Delivery, "wse:DeliveryType"))
				{	soap_flag_wse__Delivery--;
					continue;
				}
			if (soap_flag_wse__Expires && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_wse__ExpirationType(soap, "wse:Expires", &a->wse__Expires, "wse:ExpirationType"))
				{	soap_flag_wse__Expires--;
					continue;
				}
			if (soap_flag_wse__Filter && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowse__FilterType(soap, "wse:Filter", &a->wse__Filter, "wse:FilterType"))
				{	soap_flag_wse__Filter--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wse__Delivery > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wse__Subscribe *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wse__Subscribe, 0, sizeof(struct _wse__Subscribe), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wse__FilterType(struct soap *soap, const struct wse__FilterType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_uri_list(soap, &a->__item);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wse__FilterType(struct soap *soap, struct wse__FilterType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__item = NULL;
	soap_default_xsd__anyURI(soap, &a->Dialect);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wse__FilterType(struct soap *soap, const struct wse__FilterType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wse__FilterType);
	if (soap_out_wse__FilterType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wse__FilterType(struct soap *soap, const char *tag, int id, const struct wse__FilterType *a, const char *type)
{
	if (a->Dialect)
		soap_set_attr(soap, "Dialect", a->Dialect);
	return soap_out_uri_list(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wse__FilterType * SOAP_FMAC4 soap_get_wse__FilterType(struct soap *soap, struct wse__FilterType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wse__FilterType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wse__FilterType * SOAP_FMAC4 soap_in_wse__FilterType(struct soap *soap, const char *tag, struct wse__FilterType *a, const char *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!(a = (struct wse__FilterType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wse__FilterType, sizeof(struct wse__FilterType), 0, NULL, NULL, NULL)))
		return NULL;
	*soap->id = '\0';
	soap_default_wse__FilterType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Dialect", 0), &a->Dialect))
		return NULL;
	if (!soap_in_uri_list(soap, tag, &a->__item, "wse:FilterType"))
		return NULL;
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wse__DeliveryType(struct soap *soap, const struct wse__DeliveryType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_endpoint_ref(soap, &a->wse__NotifyTo);
	soap_serialize_xsd__duration(soap, &a->wsman__Heartbeats);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wse__DeliveryType(struct soap *soap, struct wse__DeliveryType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wse__NotifyTo = NULL;
	soap_default_xsd__anyURI(soap, &a->Mode);
	soap_default_xsd__duration(soap, &a->wsman__Heartbeats);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wse__DeliveryType(struct soap *soap, const struct wse__DeliveryType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wse__DeliveryType);
	if (soap_out_wse__DeliveryType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wse__DeliveryType(struct soap *soap, const char *tag, int id, const struct wse__DeliveryType *a, const char *type)
{
	if (a->Mode)
		soap_set_attr(soap, "Mode", a->Mode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wse__DeliveryType), type);
	soap_out_endpoint_ref(soap, "wse:NotifyTo", -1, &a->wse__NotifyTo, "");
	soap_out_xsd__duration(soap, "wsman:Heartbeats", -1, &a->wsman__Heartbeats, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wse__DeliveryType * SOAP_FMAC4 soap_get_wse__DeliveryType(struct soap *soap, struct wse__DeliveryType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wse__DeliveryType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wse__DeliveryType * SOAP_FMAC4 soap_in_wse__DeliveryType(struct soap *soap, const char *tag, struct wse__DeliveryType *a, const char *type)
{
	short soap_flag_wse__NotifyTo = 1, soap_flag_wsman__Heartbeats = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wse__DeliveryType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wse__DeliveryType, sizeof(struct wse__DeliveryType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wse__DeliveryType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Mode", 0), &a->Mode))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wse__NotifyTo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_endpoint_ref(soap, "wse:NotifyTo", &a->wse__NotifyTo, "endpoint-ref"))
				{	soap_flag_wse__NotifyTo--;
					continue;
				}
			if (soap_flag_wsman__Heartbeats && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__duration(soap, "wsman:Heartbeats", &a->wsman__Heartbeats, "xsd:duration"))
				{	soap_flag_wsman__Heartbeats--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wse__NotifyTo > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wse__DeliveryType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wse__DeliveryType, 0, sizeof(struct wse__DeliveryType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wse__SubscriptionEnd(struct soap *soap, struct _wse__SubscriptionEnd *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wse__SubscriptionEnd))
		soap_serialize__wse__SubscriptionEnd(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wse__SubscriptionEnd(struct soap *soap, struct _wse__SubscriptionEnd *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wse__SubscriptionEnd);
	if (soap_out_PointerTo_wse__SubscriptionEnd(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wse__SubscriptionEnd(struct soap *soap, const char *tag, int id, struct _wse__SubscriptionEnd *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wse__SubscriptionEnd);
	if (id < 0)
		return soap->error;
	return soap_out__wse__SubscriptionEnd(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wse__SubscriptionEnd ** SOAP_FMAC4 soap_get_PointerTo_wse__SubscriptionEnd(struct soap *soap, struct _wse__SubscriptionEnd **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wse__SubscriptionEnd(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wse__SubscriptionEnd ** SOAP_FMAC4 soap_in_PointerTo_wse__SubscriptionEnd(struct soap *soap, const char *tag, struct _wse__SubscriptionEnd **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct _wse__SubscriptionEnd **)soap_malloc(soap, sizeof(struct _wse__SubscriptionEnd *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wse__SubscriptionEnd(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wse__SubscriptionEnd **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wse__SubscriptionEnd, sizeof(struct _wse__SubscriptionEnd), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wse__SubscribeResponse(struct soap *soap, struct _wse__SubscribeResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wse__SubscribeResponse))
		soap_serialize__wse__SubscribeResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wse__SubscribeResponse(struct soap *soap, struct _wse__SubscribeResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wse__SubscribeResponse);
	if (soap_out_PointerTo_wse__SubscribeResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wse__SubscribeResponse(struct soap *soap, const char *tag, int id, struct _wse__SubscribeResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wse__SubscribeResponse);
	if (id < 0)
		return soap->error;
	return soap_out__wse__SubscribeResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wse__SubscribeResponse ** SOAP_FMAC4 soap_get_PointerTo_wse__SubscribeResponse(struct soap *soap, struct _wse__SubscribeResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wse__SubscribeResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wse__SubscribeResponse ** SOAP_FMAC4 soap_in_PointerTo_wse__SubscribeResponse(struct soap *soap, const char *tag, struct _wse__SubscribeResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct _wse__SubscribeResponse **)soap_malloc(soap, sizeof(struct _wse__SubscribeResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wse__SubscribeResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wse__SubscribeResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wse__SubscribeResponse, sizeof(struct _wse__SubscribeResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wse__Subscribe(struct soap *soap, struct _wse__Subscribe *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wse__Subscribe))
		soap_serialize__wse__Subscribe(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wse__Subscribe(struct soap *soap, struct _wse__Subscribe *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wse__Subscribe);
	if (soap_out_PointerTo_wse__Subscribe(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wse__Subscribe(struct soap *soap, const char *tag, int id, struct _wse__Subscribe *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wse__Subscribe);
	if (id < 0)
		return soap->error;
	return soap_out__wse__Subscribe(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wse__Subscribe ** SOAP_FMAC4 soap_get_PointerTo_wse__Subscribe(struct soap *soap, struct _wse__Subscribe **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wse__Subscribe(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wse__Subscribe ** SOAP_FMAC4 soap_in_PointerTo_wse__Subscribe(struct soap *soap, const char *tag, struct _wse__Subscribe **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct _wse__Subscribe **)soap_malloc(soap, sizeof(struct _wse__Subscribe *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wse__Subscribe(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wse__Subscribe **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wse__Subscribe, sizeof(struct _wse__Subscribe), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wse__SupportedDeliveryMode(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wse__SupportedDeliveryMode(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wse__SupportedDeliveryMode(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wse__SupportedDeliveryMode);
	if (soap_out__wse__SupportedDeliveryMode(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wse__SupportedDeliveryMode(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__wse__SupportedDeliveryMode);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__wse__SupportedDeliveryMode(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__wse__SupportedDeliveryMode(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__wse__SupportedDeliveryMode(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__wse__SupportedDeliveryMode, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wse__SupportedDialect(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wse__SupportedDialect(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wse__SupportedDialect(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wse__SupportedDialect);
	if (soap_out__wse__SupportedDialect(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wse__SupportedDialect(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__wse__SupportedDialect);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__wse__SupportedDialect(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__wse__SupportedDialect(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__wse__SupportedDialect(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__wse__SupportedDialect, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wse__Identifier(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wse__Identifier(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wse__Identifier(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wse__Identifier);
	if (soap_out__wse__Identifier(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wse__Identifier(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__wse__Identifier);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__wse__Identifier(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__wse__Identifier(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__wse__Identifier(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__wse__Identifier, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerTowse__LanguageSpecificStringType(struct soap *soap, struct wse__LanguageSpecificStringType **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerTowse__LanguageSpecificStringType))
		soap_serialize_PointerTowse__LanguageSpecificStringType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerTowse__LanguageSpecificStringType(struct soap *soap, struct wse__LanguageSpecificStringType **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerTowse__LanguageSpecificStringType);
	if (soap_out_PointerToPointerTowse__LanguageSpecificStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerTowse__LanguageSpecificStringType(struct soap *soap, const char *tag, int id, struct wse__LanguageSpecificStringType **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerTowse__LanguageSpecificStringType);
	if (id < 0)
		return soap->error;
	return soap_out_PointerTowse__LanguageSpecificStringType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wse__LanguageSpecificStringType *** SOAP_FMAC4 soap_get_PointerToPointerTowse__LanguageSpecificStringType(struct soap *soap, struct wse__LanguageSpecificStringType ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerTowse__LanguageSpecificStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wse__LanguageSpecificStringType *** SOAP_FMAC4 soap_in_PointerToPointerTowse__LanguageSpecificStringType(struct soap *soap, const char *tag, struct wse__LanguageSpecificStringType ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wse__LanguageSpecificStringType ***)soap_malloc(soap, sizeof(struct wse__LanguageSpecificStringType **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerTowse__LanguageSpecificStringType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wse__LanguageSpecificStringType ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerTowse__LanguageSpecificStringType, sizeof(struct wse__LanguageSpecificStringType *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowse__LanguageSpecificStringType(struct soap *soap, struct wse__LanguageSpecificStringType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wse__LanguageSpecificStringType))
		soap_serialize_wse__LanguageSpecificStringType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowse__LanguageSpecificStringType(struct soap *soap, struct wse__LanguageSpecificStringType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowse__LanguageSpecificStringType);
	if (soap_out_PointerTowse__LanguageSpecificStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowse__LanguageSpecificStringType(struct soap *soap, const char *tag, int id, struct wse__LanguageSpecificStringType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wse__LanguageSpecificStringType);
	if (id < 0)
		return soap->error;
	return soap_out_wse__LanguageSpecificStringType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wse__LanguageSpecificStringType ** SOAP_FMAC4 soap_get_PointerTowse__LanguageSpecificStringType(struct soap *soap, struct wse__LanguageSpecificStringType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowse__LanguageSpecificStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wse__LanguageSpecificStringType ** SOAP_FMAC4 soap_in_PointerTowse__LanguageSpecificStringType(struct soap *soap, const char *tag, struct wse__LanguageSpecificStringType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wse__LanguageSpecificStringType **)soap_malloc(soap, sizeof(struct wse__LanguageSpecificStringType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wse__LanguageSpecificStringType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wse__LanguageSpecificStringType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wse__LanguageSpecificStringType, sizeof(struct wse__LanguageSpecificStringType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowse__FilterType(struct soap *soap, struct wse__FilterType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wse__FilterType))
		soap_serialize_wse__FilterType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowse__FilterType(struct soap *soap, struct wse__FilterType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowse__FilterType);
	if (soap_out_PointerTowse__FilterType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowse__FilterType(struct soap *soap, const char *tag, int id, struct wse__FilterType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wse__FilterType);
	if (id < 0)
		return soap->error;
	return soap_out_wse__FilterType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wse__FilterType ** SOAP_FMAC4 soap_get_PointerTowse__FilterType(struct soap *soap, struct wse__FilterType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowse__FilterType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wse__FilterType ** SOAP_FMAC4 soap_in_PointerTowse__FilterType(struct soap *soap, const char *tag, struct wse__FilterType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wse__FilterType **)soap_malloc(soap, sizeof(struct wse__FilterType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wse__FilterType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wse__FilterType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wse__FilterType, sizeof(struct wse__FilterType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowse__DeliveryType(struct soap *soap, struct wse__DeliveryType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wse__DeliveryType))
		soap_serialize_wse__DeliveryType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowse__DeliveryType(struct soap *soap, struct wse__DeliveryType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowse__DeliveryType);
	if (soap_out_PointerTowse__DeliveryType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowse__DeliveryType(struct soap *soap, const char *tag, int id, struct wse__DeliveryType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wse__DeliveryType);
	if (id < 0)
		return soap->error;
	return soap_out_wse__DeliveryType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wse__DeliveryType ** SOAP_FMAC4 soap_get_PointerTowse__DeliveryType(struct soap *soap, struct wse__DeliveryType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowse__DeliveryType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wse__DeliveryType ** SOAP_FMAC4 soap_in_PointerTowse__DeliveryType(struct soap *soap, const char *tag, struct wse__DeliveryType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wse__DeliveryType **)soap_malloc(soap, sizeof(struct wse__DeliveryType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wse__DeliveryType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wse__DeliveryType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wse__DeliveryType, sizeof(struct wse__DeliveryType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wse__NonNegativeDurationType(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wse__NonNegativeDurationType(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wse__NonNegativeDurationType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wse__NonNegativeDurationType);
	if (soap_out_wse__NonNegativeDurationType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wse__NonNegativeDurationType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_wse__NonNegativeDurationType);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_wse__NonNegativeDurationType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_wse__NonNegativeDurationType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_wse__NonNegativeDurationType(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_wse__NonNegativeDurationType, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wse__OpenSubscriptionEndCodeType(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wse__OpenSubscriptionEndCodeType(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wse__OpenSubscriptionEndCodeType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wse__OpenSubscriptionEndCodeType);
	if (soap_out_wse__OpenSubscriptionEndCodeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wse__OpenSubscriptionEndCodeType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_wse__OpenSubscriptionEndCodeType);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_wse__OpenSubscriptionEndCodeType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_wse__OpenSubscriptionEndCodeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_wse__OpenSubscriptionEndCodeType(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_wse__OpenSubscriptionEndCodeType, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wse__ExpirationType(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wse__ExpirationType(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wse__ExpirationType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wse__ExpirationType);
	if (soap_out_wse__ExpirationType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wse__ExpirationType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_wse__ExpirationType);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_wse__ExpirationType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_wse__ExpirationType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_wse__ExpirationType(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_wse__ExpirationType, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__xml__lang(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__xml__lang(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__xml__lang(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__xml__lang);
	if (soap_out__xml__lang(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__xml__lang(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__xml__lang);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__xml__lang(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__xml__lang(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__xml__lang(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__xml__lang, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__duration(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__duration(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__duration(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__duration);
	if (soap_out_xsd__duration(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__duration(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__duration);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__duration(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__duration(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__duration(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__duration, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__anyURI(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__anyURI(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__anyURI(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__anyURI);
	if (soap_out_xsd__anyURI(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__anyURI);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__anyURI(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__anyURI(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__anyURI(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__anyURI, 1, -1, -1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_uri_list(struct soap *soap, struct dynamic_array *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_uri_list);
	if (soap_out_uri_list(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct dynamic_array ** SOAP_FMAC4 soap_get_uri_list(struct soap *soap, struct dynamic_array **p, const char *tag, const char *type)
{
	if ((p = soap_in_uri_list(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_qname_list(struct soap *soap, struct dynamic_array *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_qname_list);
	if (soap_out_qname_list(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct dynamic_array ** SOAP_FMAC4 soap_get_qname_list(struct soap *soap, struct dynamic_array **p, const char *tag, const char *type)
{
	if ((p = soap_in_qname_list(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_endpoint_ref(struct soap *soap, struct wsa_endpoint_ref *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_endpoint_ref);
	if (soap_out_endpoint_ref(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa_endpoint_ref ** SOAP_FMAC4 soap_get_endpoint_ref(struct soap *soap, struct wsa_endpoint_ref **p, const char *tag, const char *type)
{
	if ((p = soap_in_endpoint_ref(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

#ifdef __cplusplus
}
#endif

/* End of eventsourceC.c */
