/* discoveryC.c
   Generated by gSOAP 2.7.6c from ../../../../../src/dpws/src/discovery.gsoap
   Copyright (C) 2000-2005, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "discoveryH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) discoveryC.c ver 2.7.6c 2009-04-17 13:17:56 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
	soap->part = SOAP_END_HEADER;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE__wsd__MetadataVersion:
		return soap_in__wsd__MetadataVersion(soap, NULL, NULL, "wsd:MetadataVersion");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_wsd__FaultCodeType:
		return soap_in_wsd__FaultCodeType(soap, NULL, NULL, "wsd:FaultCodeType");
	case SOAP_TYPE_wsd__RelationshipType:
		return soap_in_wsd__RelationshipType(soap, NULL, NULL, "wsd:RelationshipType");
	case SOAP_TYPE_SOAP_ENV__Reason:
		return soap_in_SOAP_ENV__Reason(soap, NULL, NULL, "SOAP-ENV:Reason");
	case SOAP_TYPE__wsd__AppSequence:
		return soap_in__wsd__AppSequence(soap, NULL, NULL, "wsd:AppSequence");
	case SOAP_TYPE__wsd__Scopes:
		return soap_in__wsd__Scopes(soap, NULL, NULL, "wsd:Scopes");
	case SOAP_TYPE__wsd__ResolveMatches:
		return soap_in__wsd__ResolveMatches(soap, NULL, NULL, "wsd:ResolveMatches");
	case SOAP_TYPE__wsd__Resolve:
		return soap_in__wsd__Resolve(soap, NULL, NULL, "wsd:Resolve");
	case SOAP_TYPE__wsd__ProbeMatches:
		return soap_in__wsd__ProbeMatches(soap, NULL, NULL, "wsd:ProbeMatches");
	case SOAP_TYPE__wsd__Probe:
		return soap_in__wsd__Probe(soap, NULL, NULL, "wsd:Probe");
	case SOAP_TYPE__wsd__Bye:
		return soap_in__wsd__Bye(soap, NULL, NULL, "wsd:Bye");
	case SOAP_TYPE__wsd__Hello:
		return soap_in__wsd__Hello(soap, NULL, NULL, "wsd:Hello");
	case SOAP_TYPE_wsd__AppSequenceType:
		return soap_in_wsd__AppSequenceType(soap, NULL, NULL, "wsd:AppSequenceType");
	case SOAP_TYPE_wsd__ResolveMatchesType:
		return soap_in_wsd__ResolveMatchesType(soap, NULL, NULL, "wsd:ResolveMatchesType");
	case SOAP_TYPE_wsd__ResolveType:
		return soap_in_wsd__ResolveType(soap, NULL, NULL, "wsd:ResolveType");
	case SOAP_TYPE_wsd__ProbeMatchesType:
		return soap_in_wsd__ProbeMatchesType(soap, NULL, NULL, "wsd:ProbeMatchesType");
	case SOAP_TYPE_wsd__ProbeType:
		return soap_in_wsd__ProbeType(soap, NULL, NULL, "wsd:ProbeType");
	case SOAP_TYPE_wsd__ByeType:
		return soap_in_wsd__ByeType(soap, NULL, NULL, "wsd:ByeType");
	case SOAP_TYPE_wsd__ScopesType:
		return soap_in_wsd__ScopesType(soap, NULL, NULL, "wsd:ScopesType");
	case SOAP_TYPE_wsd__HelloType:
		return soap_in_wsd__HelloType(soap, NULL, NULL, "wsd:HelloType");
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		return soap_in_PointerToSOAP_ENV__Reason(soap, NULL, NULL, "SOAP-ENV:Reason");
	case SOAP_TYPE_PointerTowsd__ResolveMatchesType:
		return soap_in_PointerTowsd__ResolveMatchesType(soap, NULL, NULL, "wsd:ResolveMatchesType");
	case SOAP_TYPE_PointerTowsd__ResolveType:
		return soap_in_PointerTowsd__ResolveType(soap, NULL, NULL, "wsd:ResolveType");
	case SOAP_TYPE_PointerTowsd__ProbeMatchesType:
		return soap_in_PointerTowsd__ProbeMatchesType(soap, NULL, NULL, "wsd:ProbeMatchesType");
	case SOAP_TYPE_PointerTowsd__ProbeType:
		return soap_in_PointerTowsd__ProbeType(soap, NULL, NULL, "wsd:ProbeType");
	case SOAP_TYPE_PointerTowsd__ByeType:
		return soap_in_PointerTowsd__ByeType(soap, NULL, NULL, "wsd:ByeType");
	case SOAP_TYPE__wsd__Id:
	{	char **s;
		s = soap_in__wsd__Id(soap, NULL, NULL, "wsd:Id");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerToPointerTowsd__HelloType:
		return soap_in_PointerToPointerTowsd__HelloType(soap, NULL, NULL, "wsd:HelloType");
	case SOAP_TYPE_PointerTowsd__HelloType:
		return soap_in_PointerTowsd__HelloType(soap, NULL, NULL, "wsd:HelloType");
	case SOAP_TYPE_PointerTowsd__ScopesType:
		return soap_in_PointerTowsd__ScopesType(soap, NULL, NULL, "wsd:ScopesType");
	case SOAP_TYPE_wsd__FaultCodeOpenType:
	{	char **s;
		s = soap_in_wsd__FaultCodeOpenType(soap, NULL, NULL, "wsd:FaultCodeOpenType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_wsd__OpenRelationshipType:
	{	char **s;
		s = soap_in_wsd__OpenRelationshipType(soap, NULL, NULL, "wsd:OpenRelationshipType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__QName:
	{	char **s;
		s = soap_in_xsd__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__IDREFS:
	{	char **s;
		s = soap_in_xsd__IDREFS(soap, NULL, NULL, "xsd:IDREFS");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__ID:
	{	char **s;
		s = soap_in_xsd__ID(soap, NULL, NULL, "xsd:ID");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_uri_list:
		return soap_in_uri_list(soap, NULL, NULL, "uri-list");
	case SOAP_TYPE_qname_list:
		return soap_in_qname_list(soap, NULL, NULL, "qname-list");
	case SOAP_TYPE_endpoint_ref:
		return soap_in_endpoint_ref(soap, NULL, NULL, "endpoint-ref");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:MetadataVersion"))
		{	*type = SOAP_TYPE__wsd__MetadataVersion;
			return soap_in__wsd__MetadataVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:FaultCodeType"))
		{	*type = SOAP_TYPE_wsd__FaultCodeType;
			return soap_in_wsd__FaultCodeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:RelationshipType"))
		{	*type = SOAP_TYPE_wsd__RelationshipType;
			return soap_in_wsd__RelationshipType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SOAP-ENV:Reason"))
		{	*type = SOAP_TYPE_SOAP_ENV__Reason;
			return soap_in_SOAP_ENV__Reason(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:AppSequence"))
		{	*type = SOAP_TYPE__wsd__AppSequence;
			return soap_in__wsd__AppSequence(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:Scopes"))
		{	*type = SOAP_TYPE__wsd__Scopes;
			return soap_in__wsd__Scopes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:ResolveMatches"))
		{	*type = SOAP_TYPE__wsd__ResolveMatches;
			return soap_in__wsd__ResolveMatches(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:Resolve"))
		{	*type = SOAP_TYPE__wsd__Resolve;
			return soap_in__wsd__Resolve(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:ProbeMatches"))
		{	*type = SOAP_TYPE__wsd__ProbeMatches;
			return soap_in__wsd__ProbeMatches(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:Probe"))
		{	*type = SOAP_TYPE__wsd__Probe;
			return soap_in__wsd__Probe(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:Bye"))
		{	*type = SOAP_TYPE__wsd__Bye;
			return soap_in__wsd__Bye(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:Hello"))
		{	*type = SOAP_TYPE__wsd__Hello;
			return soap_in__wsd__Hello(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:AppSequenceType"))
		{	*type = SOAP_TYPE_wsd__AppSequenceType;
			return soap_in_wsd__AppSequenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:ResolveMatchesType"))
		{	*type = SOAP_TYPE_wsd__ResolveMatchesType;
			return soap_in_wsd__ResolveMatchesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:ResolveType"))
		{	*type = SOAP_TYPE_wsd__ResolveType;
			return soap_in_wsd__ResolveType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:ProbeMatchesType"))
		{	*type = SOAP_TYPE_wsd__ProbeMatchesType;
			return soap_in_wsd__ProbeMatchesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:ProbeType"))
		{	*type = SOAP_TYPE_wsd__ProbeType;
			return soap_in_wsd__ProbeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:ByeType"))
		{	*type = SOAP_TYPE_wsd__ByeType;
			return soap_in_wsd__ByeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:ScopesType"))
		{	*type = SOAP_TYPE_wsd__ScopesType;
			return soap_in_wsd__ScopesType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:HelloType"))
		{	*type = SOAP_TYPE_wsd__HelloType;
			return soap_in_wsd__HelloType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsd:Id"))
		{	char **s;
			*type = SOAP_TYPE__wsd__Id;
			s = soap_in__wsd__Id(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsd:FaultCodeOpenType"))
		{	char **s;
			*type = SOAP_TYPE_wsd__FaultCodeOpenType;
			s = soap_in_wsd__FaultCodeOpenType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wsd:OpenRelationshipType"))
		{	char **s;
			*type = SOAP_TYPE_wsd__OpenRelationshipType;
			s = soap_in_wsd__OpenRelationshipType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE_xsd__QName;
			s = soap_in_xsd__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:IDREFS"))
		{	char **s;
			*type = SOAP_TYPE_xsd__IDREFS;
			s = soap_in_xsd__IDREFS(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:ID"))
		{	char **s;
			*type = SOAP_TYPE_xsd__ID;
			s = soap_in_xsd__ID(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE__wsd__MetadataVersion:
		return soap_out__wsd__MetadataVersion(soap, "wsd:MetadataVersion", id, (const unsigned int *)ptr, NULL);
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_wsd__FaultCodeType:
		return soap_out_wsd__FaultCodeType(soap, tag, id, (const enum wsd__FaultCodeType *)ptr, "wsd:FaultCodeType");
	case SOAP_TYPE_wsd__RelationshipType:
		return soap_out_wsd__RelationshipType(soap, tag, id, (const enum wsd__RelationshipType *)ptr, "wsd:RelationshipType");
	case SOAP_TYPE_SOAP_ENV__Reason:
		return soap_out_SOAP_ENV__Reason(soap, tag, id, (const struct SOAP_ENV__Reason *)ptr, "SOAP-ENV:Reason");
	case SOAP_TYPE__wsd__AppSequence:
		return soap_out__wsd__AppSequence(soap, "wsd:AppSequence", id, (const struct wsd__AppSequenceType *)ptr, NULL);
	case SOAP_TYPE__wsd__Scopes:
		return soap_out__wsd__Scopes(soap, "wsd:Scopes", id, (const struct wsd__ScopesType *)ptr, NULL);
	case SOAP_TYPE__wsd__ResolveMatches:
		return soap_out__wsd__ResolveMatches(soap, "wsd:ResolveMatches", id, (const struct wsd__ResolveMatchesType *)ptr, NULL);
	case SOAP_TYPE__wsd__Resolve:
		return soap_out__wsd__Resolve(soap, "wsd:Resolve", id, (const struct wsd__ResolveType *)ptr, NULL);
	case SOAP_TYPE__wsd__ProbeMatches:
		return soap_out__wsd__ProbeMatches(soap, "wsd:ProbeMatches", id, (const struct wsd__ProbeMatchesType *)ptr, NULL);
	case SOAP_TYPE__wsd__Probe:
		return soap_out__wsd__Probe(soap, "wsd:Probe", id, (const struct wsd__ProbeType *)ptr, NULL);
	case SOAP_TYPE__wsd__Bye:
		return soap_out__wsd__Bye(soap, "wsd:Bye", id, (const struct wsd__ByeType *)ptr, NULL);
	case SOAP_TYPE__wsd__Hello:
		return soap_out__wsd__Hello(soap, "wsd:Hello", id, (const struct wsd__HelloType *)ptr, NULL);
	case SOAP_TYPE_wsd__AppSequenceType:
		return soap_out_wsd__AppSequenceType(soap, tag, id, (const struct wsd__AppSequenceType *)ptr, "wsd:AppSequenceType");
	case SOAP_TYPE_wsd__ResolveMatchesType:
		return soap_out_wsd__ResolveMatchesType(soap, tag, id, (const struct wsd__ResolveMatchesType *)ptr, "wsd:ResolveMatchesType");
	case SOAP_TYPE_wsd__ResolveType:
		return soap_out_wsd__ResolveType(soap, tag, id, (const struct wsd__ResolveType *)ptr, "wsd:ResolveType");
	case SOAP_TYPE_wsd__ProbeMatchesType:
		return soap_out_wsd__ProbeMatchesType(soap, tag, id, (const struct wsd__ProbeMatchesType *)ptr, "wsd:ProbeMatchesType");
	case SOAP_TYPE_wsd__ProbeType:
		return soap_out_wsd__ProbeType(soap, tag, id, (const struct wsd__ProbeType *)ptr, "wsd:ProbeType");
	case SOAP_TYPE_wsd__ByeType:
		return soap_out_wsd__ByeType(soap, tag, id, (const struct wsd__ByeType *)ptr, "wsd:ByeType");
	case SOAP_TYPE_wsd__ScopesType:
		return soap_out_wsd__ScopesType(soap, tag, id, (const struct wsd__ScopesType *)ptr, "wsd:ScopesType");
	case SOAP_TYPE_wsd__HelloType:
		return soap_out_wsd__HelloType(soap, tag, id, (const struct wsd__HelloType *)ptr, "wsd:HelloType");
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		return soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, (struct SOAP_ENV__Reason *const*)ptr, "SOAP-ENV:Reason");
	case SOAP_TYPE_PointerTowsd__ResolveMatchesType:
		return soap_out_PointerTowsd__ResolveMatchesType(soap, tag, id, (struct wsd__ResolveMatchesType *const*)ptr, "wsd:ResolveMatchesType");
	case SOAP_TYPE_PointerTowsd__ResolveType:
		return soap_out_PointerTowsd__ResolveType(soap, tag, id, (struct wsd__ResolveType *const*)ptr, "wsd:ResolveType");
	case SOAP_TYPE_PointerTowsd__ProbeMatchesType:
		return soap_out_PointerTowsd__ProbeMatchesType(soap, tag, id, (struct wsd__ProbeMatchesType *const*)ptr, "wsd:ProbeMatchesType");
	case SOAP_TYPE_PointerTowsd__ProbeType:
		return soap_out_PointerTowsd__ProbeType(soap, tag, id, (struct wsd__ProbeType *const*)ptr, "wsd:ProbeType");
	case SOAP_TYPE_PointerTowsd__ByeType:
		return soap_out_PointerTowsd__ByeType(soap, tag, id, (struct wsd__ByeType *const*)ptr, "wsd:ByeType");
	case SOAP_TYPE__wsd__Id:
		return soap_out_string(soap, "wsd:Id", id, (char**)&ptr, NULL);
	case SOAP_TYPE_PointerToPointerTowsd__HelloType:
		return soap_out_PointerToPointerTowsd__HelloType(soap, tag, id, (struct wsd__HelloType **const*)ptr, "wsd:HelloType");
	case SOAP_TYPE_PointerTowsd__HelloType:
		return soap_out_PointerTowsd__HelloType(soap, tag, id, (struct wsd__HelloType *const*)ptr, "wsd:HelloType");
	case SOAP_TYPE_PointerTowsd__ScopesType:
		return soap_out_PointerTowsd__ScopesType(soap, tag, id, (struct wsd__ScopesType *const*)ptr, "wsd:ScopesType");
	case SOAP_TYPE_wsd__FaultCodeOpenType:
		return soap_out_string(soap, tag, id, (char**)&ptr, "wsd:FaultCodeOpenType");
	case SOAP_TYPE_wsd__OpenRelationshipType:
		return soap_out_string(soap, tag, id, (char**)&ptr, "wsd:OpenRelationshipType");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:anyURI");
	case SOAP_TYPE_xsd__QName:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:QName");
	case SOAP_TYPE_xsd__IDREFS:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:IDREFS");
	case SOAP_TYPE_xsd__ID:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:ID");
	case SOAP_TYPE_uri_list:
		return soap_out_uri_list(soap, tag, id, (struct dynamic_array *const*)ptr, "uri-list");
	case SOAP_TYPE_qname_list:
		return soap_out_qname_list(soap, tag, id, (struct dynamic_array *const*)ptr, "qname-list");
	case SOAP_TYPE_endpoint_ref:
		return soap_out_endpoint_ref(soap, tag, id, (struct wsa_endpoint_ref *const*)ptr, "endpoint-ref");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_SOAP_ENV__Reason:
		soap_serialize_SOAP_ENV__Reason(soap, (const struct SOAP_ENV__Reason *)ptr);
		break;
	case SOAP_TYPE___wsd__DiscoveryProxyResolveOp:
		soap_serialize___wsd__DiscoveryProxyResolveOp(soap, (const struct __wsd__DiscoveryProxyResolveOp *)ptr);
		break;
	case SOAP_TYPE___wsd__DiscoveryProxyProbeOp:
		soap_serialize___wsd__DiscoveryProxyProbeOp(soap, (const struct __wsd__DiscoveryProxyProbeOp *)ptr);
		break;
	case SOAP_TYPE___wsd__DirectedProbeOp:
		soap_serialize___wsd__DirectedProbeOp(soap, (const struct __wsd__DirectedProbeOp *)ptr);
		break;
	case SOAP_TYPE___wsd__ResolveMatchOp:
		soap_serialize___wsd__ResolveMatchOp(soap, (const struct __wsd__ResolveMatchOp *)ptr);
		break;
	case SOAP_TYPE___wsd__ResolveOp:
		soap_serialize___wsd__ResolveOp(soap, (const struct __wsd__ResolveOp *)ptr);
		break;
	case SOAP_TYPE___wsd__ProbeMatchOp:
		soap_serialize___wsd__ProbeMatchOp(soap, (const struct __wsd__ProbeMatchOp *)ptr);
		break;
	case SOAP_TYPE___wsd__ProbeOp:
		soap_serialize___wsd__ProbeOp(soap, (const struct __wsd__ProbeOp *)ptr);
		break;
	case SOAP_TYPE___wsd__ByeOp:
		soap_serialize___wsd__ByeOp(soap, (const struct __wsd__ByeOp *)ptr);
		break;
	case SOAP_TYPE___wsd__HelloOp:
		soap_serialize___wsd__HelloOp(soap, (const struct __wsd__HelloOp *)ptr);
		break;
	case SOAP_TYPE__wsd__AppSequence:
		soap_serialize__wsd__AppSequence(soap, (const struct wsd__AppSequenceType *)ptr);
		break;
	case SOAP_TYPE__wsd__Scopes:
		soap_serialize__wsd__Scopes(soap, (const struct wsd__ScopesType *)ptr);
		break;
	case SOAP_TYPE__wsd__ResolveMatches:
		soap_serialize__wsd__ResolveMatches(soap, (const struct wsd__ResolveMatchesType *)ptr);
		break;
	case SOAP_TYPE__wsd__Resolve:
		soap_serialize__wsd__Resolve(soap, (const struct wsd__ResolveType *)ptr);
		break;
	case SOAP_TYPE__wsd__ProbeMatches:
		soap_serialize__wsd__ProbeMatches(soap, (const struct wsd__ProbeMatchesType *)ptr);
		break;
	case SOAP_TYPE__wsd__Probe:
		soap_serialize__wsd__Probe(soap, (const struct wsd__ProbeType *)ptr);
		break;
	case SOAP_TYPE__wsd__Bye:
		soap_serialize__wsd__Bye(soap, (const struct wsd__ByeType *)ptr);
		break;
	case SOAP_TYPE__wsd__Hello:
		soap_serialize__wsd__Hello(soap, (const struct wsd__HelloType *)ptr);
		break;
	case SOAP_TYPE_wsd__AppSequenceType:
		soap_serialize_wsd__AppSequenceType(soap, (const struct wsd__AppSequenceType *)ptr);
		break;
	case SOAP_TYPE_wsd__ResolveMatchesType:
		soap_serialize_wsd__ResolveMatchesType(soap, (const struct wsd__ResolveMatchesType *)ptr);
		break;
	case SOAP_TYPE_wsd__ResolveType:
		soap_serialize_wsd__ResolveType(soap, (const struct wsd__ResolveType *)ptr);
		break;
	case SOAP_TYPE_wsd__ProbeMatchesType:
		soap_serialize_wsd__ProbeMatchesType(soap, (const struct wsd__ProbeMatchesType *)ptr);
		break;
	case SOAP_TYPE_wsd__ProbeType:
		soap_serialize_wsd__ProbeType(soap, (const struct wsd__ProbeType *)ptr);
		break;
	case SOAP_TYPE_wsd__ByeType:
		soap_serialize_wsd__ByeType(soap, (const struct wsd__ByeType *)ptr);
		break;
	case SOAP_TYPE_wsd__ScopesType:
		soap_serialize_wsd__ScopesType(soap, (const struct wsd__ScopesType *)ptr);
		break;
	case SOAP_TYPE_wsd__HelloType:
		soap_serialize_wsd__HelloType(soap, (const struct wsd__HelloType *)ptr);
		break;
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		soap_serialize_PointerToSOAP_ENV__Reason(soap, (struct SOAP_ENV__Reason *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsd__ResolveMatchesType:
		soap_serialize_PointerTowsd__ResolveMatchesType(soap, (struct wsd__ResolveMatchesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsd__ResolveType:
		soap_serialize_PointerTowsd__ResolveType(soap, (struct wsd__ResolveType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsd__ProbeMatchesType:
		soap_serialize_PointerTowsd__ProbeMatchesType(soap, (struct wsd__ProbeMatchesType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsd__ProbeType:
		soap_serialize_PointerTowsd__ProbeType(soap, (struct wsd__ProbeType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsd__ByeType:
		soap_serialize_PointerTowsd__ByeType(soap, (struct wsd__ByeType *const*)ptr);
		break;
	case SOAP_TYPE__wsd__Id:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_PointerToPointerTowsd__HelloType:
		soap_serialize_PointerToPointerTowsd__HelloType(soap, (struct wsd__HelloType **const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsd__HelloType:
		soap_serialize_PointerTowsd__HelloType(soap, (struct wsd__HelloType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTowsd__ScopesType:
		soap_serialize_PointerTowsd__ScopesType(soap, (struct wsd__ScopesType *const*)ptr);
		break;
	case SOAP_TYPE_wsd__FaultCodeOpenType:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_wsd__OpenRelationshipType:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__IDREFS:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__ID:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_uri_list:
		soap_serialize_uri_list(soap, (struct dynamic_array *const*)ptr);
		break;
	case SOAP_TYPE_qname_list:
		soap_serialize_qname_list(soap, (struct dynamic_array *const*)ptr);
		break;
	case SOAP_TYPE_endpoint_ref:
		soap_serialize_endpoint_ref(soap, (struct wsa_endpoint_ref *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsd__MetadataVersion(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsd__MetadataVersion(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsd__MetadataVersion);
	if (soap_out__wsd__MetadataVersion(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsd__MetadataVersion(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE__wsd__MetadataVersion);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get__wsd__MetadataVersion(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsd__MetadataVersion(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in__wsd__MetadataVersion(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE__wsd__MetadataVersion);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__FaultCodeType(struct soap *soap, enum wsd__FaultCodeType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsd__FaultCodeType
	*a = SOAP_DEFAULT_wsd__FaultCodeType;
#else
	*a = (enum wsd__FaultCodeType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__FaultCodeType(struct soap *soap, const enum wsd__FaultCodeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__FaultCodeType);
	if (soap_out_wsd__FaultCodeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_wsd__FaultCodeType[] =
{	{ (long)wsd__FaultCodeType__wsd__MatchingRuleNotSupported, "wsd:MatchingRuleNotSupported" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsd__FaultCodeType2s(struct soap *soap, enum wsd__FaultCodeType n)
{	const char *s = soap_str_code(soap_codes_wsd__FaultCodeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__FaultCodeType(struct soap *soap, const char *tag, int id, const enum wsd__FaultCodeType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsd__FaultCodeType), type);
	soap_send(soap, soap_wsd__FaultCodeType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum wsd__FaultCodeType * SOAP_FMAC4 soap_get_wsd__FaultCodeType(struct soap *soap, enum wsd__FaultCodeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__FaultCodeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsd__FaultCodeType(struct soap *soap, const char *s, enum wsd__FaultCodeType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return SOAP_OK;
	soap_s2QName(soap, s, &t);
	map = soap_code(soap_codes_wsd__FaultCodeType, t);
	if (map)
		*a = (enum wsd__FaultCodeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsd__FaultCodeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsd__FaultCodeType * SOAP_FMAC4 soap_in_wsd__FaultCodeType(struct soap *soap, const char *tag, enum wsd__FaultCodeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum wsd__FaultCodeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsd__FaultCodeType, sizeof(enum wsd__FaultCodeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsd__FaultCodeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsd__FaultCodeType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wsd__FaultCodeType, 0, sizeof(enum wsd__FaultCodeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__RelationshipType(struct soap *soap, enum wsd__RelationshipType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsd__RelationshipType
	*a = SOAP_DEFAULT_wsd__RelationshipType;
#else
	*a = (enum wsd__RelationshipType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__RelationshipType(struct soap *soap, const enum wsd__RelationshipType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__RelationshipType);
	if (soap_out_wsd__RelationshipType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_wsd__RelationshipType[] =
{	{ (long)wsd__RelationshipType__wsd__Suppression, "wsd:Suppression" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsd__RelationshipType2s(struct soap *soap, enum wsd__RelationshipType n)
{	const char *s = soap_str_code(soap_codes_wsd__RelationshipType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__RelationshipType(struct soap *soap, const char *tag, int id, const enum wsd__RelationshipType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsd__RelationshipType), type);
	soap_send(soap, soap_wsd__RelationshipType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum wsd__RelationshipType * SOAP_FMAC4 soap_get_wsd__RelationshipType(struct soap *soap, enum wsd__RelationshipType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__RelationshipType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsd__RelationshipType(struct soap *soap, const char *s, enum wsd__RelationshipType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return SOAP_OK;
	soap_s2QName(soap, s, &t);
	map = soap_code(soap_codes_wsd__RelationshipType, t);
	if (map)
		*a = (enum wsd__RelationshipType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsd__RelationshipType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsd__RelationshipType * SOAP_FMAC4 soap_in_wsd__RelationshipType(struct soap *soap, const char *tag, enum wsd__RelationshipType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum wsd__RelationshipType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsd__RelationshipType, sizeof(enum wsd__RelationshipType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsd__RelationshipType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsd__RelationshipType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wsd__RelationshipType, 0, sizeof(enum wsd__RelationshipType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	dpws_headers_out(dpws_soap2dpws(soap));
	if (a) {
	/* transient dummy skipped */
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (!dpws_header_in(dpws_soap2dpws(soap)))
				continue;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsd__DiscoveryProxyResolveOp(struct soap *soap, const struct __wsd__DiscoveryProxyResolveOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsd__ResolveType(soap, &a->wsd__Resolve);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsd__DiscoveryProxyResolveOp(struct soap *soap, struct __wsd__DiscoveryProxyResolveOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsd__Resolve = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsd__DiscoveryProxyResolveOp(struct soap *soap, const struct __wsd__DiscoveryProxyResolveOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsd__DiscoveryProxyResolveOp(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsd__DiscoveryProxyResolveOp(struct soap *soap, const char *tag, int id, const struct __wsd__DiscoveryProxyResolveOp *a, const char *type)
{
	soap_out_PointerTowsd__ResolveType(soap, "wsd:Resolve", -1, &a->wsd__Resolve, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsd__DiscoveryProxyResolveOp * SOAP_FMAC4 soap_get___wsd__DiscoveryProxyResolveOp(struct soap *soap, struct __wsd__DiscoveryProxyResolveOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsd__DiscoveryProxyResolveOp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __wsd__DiscoveryProxyResolveOp * SOAP_FMAC4 soap_in___wsd__DiscoveryProxyResolveOp(struct soap *soap, const char *tag, struct __wsd__DiscoveryProxyResolveOp *a, const char *type)
{
	short soap_flag_wsd__Resolve = 1;
	a = (struct __wsd__DiscoveryProxyResolveOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___wsd__DiscoveryProxyResolveOp, sizeof(struct __wsd__DiscoveryProxyResolveOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsd__DiscoveryProxyResolveOp(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsd__Resolve && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ResolveType(soap, "wsd:Resolve", &a->wsd__Resolve, "wsd:ResolveType"))
				{	soap_flag_wsd__Resolve--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsd__DiscoveryProxyProbeOp(struct soap *soap, const struct __wsd__DiscoveryProxyProbeOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsd__ProbeType(soap, &a->wsd__Probe);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsd__DiscoveryProxyProbeOp(struct soap *soap, struct __wsd__DiscoveryProxyProbeOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsd__Probe = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsd__DiscoveryProxyProbeOp(struct soap *soap, const struct __wsd__DiscoveryProxyProbeOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsd__DiscoveryProxyProbeOp(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsd__DiscoveryProxyProbeOp(struct soap *soap, const char *tag, int id, const struct __wsd__DiscoveryProxyProbeOp *a, const char *type)
{
	soap_out_PointerTowsd__ProbeType(soap, "wsd:Probe", -1, &a->wsd__Probe, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsd__DiscoveryProxyProbeOp * SOAP_FMAC4 soap_get___wsd__DiscoveryProxyProbeOp(struct soap *soap, struct __wsd__DiscoveryProxyProbeOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsd__DiscoveryProxyProbeOp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __wsd__DiscoveryProxyProbeOp * SOAP_FMAC4 soap_in___wsd__DiscoveryProxyProbeOp(struct soap *soap, const char *tag, struct __wsd__DiscoveryProxyProbeOp *a, const char *type)
{
	short soap_flag_wsd__Probe = 1;
	a = (struct __wsd__DiscoveryProxyProbeOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___wsd__DiscoveryProxyProbeOp, sizeof(struct __wsd__DiscoveryProxyProbeOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsd__DiscoveryProxyProbeOp(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsd__Probe && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ProbeType(soap, "wsd:Probe", &a->wsd__Probe, "wsd:ProbeType"))
				{	soap_flag_wsd__Probe--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsd__DirectedProbeOp(struct soap *soap, const struct __wsd__DirectedProbeOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsd__ProbeType(soap, &a->wsd__Probe);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsd__DirectedProbeOp(struct soap *soap, struct __wsd__DirectedProbeOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsd__Probe = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsd__DirectedProbeOp(struct soap *soap, const struct __wsd__DirectedProbeOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsd__DirectedProbeOp(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsd__DirectedProbeOp(struct soap *soap, const char *tag, int id, const struct __wsd__DirectedProbeOp *a, const char *type)
{
	soap_out_PointerTowsd__ProbeType(soap, "wsd:Probe", -1, &a->wsd__Probe, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsd__DirectedProbeOp * SOAP_FMAC4 soap_get___wsd__DirectedProbeOp(struct soap *soap, struct __wsd__DirectedProbeOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsd__DirectedProbeOp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __wsd__DirectedProbeOp * SOAP_FMAC4 soap_in___wsd__DirectedProbeOp(struct soap *soap, const char *tag, struct __wsd__DirectedProbeOp *a, const char *type)
{
	short soap_flag_wsd__Probe = 1;
	a = (struct __wsd__DirectedProbeOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___wsd__DirectedProbeOp, sizeof(struct __wsd__DirectedProbeOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsd__DirectedProbeOp(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsd__Probe && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ProbeType(soap, "wsd:Probe", &a->wsd__Probe, "wsd:ProbeType"))
				{	soap_flag_wsd__Probe--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsd__ResolveMatchOp(struct soap *soap, const struct __wsd__ResolveMatchOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsd__ResolveMatchesType(soap, &a->wsd__ResolveMatches);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsd__ResolveMatchOp(struct soap *soap, struct __wsd__ResolveMatchOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsd__ResolveMatches = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsd__ResolveMatchOp(struct soap *soap, const struct __wsd__ResolveMatchOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsd__ResolveMatchOp(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsd__ResolveMatchOp(struct soap *soap, const char *tag, int id, const struct __wsd__ResolveMatchOp *a, const char *type)
{
	soap_out_PointerTowsd__ResolveMatchesType(soap, "wsd:ResolveMatches", -1, &a->wsd__ResolveMatches, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsd__ResolveMatchOp * SOAP_FMAC4 soap_get___wsd__ResolveMatchOp(struct soap *soap, struct __wsd__ResolveMatchOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsd__ResolveMatchOp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __wsd__ResolveMatchOp * SOAP_FMAC4 soap_in___wsd__ResolveMatchOp(struct soap *soap, const char *tag, struct __wsd__ResolveMatchOp *a, const char *type)
{
	short soap_flag_wsd__ResolveMatches = 1;
	a = (struct __wsd__ResolveMatchOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___wsd__ResolveMatchOp, sizeof(struct __wsd__ResolveMatchOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsd__ResolveMatchOp(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsd__ResolveMatches && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ResolveMatchesType(soap, "wsd:ResolveMatches", &a->wsd__ResolveMatches, "wsd:ResolveMatchesType"))
				{	soap_flag_wsd__ResolveMatches--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsd__ResolveOp(struct soap *soap, const struct __wsd__ResolveOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsd__ResolveType(soap, &a->wsd__Resolve);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsd__ResolveOp(struct soap *soap, struct __wsd__ResolveOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsd__Resolve = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsd__ResolveOp(struct soap *soap, const struct __wsd__ResolveOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsd__ResolveOp(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsd__ResolveOp(struct soap *soap, const char *tag, int id, const struct __wsd__ResolveOp *a, const char *type)
{
	soap_out_PointerTowsd__ResolveType(soap, "wsd:Resolve", -1, &a->wsd__Resolve, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsd__ResolveOp * SOAP_FMAC4 soap_get___wsd__ResolveOp(struct soap *soap, struct __wsd__ResolveOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsd__ResolveOp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __wsd__ResolveOp * SOAP_FMAC4 soap_in___wsd__ResolveOp(struct soap *soap, const char *tag, struct __wsd__ResolveOp *a, const char *type)
{
	short soap_flag_wsd__Resolve = 1;
	a = (struct __wsd__ResolveOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___wsd__ResolveOp, sizeof(struct __wsd__ResolveOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsd__ResolveOp(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsd__Resolve && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ResolveType(soap, "wsd:Resolve", &a->wsd__Resolve, "wsd:ResolveType"))
				{	soap_flag_wsd__Resolve--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsd__ProbeMatchOp(struct soap *soap, const struct __wsd__ProbeMatchOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsd__ProbeMatchesType(soap, &a->wsd__ProbeMatches);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsd__ProbeMatchOp(struct soap *soap, struct __wsd__ProbeMatchOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsd__ProbeMatches = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsd__ProbeMatchOp(struct soap *soap, const struct __wsd__ProbeMatchOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsd__ProbeMatchOp(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsd__ProbeMatchOp(struct soap *soap, const char *tag, int id, const struct __wsd__ProbeMatchOp *a, const char *type)
{
	soap_out_PointerTowsd__ProbeMatchesType(soap, "wsd:ProbeMatches", -1, &a->wsd__ProbeMatches, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsd__ProbeMatchOp * SOAP_FMAC4 soap_get___wsd__ProbeMatchOp(struct soap *soap, struct __wsd__ProbeMatchOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsd__ProbeMatchOp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __wsd__ProbeMatchOp * SOAP_FMAC4 soap_in___wsd__ProbeMatchOp(struct soap *soap, const char *tag, struct __wsd__ProbeMatchOp *a, const char *type)
{
	short soap_flag_wsd__ProbeMatches = 1;
	a = (struct __wsd__ProbeMatchOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___wsd__ProbeMatchOp, sizeof(struct __wsd__ProbeMatchOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsd__ProbeMatchOp(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsd__ProbeMatches && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ProbeMatchesType(soap, "wsd:ProbeMatches", &a->wsd__ProbeMatches, "wsd:ProbeMatchesType"))
				{	soap_flag_wsd__ProbeMatches--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsd__ProbeOp(struct soap *soap, const struct __wsd__ProbeOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsd__ProbeType(soap, &a->wsd__Probe);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsd__ProbeOp(struct soap *soap, struct __wsd__ProbeOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsd__Probe = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsd__ProbeOp(struct soap *soap, const struct __wsd__ProbeOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsd__ProbeOp(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsd__ProbeOp(struct soap *soap, const char *tag, int id, const struct __wsd__ProbeOp *a, const char *type)
{
	soap_out_PointerTowsd__ProbeType(soap, "wsd:Probe", -1, &a->wsd__Probe, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsd__ProbeOp * SOAP_FMAC4 soap_get___wsd__ProbeOp(struct soap *soap, struct __wsd__ProbeOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsd__ProbeOp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __wsd__ProbeOp * SOAP_FMAC4 soap_in___wsd__ProbeOp(struct soap *soap, const char *tag, struct __wsd__ProbeOp *a, const char *type)
{
	short soap_flag_wsd__Probe = 1;
	a = (struct __wsd__ProbeOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___wsd__ProbeOp, sizeof(struct __wsd__ProbeOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsd__ProbeOp(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsd__Probe && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ProbeType(soap, "wsd:Probe", &a->wsd__Probe, "wsd:ProbeType"))
				{	soap_flag_wsd__Probe--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsd__ByeOp(struct soap *soap, const struct __wsd__ByeOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsd__ByeType(soap, &a->wsd__Bye);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsd__ByeOp(struct soap *soap, struct __wsd__ByeOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsd__Bye = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsd__ByeOp(struct soap *soap, const struct __wsd__ByeOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsd__ByeOp(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsd__ByeOp(struct soap *soap, const char *tag, int id, const struct __wsd__ByeOp *a, const char *type)
{
	soap_out_PointerTowsd__ByeType(soap, "wsd:Bye", -1, &a->wsd__Bye, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsd__ByeOp * SOAP_FMAC4 soap_get___wsd__ByeOp(struct soap *soap, struct __wsd__ByeOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsd__ByeOp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __wsd__ByeOp * SOAP_FMAC4 soap_in___wsd__ByeOp(struct soap *soap, const char *tag, struct __wsd__ByeOp *a, const char *type)
{
	short soap_flag_wsd__Bye = 1;
	a = (struct __wsd__ByeOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___wsd__ByeOp, sizeof(struct __wsd__ByeOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsd__ByeOp(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsd__Bye && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ByeType(soap, "wsd:Bye", &a->wsd__Bye, "wsd:ByeType"))
				{	soap_flag_wsd__Bye--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___wsd__HelloOp(struct soap *soap, const struct __wsd__HelloOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsd__HelloType(soap, &a->wsd__Hello);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___wsd__HelloOp(struct soap *soap, struct __wsd__HelloOp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsd__Hello = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___wsd__HelloOp(struct soap *soap, const struct __wsd__HelloOp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___wsd__HelloOp(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___wsd__HelloOp(struct soap *soap, const char *tag, int id, const struct __wsd__HelloOp *a, const char *type)
{
	soap_out_PointerTowsd__HelloType(soap, "wsd:Hello", -1, &a->wsd__Hello, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __wsd__HelloOp * SOAP_FMAC4 soap_get___wsd__HelloOp(struct soap *soap, struct __wsd__HelloOp *p, const char *tag, const char *type)
{
	if ((p = soap_in___wsd__HelloOp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __wsd__HelloOp * SOAP_FMAC4 soap_in___wsd__HelloOp(struct soap *soap, const char *tag, struct __wsd__HelloOp *a, const char *type)
{
	short soap_flag_wsd__Hello = 1;
	a = (struct __wsd__HelloOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___wsd__HelloOp, sizeof(struct __wsd__HelloOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___wsd__HelloOp(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsd__Hello && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__HelloType(soap, "wsd:Hello", &a->wsd__Hello, "wsd:HelloType"))
				{	soap_flag_wsd__Hello--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsd__AppSequence(struct soap *soap, struct wsd__AppSequenceType const*a)
{	soap_serialize_wsd__AppSequenceType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsd__AppSequence(struct soap *soap, struct wsd__AppSequenceType *a)
{	soap_default_wsd__AppSequenceType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsd__AppSequence(struct soap *soap, const struct wsd__AppSequenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsd__AppSequence);
	if (soap_out__wsd__AppSequence(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsd__AppSequence(struct soap *soap, const char *tag, int id, const struct wsd__AppSequenceType *a, const char *type)
{
	soap_set_attr(soap, "InstanceId", soap_unsignedInt2s(soap, a->InstanceId));
	if (a->SequenceId)
		soap_set_attr(soap, "SequenceId", a->SequenceId);
	soap_set_attr(soap, "MessageNumber", soap_unsignedInt2s(soap, a->MessageNumber));
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsd__AppSequence), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__AppSequenceType * SOAP_FMAC4 soap_get__wsd__AppSequence(struct soap *soap, struct wsd__AppSequenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsd__AppSequence(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__AppSequenceType * SOAP_FMAC4 soap_in__wsd__AppSequence(struct soap *soap, const char *tag, struct wsd__AppSequenceType *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__AppSequenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsd__AppSequence, sizeof(struct wsd__AppSequenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsd__AppSequence(soap, a);
	if (soap_s2unsignedInt(soap, soap_attr_value(soap, "InstanceId", 1), &a->InstanceId))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "SequenceId", 0), &a->SequenceId))
		return NULL;
	if (soap_s2unsignedInt(soap, soap_attr_value(soap, "MessageNumber", 1), &a->MessageNumber))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__AppSequenceType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wsd__AppSequence, 0, sizeof(struct wsd__AppSequenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsd__Scopes(struct soap *soap, struct wsd__ScopesType const*a)
{	soap_serialize_wsd__ScopesType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsd__Scopes(struct soap *soap, struct wsd__ScopesType *a)
{	soap_default_wsd__ScopesType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsd__Scopes(struct soap *soap, const struct wsd__ScopesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsd__Scopes);
	if (soap_out__wsd__Scopes(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsd__Scopes(struct soap *soap, const char *tag, int id, const struct wsd__ScopesType *a, const char *type)
{
	if (a->MatchBy)
		soap_set_attr(soap, "MatchBy", a->MatchBy);
	return soap_out_uri_list(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wsd__ScopesType * SOAP_FMAC4 soap_get__wsd__Scopes(struct soap *soap, struct wsd__ScopesType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsd__Scopes(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ScopesType * SOAP_FMAC4 soap_in__wsd__Scopes(struct soap *soap, const char *tag, struct wsd__ScopesType *a, const char *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!(a = (struct wsd__ScopesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsd__Scopes, sizeof(struct wsd__ScopesType), 0, NULL, NULL, NULL)))
		return NULL;
	*soap->id = '\0';
	soap_default__wsd__Scopes(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "MatchBy", 0), &a->MatchBy))
		return NULL;
	if (!soap_in_uri_list(soap, tag, &a->__item, ""))
		return NULL;
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsd__ResolveMatches(struct soap *soap, struct wsd__ResolveMatchesType const*a)
{	soap_serialize_wsd__ResolveMatchesType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsd__ResolveMatches(struct soap *soap, struct wsd__ResolveMatchesType *a)
{	soap_default_wsd__ResolveMatchesType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsd__ResolveMatches(struct soap *soap, const struct wsd__ResolveMatchesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsd__ResolveMatches);
	if (soap_out__wsd__ResolveMatches(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsd__ResolveMatches(struct soap *soap, const char *tag, int id, const struct wsd__ResolveMatchesType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsd__ResolveMatches), type);
	if (a->ResolveMatch)
		soap_element_result(soap, "wsd:ResolveMatch");
	soap_out_PointerTowsd__HelloType(soap, "wsd:ResolveMatch", -1, &a->ResolveMatch, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__ResolveMatchesType * SOAP_FMAC4 soap_get__wsd__ResolveMatches(struct soap *soap, struct wsd__ResolveMatchesType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsd__ResolveMatches(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ResolveMatchesType * SOAP_FMAC4 soap_in__wsd__ResolveMatches(struct soap *soap, const char *tag, struct wsd__ResolveMatchesType *a, const char *type)
{
	short soap_flag_ResolveMatch = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__ResolveMatchesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsd__ResolveMatches, sizeof(struct wsd__ResolveMatchesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsd__ResolveMatches(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ResolveMatch && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__HelloType(soap, "wsd:ResolveMatch", &a->ResolveMatch, "wsd:HelloType"))
				{	soap_flag_ResolveMatch--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__ResolveMatchesType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wsd__ResolveMatches, 0, sizeof(struct wsd__ResolveMatchesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsd__Resolve(struct soap *soap, struct wsd__ResolveType const*a)
{	soap_serialize_wsd__ResolveType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsd__Resolve(struct soap *soap, struct wsd__ResolveType *a)
{	soap_default_wsd__ResolveType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsd__Resolve(struct soap *soap, const struct wsd__ResolveType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsd__Resolve);
	if (soap_out__wsd__Resolve(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsd__Resolve(struct soap *soap, const char *tag, int id, const struct wsd__ResolveType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsd__Resolve), type);
	soap_out_endpoint_ref(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__ResolveType * SOAP_FMAC4 soap_get__wsd__Resolve(struct soap *soap, struct wsd__ResolveType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsd__Resolve(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ResolveType * SOAP_FMAC4 soap_in__wsd__Resolve(struct soap *soap, const char *tag, struct wsd__ResolveType *a, const char *type)
{
	short soap_flag_wsa__EndpointReference = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__ResolveType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsd__Resolve, sizeof(struct wsd__ResolveType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsd__Resolve(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_endpoint_ref(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "endpoint-ref"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__ResolveType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wsd__Resolve, 0, sizeof(struct wsd__ResolveType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsd__ProbeMatches(struct soap *soap, struct wsd__ProbeMatchesType const*a)
{	soap_serialize_wsd__ProbeMatchesType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsd__ProbeMatches(struct soap *soap, struct wsd__ProbeMatchesType *a)
{	soap_default_wsd__ProbeMatchesType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsd__ProbeMatches(struct soap *soap, const struct wsd__ProbeMatchesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsd__ProbeMatches);
	if (soap_out__wsd__ProbeMatches(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsd__ProbeMatches(struct soap *soap, const char *tag, int id, const struct wsd__ProbeMatchesType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsd__ProbeMatches), type);
	soap_element_result(soap, "-sizeProbeMatch");
	if (a->ProbeMatch)
	{	int i;
		for (i = 0; i < a->__sizeProbeMatch; i++)
			soap_out_PointerTowsd__HelloType(soap, "wsd:ProbeMatch", -1, a->ProbeMatch + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__ProbeMatchesType * SOAP_FMAC4 soap_get__wsd__ProbeMatches(struct soap *soap, struct wsd__ProbeMatchesType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsd__ProbeMatches(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ProbeMatchesType * SOAP_FMAC4 soap_in__wsd__ProbeMatches(struct soap *soap, const char *tag, struct wsd__ProbeMatchesType *a, const char *type)
{
	short soap_flag_ProbeMatch = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__ProbeMatchesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsd__ProbeMatches, sizeof(struct wsd__ProbeMatchesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsd__ProbeMatches(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProbeMatch && soap->error == SOAP_TAG_MISMATCH)
			{	struct wsd__HelloType **p;
				soap_new_block(soap);
				for (a->__sizeProbeMatch = 0; !soap_element_begin_in(soap, "wsd:ProbeMatch", 1); a->__sizeProbeMatch++)
				{	p = (struct wsd__HelloType **)soap_push_block(soap, sizeof(struct wsd__HelloType *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerTowsd__HelloType(soap, "wsd:ProbeMatch", p, "wsd:HelloType"))
						break;
					soap_flag_ProbeMatch = 0;
				}
				a->ProbeMatch = (struct wsd__HelloType **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_ProbeMatch && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__ProbeMatchesType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wsd__ProbeMatches, 0, sizeof(struct wsd__ProbeMatchesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsd__Probe(struct soap *soap, struct wsd__ProbeType const*a)
{	soap_serialize_wsd__ProbeType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsd__Probe(struct soap *soap, struct wsd__ProbeType *a)
{	soap_default_wsd__ProbeType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsd__Probe(struct soap *soap, const struct wsd__ProbeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsd__Probe);
	if (soap_out__wsd__Probe(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsd__Probe(struct soap *soap, const char *tag, int id, const struct wsd__ProbeType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsd__Probe), type);
	soap_out_qname_list(soap, "wsd:Types", -1, &a->Types, "");
	soap_out_PointerTowsd__ScopesType(soap, "wsd:Scopes", -1, &a->Scopes, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__ProbeType * SOAP_FMAC4 soap_get__wsd__Probe(struct soap *soap, struct wsd__ProbeType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsd__Probe(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ProbeType * SOAP_FMAC4 soap_in__wsd__Probe(struct soap *soap, const char *tag, struct wsd__ProbeType *a, const char *type)
{
	short soap_flag_Types = 1, soap_flag_Scopes = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__ProbeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsd__Probe, sizeof(struct wsd__ProbeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsd__Probe(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Types && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_qname_list(soap, "wsd:Types", &a->Types, "qname-list"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ScopesType(soap, "wsd:Scopes", &a->Scopes, "wsd:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__ProbeType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wsd__Probe, 0, sizeof(struct wsd__ProbeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsd__Bye(struct soap *soap, struct wsd__ByeType const*a)
{	soap_serialize_wsd__ByeType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsd__Bye(struct soap *soap, struct wsd__ByeType *a)
{	soap_default_wsd__ByeType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsd__Bye(struct soap *soap, const struct wsd__ByeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsd__Bye);
	if (soap_out__wsd__Bye(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsd__Bye(struct soap *soap, const char *tag, int id, const struct wsd__ByeType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsd__Bye), type);
	soap_out_endpoint_ref(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__ByeType * SOAP_FMAC4 soap_get__wsd__Bye(struct soap *soap, struct wsd__ByeType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsd__Bye(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ByeType * SOAP_FMAC4 soap_in__wsd__Bye(struct soap *soap, const char *tag, struct wsd__ByeType *a, const char *type)
{
	short soap_flag_wsa__EndpointReference = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__ByeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsd__Bye, sizeof(struct wsd__ByeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsd__Bye(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_endpoint_ref(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "endpoint-ref"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__ByeType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wsd__Bye, 0, sizeof(struct wsd__ByeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsd__Hello(struct soap *soap, struct wsd__HelloType const*a)
{	soap_serialize_wsd__HelloType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsd__Hello(struct soap *soap, struct wsd__HelloType *a)
{	soap_default_wsd__HelloType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsd__Hello(struct soap *soap, const struct wsd__HelloType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsd__Hello);
	if (soap_out__wsd__Hello(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsd__Hello(struct soap *soap, const char *tag, int id, const struct wsd__HelloType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsd__Hello), type);
	soap_out_endpoint_ref(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, "");
	soap_out_qname_list(soap, "wsd:Types", -1, &a->Types, "");
	soap_out_PointerTowsd__ScopesType(soap, "wsd:Scopes", -1, &a->Scopes, "");
	soap_out_uri_list(soap, "wsd:XAddrs", -1, &a->XAddrs, "");
	soap_out_unsignedInt(soap, "wsd:MetadataVersion", -1, &a->MetadataVersion, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__HelloType * SOAP_FMAC4 soap_get__wsd__Hello(struct soap *soap, struct wsd__HelloType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsd__Hello(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__HelloType * SOAP_FMAC4 soap_in__wsd__Hello(struct soap *soap, const char *tag, struct wsd__HelloType *a, const char *type)
{
	short soap_flag_wsa__EndpointReference = 1, soap_flag_Types = 1, soap_flag_Scopes = 1, soap_flag_XAddrs = 1, soap_flag_MetadataVersion = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__HelloType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsd__Hello, sizeof(struct wsd__HelloType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsd__Hello(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_endpoint_ref(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "endpoint-ref"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap_flag_Types && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_qname_list(soap, "wsd:Types", &a->Types, "qname-list"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ScopesType(soap, "wsd:Scopes", &a->Scopes, "wsd:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap_flag_XAddrs && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_uri_list(soap, "wsd:XAddrs", &a->XAddrs, "uri-list"))
				{	soap_flag_XAddrs--;
					continue;
				}
			if (soap_flag_MetadataVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "wsd:MetadataVersion", &a->MetadataVersion, "xsd:unsignedInt"))
				{	soap_flag_MetadataVersion--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0 || soap_flag_MetadataVersion > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__HelloType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wsd__Hello, 0, sizeof(struct wsd__HelloType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsd__AppSequenceType(struct soap *soap, const struct wsd__AppSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__AppSequenceType(struct soap *soap, struct wsd__AppSequenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_unsignedInt(soap, &a->InstanceId);
	soap_default_xsd__anyURI(soap, &a->SequenceId);
	soap_default_unsignedInt(soap, &a->MessageNumber);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__AppSequenceType(struct soap *soap, const struct wsd__AppSequenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__AppSequenceType);
	if (soap_out_wsd__AppSequenceType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__AppSequenceType(struct soap *soap, const char *tag, int id, const struct wsd__AppSequenceType *a, const char *type)
{
	soap_set_attr(soap, "InstanceId", soap_unsignedInt2s(soap, a->InstanceId));
	if (a->SequenceId)
		soap_set_attr(soap, "SequenceId", a->SequenceId);
	soap_set_attr(soap, "MessageNumber", soap_unsignedInt2s(soap, a->MessageNumber));
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsd__AppSequenceType), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__AppSequenceType * SOAP_FMAC4 soap_get_wsd__AppSequenceType(struct soap *soap, struct wsd__AppSequenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__AppSequenceType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__AppSequenceType * SOAP_FMAC4 soap_in_wsd__AppSequenceType(struct soap *soap, const char *tag, struct wsd__AppSequenceType *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__AppSequenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsd__AppSequenceType, sizeof(struct wsd__AppSequenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsd__AppSequenceType(soap, a);
	if (soap_s2unsignedInt(soap, soap_attr_value(soap, "InstanceId", 1), &a->InstanceId))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "SequenceId", 0), &a->SequenceId))
		return NULL;
	if (soap_s2unsignedInt(soap, soap_attr_value(soap, "MessageNumber", 1), &a->MessageNumber))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__AppSequenceType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wsd__AppSequenceType, 0, sizeof(struct wsd__AppSequenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsd__ResolveMatchesType(struct soap *soap, const struct wsd__ResolveMatchesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowsd__HelloType(soap, &a->ResolveMatch);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__ResolveMatchesType(struct soap *soap, struct wsd__ResolveMatchesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ResolveMatch = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__ResolveMatchesType(struct soap *soap, const struct wsd__ResolveMatchesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__ResolveMatchesType);
	if (soap_out_wsd__ResolveMatchesType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__ResolveMatchesType(struct soap *soap, const char *tag, int id, const struct wsd__ResolveMatchesType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsd__ResolveMatchesType), type);
	if (a->ResolveMatch)
		soap_element_result(soap, "wsd:ResolveMatch");
	soap_out_PointerTowsd__HelloType(soap, "wsd:ResolveMatch", -1, &a->ResolveMatch, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__ResolveMatchesType * SOAP_FMAC4 soap_get_wsd__ResolveMatchesType(struct soap *soap, struct wsd__ResolveMatchesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__ResolveMatchesType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ResolveMatchesType * SOAP_FMAC4 soap_in_wsd__ResolveMatchesType(struct soap *soap, const char *tag, struct wsd__ResolveMatchesType *a, const char *type)
{
	short soap_flag_ResolveMatch = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__ResolveMatchesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsd__ResolveMatchesType, sizeof(struct wsd__ResolveMatchesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsd__ResolveMatchesType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ResolveMatch && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__HelloType(soap, "wsd:ResolveMatch", &a->ResolveMatch, "wsd:HelloType"))
				{	soap_flag_ResolveMatch--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__ResolveMatchesType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wsd__ResolveMatchesType, 0, sizeof(struct wsd__ResolveMatchesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsd__ResolveType(struct soap *soap, const struct wsd__ResolveType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_endpoint_ref(soap, &a->wsa__EndpointReference);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__ResolveType(struct soap *soap, struct wsd__ResolveType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsa__EndpointReference = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__ResolveType(struct soap *soap, const struct wsd__ResolveType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__ResolveType);
	if (soap_out_wsd__ResolveType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__ResolveType(struct soap *soap, const char *tag, int id, const struct wsd__ResolveType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsd__ResolveType), type);
	soap_out_endpoint_ref(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__ResolveType * SOAP_FMAC4 soap_get_wsd__ResolveType(struct soap *soap, struct wsd__ResolveType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__ResolveType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ResolveType * SOAP_FMAC4 soap_in_wsd__ResolveType(struct soap *soap, const char *tag, struct wsd__ResolveType *a, const char *type)
{
	short soap_flag_wsa__EndpointReference = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__ResolveType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsd__ResolveType, sizeof(struct wsd__ResolveType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsd__ResolveType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_endpoint_ref(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "endpoint-ref"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__ResolveType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wsd__ResolveType, 0, sizeof(struct wsd__ResolveType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsd__ProbeMatchesType(struct soap *soap, const struct wsd__ProbeMatchesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->ProbeMatch)
	{	int i;
		for (i = 0; i < a->__sizeProbeMatch; i++)
		{
			soap_serialize_PointerTowsd__HelloType(soap, a->ProbeMatch + i);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__ProbeMatchesType(struct soap *soap, struct wsd__ProbeMatchesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeProbeMatch = 0;
	a->ProbeMatch = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__ProbeMatchesType(struct soap *soap, const struct wsd__ProbeMatchesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__ProbeMatchesType);
	if (soap_out_wsd__ProbeMatchesType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__ProbeMatchesType(struct soap *soap, const char *tag, int id, const struct wsd__ProbeMatchesType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsd__ProbeMatchesType), type);
	soap_element_result(soap, "-sizeProbeMatch");
	if (a->ProbeMatch)
	{	int i;
		for (i = 0; i < a->__sizeProbeMatch; i++)
			soap_out_PointerTowsd__HelloType(soap, "wsd:ProbeMatch", -1, a->ProbeMatch + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__ProbeMatchesType * SOAP_FMAC4 soap_get_wsd__ProbeMatchesType(struct soap *soap, struct wsd__ProbeMatchesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__ProbeMatchesType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ProbeMatchesType * SOAP_FMAC4 soap_in_wsd__ProbeMatchesType(struct soap *soap, const char *tag, struct wsd__ProbeMatchesType *a, const char *type)
{
	short soap_flag_ProbeMatch = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__ProbeMatchesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsd__ProbeMatchesType, sizeof(struct wsd__ProbeMatchesType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsd__ProbeMatchesType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ProbeMatch && soap->error == SOAP_TAG_MISMATCH)
			{	struct wsd__HelloType **p;
				soap_new_block(soap);
				for (a->__sizeProbeMatch = 0; !soap_element_begin_in(soap, "wsd:ProbeMatch", 1); a->__sizeProbeMatch++)
				{	p = (struct wsd__HelloType **)soap_push_block(soap, sizeof(struct wsd__HelloType *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerTowsd__HelloType(soap, "wsd:ProbeMatch", p, "wsd:HelloType"))
						break;
					soap_flag_ProbeMatch = 0;
				}
				a->ProbeMatch = (struct wsd__HelloType **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_ProbeMatch && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__ProbeMatchesType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wsd__ProbeMatchesType, 0, sizeof(struct wsd__ProbeMatchesType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsd__ProbeType(struct soap *soap, const struct wsd__ProbeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_qname_list(soap, &a->Types);
	soap_serialize_PointerTowsd__ScopesType(soap, &a->Scopes);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__ProbeType(struct soap *soap, struct wsd__ProbeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Types = NULL;
	a->Scopes = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__ProbeType(struct soap *soap, const struct wsd__ProbeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__ProbeType);
	if (soap_out_wsd__ProbeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__ProbeType(struct soap *soap, const char *tag, int id, const struct wsd__ProbeType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsd__ProbeType), type);
	soap_out_qname_list(soap, "wsd:Types", -1, &a->Types, "");
	soap_out_PointerTowsd__ScopesType(soap, "wsd:Scopes", -1, &a->Scopes, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__ProbeType * SOAP_FMAC4 soap_get_wsd__ProbeType(struct soap *soap, struct wsd__ProbeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__ProbeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ProbeType * SOAP_FMAC4 soap_in_wsd__ProbeType(struct soap *soap, const char *tag, struct wsd__ProbeType *a, const char *type)
{
	short soap_flag_Types = 1, soap_flag_Scopes = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__ProbeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsd__ProbeType, sizeof(struct wsd__ProbeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsd__ProbeType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Types && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_qname_list(soap, "wsd:Types", &a->Types, "qname-list"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ScopesType(soap, "wsd:Scopes", &a->Scopes, "wsd:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__ProbeType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wsd__ProbeType, 0, sizeof(struct wsd__ProbeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsd__ByeType(struct soap *soap, const struct wsd__ByeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_endpoint_ref(soap, &a->wsa__EndpointReference);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__ByeType(struct soap *soap, struct wsd__ByeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsa__EndpointReference = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__ByeType(struct soap *soap, const struct wsd__ByeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__ByeType);
	if (soap_out_wsd__ByeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__ByeType(struct soap *soap, const char *tag, int id, const struct wsd__ByeType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsd__ByeType), type);
	soap_out_endpoint_ref(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__ByeType * SOAP_FMAC4 soap_get_wsd__ByeType(struct soap *soap, struct wsd__ByeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__ByeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ByeType * SOAP_FMAC4 soap_in_wsd__ByeType(struct soap *soap, const char *tag, struct wsd__ByeType *a, const char *type)
{
	short soap_flag_wsa__EndpointReference = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__ByeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsd__ByeType, sizeof(struct wsd__ByeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsd__ByeType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_endpoint_ref(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "endpoint-ref"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__ByeType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wsd__ByeType, 0, sizeof(struct wsd__ByeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsd__ScopesType(struct soap *soap, const struct wsd__ScopesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_uri_list(soap, &a->__item);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__ScopesType(struct soap *soap, struct wsd__ScopesType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__item = NULL;
	soap_default_xsd__anyURI(soap, &a->MatchBy);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__ScopesType(struct soap *soap, const struct wsd__ScopesType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__ScopesType);
	if (soap_out_wsd__ScopesType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__ScopesType(struct soap *soap, const char *tag, int id, const struct wsd__ScopesType *a, const char *type)
{
	if (a->MatchBy)
		soap_set_attr(soap, "MatchBy", a->MatchBy);
	return soap_out_uri_list(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wsd__ScopesType * SOAP_FMAC4 soap_get_wsd__ScopesType(struct soap *soap, struct wsd__ScopesType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__ScopesType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ScopesType * SOAP_FMAC4 soap_in_wsd__ScopesType(struct soap *soap, const char *tag, struct wsd__ScopesType *a, const char *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!(a = (struct wsd__ScopesType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsd__ScopesType, sizeof(struct wsd__ScopesType), 0, NULL, NULL, NULL)))
		return NULL;
	*soap->id = '\0';
	soap_default_wsd__ScopesType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "MatchBy", 0), &a->MatchBy))
		return NULL;
	if (!soap_in_uri_list(soap, tag, &a->__item, "wsd:ScopesType"))
		return NULL;
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsd__HelloType(struct soap *soap, const struct wsd__HelloType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_endpoint_ref(soap, &a->wsa__EndpointReference);
	soap_serialize_qname_list(soap, &a->Types);
	soap_serialize_PointerTowsd__ScopesType(soap, &a->Scopes);
	soap_serialize_uri_list(soap, &a->XAddrs);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__HelloType(struct soap *soap, struct wsd__HelloType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsa__EndpointReference = NULL;
	a->Types = NULL;
	a->Scopes = NULL;
	a->XAddrs = NULL;
	soap_default_unsignedInt(soap, &a->MetadataVersion);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__HelloType(struct soap *soap, const struct wsd__HelloType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__HelloType);
	if (soap_out_wsd__HelloType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__HelloType(struct soap *soap, const char *tag, int id, const struct wsd__HelloType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsd__HelloType), type);
	soap_out_endpoint_ref(soap, "wsa:EndpointReference", -1, &a->wsa__EndpointReference, "");
	soap_out_qname_list(soap, "wsd:Types", -1, &a->Types, "");
	soap_out_PointerTowsd__ScopesType(soap, "wsd:Scopes", -1, &a->Scopes, "");
	soap_out_uri_list(soap, "wsd:XAddrs", -1, &a->XAddrs, "");
	soap_out_unsignedInt(soap, "wsd:MetadataVersion", -1, &a->MetadataVersion, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsd__HelloType * SOAP_FMAC4 soap_get_wsd__HelloType(struct soap *soap, struct wsd__HelloType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__HelloType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__HelloType * SOAP_FMAC4 soap_in_wsd__HelloType(struct soap *soap, const char *tag, struct wsd__HelloType *a, const char *type)
{
	short soap_flag_wsa__EndpointReference = 1, soap_flag_Types = 1, soap_flag_Scopes = 1, soap_flag_XAddrs = 1, soap_flag_MetadataVersion = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsd__HelloType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsd__HelloType, sizeof(struct wsd__HelloType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsd__HelloType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_endpoint_ref(soap, "wsa:EndpointReference", &a->wsa__EndpointReference, "endpoint-ref"))
				{	soap_flag_wsa__EndpointReference--;
					continue;
				}
			if (soap_flag_Types && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_qname_list(soap, "wsd:Types", &a->Types, "qname-list"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_Scopes && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowsd__ScopesType(soap, "wsd:Scopes", &a->Scopes, "wsd:ScopesType"))
				{	soap_flag_Scopes--;
					continue;
				}
			if (soap_flag_XAddrs && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_uri_list(soap, "wsd:XAddrs", &a->XAddrs, "uri-list"))
				{	soap_flag_XAddrs--;
					continue;
				}
			if (soap_flag_MetadataVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedInt(soap, "wsd:MetadataVersion", &a->MetadataVersion, "xsd:unsignedInt"))
				{	soap_flag_MetadataVersion--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_wsa__EndpointReference > 0 || soap_flag_MetadataVersion > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsd__HelloType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wsd__HelloType, 0, sizeof(struct wsd__HelloType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsd__ResolveMatchesType(struct soap *soap, struct wsd__ResolveMatchesType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsd__ResolveMatchesType))
		soap_serialize_wsd__ResolveMatchesType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsd__ResolveMatchesType(struct soap *soap, struct wsd__ResolveMatchesType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsd__ResolveMatchesType);
	if (soap_out_PointerTowsd__ResolveMatchesType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsd__ResolveMatchesType(struct soap *soap, const char *tag, int id, struct wsd__ResolveMatchesType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsd__ResolveMatchesType);
	if (id < 0)
		return soap->error;
	return soap_out_wsd__ResolveMatchesType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsd__ResolveMatchesType ** SOAP_FMAC4 soap_get_PointerTowsd__ResolveMatchesType(struct soap *soap, struct wsd__ResolveMatchesType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsd__ResolveMatchesType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ResolveMatchesType ** SOAP_FMAC4 soap_in_PointerTowsd__ResolveMatchesType(struct soap *soap, const char *tag, struct wsd__ResolveMatchesType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wsd__ResolveMatchesType **)soap_malloc(soap, sizeof(struct wsd__ResolveMatchesType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsd__ResolveMatchesType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsd__ResolveMatchesType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsd__ResolveMatchesType, sizeof(struct wsd__ResolveMatchesType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsd__ResolveType(struct soap *soap, struct wsd__ResolveType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsd__ResolveType))
		soap_serialize_wsd__ResolveType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsd__ResolveType(struct soap *soap, struct wsd__ResolveType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsd__ResolveType);
	if (soap_out_PointerTowsd__ResolveType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsd__ResolveType(struct soap *soap, const char *tag, int id, struct wsd__ResolveType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsd__ResolveType);
	if (id < 0)
		return soap->error;
	return soap_out_wsd__ResolveType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsd__ResolveType ** SOAP_FMAC4 soap_get_PointerTowsd__ResolveType(struct soap *soap, struct wsd__ResolveType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsd__ResolveType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ResolveType ** SOAP_FMAC4 soap_in_PointerTowsd__ResolveType(struct soap *soap, const char *tag, struct wsd__ResolveType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wsd__ResolveType **)soap_malloc(soap, sizeof(struct wsd__ResolveType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsd__ResolveType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsd__ResolveType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsd__ResolveType, sizeof(struct wsd__ResolveType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsd__ProbeMatchesType(struct soap *soap, struct wsd__ProbeMatchesType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsd__ProbeMatchesType))
		soap_serialize_wsd__ProbeMatchesType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsd__ProbeMatchesType(struct soap *soap, struct wsd__ProbeMatchesType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsd__ProbeMatchesType);
	if (soap_out_PointerTowsd__ProbeMatchesType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsd__ProbeMatchesType(struct soap *soap, const char *tag, int id, struct wsd__ProbeMatchesType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsd__ProbeMatchesType);
	if (id < 0)
		return soap->error;
	return soap_out_wsd__ProbeMatchesType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsd__ProbeMatchesType ** SOAP_FMAC4 soap_get_PointerTowsd__ProbeMatchesType(struct soap *soap, struct wsd__ProbeMatchesType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsd__ProbeMatchesType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ProbeMatchesType ** SOAP_FMAC4 soap_in_PointerTowsd__ProbeMatchesType(struct soap *soap, const char *tag, struct wsd__ProbeMatchesType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wsd__ProbeMatchesType **)soap_malloc(soap, sizeof(struct wsd__ProbeMatchesType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsd__ProbeMatchesType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsd__ProbeMatchesType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsd__ProbeMatchesType, sizeof(struct wsd__ProbeMatchesType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsd__ProbeType(struct soap *soap, struct wsd__ProbeType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsd__ProbeType))
		soap_serialize_wsd__ProbeType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsd__ProbeType(struct soap *soap, struct wsd__ProbeType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsd__ProbeType);
	if (soap_out_PointerTowsd__ProbeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsd__ProbeType(struct soap *soap, const char *tag, int id, struct wsd__ProbeType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsd__ProbeType);
	if (id < 0)
		return soap->error;
	return soap_out_wsd__ProbeType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsd__ProbeType ** SOAP_FMAC4 soap_get_PointerTowsd__ProbeType(struct soap *soap, struct wsd__ProbeType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsd__ProbeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ProbeType ** SOAP_FMAC4 soap_in_PointerTowsd__ProbeType(struct soap *soap, const char *tag, struct wsd__ProbeType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wsd__ProbeType **)soap_malloc(soap, sizeof(struct wsd__ProbeType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsd__ProbeType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsd__ProbeType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsd__ProbeType, sizeof(struct wsd__ProbeType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsd__ByeType(struct soap *soap, struct wsd__ByeType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsd__ByeType))
		soap_serialize_wsd__ByeType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsd__ByeType(struct soap *soap, struct wsd__ByeType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsd__ByeType);
	if (soap_out_PointerTowsd__ByeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsd__ByeType(struct soap *soap, const char *tag, int id, struct wsd__ByeType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsd__ByeType);
	if (id < 0)
		return soap->error;
	return soap_out_wsd__ByeType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsd__ByeType ** SOAP_FMAC4 soap_get_PointerTowsd__ByeType(struct soap *soap, struct wsd__ByeType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsd__ByeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ByeType ** SOAP_FMAC4 soap_in_PointerTowsd__ByeType(struct soap *soap, const char *tag, struct wsd__ByeType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wsd__ByeType **)soap_malloc(soap, sizeof(struct wsd__ByeType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsd__ByeType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsd__ByeType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsd__ByeType, sizeof(struct wsd__ByeType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsd__Id(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsd__Id(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsd__Id(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsd__Id);
	if (soap_out__wsd__Id(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsd__Id(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__wsd__Id);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__wsd__Id(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__wsd__Id(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__wsd__Id(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__wsd__Id, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerTowsd__HelloType(struct soap *soap, struct wsd__HelloType **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerTowsd__HelloType))
		soap_serialize_PointerTowsd__HelloType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerTowsd__HelloType(struct soap *soap, struct wsd__HelloType **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerTowsd__HelloType);
	if (soap_out_PointerToPointerTowsd__HelloType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerTowsd__HelloType(struct soap *soap, const char *tag, int id, struct wsd__HelloType **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerTowsd__HelloType);
	if (id < 0)
		return soap->error;
	return soap_out_PointerTowsd__HelloType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsd__HelloType *** SOAP_FMAC4 soap_get_PointerToPointerTowsd__HelloType(struct soap *soap, struct wsd__HelloType ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerTowsd__HelloType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__HelloType *** SOAP_FMAC4 soap_in_PointerToPointerTowsd__HelloType(struct soap *soap, const char *tag, struct wsd__HelloType ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wsd__HelloType ***)soap_malloc(soap, sizeof(struct wsd__HelloType **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerTowsd__HelloType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsd__HelloType ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerTowsd__HelloType, sizeof(struct wsd__HelloType *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsd__HelloType(struct soap *soap, struct wsd__HelloType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsd__HelloType))
		soap_serialize_wsd__HelloType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsd__HelloType(struct soap *soap, struct wsd__HelloType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsd__HelloType);
	if (soap_out_PointerTowsd__HelloType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsd__HelloType(struct soap *soap, const char *tag, int id, struct wsd__HelloType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsd__HelloType);
	if (id < 0)
		return soap->error;
	return soap_out_wsd__HelloType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsd__HelloType ** SOAP_FMAC4 soap_get_PointerTowsd__HelloType(struct soap *soap, struct wsd__HelloType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsd__HelloType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__HelloType ** SOAP_FMAC4 soap_in_PointerTowsd__HelloType(struct soap *soap, const char *tag, struct wsd__HelloType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wsd__HelloType **)soap_malloc(soap, sizeof(struct wsd__HelloType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsd__HelloType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsd__HelloType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsd__HelloType, sizeof(struct wsd__HelloType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowsd__ScopesType(struct soap *soap, struct wsd__ScopesType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wsd__ScopesType))
		soap_serialize_wsd__ScopesType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowsd__ScopesType(struct soap *soap, struct wsd__ScopesType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowsd__ScopesType);
	if (soap_out_PointerTowsd__ScopesType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowsd__ScopesType(struct soap *soap, const char *tag, int id, struct wsd__ScopesType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wsd__ScopesType);
	if (id < 0)
		return soap->error;
	return soap_out_wsd__ScopesType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsd__ScopesType ** SOAP_FMAC4 soap_get_PointerTowsd__ScopesType(struct soap *soap, struct wsd__ScopesType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowsd__ScopesType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsd__ScopesType ** SOAP_FMAC4 soap_in_PointerTowsd__ScopesType(struct soap *soap, const char *tag, struct wsd__ScopesType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wsd__ScopesType **)soap_malloc(soap, sizeof(struct wsd__ScopesType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wsd__ScopesType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsd__ScopesType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wsd__ScopesType, sizeof(struct wsd__ScopesType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__FaultCodeOpenType(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsd__FaultCodeOpenType(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__FaultCodeOpenType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__FaultCodeOpenType);
	if (soap_out_wsd__FaultCodeOpenType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__FaultCodeOpenType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_wsd__FaultCodeOpenType);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_wsd__FaultCodeOpenType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__FaultCodeOpenType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_wsd__FaultCodeOpenType(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_wsd__FaultCodeOpenType, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsd__OpenRelationshipType(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsd__OpenRelationshipType(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsd__OpenRelationshipType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsd__OpenRelationshipType);
	if (soap_out_wsd__OpenRelationshipType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsd__OpenRelationshipType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_wsd__OpenRelationshipType);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_wsd__OpenRelationshipType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_wsd__OpenRelationshipType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_wsd__OpenRelationshipType(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_wsd__OpenRelationshipType, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__anyURI(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__anyURI(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__anyURI(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__anyURI);
	if (soap_out_xsd__anyURI(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__anyURI);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__anyURI(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__anyURI(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__anyURI(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__anyURI, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__QName);
	if (soap_out_xsd__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__IDREFS(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__IDREFS(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__IDREFS(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__IDREFS);
	if (soap_out_xsd__IDREFS(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__IDREFS(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__IDREFS);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__IDREFS(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__IDREFS(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__IDREFS(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__IDREFS, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__ID(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__ID(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__ID(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__ID);
	if (soap_out_xsd__ID(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__ID(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__ID);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__ID(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__ID(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__ID(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__ID, 1, -1, -1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_uri_list(struct soap *soap, struct dynamic_array *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_uri_list);
	if (soap_out_uri_list(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct dynamic_array ** SOAP_FMAC4 soap_get_uri_list(struct soap *soap, struct dynamic_array **p, const char *tag, const char *type)
{
	if ((p = soap_in_uri_list(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_qname_list(struct soap *soap, struct dynamic_array *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_qname_list);
	if (soap_out_qname_list(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct dynamic_array ** SOAP_FMAC4 soap_get_qname_list(struct soap *soap, struct dynamic_array **p, const char *tag, const char *type)
{
	if ((p = soap_in_qname_list(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_endpoint_ref(struct soap *soap, struct wsa_endpoint_ref *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_endpoint_ref);
	if (soap_out_endpoint_ref(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa_endpoint_ref ** SOAP_FMAC4 soap_get_endpoint_ref(struct soap *soap, struct wsa_endpoint_ref **p, const char *tag, const char *type)
{
	if ((p = soap_in_endpoint_ref(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

#ifdef __cplusplus
}
#endif

/* End of discoveryC.c */
