/* metadataC.c
   Generated by gSOAP 2.7.6c from ../../../../../src/dpws/src/metadata.gsoap
   Copyright (C) 2000-2005, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "metadataH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) metadataC.c ver 2.7.6c 2008-06-10 13:21:29 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
	soap->part = SOAP_END_HEADER;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_SOAP_ENV__Reason:
		return soap_in_SOAP_ENV__Reason(soap, NULL, NULL, "SOAP-ENV:Reason");
	case SOAP_TYPE__wsm__MetadataSection:
		return soap_in__wsm__MetadataSection(soap, NULL, NULL, "wsm:MetadataSection");
	case SOAP_TYPE__wsm__Metadata:
		return soap_in__wsm__Metadata(soap, NULL, NULL, "wsm:Metadata");
	case SOAP_TYPE__wsm__GetMetadata:
		return soap_in__wsm__GetMetadata(soap, NULL, NULL, "wsm:GetMetadata");
	case SOAP_TYPE_wsm__AnyXmlType:
		return soap_in_wsm__AnyXmlType(soap, NULL, NULL, "wsm:AnyXmlType");
	case SOAP_TYPE__wdp__Hosted:
		return soap_in__wdp__Hosted(soap, NULL, NULL, "wdp:Hosted");
	case SOAP_TYPE__wdp__Host:
		return soap_in__wdp__Host(soap, NULL, NULL, "wdp:Host");
	case SOAP_TYPE__wdp__ThisDevice:
		return soap_in__wdp__ThisDevice(soap, NULL, NULL, "wdp:ThisDevice");
	case SOAP_TYPE__wdp__ThisModel:
		return soap_in__wdp__ThisModel(soap, NULL, NULL, "wdp:ThisModel");
	case SOAP_TYPE__wdp__Relationship:
		return soap_in__wdp__Relationship(soap, NULL, NULL, "wdp:Relationship");
	case SOAP_TYPE_wdp__HostServiceType:
		return soap_in_wdp__HostServiceType(soap, NULL, NULL, "wdp:HostServiceType");
	case SOAP_TYPE_wdp__ThisDeviceType:
		return soap_in_wdp__ThisDeviceType(soap, NULL, NULL, "wdp:ThisDeviceType");
	case SOAP_TYPE_wdp__LocalizedStringType:
		return soap_in_wdp__LocalizedStringType(soap, NULL, NULL, "wdp:LocalizedStringType");
	case SOAP_TYPE_wdp__ThisModelType:
		return soap_in_wdp__ThisModelType(soap, NULL, NULL, "wdp:ThisModelType");
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		return soap_in_PointerToSOAP_ENV__Reason(soap, NULL, NULL, "SOAP-ENV:Reason");
	case SOAP_TYPE_PointerToPointerTo_wsm__MetadataSection:
		return soap_in_PointerToPointerTo_wsm__MetadataSection(soap, NULL, NULL, "wsm:MetadataSection");
	case SOAP_TYPE_PointerTo_wsm__MetadataSection:
		return soap_in_PointerTo_wsm__MetadataSection(soap, NULL, NULL, "wsm:MetadataSection");
	case SOAP_TYPE_xsd__nonNegativeInteger:
	{	char **s;
		s = soap_in_xsd__nonNegativeInteger(soap, NULL, NULL, "xsd:nonNegativeInteger");
		return s ? *s : NULL;
	}
	case SOAP_TYPE__wdp__ServiceId:
	{	char **s;
		s = soap_in__wdp__ServiceId(soap, NULL, NULL, "wdp:ServiceId");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerToPointerTowdp__HostServiceType:
		return soap_in_PointerToPointerTowdp__HostServiceType(soap, NULL, NULL, "wdp:HostServiceType");
	case SOAP_TYPE_PointerTowdp__HostServiceType:
		return soap_in_PointerTowdp__HostServiceType(soap, NULL, NULL, "wdp:HostServiceType");
	case SOAP_TYPE_PointerToendpoint_ref:
		return soap_in_PointerToendpoint_ref(soap, NULL, NULL, "endpoint-ref");
	case SOAP_TYPE_PointerToPointerTowdp__LocalizedStringType:
		return soap_in_PointerToPointerTowdp__LocalizedStringType(soap, NULL, NULL, "wdp:LocalizedStringType");
	case SOAP_TYPE_PointerTowdp__LocalizedStringType:
		return soap_in_PointerTowdp__LocalizedStringType(soap, NULL, NULL, "wdp:LocalizedStringType");
	case SOAP_TYPE__xml__lang:
	{	char **s;
		s = soap_in__xml__lang(soap, NULL, NULL, "xml:lang");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__QName:
	{	char **s;
		s = soap_in_xsd__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_uri_list:
		return soap_in_uri_list(soap, NULL, NULL, "uri-list");
	case SOAP_TYPE_qname_list:
		return soap_in_qname_list(soap, NULL, NULL, "qname-list");
	case SOAP_TYPE_endpoint_ref:
		return soap_in_endpoint_ref(soap, NULL, NULL, "endpoint-ref");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SOAP-ENV:Reason"))
		{	*type = SOAP_TYPE_SOAP_ENV__Reason;
			return soap_in_SOAP_ENV__Reason(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsm:MetadataSection"))
		{	*type = SOAP_TYPE__wsm__MetadataSection;
			return soap_in__wsm__MetadataSection(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsm:Metadata"))
		{	*type = SOAP_TYPE__wsm__Metadata;
			return soap_in__wsm__Metadata(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsm:GetMetadata"))
		{	*type = SOAP_TYPE__wsm__GetMetadata;
			return soap_in__wsm__GetMetadata(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wsm:AnyXmlType"))
		{	*type = SOAP_TYPE_wsm__AnyXmlType;
			return soap_in_wsm__AnyXmlType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wdp:Hosted"))
		{	*type = SOAP_TYPE__wdp__Hosted;
			return soap_in__wdp__Hosted(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wdp:Host"))
		{	*type = SOAP_TYPE__wdp__Host;
			return soap_in__wdp__Host(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wdp:ThisDevice"))
		{	*type = SOAP_TYPE__wdp__ThisDevice;
			return soap_in__wdp__ThisDevice(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wdp:ThisModel"))
		{	*type = SOAP_TYPE__wdp__ThisModel;
			return soap_in__wdp__ThisModel(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wdp:Relationship"))
		{	*type = SOAP_TYPE__wdp__Relationship;
			return soap_in__wdp__Relationship(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wdp:HostServiceType"))
		{	*type = SOAP_TYPE_wdp__HostServiceType;
			return soap_in_wdp__HostServiceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wdp:ThisDeviceType"))
		{	*type = SOAP_TYPE_wdp__ThisDeviceType;
			return soap_in_wdp__ThisDeviceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wdp:LocalizedStringType"))
		{	*type = SOAP_TYPE_wdp__LocalizedStringType;
			return soap_in_wdp__LocalizedStringType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "wdp:ThisModelType"))
		{	*type = SOAP_TYPE_wdp__ThisModelType;
			return soap_in_wdp__ThisModelType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:nonNegativeInteger"))
		{	char **s;
			*type = SOAP_TYPE_xsd__nonNegativeInteger;
			s = soap_in_xsd__nonNegativeInteger(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "wdp:ServiceId"))
		{	char **s;
			*type = SOAP_TYPE__wdp__ServiceId;
			s = soap_in__wdp__ServiceId(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xml:lang"))
		{	char **s;
			*type = SOAP_TYPE__xml__lang;
			s = soap_in__xml__lang(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE_xsd__QName;
			s = soap_in_xsd__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_SOAP_ENV__Reason:
		return soap_out_SOAP_ENV__Reason(soap, tag, id, (const struct SOAP_ENV__Reason *)ptr, "SOAP-ENV:Reason");
	case SOAP_TYPE__wsm__MetadataSection:
		return soap_out__wsm__MetadataSection(soap, "wsm:MetadataSection", id, (const struct _wsm__MetadataSection *)ptr, NULL);
	case SOAP_TYPE__wsm__Metadata:
		return soap_out__wsm__Metadata(soap, "wsm:Metadata", id, (const struct _wsm__Metadata *)ptr, NULL);
	case SOAP_TYPE__wsm__GetMetadata:
		return soap_out__wsm__GetMetadata(soap, "wsm:GetMetadata", id, (const struct _wsm__GetMetadata *)ptr, NULL);
	case SOAP_TYPE_wsm__AnyXmlType:
		return soap_out_wsm__AnyXmlType(soap, tag, id, (const struct wsm__AnyXmlType *)ptr, "wsm:AnyXmlType");
	case SOAP_TYPE__wdp__Hosted:
		return soap_out__wdp__Hosted(soap, "wdp:Hosted", id, (const struct wdp__HostServiceType *)ptr, NULL);
	case SOAP_TYPE__wdp__Host:
		return soap_out__wdp__Host(soap, "wdp:Host", id, (const struct wdp__HostServiceType *)ptr, NULL);
	case SOAP_TYPE__wdp__ThisDevice:
		return soap_out__wdp__ThisDevice(soap, "wdp:ThisDevice", id, (const struct wdp__ThisDeviceType *)ptr, NULL);
	case SOAP_TYPE__wdp__ThisModel:
		return soap_out__wdp__ThisModel(soap, "wdp:ThisModel", id, (const struct wdp__ThisModelType *)ptr, NULL);
	case SOAP_TYPE__wdp__Relationship:
		return soap_out__wdp__Relationship(soap, "wdp:Relationship", id, (const struct _wdp__Relationship *)ptr, NULL);
	case SOAP_TYPE_wdp__HostServiceType:
		return soap_out_wdp__HostServiceType(soap, tag, id, (const struct wdp__HostServiceType *)ptr, "wdp:HostServiceType");
	case SOAP_TYPE_wdp__ThisDeviceType:
		return soap_out_wdp__ThisDeviceType(soap, tag, id, (const struct wdp__ThisDeviceType *)ptr, "wdp:ThisDeviceType");
	case SOAP_TYPE_wdp__LocalizedStringType:
		return soap_out_wdp__LocalizedStringType(soap, tag, id, (const struct wdp__LocalizedStringType *)ptr, "wdp:LocalizedStringType");
	case SOAP_TYPE_wdp__ThisModelType:
		return soap_out_wdp__ThisModelType(soap, tag, id, (const struct wdp__ThisModelType *)ptr, "wdp:ThisModelType");
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		return soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, (struct SOAP_ENV__Reason *const*)ptr, "SOAP-ENV:Reason");
	case SOAP_TYPE_PointerToPointerTo_wsm__MetadataSection:
		return soap_out_PointerToPointerTo_wsm__MetadataSection(soap, tag, id, (struct _wsm__MetadataSection **const*)ptr, "wsm:MetadataSection");
	case SOAP_TYPE_PointerTo_wsm__MetadataSection:
		return soap_out_PointerTo_wsm__MetadataSection(soap, tag, id, (struct _wsm__MetadataSection *const*)ptr, "wsm:MetadataSection");
	case SOAP_TYPE_xsd__nonNegativeInteger:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:nonNegativeInteger");
	case SOAP_TYPE__wdp__ServiceId:
		return soap_out_string(soap, "wdp:ServiceId", id, (char**)&ptr, NULL);
	case SOAP_TYPE_PointerToPointerTowdp__HostServiceType:
		return soap_out_PointerToPointerTowdp__HostServiceType(soap, tag, id, (struct wdp__HostServiceType **const*)ptr, "wdp:HostServiceType");
	case SOAP_TYPE_PointerTowdp__HostServiceType:
		return soap_out_PointerTowdp__HostServiceType(soap, tag, id, (struct wdp__HostServiceType *const*)ptr, "wdp:HostServiceType");
	case SOAP_TYPE_PointerToendpoint_ref:
		return soap_out_PointerToendpoint_ref(soap, tag, id, (struct wsa_endpoint_ref **const*)ptr, "endpoint-ref");
	case SOAP_TYPE_PointerToPointerTowdp__LocalizedStringType:
		return soap_out_PointerToPointerTowdp__LocalizedStringType(soap, tag, id, (struct wdp__LocalizedStringType **const*)ptr, "wdp:LocalizedStringType");
	case SOAP_TYPE_PointerTowdp__LocalizedStringType:
		return soap_out_PointerTowdp__LocalizedStringType(soap, tag, id, (struct wdp__LocalizedStringType *const*)ptr, "wdp:LocalizedStringType");
	case SOAP_TYPE__xml__lang:
		return soap_out_string(soap, "xml:lang", id, (char**)&ptr, NULL);
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:anyURI");
	case SOAP_TYPE_xsd__QName:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:QName");
	case SOAP_TYPE_uri_list:
		return soap_out_uri_list(soap, tag, id, (struct dynamic_array *const*)ptr, "uri-list");
	case SOAP_TYPE_qname_list:
		return soap_out_qname_list(soap, tag, id, (struct dynamic_array *const*)ptr, "qname-list");
	case SOAP_TYPE_endpoint_ref:
		return soap_out_endpoint_ref(soap, tag, id, (struct wsa_endpoint_ref *const*)ptr, "endpoint-ref");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_SOAP_ENV__Reason:
		soap_serialize_SOAP_ENV__Reason(soap, (const struct SOAP_ENV__Reason *)ptr);
		break;
	case SOAP_TYPE__wsm__MetadataSection:
		soap_serialize__wsm__MetadataSection(soap, (const struct _wsm__MetadataSection *)ptr);
		break;
	case SOAP_TYPE__wsm__Metadata:
		soap_serialize__wsm__Metadata(soap, (const struct _wsm__Metadata *)ptr);
		break;
	case SOAP_TYPE__wsm__GetMetadata:
		soap_serialize__wsm__GetMetadata(soap, (const struct _wsm__GetMetadata *)ptr);
		break;
	case SOAP_TYPE_wsm__AnyXmlType:
		soap_serialize_wsm__AnyXmlType(soap, (const struct wsm__AnyXmlType *)ptr);
		break;
	case SOAP_TYPE__wdp__Hosted:
		soap_serialize__wdp__Hosted(soap, (const struct wdp__HostServiceType *)ptr);
		break;
	case SOAP_TYPE__wdp__Host:
		soap_serialize__wdp__Host(soap, (const struct wdp__HostServiceType *)ptr);
		break;
	case SOAP_TYPE__wdp__ThisDevice:
		soap_serialize__wdp__ThisDevice(soap, (const struct wdp__ThisDeviceType *)ptr);
		break;
	case SOAP_TYPE__wdp__ThisModel:
		soap_serialize__wdp__ThisModel(soap, (const struct wdp__ThisModelType *)ptr);
		break;
	case SOAP_TYPE__wdp__Relationship:
		soap_serialize__wdp__Relationship(soap, (const struct _wdp__Relationship *)ptr);
		break;
	case SOAP_TYPE_wdp__HostServiceType:
		soap_serialize_wdp__HostServiceType(soap, (const struct wdp__HostServiceType *)ptr);
		break;
	case SOAP_TYPE_wdp__ThisDeviceType:
		soap_serialize_wdp__ThisDeviceType(soap, (const struct wdp__ThisDeviceType *)ptr);
		break;
	case SOAP_TYPE_wdp__LocalizedStringType:
		soap_serialize_wdp__LocalizedStringType(soap, (const struct wdp__LocalizedStringType *)ptr);
		break;
	case SOAP_TYPE_wdp__ThisModelType:
		soap_serialize_wdp__ThisModelType(soap, (const struct wdp__ThisModelType *)ptr);
		break;
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		soap_serialize_PointerToSOAP_ENV__Reason(soap, (struct SOAP_ENV__Reason *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTo_wsm__MetadataSection:
		soap_serialize_PointerToPointerTo_wsm__MetadataSection(soap, (struct _wsm__MetadataSection **const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_wsm__MetadataSection:
		soap_serialize_PointerTo_wsm__MetadataSection(soap, (struct _wsm__MetadataSection *const*)ptr);
		break;
	case SOAP_TYPE_xsd__nonNegativeInteger:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__wdp__ServiceId:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_PointerToPointerTowdp__HostServiceType:
		soap_serialize_PointerToPointerTowdp__HostServiceType(soap, (struct wdp__HostServiceType **const*)ptr);
		break;
	case SOAP_TYPE_PointerTowdp__HostServiceType:
		soap_serialize_PointerTowdp__HostServiceType(soap, (struct wdp__HostServiceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToendpoint_ref:
		soap_serialize_PointerToendpoint_ref(soap, (struct wsa_endpoint_ref **const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTowdp__LocalizedStringType:
		soap_serialize_PointerToPointerTowdp__LocalizedStringType(soap, (struct wdp__LocalizedStringType **const*)ptr);
		break;
	case SOAP_TYPE_PointerTowdp__LocalizedStringType:
		soap_serialize_PointerTowdp__LocalizedStringType(soap, (struct wdp__LocalizedStringType *const*)ptr);
		break;
	case SOAP_TYPE__xml__lang:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_uri_list:
		soap_serialize_uri_list(soap, (struct dynamic_array *const*)ptr);
		break;
	case SOAP_TYPE_qname_list:
		soap_serialize_qname_list(soap, (struct dynamic_array *const*)ptr);
		break;
	case SOAP_TYPE_endpoint_ref:
		soap_serialize_endpoint_ref(soap, (struct wsa_endpoint_ref *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	dpws_headers_out(dpws_soap2dpws(soap));
	if (a) {
	/* transient dummy skipped */
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (!dpws_header_in(dpws_soap2dpws(soap)))
				continue;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsm__MetadataSection(struct soap *soap, const struct _wsm__MetadataSection *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToendpoint_ref(soap, &a->wsm__MetadataReference);
	soap_serialize_xsd__anyURI(soap, &a->wsm__Location);
	soap_markelement(soap, a->_any, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsm__MetadataSection(struct soap *soap, struct _wsm__MetadataSection *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsm__MetadataReference = NULL;
	soap_default_xsd__anyURI(soap, &a->wsm__Location);
	a->__type = 0;
	a->_any = NULL;
	soap_default_xsd__anyURI(soap, &a->Dialect);
	soap_default_xsd__anyURI(soap, &a->Identifier);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsm__MetadataSection(struct soap *soap, const struct _wsm__MetadataSection *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsm__MetadataSection);
	if (soap_out__wsm__MetadataSection(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsm__MetadataSection(struct soap *soap, const char *tag, int id, const struct _wsm__MetadataSection *a, const char *type)
{
	if (a->Dialect)
		soap_set_attr(soap, "Dialect", a->Dialect);
	if (a->Identifier)
		soap_set_attr(soap, "Identifier", a->Identifier);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsm__MetadataSection), type);
	soap_out_PointerToendpoint_ref(soap, "wsm:MetadataReference", -1, &a->wsm__MetadataReference, "");
	soap_out_xsd__anyURI(soap, "wsm:Location", -1, &a->wsm__Location, "");
	soap_putelement(soap, a->_any, "any", -1, a->__type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _wsm__MetadataSection * SOAP_FMAC4 soap_get__wsm__MetadataSection(struct soap *soap, struct _wsm__MetadataSection *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsm__MetadataSection(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wsm__MetadataSection * SOAP_FMAC4 soap_in__wsm__MetadataSection(struct soap *soap, const char *tag, struct _wsm__MetadataSection *a, const char *type)
{
	short soap_flag_wsm__MetadataReference = 1, soap_flag_wsm__Location = 1, soap_flag__any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct _wsm__MetadataSection *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsm__MetadataSection, sizeof(struct _wsm__MetadataSection), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsm__MetadataSection(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Dialect", 1), &a->Dialect))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "Identifier", 0), &a->Identifier))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsm__MetadataReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToendpoint_ref(soap, "wsm:MetadataReference", &a->wsm__MetadataReference, "endpoint-ref"))
				{	soap_flag_wsm__MetadataReference--;
					continue;
				}
			if (soap_flag_wsm__Location && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wsm:Location", &a->wsm__Location, "xsd:anyURI"))
				{	soap_flag_wsm__Location--;
					continue;
				}
			if (soap_flag__any && soap->error == SOAP_TAG_MISMATCH)
				if ((a->_any = soap_getelement(soap, &a->__type)))
				{	soap_flag__any = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__any > 1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsm__MetadataSection *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wsm__MetadataSection, 0, sizeof(struct _wsm__MetadataSection), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsm__Metadata(struct soap *soap, const struct _wsm__Metadata *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->wsm__MetadataSection)
	{	int i;
		for (i = 0; i < a->__sizeMetadataSection; i++)
		{
			soap_serialize_PointerTo_wsm__MetadataSection(soap, a->wsm__MetadataSection + i);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsm__Metadata(struct soap *soap, struct _wsm__Metadata *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeMetadataSection = 0;
	a->wsm__MetadataSection = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsm__Metadata(struct soap *soap, const struct _wsm__Metadata *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsm__Metadata);
	if (soap_out__wsm__Metadata(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsm__Metadata(struct soap *soap, const char *tag, int id, const struct _wsm__Metadata *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsm__Metadata), type);
	if (a->wsm__MetadataSection)
	{	int i;
		for (i = 0; i < a->__sizeMetadataSection; i++)
			soap_out_PointerTo_wsm__MetadataSection(soap, "wsm:MetadataSection", -1, a->wsm__MetadataSection + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _wsm__Metadata * SOAP_FMAC4 soap_get__wsm__Metadata(struct soap *soap, struct _wsm__Metadata *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsm__Metadata(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wsm__Metadata * SOAP_FMAC4 soap_in__wsm__Metadata(struct soap *soap, const char *tag, struct _wsm__Metadata *a, const char *type)
{
	short soap_flag_wsm__MetadataSection = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct _wsm__Metadata *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsm__Metadata, sizeof(struct _wsm__Metadata), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsm__Metadata(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsm__MetadataSection && soap->error == SOAP_TAG_MISMATCH)
			{	struct _wsm__MetadataSection **p;
				soap_new_block(soap);
				for (a->__sizeMetadataSection = 0; !soap_element_begin_in(soap, "wsm:MetadataSection", 1); a->__sizeMetadataSection++)
				{	p = (struct _wsm__MetadataSection **)soap_push_block(soap, sizeof(struct _wsm__MetadataSection *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerTo_wsm__MetadataSection(soap, "wsm:MetadataSection", p, ""))
						break;
					soap_flag_wsm__MetadataSection = 0;
				}
				a->wsm__MetadataSection = (struct _wsm__MetadataSection **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_wsm__MetadataSection && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsm__Metadata *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wsm__Metadata, 0, sizeof(struct _wsm__Metadata), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsm__GetMetadata(struct soap *soap, const struct _wsm__GetMetadata *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &a->wsm__Dialect);
	soap_serialize_xsd__anyURI(soap, &a->wsm__Identifier);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsm__GetMetadata(struct soap *soap, struct _wsm__GetMetadata *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &a->wsm__Dialect);
	soap_default_xsd__anyURI(soap, &a->wsm__Identifier);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsm__GetMetadata(struct soap *soap, const struct _wsm__GetMetadata *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsm__GetMetadata);
	if (soap_out__wsm__GetMetadata(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsm__GetMetadata(struct soap *soap, const char *tag, int id, const struct _wsm__GetMetadata *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsm__GetMetadata), type);
	soap_out_xsd__anyURI(soap, "wsm:Dialect", -1, &a->wsm__Dialect, "");
	soap_out_xsd__anyURI(soap, "wsm:Identifier", -1, &a->wsm__Identifier, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _wsm__GetMetadata * SOAP_FMAC4 soap_get__wsm__GetMetadata(struct soap *soap, struct _wsm__GetMetadata *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsm__GetMetadata(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wsm__GetMetadata * SOAP_FMAC4 soap_in__wsm__GetMetadata(struct soap *soap, const char *tag, struct _wsm__GetMetadata *a, const char *type)
{
	short soap_flag_wsm__Dialect = 1, soap_flag_wsm__Identifier = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct _wsm__GetMetadata *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsm__GetMetadata, sizeof(struct _wsm__GetMetadata), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsm__GetMetadata(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsm__Dialect && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wsm:Dialect", &a->wsm__Dialect, "xsd:anyURI"))
				{	soap_flag_wsm__Dialect--;
					continue;
				}
			if (soap_flag_wsm__Identifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wsm:Identifier", &a->wsm__Identifier, "xsd:anyURI"))
				{	soap_flag_wsm__Identifier--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsm__GetMetadata *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wsm__GetMetadata, 0, sizeof(struct _wsm__GetMetadata), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wsm__AnyXmlType(struct soap *soap, const struct wsm__AnyXmlType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->__any, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsm__AnyXmlType(struct soap *soap, struct wsm__AnyXmlType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsm__AnyXmlType(struct soap *soap, const struct wsm__AnyXmlType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsm__AnyXmlType);
	if (soap_out_wsm__AnyXmlType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsm__AnyXmlType(struct soap *soap, const char *tag, int id, const struct wsm__AnyXmlType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsm__AnyXmlType), type);
	soap_putelement(soap, a->__any, "-any", -1, a->__type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wsm__AnyXmlType * SOAP_FMAC4 soap_get_wsm__AnyXmlType(struct soap *soap, struct wsm__AnyXmlType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsm__AnyXmlType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsm__AnyXmlType * SOAP_FMAC4 soap_in_wsm__AnyXmlType(struct soap *soap, const char *tag, struct wsm__AnyXmlType *a, const char *type)
{
	short soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wsm__AnyXmlType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsm__AnyXmlType, sizeof(struct wsm__AnyXmlType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wsm__AnyXmlType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag___any && soap->error == SOAP_TAG_MISMATCH)
				if ((a->__any = soap_getelement(soap, &a->__type)))
				{	soap_flag___any = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag___any > 1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wsm__AnyXmlType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wsm__AnyXmlType, 0, sizeof(struct wsm__AnyXmlType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wdp__Hosted(struct soap *soap, struct wdp__HostServiceType const*a)
{	soap_serialize_wdp__HostServiceType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wdp__Hosted(struct soap *soap, struct wdp__HostServiceType *a)
{	soap_default_wdp__HostServiceType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wdp__Hosted(struct soap *soap, const struct wdp__HostServiceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wdp__Hosted);
	if (soap_out__wdp__Hosted(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wdp__Hosted(struct soap *soap, const char *tag, int id, const struct wdp__HostServiceType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wdp__Hosted), type);
	if (a->wsa__EndpointReference)
	{	int i;
		for (i = 0; i < a->__sizeEndpointReference; i++)
			soap_out_endpoint_ref(soap, "wsa:EndpointReference", -1, a->wsa__EndpointReference + i, "");
	}
	soap_out_qname_list(soap, "wdp:Types", -1, &a->Types, "");
	soap_out_xsd__anyURI(soap, "wdp:ServiceId", -1, &a->ServiceId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wdp__HostServiceType * SOAP_FMAC4 soap_get__wdp__Hosted(struct soap *soap, struct wdp__HostServiceType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wdp__Hosted(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__HostServiceType * SOAP_FMAC4 soap_in__wdp__Hosted(struct soap *soap, const char *tag, struct wdp__HostServiceType *a, const char *type)
{
	short soap_flag_wsa__EndpointReference = 1, soap_flag_Types = 1, soap_flag_ServiceId = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wdp__HostServiceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wdp__Hosted, sizeof(struct wdp__HostServiceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wdp__Hosted(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
			{	struct wsa_endpoint_ref **p;
				soap_new_block(soap);
				for (a->__sizeEndpointReference = 0; !soap_element_begin_in(soap, "wsa:EndpointReference", 1); a->__sizeEndpointReference++)
				{	p = (struct wsa_endpoint_ref **)soap_push_block(soap, sizeof(struct wsa_endpoint_ref *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_endpoint_ref(soap, "wsa:EndpointReference", p, "endpoint-ref"))
						break;
					soap_flag_wsa__EndpointReference = 0;
				}
				a->wsa__EndpointReference = (struct wsa_endpoint_ref **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_Types && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_qname_list(soap, "wdp:Types", &a->Types, "qname-list"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_ServiceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wdp:ServiceId", &a->ServiceId, "xsd:anyURI"))
				{	soap_flag_ServiceId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wdp__HostServiceType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wdp__Hosted, 0, sizeof(struct wdp__HostServiceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wdp__Host(struct soap *soap, struct wdp__HostServiceType const*a)
{	soap_serialize_wdp__HostServiceType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wdp__Host(struct soap *soap, struct wdp__HostServiceType *a)
{	soap_default_wdp__HostServiceType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wdp__Host(struct soap *soap, const struct wdp__HostServiceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wdp__Host);
	if (soap_out__wdp__Host(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wdp__Host(struct soap *soap, const char *tag, int id, const struct wdp__HostServiceType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wdp__Host), type);
	if (a->wsa__EndpointReference)
	{	int i;
		for (i = 0; i < a->__sizeEndpointReference; i++)
			soap_out_endpoint_ref(soap, "wsa:EndpointReference", -1, a->wsa__EndpointReference + i, "");
	}
	soap_out_qname_list(soap, "wdp:Types", -1, &a->Types, "");
	soap_out_xsd__anyURI(soap, "wdp:ServiceId", -1, &a->ServiceId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wdp__HostServiceType * SOAP_FMAC4 soap_get__wdp__Host(struct soap *soap, struct wdp__HostServiceType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wdp__Host(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__HostServiceType * SOAP_FMAC4 soap_in__wdp__Host(struct soap *soap, const char *tag, struct wdp__HostServiceType *a, const char *type)
{
	short soap_flag_wsa__EndpointReference = 1, soap_flag_Types = 1, soap_flag_ServiceId = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wdp__HostServiceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wdp__Host, sizeof(struct wdp__HostServiceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wdp__Host(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
			{	struct wsa_endpoint_ref **p;
				soap_new_block(soap);
				for (a->__sizeEndpointReference = 0; !soap_element_begin_in(soap, "wsa:EndpointReference", 1); a->__sizeEndpointReference++)
				{	p = (struct wsa_endpoint_ref **)soap_push_block(soap, sizeof(struct wsa_endpoint_ref *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_endpoint_ref(soap, "wsa:EndpointReference", p, "endpoint-ref"))
						break;
					soap_flag_wsa__EndpointReference = 0;
				}
				a->wsa__EndpointReference = (struct wsa_endpoint_ref **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_Types && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_qname_list(soap, "wdp:Types", &a->Types, "qname-list"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_ServiceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wdp:ServiceId", &a->ServiceId, "xsd:anyURI"))
				{	soap_flag_ServiceId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wdp__HostServiceType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wdp__Host, 0, sizeof(struct wdp__HostServiceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wdp__ThisDevice(struct soap *soap, struct wdp__ThisDeviceType const*a)
{	soap_serialize_wdp__ThisDeviceType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wdp__ThisDevice(struct soap *soap, struct wdp__ThisDeviceType *a)
{	soap_default_wdp__ThisDeviceType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wdp__ThisDevice(struct soap *soap, const struct wdp__ThisDeviceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wdp__ThisDevice);
	if (soap_out__wdp__ThisDevice(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wdp__ThisDevice(struct soap *soap, const char *tag, int id, const struct wdp__ThisDeviceType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wdp__ThisDevice), type);
	if (a->FriendlyName)
	{	int i;
		for (i = 0; i < a->__sizeFriendlyName; i++)
			soap_out_PointerTowdp__LocalizedStringType(soap, "wdp:FriendlyName", -1, a->FriendlyName + i, "");
	}
	soap_out_string(soap, "wdp:FirmwareVersion", -1, &a->FirmwareVersion, "");
	soap_out_string(soap, "wdp:SerialNumber", -1, &a->SerialNumber, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wdp__ThisDeviceType * SOAP_FMAC4 soap_get__wdp__ThisDevice(struct soap *soap, struct wdp__ThisDeviceType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wdp__ThisDevice(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__ThisDeviceType * SOAP_FMAC4 soap_in__wdp__ThisDevice(struct soap *soap, const char *tag, struct wdp__ThisDeviceType *a, const char *type)
{
	short soap_flag_FriendlyName = 1, soap_flag_FirmwareVersion = 1, soap_flag_SerialNumber = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wdp__ThisDeviceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wdp__ThisDevice, sizeof(struct wdp__ThisDeviceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wdp__ThisDevice(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_FriendlyName && soap->error == SOAP_TAG_MISMATCH)
			{	struct wdp__LocalizedStringType **p;
				soap_new_block(soap);
				for (a->__sizeFriendlyName = 0; !soap_element_begin_in(soap, "wdp:FriendlyName", 1); a->__sizeFriendlyName++)
				{	p = (struct wdp__LocalizedStringType **)soap_push_block(soap, sizeof(struct wdp__LocalizedStringType *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerTowdp__LocalizedStringType(soap, "wdp:FriendlyName", p, "wdp:LocalizedStringType"))
						break;
					soap_flag_FriendlyName = 0;
				}
				a->FriendlyName = (struct wdp__LocalizedStringType **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_FriendlyName && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_FirmwareVersion && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wdp:FirmwareVersion", &a->FirmwareVersion, "xsd:string"))
				{	soap_flag_FirmwareVersion--;
					continue;
				}
			if (soap_flag_SerialNumber && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wdp:SerialNumber", &a->SerialNumber, "xsd:string"))
				{	soap_flag_SerialNumber--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wdp__ThisDeviceType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wdp__ThisDevice, 0, sizeof(struct wdp__ThisDeviceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wdp__ThisModel(struct soap *soap, struct wdp__ThisModelType const*a)
{	soap_serialize_wdp__ThisModelType(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wdp__ThisModel(struct soap *soap, struct wdp__ThisModelType *a)
{	soap_default_wdp__ThisModelType(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wdp__ThisModel(struct soap *soap, const struct wdp__ThisModelType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wdp__ThisModel);
	if (soap_out__wdp__ThisModel(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wdp__ThisModel(struct soap *soap, const char *tag, int id, const struct wdp__ThisModelType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wdp__ThisModel), type);
	if (a->Manufacturer)
	{	int i;
		for (i = 0; i < a->__sizeManufacturer; i++)
			soap_out_PointerTowdp__LocalizedStringType(soap, "wdp:Manufacturer", -1, a->Manufacturer + i, "");
	}
	soap_out_xsd__anyURI(soap, "wdp:ManufacturerUrl", -1, &a->ManufacturerUrl, "");
	if (a->ModelName)
	{	int i;
		for (i = 0; i < a->__sizeModelName; i++)
			soap_out_PointerTowdp__LocalizedStringType(soap, "wdp:ModelName", -1, a->ModelName + i, "");
	}
	soap_out_string(soap, "wdp:ModelNumber", -1, &a->ModelNumber, "");
	soap_out_xsd__anyURI(soap, "wdp:ModelUrl", -1, &a->ModelUrl, "");
	soap_out_xsd__anyURI(soap, "wdp:PresentationUrl", -1, &a->PresentationUrl, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wdp__ThisModelType * SOAP_FMAC4 soap_get__wdp__ThisModel(struct soap *soap, struct wdp__ThisModelType *p, const char *tag, const char *type)
{
	if ((p = soap_in__wdp__ThisModel(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__ThisModelType * SOAP_FMAC4 soap_in__wdp__ThisModel(struct soap *soap, const char *tag, struct wdp__ThisModelType *a, const char *type)
{
	short soap_flag_Manufacturer = 1, soap_flag_ManufacturerUrl = 1, soap_flag_ModelName = 1, soap_flag_ModelNumber = 1, soap_flag_ModelUrl = 1, soap_flag_PresentationUrl = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wdp__ThisModelType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wdp__ThisModel, sizeof(struct wdp__ThisModelType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wdp__ThisModel(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Manufacturer && soap->error == SOAP_TAG_MISMATCH)
			{	struct wdp__LocalizedStringType **p;
				soap_new_block(soap);
				for (a->__sizeManufacturer = 0; !soap_element_begin_in(soap, "wdp:Manufacturer", 1); a->__sizeManufacturer++)
				{	p = (struct wdp__LocalizedStringType **)soap_push_block(soap, sizeof(struct wdp__LocalizedStringType *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerTowdp__LocalizedStringType(soap, "wdp:Manufacturer", p, "wdp:LocalizedStringType"))
						break;
					soap_flag_Manufacturer = 0;
				}
				a->Manufacturer = (struct wdp__LocalizedStringType **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_Manufacturer && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_ManufacturerUrl && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wdp:ManufacturerUrl", &a->ManufacturerUrl, "xsd:anyURI"))
				{	soap_flag_ManufacturerUrl--;
					continue;
				}
			if (soap_flag_ModelName && soap->error == SOAP_TAG_MISMATCH)
			{	struct wdp__LocalizedStringType **p;
				soap_new_block(soap);
				for (a->__sizeModelName = 0; !soap_element_begin_in(soap, "wdp:ModelName", 1); a->__sizeModelName++)
				{	p = (struct wdp__LocalizedStringType **)soap_push_block(soap, sizeof(struct wdp__LocalizedStringType *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerTowdp__LocalizedStringType(soap, "wdp:ModelName", p, "wdp:LocalizedStringType"))
						break;
					soap_flag_ModelName = 0;
				}
				a->ModelName = (struct wdp__LocalizedStringType **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_ModelName && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_ModelNumber && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wdp:ModelNumber", &a->ModelNumber, "xsd:string"))
				{	soap_flag_ModelNumber--;
					continue;
				}
			if (soap_flag_ModelUrl && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wdp:ModelUrl", &a->ModelUrl, "xsd:anyURI"))
				{	soap_flag_ModelUrl--;
					continue;
				}
			if (soap_flag_PresentationUrl && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wdp:PresentationUrl", &a->PresentationUrl, "xsd:anyURI"))
				{	soap_flag_PresentationUrl--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wdp__ThisModelType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wdp__ThisModel, 0, sizeof(struct wdp__ThisModelType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wdp__Relationship(struct soap *soap, const struct _wdp__Relationship *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTowdp__HostServiceType(soap, &a->Host);
	if (a->Hosted)
	{	int i;
		for (i = 0; i < a->__sizeHosted; i++)
		{
			soap_serialize_PointerTowdp__HostServiceType(soap, a->Hosted + i);
		}
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wdp__Relationship(struct soap *soap, struct _wdp__Relationship *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Host = NULL;
	a->__sizeHosted = 0;
	a->Hosted = NULL;
	soap_default_xsd__anyURI(soap, &a->Type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wdp__Relationship(struct soap *soap, const struct _wdp__Relationship *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wdp__Relationship);
	if (soap_out__wdp__Relationship(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wdp__Relationship(struct soap *soap, const char *tag, int id, const struct _wdp__Relationship *a, const char *type)
{
	if (a->Type)
		soap_set_attr(soap, "Type", a->Type);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wdp__Relationship), type);
	soap_out_PointerTowdp__HostServiceType(soap, "wdp:Host", -1, &a->Host, "");
	if (a->Hosted)
	{	int i;
		for (i = 0; i < a->__sizeHosted; i++)
			soap_out_PointerTowdp__HostServiceType(soap, "wdp:Hosted", -1, a->Hosted + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _wdp__Relationship * SOAP_FMAC4 soap_get__wdp__Relationship(struct soap *soap, struct _wdp__Relationship *p, const char *tag, const char *type)
{
	if ((p = soap_in__wdp__Relationship(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wdp__Relationship * SOAP_FMAC4 soap_in__wdp__Relationship(struct soap *soap, const char *tag, struct _wdp__Relationship *a, const char *type)
{
	short soap_flag_Host = 1, soap_flag_Hosted = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct _wdp__Relationship *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wdp__Relationship, sizeof(struct _wdp__Relationship), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wdp__Relationship(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Type", 1), &a->Type))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Host && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTowdp__HostServiceType(soap, "wdp:Host", &a->Host, "wdp:HostServiceType"))
				{	soap_flag_Host--;
					continue;
				}
			if (soap_flag_Hosted && soap->error == SOAP_TAG_MISMATCH)
			{	struct wdp__HostServiceType **p;
				soap_new_block(soap);
				for (a->__sizeHosted = 0; !soap_element_begin_in(soap, "wdp:Hosted", 1); a->__sizeHosted++)
				{	p = (struct wdp__HostServiceType **)soap_push_block(soap, sizeof(struct wdp__HostServiceType *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerTowdp__HostServiceType(soap, "wdp:Hosted", p, "wdp:HostServiceType"))
						break;
					soap_flag_Hosted = 0;
				}
				a->Hosted = (struct wdp__HostServiceType **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_Hosted && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wdp__Relationship *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__wdp__Relationship, 0, sizeof(struct _wdp__Relationship), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wdp__HostServiceType(struct soap *soap, const struct wdp__HostServiceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->wsa__EndpointReference)
	{	int i;
		for (i = 0; i < a->__sizeEndpointReference; i++)
		{
			soap_serialize_endpoint_ref(soap, a->wsa__EndpointReference + i);
		}
	}
	soap_serialize_qname_list(soap, &a->Types);
	soap_serialize_xsd__anyURI(soap, &a->ServiceId);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wdp__HostServiceType(struct soap *soap, struct wdp__HostServiceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeEndpointReference = 0;
	a->wsa__EndpointReference = NULL;
	a->Types = NULL;
	soap_default_xsd__anyURI(soap, &a->ServiceId);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wdp__HostServiceType(struct soap *soap, const struct wdp__HostServiceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wdp__HostServiceType);
	if (soap_out_wdp__HostServiceType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wdp__HostServiceType(struct soap *soap, const char *tag, int id, const struct wdp__HostServiceType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wdp__HostServiceType), type);
	if (a->wsa__EndpointReference)
	{	int i;
		for (i = 0; i < a->__sizeEndpointReference; i++)
			soap_out_endpoint_ref(soap, "wsa:EndpointReference", -1, a->wsa__EndpointReference + i, "");
	}
	soap_out_qname_list(soap, "wdp:Types", -1, &a->Types, "");
	soap_out_xsd__anyURI(soap, "wdp:ServiceId", -1, &a->ServiceId, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wdp__HostServiceType * SOAP_FMAC4 soap_get_wdp__HostServiceType(struct soap *soap, struct wdp__HostServiceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wdp__HostServiceType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__HostServiceType * SOAP_FMAC4 soap_in_wdp__HostServiceType(struct soap *soap, const char *tag, struct wdp__HostServiceType *a, const char *type)
{
	short soap_flag_wsa__EndpointReference = 1, soap_flag_Types = 1, soap_flag_ServiceId = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wdp__HostServiceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wdp__HostServiceType, sizeof(struct wdp__HostServiceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wdp__HostServiceType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
			{	struct wsa_endpoint_ref **p;
				soap_new_block(soap);
				for (a->__sizeEndpointReference = 0; !soap_element_begin_in(soap, "wsa:EndpointReference", 1); a->__sizeEndpointReference++)
				{	p = (struct wsa_endpoint_ref **)soap_push_block(soap, sizeof(struct wsa_endpoint_ref *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_endpoint_ref(soap, "wsa:EndpointReference", p, "endpoint-ref"))
						break;
					soap_flag_wsa__EndpointReference = 0;
				}
				a->wsa__EndpointReference = (struct wsa_endpoint_ref **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_wsa__EndpointReference && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_Types && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_qname_list(soap, "wdp:Types", &a->Types, "qname-list"))
				{	soap_flag_Types--;
					continue;
				}
			if (soap_flag_ServiceId && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wdp:ServiceId", &a->ServiceId, "xsd:anyURI"))
				{	soap_flag_ServiceId--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wdp__HostServiceType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wdp__HostServiceType, 0, sizeof(struct wdp__HostServiceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wdp__ThisDeviceType(struct soap *soap, const struct wdp__ThisDeviceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->FriendlyName)
	{	int i;
		for (i = 0; i < a->__sizeFriendlyName; i++)
		{
			soap_serialize_PointerTowdp__LocalizedStringType(soap, a->FriendlyName + i);
		}
	}
	soap_serialize_string(soap, &a->FirmwareVersion);
	soap_serialize_string(soap, &a->SerialNumber);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wdp__ThisDeviceType(struct soap *soap, struct wdp__ThisDeviceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeFriendlyName = 0;
	a->FriendlyName = NULL;
	soap_default_string(soap, &a->FirmwareVersion);
	soap_default_string(soap, &a->SerialNumber);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wdp__ThisDeviceType(struct soap *soap, const struct wdp__ThisDeviceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wdp__ThisDeviceType);
	if (soap_out_wdp__ThisDeviceType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wdp__ThisDeviceType(struct soap *soap, const char *tag, int id, const struct wdp__ThisDeviceType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wdp__ThisDeviceType), type);
	if (a->FriendlyName)
	{	int i;
		for (i = 0; i < a->__sizeFriendlyName; i++)
			soap_out_PointerTowdp__LocalizedStringType(soap, "wdp:FriendlyName", -1, a->FriendlyName + i, "");
	}
	soap_out_string(soap, "wdp:FirmwareVersion", -1, &a->FirmwareVersion, "");
	soap_out_string(soap, "wdp:SerialNumber", -1, &a->SerialNumber, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wdp__ThisDeviceType * SOAP_FMAC4 soap_get_wdp__ThisDeviceType(struct soap *soap, struct wdp__ThisDeviceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wdp__ThisDeviceType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__ThisDeviceType * SOAP_FMAC4 soap_in_wdp__ThisDeviceType(struct soap *soap, const char *tag, struct wdp__ThisDeviceType *a, const char *type)
{
	short soap_flag_FriendlyName = 1, soap_flag_FirmwareVersion = 1, soap_flag_SerialNumber = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wdp__ThisDeviceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wdp__ThisDeviceType, sizeof(struct wdp__ThisDeviceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wdp__ThisDeviceType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_FriendlyName && soap->error == SOAP_TAG_MISMATCH)
			{	struct wdp__LocalizedStringType **p;
				soap_new_block(soap);
				for (a->__sizeFriendlyName = 0; !soap_element_begin_in(soap, "wdp:FriendlyName", 1); a->__sizeFriendlyName++)
				{	p = (struct wdp__LocalizedStringType **)soap_push_block(soap, sizeof(struct wdp__LocalizedStringType *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerTowdp__LocalizedStringType(soap, "wdp:FriendlyName", p, "wdp:LocalizedStringType"))
						break;
					soap_flag_FriendlyName = 0;
				}
				a->FriendlyName = (struct wdp__LocalizedStringType **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_FriendlyName && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_FirmwareVersion && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wdp:FirmwareVersion", &a->FirmwareVersion, "xsd:string"))
				{	soap_flag_FirmwareVersion--;
					continue;
				}
			if (soap_flag_SerialNumber && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wdp:SerialNumber", &a->SerialNumber, "xsd:string"))
				{	soap_flag_SerialNumber--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wdp__ThisDeviceType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wdp__ThisDeviceType, 0, sizeof(struct wdp__ThisDeviceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wdp__LocalizedStringType(struct soap *soap, const struct wdp__LocalizedStringType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wdp__LocalizedStringType(struct soap *soap, struct wdp__LocalizedStringType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default__xml__lang(soap, &a->xml__lang);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wdp__LocalizedStringType(struct soap *soap, const struct wdp__LocalizedStringType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wdp__LocalizedStringType);
	if (soap_out_wdp__LocalizedStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wdp__LocalizedStringType(struct soap *soap, const char *tag, int id, const struct wdp__LocalizedStringType *a, const char *type)
{
	if (a->xml__lang)
		soap_set_attr(soap, "xml:lang", a->xml__lang);
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct wdp__LocalizedStringType * SOAP_FMAC4 soap_get_wdp__LocalizedStringType(struct soap *soap, struct wdp__LocalizedStringType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wdp__LocalizedStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__LocalizedStringType * SOAP_FMAC4 soap_in_wdp__LocalizedStringType(struct soap *soap, const char *tag, struct wdp__LocalizedStringType *a, const char *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!(a = (struct wdp__LocalizedStringType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wdp__LocalizedStringType, sizeof(struct wdp__LocalizedStringType), 0, NULL, NULL, NULL)))
		return NULL;
	*soap->id = '\0';
	soap_default_wdp__LocalizedStringType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "xml:lang", 0), &a->xml__lang))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, "wdp:LocalizedStringType"))
		return NULL;
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_wdp__ThisModelType(struct soap *soap, const struct wdp__ThisModelType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->Manufacturer)
	{	int i;
		for (i = 0; i < a->__sizeManufacturer; i++)
		{
			soap_serialize_PointerTowdp__LocalizedStringType(soap, a->Manufacturer + i);
		}
	}
	soap_serialize_xsd__anyURI(soap, &a->ManufacturerUrl);
	if (a->ModelName)
	{	int i;
		for (i = 0; i < a->__sizeModelName; i++)
		{
			soap_serialize_PointerTowdp__LocalizedStringType(soap, a->ModelName + i);
		}
	}
	soap_serialize_string(soap, &a->ModelNumber);
	soap_serialize_xsd__anyURI(soap, &a->ModelUrl);
	soap_serialize_xsd__anyURI(soap, &a->PresentationUrl);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wdp__ThisModelType(struct soap *soap, struct wdp__ThisModelType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeManufacturer = 0;
	a->Manufacturer = NULL;
	soap_default_xsd__anyURI(soap, &a->ManufacturerUrl);
	a->__sizeModelName = 0;
	a->ModelName = NULL;
	soap_default_string(soap, &a->ModelNumber);
	soap_default_xsd__anyURI(soap, &a->ModelUrl);
	soap_default_xsd__anyURI(soap, &a->PresentationUrl);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wdp__ThisModelType(struct soap *soap, const struct wdp__ThisModelType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wdp__ThisModelType);
	if (soap_out_wdp__ThisModelType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wdp__ThisModelType(struct soap *soap, const char *tag, int id, const struct wdp__ThisModelType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wdp__ThisModelType), type);
	if (a->Manufacturer)
	{	int i;
		for (i = 0; i < a->__sizeManufacturer; i++)
			soap_out_PointerTowdp__LocalizedStringType(soap, "wdp:Manufacturer", -1, a->Manufacturer + i, "");
	}
	soap_out_xsd__anyURI(soap, "wdp:ManufacturerUrl", -1, &a->ManufacturerUrl, "");
	if (a->ModelName)
	{	int i;
		for (i = 0; i < a->__sizeModelName; i++)
			soap_out_PointerTowdp__LocalizedStringType(soap, "wdp:ModelName", -1, a->ModelName + i, "");
	}
	soap_out_string(soap, "wdp:ModelNumber", -1, &a->ModelNumber, "");
	soap_out_xsd__anyURI(soap, "wdp:ModelUrl", -1, &a->ModelUrl, "");
	soap_out_xsd__anyURI(soap, "wdp:PresentationUrl", -1, &a->PresentationUrl, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct wdp__ThisModelType * SOAP_FMAC4 soap_get_wdp__ThisModelType(struct soap *soap, struct wdp__ThisModelType *p, const char *tag, const char *type)
{
	if ((p = soap_in_wdp__ThisModelType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__ThisModelType * SOAP_FMAC4 soap_in_wdp__ThisModelType(struct soap *soap, const char *tag, struct wdp__ThisModelType *a, const char *type)
{
	short soap_flag_Manufacturer = 1, soap_flag_ManufacturerUrl = 1, soap_flag_ModelName = 1, soap_flag_ModelNumber = 1, soap_flag_ModelUrl = 1, soap_flag_PresentationUrl = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct wdp__ThisModelType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wdp__ThisModelType, sizeof(struct wdp__ThisModelType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_wdp__ThisModelType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Manufacturer && soap->error == SOAP_TAG_MISMATCH)
			{	struct wdp__LocalizedStringType **p;
				soap_new_block(soap);
				for (a->__sizeManufacturer = 0; !soap_element_begin_in(soap, "wdp:Manufacturer", 1); a->__sizeManufacturer++)
				{	p = (struct wdp__LocalizedStringType **)soap_push_block(soap, sizeof(struct wdp__LocalizedStringType *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerTowdp__LocalizedStringType(soap, "wdp:Manufacturer", p, "wdp:LocalizedStringType"))
						break;
					soap_flag_Manufacturer = 0;
				}
				a->Manufacturer = (struct wdp__LocalizedStringType **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_Manufacturer && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_ManufacturerUrl && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wdp:ManufacturerUrl", &a->ManufacturerUrl, "xsd:anyURI"))
				{	soap_flag_ManufacturerUrl--;
					continue;
				}
			if (soap_flag_ModelName && soap->error == SOAP_TAG_MISMATCH)
			{	struct wdp__LocalizedStringType **p;
				soap_new_block(soap);
				for (a->__sizeModelName = 0; !soap_element_begin_in(soap, "wdp:ModelName", 1); a->__sizeModelName++)
				{	p = (struct wdp__LocalizedStringType **)soap_push_block(soap, sizeof(struct wdp__LocalizedStringType *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerTowdp__LocalizedStringType(soap, "wdp:ModelName", p, "wdp:LocalizedStringType"))
						break;
					soap_flag_ModelName = 0;
				}
				a->ModelName = (struct wdp__LocalizedStringType **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_ModelName && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_ModelNumber && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wdp:ModelNumber", &a->ModelNumber, "xsd:string"))
				{	soap_flag_ModelNumber--;
					continue;
				}
			if (soap_flag_ModelUrl && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wdp:ModelUrl", &a->ModelUrl, "xsd:anyURI"))
				{	soap_flag_ModelUrl--;
					continue;
				}
			if (soap_flag_PresentationUrl && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "wdp:PresentationUrl", &a->PresentationUrl, "xsd:anyURI"))
				{	soap_flag_PresentationUrl--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct wdp__ThisModelType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_wdp__ThisModelType, 0, sizeof(struct wdp__ThisModelType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerTo_wsm__MetadataSection(struct soap *soap, struct _wsm__MetadataSection **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerTo_wsm__MetadataSection))
		soap_serialize_PointerTo_wsm__MetadataSection(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerTo_wsm__MetadataSection(struct soap *soap, struct _wsm__MetadataSection **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerTo_wsm__MetadataSection);
	if (soap_out_PointerToPointerTo_wsm__MetadataSection(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerTo_wsm__MetadataSection(struct soap *soap, const char *tag, int id, struct _wsm__MetadataSection **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerTo_wsm__MetadataSection);
	if (id < 0)
		return soap->error;
	return soap_out_PointerTo_wsm__MetadataSection(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsm__MetadataSection *** SOAP_FMAC4 soap_get_PointerToPointerTo_wsm__MetadataSection(struct soap *soap, struct _wsm__MetadataSection ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerTo_wsm__MetadataSection(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wsm__MetadataSection *** SOAP_FMAC4 soap_in_PointerToPointerTo_wsm__MetadataSection(struct soap *soap, const char *tag, struct _wsm__MetadataSection ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct _wsm__MetadataSection ***)soap_malloc(soap, sizeof(struct _wsm__MetadataSection **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerTo_wsm__MetadataSection(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsm__MetadataSection ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerTo_wsm__MetadataSection, sizeof(struct _wsm__MetadataSection *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsm__MetadataSection(struct soap *soap, struct _wsm__MetadataSection *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsm__MetadataSection))
		soap_serialize__wsm__MetadataSection(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsm__MetadataSection(struct soap *soap, struct _wsm__MetadataSection *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsm__MetadataSection);
	if (soap_out_PointerTo_wsm__MetadataSection(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsm__MetadataSection(struct soap *soap, const char *tag, int id, struct _wsm__MetadataSection *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsm__MetadataSection);
	if (id < 0)
		return soap->error;
	return soap_out__wsm__MetadataSection(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsm__MetadataSection ** SOAP_FMAC4 soap_get_PointerTo_wsm__MetadataSection(struct soap *soap, struct _wsm__MetadataSection **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsm__MetadataSection(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _wsm__MetadataSection ** SOAP_FMAC4 soap_in_PointerTo_wsm__MetadataSection(struct soap *soap, const char *tag, struct _wsm__MetadataSection **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct _wsm__MetadataSection **)soap_malloc(soap, sizeof(struct _wsm__MetadataSection *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsm__MetadataSection(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsm__MetadataSection **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsm__MetadataSection, sizeof(struct _wsm__MetadataSection), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__nonNegativeInteger(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__nonNegativeInteger(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__nonNegativeInteger(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__nonNegativeInteger);
	if (soap_out_xsd__nonNegativeInteger(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__nonNegativeInteger(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__nonNegativeInteger);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__nonNegativeInteger(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__nonNegativeInteger(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__nonNegativeInteger(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__nonNegativeInteger, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wdp__ServiceId(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wdp__ServiceId(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wdp__ServiceId(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wdp__ServiceId);
	if (soap_out__wdp__ServiceId(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wdp__ServiceId(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__wdp__ServiceId);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__wdp__ServiceId(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__wdp__ServiceId(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__wdp__ServiceId(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__wdp__ServiceId, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerTowdp__HostServiceType(struct soap *soap, struct wdp__HostServiceType **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerTowdp__HostServiceType))
		soap_serialize_PointerTowdp__HostServiceType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerTowdp__HostServiceType(struct soap *soap, struct wdp__HostServiceType **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerTowdp__HostServiceType);
	if (soap_out_PointerToPointerTowdp__HostServiceType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerTowdp__HostServiceType(struct soap *soap, const char *tag, int id, struct wdp__HostServiceType **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerTowdp__HostServiceType);
	if (id < 0)
		return soap->error;
	return soap_out_PointerTowdp__HostServiceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wdp__HostServiceType *** SOAP_FMAC4 soap_get_PointerToPointerTowdp__HostServiceType(struct soap *soap, struct wdp__HostServiceType ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerTowdp__HostServiceType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__HostServiceType *** SOAP_FMAC4 soap_in_PointerToPointerTowdp__HostServiceType(struct soap *soap, const char *tag, struct wdp__HostServiceType ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wdp__HostServiceType ***)soap_malloc(soap, sizeof(struct wdp__HostServiceType **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerTowdp__HostServiceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wdp__HostServiceType ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerTowdp__HostServiceType, sizeof(struct wdp__HostServiceType *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowdp__HostServiceType(struct soap *soap, struct wdp__HostServiceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wdp__HostServiceType))
		soap_serialize_wdp__HostServiceType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowdp__HostServiceType(struct soap *soap, struct wdp__HostServiceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowdp__HostServiceType);
	if (soap_out_PointerTowdp__HostServiceType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowdp__HostServiceType(struct soap *soap, const char *tag, int id, struct wdp__HostServiceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wdp__HostServiceType);
	if (id < 0)
		return soap->error;
	return soap_out_wdp__HostServiceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wdp__HostServiceType ** SOAP_FMAC4 soap_get_PointerTowdp__HostServiceType(struct soap *soap, struct wdp__HostServiceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowdp__HostServiceType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__HostServiceType ** SOAP_FMAC4 soap_in_PointerTowdp__HostServiceType(struct soap *soap, const char *tag, struct wdp__HostServiceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wdp__HostServiceType **)soap_malloc(soap, sizeof(struct wdp__HostServiceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wdp__HostServiceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wdp__HostServiceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wdp__HostServiceType, sizeof(struct wdp__HostServiceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToendpoint_ref(struct soap *soap, struct wsa_endpoint_ref **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_endpoint_ref))
		soap_serialize_endpoint_ref(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToendpoint_ref(struct soap *soap, struct wsa_endpoint_ref **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToendpoint_ref);
	if (soap_out_PointerToendpoint_ref(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToendpoint_ref(struct soap *soap, const char *tag, int id, struct wsa_endpoint_ref **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_endpoint_ref);
	if (id < 0)
		return soap->error;
	return soap_out_endpoint_ref(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wsa_endpoint_ref *** SOAP_FMAC4 soap_get_PointerToendpoint_ref(struct soap *soap, struct wsa_endpoint_ref ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToendpoint_ref(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wsa_endpoint_ref *** SOAP_FMAC4 soap_in_PointerToendpoint_ref(struct soap *soap, const char *tag, struct wsa_endpoint_ref ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wsa_endpoint_ref ***)soap_malloc(soap, sizeof(struct wsa_endpoint_ref **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_endpoint_ref(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wsa_endpoint_ref ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_endpoint_ref, sizeof(struct wsa_endpoint_ref *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerTowdp__LocalizedStringType(struct soap *soap, struct wdp__LocalizedStringType **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerTowdp__LocalizedStringType))
		soap_serialize_PointerTowdp__LocalizedStringType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerTowdp__LocalizedStringType(struct soap *soap, struct wdp__LocalizedStringType **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerTowdp__LocalizedStringType);
	if (soap_out_PointerToPointerTowdp__LocalizedStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerTowdp__LocalizedStringType(struct soap *soap, const char *tag, int id, struct wdp__LocalizedStringType **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerTowdp__LocalizedStringType);
	if (id < 0)
		return soap->error;
	return soap_out_PointerTowdp__LocalizedStringType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wdp__LocalizedStringType *** SOAP_FMAC4 soap_get_PointerToPointerTowdp__LocalizedStringType(struct soap *soap, struct wdp__LocalizedStringType ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerTowdp__LocalizedStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__LocalizedStringType *** SOAP_FMAC4 soap_in_PointerToPointerTowdp__LocalizedStringType(struct soap *soap, const char *tag, struct wdp__LocalizedStringType ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wdp__LocalizedStringType ***)soap_malloc(soap, sizeof(struct wdp__LocalizedStringType **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerTowdp__LocalizedStringType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wdp__LocalizedStringType ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerTowdp__LocalizedStringType, sizeof(struct wdp__LocalizedStringType *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTowdp__LocalizedStringType(struct soap *soap, struct wdp__LocalizedStringType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_wdp__LocalizedStringType))
		soap_serialize_wdp__LocalizedStringType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTowdp__LocalizedStringType(struct soap *soap, struct wdp__LocalizedStringType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTowdp__LocalizedStringType);
	if (soap_out_PointerTowdp__LocalizedStringType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTowdp__LocalizedStringType(struct soap *soap, const char *tag, int id, struct wdp__LocalizedStringType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_wdp__LocalizedStringType);
	if (id < 0)
		return soap->error;
	return soap_out_wdp__LocalizedStringType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct wdp__LocalizedStringType ** SOAP_FMAC4 soap_get_PointerTowdp__LocalizedStringType(struct soap *soap, struct wdp__LocalizedStringType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTowdp__LocalizedStringType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct wdp__LocalizedStringType ** SOAP_FMAC4 soap_in_PointerTowdp__LocalizedStringType(struct soap *soap, const char *tag, struct wdp__LocalizedStringType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct wdp__LocalizedStringType **)soap_malloc(soap, sizeof(struct wdp__LocalizedStringType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_wdp__LocalizedStringType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct wdp__LocalizedStringType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_wdp__LocalizedStringType, sizeof(struct wdp__LocalizedStringType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__xml__lang(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__xml__lang(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__xml__lang(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__xml__lang);
	if (soap_out__xml__lang(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__xml__lang(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__xml__lang);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__xml__lang(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__xml__lang(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__xml__lang(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__xml__lang, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__anyURI(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__anyURI(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__anyURI(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__anyURI);
	if (soap_out_xsd__anyURI(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__anyURI);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__anyURI(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__anyURI(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__anyURI(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__anyURI, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__QName);
	if (soap_out_xsd__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__QName, 2, -1, -1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_uri_list(struct soap *soap, struct dynamic_array *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_uri_list);
	if (soap_out_uri_list(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct dynamic_array ** SOAP_FMAC4 soap_get_uri_list(struct soap *soap, struct dynamic_array **p, const char *tag, const char *type)
{
	if ((p = soap_in_uri_list(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_qname_list(struct soap *soap, struct dynamic_array *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_qname_list);
	if (soap_out_qname_list(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct dynamic_array ** SOAP_FMAC4 soap_get_qname_list(struct soap *soap, struct dynamic_array **p, const char *tag, const char *type)
{
	if ((p = soap_in_qname_list(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_endpoint_ref(struct soap *soap, struct wsa_endpoint_ref *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_endpoint_ref);
	if (soap_out_endpoint_ref(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct wsa_endpoint_ref ** SOAP_FMAC4 soap_get_endpoint_ref(struct soap *soap, struct wsa_endpoint_ref **p, const char *tag, const char *type)
{
	if ((p = soap_in_endpoint_ref(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

#ifdef __cplusplus
}
#endif

/* End of metadataC.c */
