/* litC.c
   Generated by gSOAP 2.7.6c from Lighting.gsoap
   Copyright (C) 2000-2005, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "litH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) litC.c ver 2.7.6c 2008-06-10 13:21:28 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
	soap->part = SOAP_END_HEADER;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_lit__DimmingDuration:
		return soap_in_lit__DimmingDuration(soap, NULL, NULL, "lit:DimmingDuration");
	case SOAP_TYPE_lit__Level:
		return soap_in_lit__Level(soap, NULL, NULL, "lit:Level");
	case SOAP_TYPE_short:
		return soap_in_short(soap, NULL, NULL, "xsd:short");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_lit__PowerState:
		return soap_in_lit__PowerState(soap, NULL, NULL, "lit:PowerState");
	case SOAP_TYPE_SOAP_ENV__Reason:
		return soap_in_SOAP_ENV__Reason(soap, NULL, NULL, "SOAP-ENV:Reason");
	case SOAP_TYPE__lit__LightLevelTarget:
		return soap_in__lit__LightLevelTarget(soap, NULL, NULL, "lit:LightLevelTarget");
	case SOAP_TYPE_lit__dummyType:
		return soap_in_lit__dummyType(soap, NULL, NULL, "lit:dummyType");
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		return soap_in_PointerToSOAP_ENV__Reason(soap, NULL, NULL, "SOAP-ENV:Reason");
	case SOAP_TYPE_PointerTolit__Level:
		return soap_in_PointerTolit__Level(soap, NULL, NULL, "lit:Level");
	case SOAP_TYPE_PointerTo_lit__LightLevelTarget:
		return soap_in_PointerTo_lit__LightLevelTarget(soap, NULL, NULL, "lit:LightLevelTarget");
	case SOAP_TYPE_PointerTolit__PowerState:
		return soap_in_PointerTolit__PowerState(soap, NULL, NULL, "lit:PowerState");
	case SOAP_TYPE_PointerTolit__DimmingDuration:
		return soap_in_PointerTolit__DimmingDuration(soap, NULL, NULL, "lit:DimmingDuration");
	case SOAP_TYPE_xsd__token:
	{	char **s;
		s = soap_in_xsd__token(soap, NULL, NULL, "xsd:token");
		return s ? *s : NULL;
	}
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "lit:DimmingDuration"))
		{	*type = SOAP_TYPE_lit__DimmingDuration;
			return soap_in_lit__DimmingDuration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "lit:Level"))
		{	*type = SOAP_TYPE_lit__Level;
			return soap_in_lit__Level(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:short"))
		{	*type = SOAP_TYPE_short;
			return soap_in_short(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "lit:PowerState"))
		{	*type = SOAP_TYPE_lit__PowerState;
			return soap_in_lit__PowerState(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SOAP-ENV:Reason"))
		{	*type = SOAP_TYPE_SOAP_ENV__Reason;
			return soap_in_SOAP_ENV__Reason(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "lit:LightLevelTarget"))
		{	*type = SOAP_TYPE__lit__LightLevelTarget;
			return soap_in__lit__LightLevelTarget(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "lit:dummyType"))
		{	*type = SOAP_TYPE_lit__dummyType;
			return soap_in_lit__dummyType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:token"))
		{	char **s;
			*type = SOAP_TYPE_xsd__token;
			s = soap_in_xsd__token(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_lit__DimmingDuration:
		return soap_out_lit__DimmingDuration(soap, tag, id, (const short *)ptr, "lit:DimmingDuration");
	case SOAP_TYPE_lit__Level:
		return soap_out_lit__Level(soap, tag, id, (const short *)ptr, "lit:Level");
	case SOAP_TYPE_short:
		return soap_out_short(soap, tag, id, (const short *)ptr, "xsd:short");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_lit__PowerState:
		return soap_out_lit__PowerState(soap, tag, id, (const enum lit__PowerState *)ptr, "lit:PowerState");
	case SOAP_TYPE_SOAP_ENV__Reason:
		return soap_out_SOAP_ENV__Reason(soap, tag, id, (const struct SOAP_ENV__Reason *)ptr, "SOAP-ENV:Reason");
	case SOAP_TYPE__lit__LightLevelTarget:
		return soap_out__lit__LightLevelTarget(soap, "lit:LightLevelTarget", id, (const struct _lit__LightLevelTarget *)ptr, NULL);
	case SOAP_TYPE_lit__dummyType:
		return soap_out_lit__dummyType(soap, tag, id, (const struct lit__dummyType *)ptr, "lit:dummyType");
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		return soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, (struct SOAP_ENV__Reason *const*)ptr, "SOAP-ENV:Reason");
	case SOAP_TYPE_PointerTolit__Level:
		return soap_out_PointerTolit__Level(soap, tag, id, (short *const*)ptr, "lit:Level");
	case SOAP_TYPE_PointerTo_lit__LightLevelTarget:
		return soap_out_PointerTo_lit__LightLevelTarget(soap, tag, id, (struct _lit__LightLevelTarget *const*)ptr, "lit:LightLevelTarget");
	case SOAP_TYPE_PointerTolit__PowerState:
		return soap_out_PointerTolit__PowerState(soap, tag, id, (enum lit__PowerState *const*)ptr, "lit:PowerState");
	case SOAP_TYPE_PointerTolit__DimmingDuration:
		return soap_out_PointerTolit__DimmingDuration(soap, tag, id, (short *const*)ptr, "lit:DimmingDuration");
	case SOAP_TYPE_xsd__token:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:token");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_SOAP_ENV__Reason:
		soap_serialize_SOAP_ENV__Reason(soap, (const struct SOAP_ENV__Reason *)ptr);
		break;
	case SOAP_TYPE___lit__TargetReached:
		soap_serialize___lit__TargetReached(soap, (const struct __lit__TargetReached *)ptr);
		break;
	case SOAP_TYPE___lit__GetLevel:
		soap_serialize___lit__GetLevel(soap, (const struct __lit__GetLevel *)ptr);
		break;
	case SOAP_TYPE___lit__GetLevelResponse:
		soap_serialize___lit__GetLevelResponse(soap, (const struct __lit__GetLevelResponse *)ptr);
		break;
	case SOAP_TYPE___lit__GetLevelTarget:
		soap_serialize___lit__GetLevelTarget(soap, (const struct __lit__GetLevelTarget *)ptr);
		break;
	case SOAP_TYPE___lit__GetLevelTargetResponse:
		soap_serialize___lit__GetLevelTargetResponse(soap, (const struct __lit__GetLevelTargetResponse *)ptr);
		break;
	case SOAP_TYPE___lit__SetLevel:
		soap_serialize___lit__SetLevel(soap, (const struct __lit__SetLevel *)ptr);
		break;
	case SOAP_TYPE___lit__GetStatus:
		soap_serialize___lit__GetStatus(soap, (const struct __lit__GetStatus *)ptr);
		break;
	case SOAP_TYPE___lit__GetStatusResponse:
		soap_serialize___lit__GetStatusResponse(soap, (const struct __lit__GetStatusResponse *)ptr);
		break;
	case SOAP_TYPE___lit__Switch:
		soap_serialize___lit__Switch(soap, (const struct __lit__Switch *)ptr);
		break;
	case SOAP_TYPE__lit__LightLevelTarget:
		soap_serialize__lit__LightLevelTarget(soap, (const struct _lit__LightLevelTarget *)ptr);
		break;
	case SOAP_TYPE_lit__dummyType:
		soap_serialize_lit__dummyType(soap, (const struct lit__dummyType *)ptr);
		break;
	case SOAP_TYPE_PointerToSOAP_ENV__Reason:
		soap_serialize_PointerToSOAP_ENV__Reason(soap, (struct SOAP_ENV__Reason *const*)ptr);
		break;
	case SOAP_TYPE_PointerTolit__Level:
		soap_serialize_PointerTolit__Level(soap, (short *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_lit__LightLevelTarget:
		soap_serialize_PointerTo_lit__LightLevelTarget(soap, (struct _lit__LightLevelTarget *const*)ptr);
		break;
	case SOAP_TYPE_PointerTolit__PowerState:
		soap_serialize_PointerTolit__PowerState(soap, (enum lit__PowerState *const*)ptr);
		break;
	case SOAP_TYPE_PointerTolit__DimmingDuration:
		soap_serialize_PointerTolit__DimmingDuration(soap, (short *const*)ptr);
		break;
	case SOAP_TYPE_xsd__token:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_lit__DimmingDuration(struct soap *soap, short *a)
{	soap_default_short(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_lit__DimmingDuration(struct soap *soap, const short *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_lit__DimmingDuration);
	if (soap_out_lit__DimmingDuration(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_lit__DimmingDuration(struct soap *soap, const char *tag, int id, const short *a, const char *type)
{
	return soap_outshort(soap, tag, id, a, type, SOAP_TYPE_lit__DimmingDuration);
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_get_lit__DimmingDuration(struct soap *soap, short *p, const char *tag, const char *type)
{
	if ((p = soap_in_lit__DimmingDuration(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_in_lit__DimmingDuration(struct soap *soap, const char *tag, short *a, const char *type)
{
	return soap_inshort(soap, tag, a, type, SOAP_TYPE_lit__DimmingDuration);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_lit__Level(struct soap *soap, short *a)
{	soap_default_short(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_lit__Level(struct soap *soap, const short *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_lit__Level);
	if (soap_out_lit__Level(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_lit__Level(struct soap *soap, const char *tag, int id, const short *a, const char *type)
{
	return soap_outshort(soap, tag, id, a, type, SOAP_TYPE_lit__Level);
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_get_lit__Level(struct soap *soap, short *p, const char *tag, const char *type)
{
	if ((p = soap_in_lit__Level(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_in_lit__Level(struct soap *soap, const char *tag, short *a, const char *type)
{
	return soap_inshort(soap, tag, a, type, SOAP_TYPE_lit__Level);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_short(struct soap *soap, short *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_short
	*a = SOAP_DEFAULT_short;
#else
	*a = (short)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_short(struct soap *soap, const short *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_short);
	if (soap_out_short(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_short(struct soap *soap, const char *tag, int id, const short *a, const char *type)
{
	return soap_outshort(soap, tag, id, a, type, SOAP_TYPE_short);
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_get_short(struct soap *soap, short *p, const char *tag, const char *type)
{
	if ((p = soap_in_short(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_in_short(struct soap *soap, const char *tag, short *a, const char *type)
{
	return soap_inshort(soap, tag, a, type, SOAP_TYPE_short);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_lit__PowerState(struct soap *soap, enum lit__PowerState *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_lit__PowerState
	*a = SOAP_DEFAULT_lit__PowerState;
#else
	*a = (enum lit__PowerState)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_lit__PowerState(struct soap *soap, const enum lit__PowerState *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_lit__PowerState);
	if (soap_out_lit__PowerState(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_lit__PowerState[] =
{	{ (long)lit__PowerState__ON, "ON" },
	{ (long)lit__PowerState__OFF, "OFF" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_lit__PowerState2s(struct soap *soap, enum lit__PowerState n)
{	const char *s = soap_str_code(soap_codes_lit__PowerState, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_lit__PowerState(struct soap *soap, const char *tag, int id, const enum lit__PowerState *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_lit__PowerState), type);
	soap_send(soap, soap_lit__PowerState2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum lit__PowerState * SOAP_FMAC4 soap_get_lit__PowerState(struct soap *soap, enum lit__PowerState *p, const char *tag, const char *type)
{
	if ((p = soap_in_lit__PowerState(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2lit__PowerState(struct soap *soap, const char *s, enum lit__PowerState *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_lit__PowerState, s);
	if (map)
		*a = (enum lit__PowerState)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum lit__PowerState)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum lit__PowerState * SOAP_FMAC4 soap_in_lit__PowerState(struct soap *soap, const char *tag, enum lit__PowerState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum lit__PowerState *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_lit__PowerState, sizeof(enum lit__PowerState), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2lit__PowerState(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum lit__PowerState *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_lit__PowerState, 0, sizeof(enum lit__PowerState), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	dpws_headers_out(dpws_soap2dpws(soap));
	if (a) {
	/* transient dummy skipped */
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (!dpws_header_in(dpws_soap2dpws(soap)))
				continue;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___lit__TargetReached(struct soap *soap, const struct __lit__TargetReached *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->lit__LightLevel, SOAP_TYPE_lit__Level);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___lit__TargetReached(struct soap *soap, struct __lit__TargetReached *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_lit__Level(soap, &a->lit__LightLevel);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___lit__TargetReached(struct soap *soap, const struct __lit__TargetReached *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___lit__TargetReached(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___lit__TargetReached(struct soap *soap, const char *tag, int id, const struct __lit__TargetReached *a, const char *type)
{
	soap_out_lit__Level(soap, "lit:LightLevel", -1, &a->lit__LightLevel, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __lit__TargetReached * SOAP_FMAC4 soap_get___lit__TargetReached(struct soap *soap, struct __lit__TargetReached *p, const char *tag, const char *type)
{
	if ((p = soap_in___lit__TargetReached(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __lit__TargetReached * SOAP_FMAC4 soap_in___lit__TargetReached(struct soap *soap, const char *tag, struct __lit__TargetReached *a, const char *type)
{
	short soap_flag_lit__LightLevel = 1;
	a = (struct __lit__TargetReached *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___lit__TargetReached, sizeof(struct __lit__TargetReached), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___lit__TargetReached(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_lit__LightLevel && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_lit__Level(soap, "lit:LightLevel", &a->lit__LightLevel, "lit:Level"))
				{	soap_flag_lit__LightLevel--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_lit__LightLevel > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___lit__GetLevel(struct soap *soap, const struct __lit__GetLevel *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___lit__GetLevel(struct soap *soap, struct __lit__GetLevel *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___lit__GetLevel(struct soap *soap, const struct __lit__GetLevel *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___lit__GetLevel(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___lit__GetLevel(struct soap *soap, const char *tag, int id, const struct __lit__GetLevel *a, const char *type)
{
	return SOAP_OK;
}

SOAP_FMAC3 struct __lit__GetLevel * SOAP_FMAC4 soap_get___lit__GetLevel(struct soap *soap, struct __lit__GetLevel *p, const char *tag, const char *type)
{
	if ((p = soap_in___lit__GetLevel(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __lit__GetLevel * SOAP_FMAC4 soap_in___lit__GetLevel(struct soap *soap, const char *tag, struct __lit__GetLevel *a, const char *type)
{;
	a = (struct __lit__GetLevel *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___lit__GetLevel, sizeof(struct __lit__GetLevel), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___lit__GetLevel(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___lit__GetLevelResponse(struct soap *soap, const struct __lit__GetLevelResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTolit__Level(soap, &a->lit__LightLevel);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___lit__GetLevelResponse(struct soap *soap, struct __lit__GetLevelResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->lit__LightLevel = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___lit__GetLevelResponse(struct soap *soap, const struct __lit__GetLevelResponse *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___lit__GetLevelResponse(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___lit__GetLevelResponse(struct soap *soap, const char *tag, int id, const struct __lit__GetLevelResponse *a, const char *type)
{
	if (a->lit__LightLevel)
		soap_element_result(soap, "lit:LightLevel");
	soap_out_PointerTolit__Level(soap, "lit:LightLevel", -1, &a->lit__LightLevel, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __lit__GetLevelResponse * SOAP_FMAC4 soap_get___lit__GetLevelResponse(struct soap *soap, struct __lit__GetLevelResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in___lit__GetLevelResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __lit__GetLevelResponse * SOAP_FMAC4 soap_in___lit__GetLevelResponse(struct soap *soap, const char *tag, struct __lit__GetLevelResponse *a, const char *type)
{
	short soap_flag_lit__LightLevel = 1;
	a = (struct __lit__GetLevelResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___lit__GetLevelResponse, sizeof(struct __lit__GetLevelResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___lit__GetLevelResponse(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_lit__LightLevel && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTolit__Level(soap, "lit:LightLevel", &a->lit__LightLevel, "lit:Level"))
				{	soap_flag_lit__LightLevel--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___lit__GetLevelTarget(struct soap *soap, const struct __lit__GetLevelTarget *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___lit__GetLevelTarget(struct soap *soap, struct __lit__GetLevelTarget *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___lit__GetLevelTarget(struct soap *soap, const struct __lit__GetLevelTarget *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___lit__GetLevelTarget(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___lit__GetLevelTarget(struct soap *soap, const char *tag, int id, const struct __lit__GetLevelTarget *a, const char *type)
{
	return SOAP_OK;
}

SOAP_FMAC3 struct __lit__GetLevelTarget * SOAP_FMAC4 soap_get___lit__GetLevelTarget(struct soap *soap, struct __lit__GetLevelTarget *p, const char *tag, const char *type)
{
	if ((p = soap_in___lit__GetLevelTarget(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __lit__GetLevelTarget * SOAP_FMAC4 soap_in___lit__GetLevelTarget(struct soap *soap, const char *tag, struct __lit__GetLevelTarget *a, const char *type)
{;
	a = (struct __lit__GetLevelTarget *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___lit__GetLevelTarget, sizeof(struct __lit__GetLevelTarget), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___lit__GetLevelTarget(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___lit__GetLevelTargetResponse(struct soap *soap, const struct __lit__GetLevelTargetResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTolit__Level(soap, &a->lit__LightLevel);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___lit__GetLevelTargetResponse(struct soap *soap, struct __lit__GetLevelTargetResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->lit__LightLevel = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___lit__GetLevelTargetResponse(struct soap *soap, const struct __lit__GetLevelTargetResponse *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___lit__GetLevelTargetResponse(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___lit__GetLevelTargetResponse(struct soap *soap, const char *tag, int id, const struct __lit__GetLevelTargetResponse *a, const char *type)
{
	if (a->lit__LightLevel)
		soap_element_result(soap, "lit:LightLevel");
	soap_out_PointerTolit__Level(soap, "lit:LightLevel", -1, &a->lit__LightLevel, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __lit__GetLevelTargetResponse * SOAP_FMAC4 soap_get___lit__GetLevelTargetResponse(struct soap *soap, struct __lit__GetLevelTargetResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in___lit__GetLevelTargetResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __lit__GetLevelTargetResponse * SOAP_FMAC4 soap_in___lit__GetLevelTargetResponse(struct soap *soap, const char *tag, struct __lit__GetLevelTargetResponse *a, const char *type)
{
	short soap_flag_lit__LightLevel = 1;
	a = (struct __lit__GetLevelTargetResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___lit__GetLevelTargetResponse, sizeof(struct __lit__GetLevelTargetResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___lit__GetLevelTargetResponse(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_lit__LightLevel && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTolit__Level(soap, "lit:LightLevel", &a->lit__LightLevel, "lit:Level"))
				{	soap_flag_lit__LightLevel--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___lit__SetLevel(struct soap *soap, const struct __lit__SetLevel *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_lit__LightLevelTarget(soap, &a->lit__LightLevelTarget);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___lit__SetLevel(struct soap *soap, struct __lit__SetLevel *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->lit__LightLevelTarget = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___lit__SetLevel(struct soap *soap, const struct __lit__SetLevel *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___lit__SetLevel(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___lit__SetLevel(struct soap *soap, const char *tag, int id, const struct __lit__SetLevel *a, const char *type)
{
	soap_out_PointerTo_lit__LightLevelTarget(soap, "lit:LightLevelTarget", -1, &a->lit__LightLevelTarget, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __lit__SetLevel * SOAP_FMAC4 soap_get___lit__SetLevel(struct soap *soap, struct __lit__SetLevel *p, const char *tag, const char *type)
{
	if ((p = soap_in___lit__SetLevel(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __lit__SetLevel * SOAP_FMAC4 soap_in___lit__SetLevel(struct soap *soap, const char *tag, struct __lit__SetLevel *a, const char *type)
{
	short soap_flag_lit__LightLevelTarget = 1;
	a = (struct __lit__SetLevel *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___lit__SetLevel, sizeof(struct __lit__SetLevel), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___lit__SetLevel(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_lit__LightLevelTarget && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_lit__LightLevelTarget(soap, "lit:LightLevelTarget", &a->lit__LightLevelTarget, ""))
				{	soap_flag_lit__LightLevelTarget--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___lit__GetStatus(struct soap *soap, const struct __lit__GetStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___lit__GetStatus(struct soap *soap, struct __lit__GetStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___lit__GetStatus(struct soap *soap, const struct __lit__GetStatus *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___lit__GetStatus(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___lit__GetStatus(struct soap *soap, const char *tag, int id, const struct __lit__GetStatus *a, const char *type)
{
	return SOAP_OK;
}

SOAP_FMAC3 struct __lit__GetStatus * SOAP_FMAC4 soap_get___lit__GetStatus(struct soap *soap, struct __lit__GetStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in___lit__GetStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __lit__GetStatus * SOAP_FMAC4 soap_in___lit__GetStatus(struct soap *soap, const char *tag, struct __lit__GetStatus *a, const char *type)
{;
	a = (struct __lit__GetStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___lit__GetStatus, sizeof(struct __lit__GetStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___lit__GetStatus(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___lit__GetStatusResponse(struct soap *soap, const struct __lit__GetStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTolit__PowerState(soap, &a->lit__Power);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___lit__GetStatusResponse(struct soap *soap, struct __lit__GetStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->lit__Power = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___lit__GetStatusResponse(struct soap *soap, const struct __lit__GetStatusResponse *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___lit__GetStatusResponse(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___lit__GetStatusResponse(struct soap *soap, const char *tag, int id, const struct __lit__GetStatusResponse *a, const char *type)
{
	if (a->lit__Power)
		soap_element_result(soap, "lit:Power");
	soap_out_PointerTolit__PowerState(soap, "lit:Power", -1, &a->lit__Power, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __lit__GetStatusResponse * SOAP_FMAC4 soap_get___lit__GetStatusResponse(struct soap *soap, struct __lit__GetStatusResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in___lit__GetStatusResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __lit__GetStatusResponse * SOAP_FMAC4 soap_in___lit__GetStatusResponse(struct soap *soap, const char *tag, struct __lit__GetStatusResponse *a, const char *type)
{
	short soap_flag_lit__Power = 1;
	a = (struct __lit__GetStatusResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___lit__GetStatusResponse, sizeof(struct __lit__GetStatusResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___lit__GetStatusResponse(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_lit__Power && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTolit__PowerState(soap, "lit:Power", &a->lit__Power, "lit:PowerState"))
				{	soap_flag_lit__Power--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___lit__Switch(struct soap *soap, const struct __lit__Switch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->lit__Power, SOAP_TYPE_lit__PowerState);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___lit__Switch(struct soap *soap, struct __lit__Switch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_lit__PowerState(soap, &a->lit__Power);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___lit__Switch(struct soap *soap, const struct __lit__Switch *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___lit__Switch(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___lit__Switch(struct soap *soap, const char *tag, int id, const struct __lit__Switch *a, const char *type)
{
	soap_out_lit__PowerState(soap, "lit:Power", -1, &a->lit__Power, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __lit__Switch * SOAP_FMAC4 soap_get___lit__Switch(struct soap *soap, struct __lit__Switch *p, const char *tag, const char *type)
{
	if ((p = soap_in___lit__Switch(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct __lit__Switch * SOAP_FMAC4 soap_in___lit__Switch(struct soap *soap, const char *tag, struct __lit__Switch *a, const char *type)
{
	short soap_flag_lit__Power = 1;
	a = (struct __lit__Switch *)soap_id_enter(soap, soap->id, a, SOAP_TYPE___lit__Switch, sizeof(struct __lit__Switch), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___lit__Switch(soap, a);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_lit__Power && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_lit__PowerState(soap, "lit:Power", &a->lit__Power, "lit:PowerState"))
				{	soap_flag_lit__Power--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_lit__Power > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__lit__LightLevelTarget(struct soap *soap, const struct _lit__LightLevelTarget *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->__item, SOAP_TYPE_lit__Level);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__lit__LightLevelTarget(struct soap *soap, struct _lit__LightLevelTarget *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_lit__Level(soap, &a->__item);
	a->TransitionDuration = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__lit__LightLevelTarget(struct soap *soap, const struct _lit__LightLevelTarget *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__lit__LightLevelTarget);
	if (soap_out__lit__LightLevelTarget(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__lit__LightLevelTarget(struct soap *soap, const char *tag, int id, const struct _lit__LightLevelTarget *a, const char *type)
{
	if (a->TransitionDuration)
		soap_set_attr(soap, "TransitionDuration", soap_short2s(soap, *a->TransitionDuration));
	return soap_out_lit__Level(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct _lit__LightLevelTarget * SOAP_FMAC4 soap_get__lit__LightLevelTarget(struct soap *soap, struct _lit__LightLevelTarget *p, const char *tag, const char *type)
{
	if ((p = soap_in__lit__LightLevelTarget(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _lit__LightLevelTarget * SOAP_FMAC4 soap_in__lit__LightLevelTarget(struct soap *soap, const char *tag, struct _lit__LightLevelTarget *a, const char *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!(a = (struct _lit__LightLevelTarget *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__lit__LightLevelTarget, sizeof(struct _lit__LightLevelTarget), 0, NULL, NULL, NULL)))
		return NULL;
	*soap->id = '\0';
	soap_default__lit__LightLevelTarget(soap, a);
	{	const char *t = soap_attr_value(soap, "TransitionDuration", 0);
		if (t)
		{	if (!(a->TransitionDuration = (short *)soap_malloc(soap, sizeof(short))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	if (soap_s2short(soap, t, a->TransitionDuration))
		return NULL;
		}
	}
	if (!soap_in_lit__Level(soap, tag, &a->__item, ""))
		return NULL;
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_lit__dummyType(struct soap *soap, const struct lit__dummyType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_lit__dummyType(struct soap *soap, struct lit__dummyType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_lit__dummyType(struct soap *soap, const struct lit__dummyType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_lit__dummyType);
	if (soap_out_lit__dummyType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_lit__dummyType(struct soap *soap, const char *tag, int id, const struct lit__dummyType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_lit__dummyType), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct lit__dummyType * SOAP_FMAC4 soap_get_lit__dummyType(struct soap *soap, struct lit__dummyType *p, const char *tag, const char *type)
{
	if ((p = soap_in_lit__dummyType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct lit__dummyType * SOAP_FMAC4 soap_in_lit__dummyType(struct soap *soap, const char *tag, struct lit__dummyType *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct lit__dummyType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_lit__dummyType, sizeof(struct lit__dummyType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_lit__dummyType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct lit__dummyType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_lit__dummyType, 0, sizeof(struct lit__dummyType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTolit__Level(struct soap *soap, short *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_lit__Level);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTolit__Level(struct soap *soap, short *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTolit__Level);
	if (soap_out_PointerTolit__Level(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTolit__Level(struct soap *soap, const char *tag, int id, short *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_lit__Level);
	if (id < 0)
		return soap->error;
	return soap_out_lit__Level(soap, tag, id, *a, type);
}

SOAP_FMAC3 short ** SOAP_FMAC4 soap_get_PointerTolit__Level(struct soap *soap, short **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTolit__Level(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 short ** SOAP_FMAC4 soap_in_PointerTolit__Level(struct soap *soap, const char *tag, short **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (short **)soap_malloc(soap, sizeof(short *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_lit__Level(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (short **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_lit__Level, sizeof(short), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_lit__LightLevelTarget(struct soap *soap, struct _lit__LightLevelTarget *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__lit__LightLevelTarget))
		soap_serialize__lit__LightLevelTarget(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_lit__LightLevelTarget(struct soap *soap, struct _lit__LightLevelTarget *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_lit__LightLevelTarget);
	if (soap_out_PointerTo_lit__LightLevelTarget(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_lit__LightLevelTarget(struct soap *soap, const char *tag, int id, struct _lit__LightLevelTarget *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__lit__LightLevelTarget);
	if (id < 0)
		return soap->error;
	return soap_out__lit__LightLevelTarget(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _lit__LightLevelTarget ** SOAP_FMAC4 soap_get_PointerTo_lit__LightLevelTarget(struct soap *soap, struct _lit__LightLevelTarget **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_lit__LightLevelTarget(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct _lit__LightLevelTarget ** SOAP_FMAC4 soap_in_PointerTo_lit__LightLevelTarget(struct soap *soap, const char *tag, struct _lit__LightLevelTarget **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct _lit__LightLevelTarget **)soap_malloc(soap, sizeof(struct _lit__LightLevelTarget *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__lit__LightLevelTarget(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _lit__LightLevelTarget **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__lit__LightLevelTarget, sizeof(struct _lit__LightLevelTarget), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTolit__PowerState(struct soap *soap, enum lit__PowerState *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_lit__PowerState);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTolit__PowerState(struct soap *soap, enum lit__PowerState *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTolit__PowerState);
	if (soap_out_PointerTolit__PowerState(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTolit__PowerState(struct soap *soap, const char *tag, int id, enum lit__PowerState *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_lit__PowerState);
	if (id < 0)
		return soap->error;
	return soap_out_lit__PowerState(soap, tag, id, *a, type);
}

SOAP_FMAC3 enum lit__PowerState ** SOAP_FMAC4 soap_get_PointerTolit__PowerState(struct soap *soap, enum lit__PowerState **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTolit__PowerState(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 enum lit__PowerState ** SOAP_FMAC4 soap_in_PointerTolit__PowerState(struct soap *soap, const char *tag, enum lit__PowerState **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (enum lit__PowerState **)soap_malloc(soap, sizeof(enum lit__PowerState *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_lit__PowerState(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (enum lit__PowerState **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_lit__PowerState, sizeof(enum lit__PowerState), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTolit__DimmingDuration(struct soap *soap, short *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_lit__DimmingDuration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTolit__DimmingDuration(struct soap *soap, short *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTolit__DimmingDuration);
	if (soap_out_PointerTolit__DimmingDuration(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTolit__DimmingDuration(struct soap *soap, const char *tag, int id, short *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_lit__DimmingDuration);
	if (id < 0)
		return soap->error;
	return soap_out_lit__DimmingDuration(soap, tag, id, *a, type);
}

SOAP_FMAC3 short ** SOAP_FMAC4 soap_get_PointerTolit__DimmingDuration(struct soap *soap, short **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTolit__DimmingDuration(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 short ** SOAP_FMAC4 soap_in_PointerTolit__DimmingDuration(struct soap *soap, const char *tag, short **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (short **)soap_malloc(soap, sizeof(short *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_lit__DimmingDuration(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (short **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_lit__DimmingDuration, sizeof(short), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__token(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__token(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__token(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__token);
	if (soap_out_xsd__token(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__token(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__token);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__token(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__token(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__token(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__token, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

#ifdef __cplusplus
}
#endif

/* End of litC.c */
