/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2091 $
|                     $Date: 2009-02-17 15:38:44 +0100 (mar, 17 fév 2009) $
\*============================================================================*/

/*******************************************************************************
*             Streaming Persistence Abstract Layer implementation              *
*******************************************************************************/

#include <stdlib.h>

#include "dcXTOOL_Sun.h"
#include "dcDCPL_Mem.h"
#include "al_stor.h"

/*------------------------- Static Functions prototypes ----------------------*/

static void * sun_al_write_init(void * implementation, const char * sun_id, unsigned long * len);
static void * sun_al_read_init(void * implementation, const char * sun_id);
static int sun_al_stream_read(void * in_stream, char * buf, unsigned long * size);
static int sun_al_stream_write(void * out_stream, const char * buf, unsigned long * size);
static int sun_al_get_error(void * stream);
static int sun_al_close(void * stream);

/*----------------------------------------------------------------------------*/

sun_impl_t sun_dcpl_impl = {
		sun_al_write_init,
		sun_al_read_init,
		sun_al_stream_read,
		sun_al_stream_write,
		sun_al_get_error,
		sun_al_close
};

// Note all implementation context structs should start with the same impl field.
typedef struct sun_al_ctx {
	sun_impl_t * impl;
	al_stream_t stream;
} sun_al_ctx_t;


static void * sun_al_write_init(void * implementation, const char * sun_id, unsigned long * len)
{
	sun_al_ctx_t *ctx = (sun_al_ctx_t*)dcpl_malloc(sizeof(sun_al_ctx_t));
	if (!ctx)
		return NULL;
	ctx->impl = (sun_impl_t*)implementation;
	return al_stream_init(&ctx->stream, sun_id, AL_STREAM_WRITE_OVERWRITE) ? NULL : ctx;
}

static void * sun_al_read_init(void * implementation, const char * sun_id)
{
	sun_al_ctx_t *ctx = (struct sun_al_ctx*)dcpl_malloc(sizeof(sun_al_ctx_t));
	if (!ctx)
		return NULL;
	ctx->impl = (sun_impl_t*)implementation;
	return al_stream_init(&ctx->stream, sun_id, AL_STREAM_READ) ? NULL : ctx;
}

static int sun_al_stream_read(void * in_stream, char * buf, unsigned long * size)
{
	int ret;
	sun_al_ctx_t *ctx = (sun_al_ctx_t *)in_stream;
	ret = al_stream_read(&ctx->stream, (char *)buf, size);
	return ret ? (ret == AL_EEOS ? SUN_EOS : SUN_IMPL_ERROR) : SUN_OK;
}

static int sun_al_stream_write(void * out_stream, const char * buf, unsigned long * size)
{
	int ret;
	sun_al_ctx_t *ctx = (sun_al_ctx_t *)out_stream;
	ret = al_stream_write(&ctx->stream, buf, (unsigned long *)size);
	return ret ? (ret == AL_EEOS ? SUN_EOS : SUN_IMPL_ERROR) : SUN_OK;
}

static int sun_al_get_error(void * stream)
{
	return al_stream_error(&((sun_al_ctx_t *)stream)->stream);
}

static int sun_al_close(void * stream)
{
	int ret;
	ret = al_stream_close(&((sun_al_ctx_t *)stream)->stream);
	dcpl_free(stream);
	return ret;
}
