/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|                   ->>  Copyright 2008-2009 Odonata <<-                       |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1772 $
|                     $Date: 2008-10-09 11:57:03 +0200 (jeu., 09 oct. 2008) $
\*============================================================================*/

/*******************************************************************************
*                 DPWSCore Portability layer error management                  *
*******************************************************************************/
#include "dcDCPL_Error.h"

#include "al_ip.h"
#include "al_stdlib.h"

int dcpl_init_error(struct dcpl_error * error_info)
{
	if (error_info) {
		error_info->error = 0;
		error_info->syserr = 0;
		error_info->detail = NULL;
	}
	return DCPL_OK;
}

int dcpl_set_error(struct dcpl_error * error_info, int error, char* detail)
{
	if (error_info) {
		error_info->error = error;
		if (error <= DCPL_MAX_SOCKET_ERROR)
			error_info->syserr = al_ip_error();
		error_info->detail = detail;
	}
	return error;
}

const char * dcpl_error_string(struct dcpl_error * error_info, char * error_string_buf, int buflen)
{
	int err = error_info->syserr;
	if (err) {
		char * fmt = "System error (errno: %d)";
		if (error_string_buf && (size_t)buflen > strlen(fmt) + 5) {
			sprintf(error_string_buf, fmt, err);
			return error_string_buf;
		} else
			return "System error";
	}
	else
		return "Operation interrupted or timed out";
}
