### Files, includes and libraries ###
SERVER_OBJS=server.o listener.o litServerLib.o prjServerLib.o wshServerLib.o litClientLib.o fileio.o
CLIENT_OBJS=client.o listener.o litClientLib.o prjClientLib.o wshClientLib.o litHandlerLib.o wshHandlerLib.o ProjectorClient.o LightingClient.o WasherClient.o fileio.o

CUSTOM_OUTPUT_FILES+=server$(EXE_EXT) client$(EXE_EXT)

all: prerequisites server$(EXE_EXT) client$(EXE_EXT)

server$(EXE_EXT): $(SERVER_OBJS) $(STATIC_DEPS) $(SHARED_DEPS)
		$(CC) $(CMFLAGS) -o server$(EXE_EXT) $(SERVER_OBJS) $(LDFLAGS) $(LIBS)

client$(EXE_EXT): $(CLIENT_OBJS) $(STATIC_DEPS) $(SHARED_DEPS)
		$(CC) $(CMFLAGS) -o client$(EXE_EXT) $(CLIENT_OBJS) $(LDFLAGS) $(LIBS)

litStub.h litServerLib.c litClientLib.c: Lighting.gsoap $(SOAPCPP)
		$(SOAPCPP) $(SOAPCPP_FLAGS) -2ucn -plit Lighting.gsoap

prjStub.h prjServerLib.c prjClientLib.c: Projector.gsoap $(SOAPCPP)
		$(SOAPCPP) $(SOAPCPP_FLAGS) -2ucn -pprj Projector.gsoap

wshStub.h wshServerLib.c wshClientLib.c: WashingMachine.gsoap $(SOAPCPP)
		$(SOAPCPP) $(SOAPCPP_FLAGS) -2ucn -pwsh WashingMachine.gsoap
